/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.allthetrims.mixin.client;

import com.bawnorton.allthetrims.AllTheTrims;
import com.bawnorton.allthetrims.Compat;
import com.bawnorton.allthetrims.json.JsonHelper;
import com.bawnorton.allthetrims.util.DebugHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import org.apache.commons.io.IOUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ModelManager.class})
public abstract class BakedModelManagerMixin {
    @ModifyExpressionValue(method={"method_45895(Lnet/minecraft/resource/ResourceManager;)Ljava/util/Map;"}, at={@At(value="INVOKE", target="Lnet/minecraft/resource/ResourceFinder;findResources(Lnet/minecraft/resource/ResourceManager;)Ljava/util/Map;")})
    private static Map<ResourceLocation, Resource> addTrimModels(Map<ResourceLocation, Resource> original) {
        HashSet equipmentSet = new HashSet();
        BuiltInRegistries.f_257033_.forEach(item -> {
            if (item instanceof Equipable) {
                Equipable equipment = (Equipable)item;
                equipmentSet.add(equipment);
            }
        });
        for (Equipable equipment : equipmentSet) {
            Resource resource;
            String armourType;
            ResourceLocation equipmentId = BuiltInRegistries.f_257033_.m_7981_((Object)((Item)equipment));
            if (equipmentId.m_135827_().equals("betterend")) continue;
            ResourceLocation resourceId = new ResourceLocation(equipmentId.m_135827_(), "models/item/" + equipmentId.m_135815_() + ".json");
            switch (equipment.m_40402_()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case HEAD: {
                    String string = "helmet";
                    break;
                }
                case CHEST: {
                    String string = "chestplate";
                    break;
                }
                case LEGS: {
                    String string = "leggings";
                    break;
                }
                case FEET: {
                    String string = "boots";
                    break;
                }
                case MAINHAND: 
                case OFFHAND: {
                    String string = armourType = null;
                }
            }
            if (armourType == null) {
                AllTheTrims.LOGGER.warn("Item " + String.valueOf(equipmentId) + "'s slot type is not an armour slot type, skipping", new Object[0]);
                continue;
            }
            if (BuiltInRegistries.f_257033_.m_7745_(equipmentId) instanceof ElytraItem) {
                if (Compat.isElytraTrimsLoaded()) {
                    armourType = "elytra";
                } else {
                    AllTheTrims.LOGGER.warn("Item " + String.valueOf(equipmentId) + " is an elytra, but elytratrims is not loaded, skipping", new Object[0]);
                    continue;
                }
            }
            if ((resource = original.get(resourceId)) == null) {
                AllTheTrims.LOGGER.warn("Could not find resource " + String.valueOf(resourceId) + " for item " + String.valueOf(equipmentId) + ", skipping", new Object[0]);
                continue;
            }
            try {
                BufferedReader reader = resource.m_215508_();
                try {
                    JsonArray overrides;
                    JsonObject model = JsonHelper.fromJsonReader(reader, JsonObject.class);
                    if (!model.has("textures")) {
                        AllTheTrims.LOGGER.warn("Item " + String.valueOf(equipmentId) + "'s model does not have a textures parameter, skipping", new Object[0]);
                        continue;
                    }
                    JsonObject textures = model.get("textures").getAsJsonObject();
                    if (!textures.has("layer0")) {
                        AllTheTrims.LOGGER.warn("Item " + String.valueOf(equipmentId) + "'s model does not have a layer0 texture, skipping", new Object[0]);
                        continue;
                    }
                    String baseTexture = textures.get("layer0").getAsString();
                    if (model.has("overrides")) {
                        overrides = model.get("overrides").getAsJsonArray();
                    } else {
                        overrides = new JsonArray();
                        model.add("overrides", (JsonElement)overrides);
                    }
                    JsonObject attOverride = new JsonObject();
                    attOverride.addProperty("model", baseTexture + "_dynamic_trim");
                    JsonObject predicate = new JsonObject();
                    predicate.addProperty("trim_type", "dynamic");
                    attOverride.add("predicate", (JsonElement)predicate);
                    overrides.add((JsonElement)attOverride);
                    JsonObject overrideResourceJson = new JsonObject();
                    overrideResourceJson.addProperty("parent", model.get("parent").getAsString());
                    JsonObject overrideTextures = new JsonObject();
                    overrideTextures.addProperty("layer0", baseTexture);
                    int layer = 1;
                    int trimCount = 0;
                    boolean reachedEnd = false;
                    while (true) {
                        JsonElement layerElement;
                        if ((layerElement = textures.get("layer" + layer)) == null) {
                            reachedEnd = true;
                        } else {
                            overrideTextures.add("layer" + layer, layerElement);
                        }
                        if (reachedEnd) {
                            overrideTextures.addProperty("layer" + layer, "minecraft:trims/items/" + armourType + "_trim_" + trimCount + "_dynamic");
                            if (trimCount == 7) break;
                            ++trimCount;
                        }
                        ++layer;
                    }
                    overrideResourceJson.add("textures", (JsonElement)overrideTextures);
                    ResourceLocation baseId = new ResourceLocation(baseTexture);
                    ResourceLocation overrideResourceModelId = baseId.m_247449_("models/" + baseId.m_135815_() + "_dynamic_trim.json");
                    Resource overrideResource = new Resource(resource.m_247173_(), () -> IOUtils.toInputStream((String)JsonHelper.toJsonString(overrideResourceJson), (String)"UTF-8"));
                    original.put(overrideResourceModelId, overrideResource);
                    DebugHelper.createDebugFile("models", String.valueOf(equipmentId) + "_dynamic_trim.json", JsonHelper.toJsonString(overrideResourceJson));
                    resource = new Resource(resource.m_247173_(), () -> IOUtils.toInputStream((String)JsonHelper.toJsonString(model), (String)"UTF-8"));
                    DebugHelper.createDebugFile("models", String.valueOf(equipmentId) + ".json", JsonHelper.toJsonString(model));
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                    continue;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            original.put(resourceId, resource);
        }
        return original;
    }
}

