/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.allthetrims.mixin.client;

import com.bawnorton.allthetrims.AllTheTrims;
import com.bawnorton.allthetrims.json.JsonHelper;
import com.bawnorton.allthetrims.util.DebugHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.FallbackResourceManager;
import net.minecraft.server.packs.resources.Resource;
import org.apache.commons.io.IOUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={FallbackResourceManager.class})
public abstract class NamespaceResourceManagerMixin {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ModifyReturnValue(method={"getAllResources"}, at={@At(value="RETURN")})
    private List<Resource> replaceTrimMaterials(List<Resource> original, ResourceLocation identifier) {
        if (!identifier.toString().contains("armour_trims")) {
            return original;
        }
        ArrayList<Resource> newResources = new ArrayList<Resource>();
        Iterator<Resource> iterator = original.iterator();
        while (iterator.hasNext()) {
            Resource resource = iterator.next();
            try {
                BufferedReader reader = resource.m_215508_();
                try {
                    JsonObject atlas = JsonHelper.fromJsonReader(reader, JsonObject.class);
                    if (!atlas.has("sources")) {
                        List<Resource> list = original;
                        return list;
                    }
                    JsonArray sources = atlas.getAsJsonArray("sources");
                    if (sources.size() == 0) {
                        List<Resource> list = original;
                        return list;
                    }
                    for (JsonElement source : sources) {
                        String type;
                        JsonObject sourceJson;
                        if (!(source instanceof JsonObject) || !(sourceJson = (JsonObject)source).has("permutations") || !sourceJson.has("type") || !(type = sourceJson.get("type").getAsString()).equals("paletted_permutations")) continue;
                        JsonObject permutations = new JsonObject();
                        permutations.addProperty("dynamic", "trims/color_palettes/blank");
                        sourceJson.add("permutations", (JsonElement)permutations);
                    }
                    newResources.add(new Resource(resource.m_247173_(), () -> IOUtils.toInputStream((String)JsonHelper.toJsonString(atlas), (String)"UTF-8")));
                    DebugHelper.createDebugFile("atlases", resource.m_215506_() + "_armour_trims.json", JsonHelper.toJsonString(atlas));
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException | RuntimeException e) {
                AllTheTrims.LOGGER.error("Failed to modify trim atlas: " + String.valueOf(identifier), new Object[0]);
                return original;
            }
        }
        return newResources;
    }
}

