/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.allthetrims.mixin.client;

import com.bawnorton.allthetrims.AllTheTrims;
import com.bawnorton.allthetrims.client.util.ImageUtil;
import com.bawnorton.allthetrims.client.util.PaletteHelper;
import com.bawnorton.allthetrims.util.DebugHelper;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.datafixers.util.Function3;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.atlas.sources.PalettedPermutations;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={PalettedPermutations.class})
public abstract class PalettedPermutationsAtlasSourceMixin {
    @ModifyArg(method={"method_48487"}, at=@At(value="INVOKE", target="Lcom/mojang/datafixers/Products$P3;apply(Lcom/mojang/datafixers/kinds/Applicative;Lcom/mojang/datafixers/util/Function3;)Lcom/mojang/datafixers/kinds/App;", remap=false), index=1)
    private static <R> Function3<List<ResourceLocation>, ResourceLocation, Map<String, ResourceLocation>, R> createDynamicTrimPermutation(Function3<List<ResourceLocation>, ResourceLocation, Map<String, ResourceLocation>, R> function) {
        return (textures, paletteKey, palettedPermutations) -> {
            if (!paletteKey.m_135815_().contains("trim_palette")) {
                return function.apply(textures, paletteKey, palettedPermutations);
            }
            ArrayList<ResourceLocation> newTextures = new ArrayList<ResourceLocation>(textures.size() * 9);
            for (ResourceLocation texture : textures) {
                newTextures.add(texture);
                for (int i = 0; i < 8; ++i) {
                    newTextures.add(texture.m_266382_("_" + i));
                }
            }
            HashMap<String, ResourceLocation> newPermutations = new HashMap<String, ResourceLocation>((Map<String, ResourceLocation>)palettedPermutations);
            newPermutations.put("dynamic", new ResourceLocation("trims/color_palettes/blank"));
            return function.apply(newTextures, paletteKey, newPermutations);
        };
    }

    @ModifyExpressionValue(method={"method_48486"}, at={@At(value="INVOKE", target="Lnet/minecraft/resource/ResourceManager;getResource(Lnet/minecraft/util/Identifier;)Ljava/util/Optional;")})
    private static Optional<Resource> addBlankPalette(Optional<Resource> optionalResource, ResourceManager resourceManager, ResourceLocation identifier) {
        if (optionalResource.isPresent()) {
            String path = identifier.m_135815_();
            path = path.substring("trims_color_palettes_".length());
            PaletteHelper.putPalette(identifier.m_247449_(path), PaletteHelper.existingResourceToPalette(optionalResource.get()));
            return optionalResource;
        }
        return Optional.of(new Resource((PackResources)Minecraft.m_91087_().m_246804_(), () -> ImageUtil.toInputStream(ImageUtil.newBlankPaletteImage())));
    }

    @Redirect(method={"load"}, at=@At(value="INVOKE", target="Lnet/minecraft/resource/ResourceManager;getResource(Lnet/minecraft/util/Identifier;)Ljava/util/Optional;"))
    private Optional<Resource> getLayeredTrimResource(ResourceManager instance, ResourceLocation identifier, @Share(value="identifier") LocalRef<ResourceLocation> identifierRef) {
        Optional<Resource> optional;
        block12: {
            identifierRef.set((Object)identifier);
            Optional original = instance.m_213713_(identifier);
            if (original.isPresent()) {
                return original;
            }
            String path = identifier.m_135815_();
            int pathEnd = path.lastIndexOf(95);
            ResourceLocation originalIdentifier = pathEnd > 0 ? identifier.m_247449_(path.substring(0, pathEnd) + ".png") : identifier;
            Optional optionalResource = instance.m_213713_(originalIdentifier);
            if (optionalResource.isEmpty()) {
                return optionalResource;
            }
            Pattern pattern = Pattern.compile("\\d+(?![\\d\\D]*\\d)");
            Matcher matcher = pattern.matcher(path);
            if (!matcher.find()) {
                AllTheTrims.LOGGER.warn("Failed to find layer number in " + path, new Object[0]);
                return optionalResource;
            }
            int layer = Integer.parseInt(matcher.group());
            Resource resource = (Resource)optionalResource.get();
            InputStream inputStream = resource.m_215507_();
            try {
                BufferedImage bufferedImage = ImageIO.read(inputStream);
                if (bufferedImage == null) {
                    throw new RuntimeException("Failed to read image from " + String.valueOf(originalIdentifier));
                }
                Color colour = ImageUtil.getNthDarkestColour(bufferedImage, layer);
                BufferedImage newImage = ImageUtil.removeOtherColours(bufferedImage, colour);
                DebugHelper.saveLayeredTexture(newImage, identifier.toString());
                optional = Optional.of(new Resource(resource.m_247173_(), () -> ImageUtil.toInputStream(newImage)));
                if (inputStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream.close();
        }
        return optional;
    }

    @ModifyExpressionValue(method={"load"}, at={@At(value="INVOKE", target="Ljava/util/Map;entrySet()Ljava/util/Set;")})
    private Set<Map.Entry<String, Supplier<IntUnaryOperator>>> removeAllNonBlankPalettes(Set<Map.Entry<String, Supplier<IntUnaryOperator>>> permutations, @Share(value="identifier") LocalRef<ResourceLocation> identifierRef) {
        String path = ((ResourceLocation)identifierRef.get()).m_135815_();
        String pattern = ".*_\\d.png";
        HashSet<Map.Entry<String, Supplier<IntUnaryOperator>>> newPermutations = new HashSet<Map.Entry<String, Supplier<IntUnaryOperator>>>();
        if (!path.matches(pattern)) {
            for (Map.Entry<String, Supplier<IntUnaryOperator>> entry : permutations) {
                if (entry.getKey().equals("dynamic")) continue;
                newPermutations.add(entry);
            }
        } else {
            for (Map.Entry<String, Supplier<IntUnaryOperator>> entry : permutations) {
                if (!entry.getKey().equals("dynamic")) continue;
                newPermutations.add(entry);
            }
        }
        return newPermutations;
    }
}

