/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.armorstatues.api.client.gui.components.LiveSliderButton;
import fuzs.armorstatues.api.client.gui.components.UnboundedSliderButton;
import fuzs.armorstatues.api.client.gui.screens.armorstand.AbstractArmorStandScreen;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandPose;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public abstract class BoxedSliderButton
extends AbstractWidget
implements UnboundedSliderButton,
LiveSliderButton {
    static final double VALUE_KEY_INTERVAL = 0.035;
    private static final int SLIDER_SIZE = 13;
    private final DoubleSupplier currentHorizontalValue;
    private final DoubleSupplier currentVerticalValue;
    protected final OnTooltip onTooltip;
    protected double horizontalValue;
    protected double verticalValue;

    public BoxedSliderButton(int x, int y, DoubleSupplier currentHorizontalValue, DoubleSupplier currentVerticalValue) {
        this(x, y, currentHorizontalValue, currentVerticalValue, (button, poseStack, mouseX, mouseY) -> {});
    }

    public BoxedSliderButton(int x, int y, DoubleSupplier currentHorizontalValue, DoubleSupplier currentVerticalValue, OnTooltip onTooltip) {
        super(x, y, 54, 54, CommonComponents.f_237098_);
        this.onTooltip = onTooltip;
        this.currentHorizontalValue = currentHorizontalValue;
        this.currentVerticalValue = currentVerticalValue;
        this.refreshValues();
    }

    @Override
    public void refreshValues() {
        this.horizontalValue = this.currentHorizontalValue.getAsDouble();
        this.verticalValue = this.currentVerticalValue.getAsDouble();
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
        if (this.f_93623_) {
            if (this.m_93696_()) {
                narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.slider.usage.focused"));
            } else {
                narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.slider.usage.hovered"));
            }
            this.onTooltip.narrateTooltip(component -> narrationElementOutput.m_169146_(NarratedElementType.HINT, component));
        }
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)AbstractArmorStandScreen.getArmorStandWidgetsLocation());
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        int sliderX = (int)(this.horizontalValue * (double)(this.f_93618_ - 13 - 2));
        int sliderY = (int)(this.verticalValue * (double)(this.f_93619_ - 13 - 2));
        boolean hoveredOrFocused = this.m_198029_();
        boolean horizontalValueLocked = this.horizontalValueLocked();
        boolean verticalValueLocked = this.verticalValueLocked();
        if (!this.f_93623_ || !hoveredOrFocused || !horizontalValueLocked && !verticalValueLocked) {
            this.m_93228_(poseStack, this.f_93620_, this.f_93621_, 0, 120, this.f_93618_, this.f_93619_);
        } else if (horizontalValueLocked && verticalValueLocked) {
            this.m_93228_(poseStack, this.f_93620_ + sliderX, this.f_93621_ + sliderY, 164, 0, 15, 15);
        } else if (horizontalValueLocked) {
            this.m_93228_(poseStack, this.f_93620_ + sliderX, this.f_93621_, 54, 120, 15, this.f_93619_);
        } else {
            this.m_93228_(poseStack, this.f_93620_, this.f_93621_ + sliderY, 136, 49, this.f_93618_, 15);
        }
        int i = this.m_7202_(hoveredOrFocused);
        this.m_93228_(poseStack, this.f_93620_ + 1 + sliderX, this.f_93621_ + 1 + sliderY, 151, i * 13, 13, 13);
        if (hoveredOrFocused) {
            this.m_7428_(poseStack, mouseX, mouseY);
        }
    }

    public void m_7428_(PoseStack poseStack, int relativeMouseX, int relativeMouseY) {
        this.onTooltip.onTooltip(this, poseStack, relativeMouseX, relativeMouseY);
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX, mouseY);
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        this.setValueFromMouse(mouseX, mouseY);
    }

    private void setValueFromMouse(double mouseX, double mouseY) {
        this.setHorizontalValue((mouseX - (double)(this.f_93620_ + 8)) / (double)(this.f_93618_ - 13 - 2), true);
        this.setVerticalValue((mouseY - (double)(this.f_93621_ + 8)) / (double)(this.f_93619_ - 13 - 2), true);
    }

    private void setHorizontalValue(double horizontalValue, boolean snapValue) {
        double oldHorizontalValue = this.horizontalValue;
        if (!this.horizontalValueLocked()) {
            this.horizontalValue = Mth.m_14008_((double)horizontalValue, (double)0.0, (double)1.0);
            if (snapValue) {
                this.horizontalValue = ArmorStandPose.snapValue(this.horizontalValue, 0.125);
            }
        }
        if (oldHorizontalValue != this.horizontalValue) {
            this.applyValue();
        }
    }

    private void setVerticalValue(double verticalValue, boolean snapValue) {
        double oldVerticalValue = this.verticalValue;
        if (!this.verticalValueLocked()) {
            this.verticalValue = Mth.m_14008_((double)verticalValue, (double)0.0, (double)1.0);
            if (snapValue) {
                this.verticalValue = ArmorStandPose.snapValue(this.verticalValue, 0.125);
            }
        }
        if (oldVerticalValue != this.verticalValue) {
            this.applyValue();
        }
    }

    protected boolean verticalValueLocked() {
        return Screen.m_96638_();
    }

    protected boolean horizontalValueLocked() {
        return Screen.m_96639_();
    }

    public void m_7435_(SoundManager handler) {
    }

    public void m_7691_(double mouseX, double mouseY) {
        super.m_7435_(Minecraft.m_91087_().m_91106_());
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_93623_ && this.f_93624_) {
            switch (keyCode) {
                case 263: {
                    this.setHorizontalValue(this.horizontalValue - 0.035, false);
                    return true;
                }
                case 262: {
                    this.setHorizontalValue(this.horizontalValue + 0.035, false);
                    return true;
                }
                case 265: {
                    this.setVerticalValue(this.verticalValue - 0.035, false);
                    return true;
                }
                case 264: {
                    this.setVerticalValue(this.verticalValue + 0.035, false);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    protected abstract void applyValue();

    public static interface OnTooltip {
        public void onTooltip(BoxedSliderButton var1, PoseStack var2, int var3, int var4);

        default public void narrateTooltip(Consumer<Component> contents) {
        }
    }
}

