/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.client.gui.screens.armorstand;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.armorstatues.api.StatuesApi;
import fuzs.armorstatues.api.client.gui.components.TickingButton;
import fuzs.armorstatues.api.client.gui.components.UnboundedSliderButton;
import fuzs.armorstatues.api.client.gui.screens.armorstand.ArmorStandInInventoryRenderer;
import fuzs.armorstatues.api.client.gui.screens.armorstand.ArmorStandScreen;
import fuzs.armorstatues.api.client.gui.screens.armorstand.ArmorStandScreenFactory;
import fuzs.armorstatues.api.network.client.data.DataSyncHandler;
import fuzs.armorstatues.api.world.inventory.ArmorStandHolder;
import fuzs.armorstatues.api.world.inventory.ArmorStandMenu;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandScreenType;
import fuzs.puzzleslib.client.core.ClientCoreServices;
import fuzs.puzzleslib.client.gui.screens.CommonScreens;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractArmorStandScreen
extends Screen
implements MenuAccess<ArmorStandMenu>,
ArmorStandScreen {
    public static final String VANILLA_TWEAKS_HOMEPAGE = "https://vanillatweaks.net/";
    public static final String CREDITS_TRANSLATION_KEY = "statues.screen.credits";
    private static final ResourceLocation ARMOR_STAND_BACKGROUND_LOCATION = StatuesApi.id("textures/gui/container/statue/background.png");
    private static final ResourceLocation ARMOR_STAND_WIDGETS_LOCATION = StatuesApi.id("textures/gui/container/statue/widgets.png");
    private static final ResourceLocation ARMOR_STAND_EQUIPMENT_LOCATION = StatuesApi.id("textures/gui/container/statue/equipment.png");
    @Nullable
    static ArmorStandScreenType lastScreenType;
    static ArmorStandInInventoryRenderer armorStandRenderer;
    protected final int imageWidth = 210;
    protected final int imageHeight = 188;
    protected final ArmorStandHolder holder;
    private final Inventory inventory;
    protected final DataSyncHandler dataSyncHandler;
    protected int leftPos;
    protected int topPos;
    protected int inventoryEntityX;
    protected int inventoryEntityY;
    protected boolean smallInventoryEntity;
    protected int mouseX;
    protected int mouseY;
    @Nullable
    private AbstractWidget closeButton;

    public AbstractArmorStandScreen(ArmorStandHolder holder, Inventory inventory, Component component, DataSyncHandler dataSyncHandler) {
        super(component);
        this.holder = holder;
        this.inventory = inventory;
        this.dataSyncHandler = dataSyncHandler;
    }

    public static ResourceLocation getArmorStandBackgroundLocation() {
        return ARMOR_STAND_BACKGROUND_LOCATION;
    }

    public static ResourceLocation getArmorStandWidgetsLocation() {
        return ARMOR_STAND_WIDGETS_LOCATION;
    }

    public static ResourceLocation getArmorStandEquipmentLocation() {
        return ARMOR_STAND_EQUIPMENT_LOCATION;
    }

    @Override
    public ArmorStandHolder getHolder() {
        return this.holder;
    }

    @Override
    public DataSyncHandler getDataSyncHandler() {
        return this.dataSyncHandler;
    }

    @Override
    public <T extends Screen & ArmorStandScreen> T createScreenType(ArmorStandScreenType screenType) {
        Object screen = ArmorStandScreenFactory.createScreenType(screenType, this.holder, this.inventory, this.f_96539_, this.dataSyncHandler);
        ((ArmorStandScreen)screen).setMouseX(this.mouseX);
        ((ArmorStandScreen)screen).setMouseY(this.mouseY);
        return screen;
    }

    @Override
    public void setMouseX(int mouseX) {
        this.mouseX = mouseX;
    }

    @Override
    public void setMouseY(int mouseY) {
        this.mouseY = mouseY;
    }

    public void m_86600_() {
        this.dataSyncHandler.tick();
        for (GuiEventListener child : this.m_6702_()) {
            if (!(child instanceof TickingButton)) continue;
            TickingButton button = (TickingButton)child;
            button.tick();
        }
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        if (this.withCloseButton()) {
            this.closeButton = (AbstractWidget)this.m_142416_((GuiEventListener)AbstractArmorStandScreen.makeCloseButton(this, this.leftPos, this.imageWidth, this.topPos));
        }
    }

    public static AbstractButton makeCloseButton(Screen screen, int leftPos, int imageWidth, int topPos) {
        return new ImageButton(leftPos + imageWidth - 15 - 8, topPos + 8, 15, 15, 136, 0, AbstractArmorStandScreen.getArmorStandWidgetsLocation(), button -> screen.m_7379_());
    }

    protected boolean withCloseButton() {
        return true;
    }

    protected boolean renderInventoryEntity() {
        return true;
    }

    protected boolean disableMenuRendering() {
        return false;
    }

    protected void toggleMenuRendering(boolean disableMenuRendering) {
        if (this.closeButton != null) {
            this.closeButton.f_93624_ = !disableMenuRendering;
        }
    }

    protected void addVanillaTweaksCreditsButton() {
        this.m_142416_((GuiEventListener)new ImageButton(this.leftPos + 6, this.topPos + 6, 20, 20, 136, 64, 20, AbstractArmorStandScreen.getArmorStandWidgetsLocation(), 256, 256, button -> this.f_96541_.m_91152_((Screen)new ConfirmLinkScreen(bl -> {
            if (bl) {
                Util.m_137581_().m_137646_(VANILLA_TWEAKS_HOMEPAGE);
            }
            this.f_96541_.m_91152_((Screen)this);
        }, VANILLA_TWEAKS_HOMEPAGE, true)), (button, poseStack, mouseX, mouseY) -> this.m_96617_(poseStack, this.f_96547_.m_92923_((FormattedText)Component.m_237115_((String)CREDITS_TRANSLATION_KEY), 175), mouseX, mouseY), CommonComponents.f_237098_));
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && !this.disableMenuRendering() && AbstractArmorStandScreen.handleTabClicked((int)mouseX, (int)mouseY, this.leftPos, this.topPos, this.imageHeight, this, this.dataSyncHandler.getScreenTypes())) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (!this.disableMenuRendering()) {
            this.m_7333_(poseStack);
        }
        this.renderBg(poseStack, partialTick, mouseX, mouseY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (!this.disableMenuRendering()) {
            AbstractArmorStandScreen.findHoveredTab(this.leftPos, this.topPos, this.imageHeight, mouseX, mouseY, this.dataSyncHandler.getScreenTypes()).ifPresent(hoveredTab -> this.m_96602_(poseStack, (Component)Component.m_237115_((String)hoveredTab.getTranslationKey()), mouseX, mouseY));
        }
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    protected void renderBg(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        if (!this.disableMenuRendering()) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)AbstractArmorStandScreen.getArmorStandBackgroundLocation());
            this.m_93228_(poseStack, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
            AbstractArmorStandScreen.drawTabs(poseStack, this.leftPos, this.topPos, this.imageHeight, this, this.dataSyncHandler.getScreenTypes());
            this.renderEntityInInventory(poseStack);
        }
    }

    private void renderEntityInInventory(PoseStack poseStack) {
        if (this.renderInventoryEntity()) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)AbstractArmorStandScreen.getArmorStandWidgetsLocation());
            if (this.smallInventoryEntity) {
                this.m_93228_(poseStack, this.leftPos + this.inventoryEntityX, this.topPos + this.inventoryEntityY, 200, 184, 50, 72);
                this.renderArmorStandInInventory(this.leftPos + this.inventoryEntityX + 24, this.topPos + this.inventoryEntityY + 65, 30, this.leftPos + this.inventoryEntityX + 24 - 10 - this.mouseX, this.topPos + this.inventoryEntityY + 65 - 44 - this.mouseY);
            } else {
                this.m_93228_(poseStack, this.leftPos + this.inventoryEntityX, this.topPos + this.inventoryEntityY, 0, 0, 76, 108);
                this.renderArmorStandInInventory(this.leftPos + this.inventoryEntityX + 38, this.topPos + this.inventoryEntityY + 98, 45, (float)(this.leftPos + this.inventoryEntityX + 38 - 5) - (float)this.mouseX, (float)(this.topPos + this.inventoryEntityY + 98 - 66) - (float)this.mouseY);
            }
        }
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        boolean mouseReleased = false;
        for (GuiEventListener child : this.m_6702_()) {
            UnboundedSliderButton sliderButton;
            if (!(child instanceof UnboundedSliderButton) || !(sliderButton = (UnboundedSliderButton)child).isDirty()) continue;
            mouseReleased |= child.m_6348_(mouseX, mouseY, button);
        }
        return mouseReleased || super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.f_96541_.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        return AbstractArmorStandScreen.handleHotbarKeyPressed(keyCode, scanCode, this, this.dataSyncHandler.getScreenTypes());
    }

    public static <T extends Screen> boolean handleHotbarKeyPressed(int keyCode, int scanCode, T screen, ArmorStandScreenType[] tabs) {
        Minecraft minecraft = CommonScreens.INSTANCE.getMinecraft(screen);
        for (int i = 0; i < Math.min(tabs.length, 9); ++i) {
            if (!minecraft.f_91066_.f_92056_[i].m_90832_(keyCode, scanCode) || !AbstractArmorStandScreen.openTabScreen(screen, tabs[i], true)) continue;
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (super.m_6050_(mouseX, mouseY, delta)) {
            return true;
        }
        return AbstractArmorStandScreen.handleMouseScrolled((int)mouseX, (int)mouseY, delta, this.leftPos, this.topPos, this.imageHeight, this, this.dataSyncHandler.getScreenTypes());
    }

    public static <T extends Screen> boolean handleMouseScrolled(int mouseX, int mouseY, double delta, int leftPos, int topPos, int imageHeight, T screen, ArmorStandScreenType[] tabs) {
        Optional<ArmorStandScreenType> optional;
        if ((delta = Math.signum(delta)) != 0.0 && (optional = AbstractArmorStandScreen.findHoveredTab(leftPos, topPos, imageHeight, mouseX, mouseY, tabs)).isPresent()) {
            ArmorStandScreenType screenType = AbstractArmorStandScreen.cycleTabs(((ArmorStandScreen)screen).getScreenType(), tabs, delta > 0.0);
            return AbstractArmorStandScreen.openTabScreen(screen, screenType, false);
        }
        return false;
    }

    public static <T extends Screen> boolean handleTabClicked(int mouseX, int mouseY, int leftPos, int topPos, int imageHeight, T screen, ArmorStandScreenType[] tabs) {
        Optional<ArmorStandScreenType> hoveredTab = AbstractArmorStandScreen.findHoveredTab(leftPos, topPos, imageHeight, mouseX, mouseY, tabs);
        return hoveredTab.filter(armorStandScreenType -> AbstractArmorStandScreen.openTabScreen(screen, armorStandScreenType, true)).isPresent();
    }

    private static <T extends Screen> boolean openTabScreen(T screen, ArmorStandScreenType screenType, boolean clickSound) {
        if (screenType != ((ArmorStandScreen)screen).getScreenType()) {
            Minecraft minecraft = ClientCoreServices.SCREENS.getMinecraft(screen);
            if (clickSound) {
                SimpleSoundInstance sound = SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f);
                minecraft.m_91106_().m_120367_((SoundInstance)sound);
            }
            minecraft.m_91152_(((ArmorStandScreen)screen).createScreenType(screenType));
            return true;
        }
        return false;
    }

    private static ArmorStandScreenType cycleTabs(ArmorStandScreenType currentScreenType, ArmorStandScreenType[] screenTypes, boolean backwards) {
        int index = ArrayUtils.indexOf((Object[])screenTypes, (Object)currentScreenType);
        return screenTypes[((backwards ? --index : ++index) % screenTypes.length + screenTypes.length) % screenTypes.length];
    }

    public static <T extends Screen> void drawTabs(PoseStack poseStack, int leftPos, int topPos, int imageHeight, T screen, ArmorStandScreenType[] tabs) {
        int tabsStartY = AbstractArmorStandScreen.getTabsStartY(imageHeight, tabs.length);
        for (int i = 0; i < tabs.length; ++i) {
            ArmorStandScreenType tabType = tabs[i];
            int tabX = leftPos - 32;
            int tabY = topPos + tabsStartY + 27 * i;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)AbstractArmorStandScreen.getArmorStandBackgroundLocation());
            GuiComponent.m_93133_((PoseStack)poseStack, (int)tabX, (int)tabY, (float)(tabY <= topPos ? 36.0f : (tabY >= topPos + imageHeight - 36 ? 72.0f : 0.0f)), (float)(188 + (tabType == ((ArmorStandScreen)screen).getScreenType() ? 0 : 26)), (int)36, (int)26, (int)256, (int)256);
            ItemRenderer itemRenderer = ClientCoreServices.SCREENS.getItemRenderer(screen);
            itemRenderer.f_115093_ = 100.0f;
            itemRenderer.m_115203_(tabType.getIcon(), tabX + 10, tabY + 5);
            itemRenderer.f_115093_ = 0.0f;
        }
    }

    public static Optional<ArmorStandScreenType> findHoveredTab(int leftPos, int topPos, int imageHeight, int mouseX, int mouseY, ArmorStandScreenType[] tabs) {
        int tabsStartY = AbstractArmorStandScreen.getTabsStartY(imageHeight, tabs.length);
        for (int i = 0; i < tabs.length; ++i) {
            int tabX = leftPos - 32;
            int tabY = topPos + tabsStartY + 27 * i;
            if (mouseX <= tabX || mouseX > tabX + 32 || mouseY <= tabY || mouseY > tabY + 26) continue;
            return Optional.of(tabs[i]);
        }
        return Optional.empty();
    }

    private static int getTabsStartY(int imageHeight, int tabsCount) {
        int tabsHeight = tabsCount * 26 + (tabsCount - 1);
        return (imageHeight - tabsHeight) / 2;
    }

    public ArmorStandMenu getMenu() {
        return (ArmorStandMenu)this.holder;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7861_() {
        for (GuiEventListener child : this.m_6702_()) {
            if (!(child instanceof UnboundedSliderButton)) continue;
            UnboundedSliderButton sliderButton = (UnboundedSliderButton)child;
            sliderButton.clearDirty();
        }
    }

    public void m_7379_() {
        if (this.holder instanceof AbstractContainerMenu) {
            this.f_96541_.f_91074_.m_6915_();
        }
        super.m_7379_();
    }

    static {
        armorStandRenderer = ArmorStandInInventoryRenderer.SIMPLE;
    }
}

