/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.client.gui.screens.armorstand;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.armorstatues.api.client.gui.screens.armorstand.AbstractArmorStandScreen;
import fuzs.armorstatues.api.network.client.data.DataSyncHandler;
import fuzs.armorstatues.api.world.inventory.ArmorStandHolder;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandPose;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandScreenType;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Inventory;

public class ArmorStandPosesScreen
extends AbstractArmorStandScreen {
    public static final String POSE_SOURCE_TRANSLATION_KEY = "statues.screen.pose.by";
    private static final int POSES_PER_PAGE = 4;
    private static int firstPoseIndex;
    private final AbstractWidget[] cycleButtons = new AbstractWidget[2];
    private final AbstractWidget[] poseButtons = new AbstractWidget[4];

    public ArmorStandPosesScreen(ArmorStandHolder holder, Inventory inventory, Component component, DataSyncHandler dataSyncHandler) {
        super(holder, inventory, component, dataSyncHandler);
        this.inventoryEntityX = 5;
        this.inventoryEntityY = 40;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.cycleButtons[0] = (AbstractWidget)this.m_142416_((GuiEventListener)new ImageButton(this.leftPos + 17, this.topPos + 153, 20, 20, 156, 64, ArmorStandPosesScreen.getArmorStandWidgetsLocation(), button -> this.toggleCycleButtons(-4)));
        this.cycleButtons[1] = (AbstractWidget)this.m_142416_((GuiEventListener)new ImageButton(this.leftPos + 49, this.topPos + 153, 20, 20, 176, 64, ArmorStandPosesScreen.getArmorStandWidgetsLocation(), button -> this.toggleCycleButtons(4)));
        for (int i = 0; i < this.poseButtons.length; ++i) {
            int index = i;
            this.poseButtons[i] = (AbstractWidget)this.m_142416_((GuiEventListener)new ImageButton(this.leftPos + 83 + i % 2 * 62, this.topPos + 9 + i / 2 * 88, 60, 82, 76, 0, 82, ArmorStandPosesScreen.getArmorStandWidgetsLocation(), 256, 256, button -> ArmorStandPosesScreen.getPoseAt(index).ifPresent(this.dataSyncHandler::sendPose), (button, poseStack, mouseX, mouseY) -> ArmorStandPosesScreen.getPoseAt(index).ifPresent(pose -> {
                String translationKey = pose.getTranslationKey();
                if (translationKey != null) {
                    MutableComponent component = Component.m_237115_((String)translationKey);
                    ArrayList lines = Lists.newArrayList((Object[])new Component[]{component});
                    String sourceType = pose.getSourceType().getDisplayName();
                    if (!StringUtil.m_14408_((String)sourceType)) {
                        lines.add(Component.m_237110_((String)POSE_SOURCE_TRANSLATION_KEY, (Object[])new Object[]{sourceType}).m_130940_(ChatFormatting.GRAY));
                    }
                    this.m_169388_(poseStack, lines, Optional.empty(), mouseX, mouseY);
                }
            }), CommonComponents.f_237098_));
        }
        this.toggleCycleButtons(0);
        this.addVanillaTweaksCreditsButton();
    }

    private void toggleCycleButtons(int increment) {
        int newFirstPoseIndex = firstPoseIndex + increment;
        if (newFirstPoseIndex >= 0 && newFirstPoseIndex < ArmorStandPose.valuesLength()) {
            firstPoseIndex = newFirstPoseIndex;
            this.cycleButtons[0].f_93623_ = newFirstPoseIndex - 4 >= 0;
            this.cycleButtons[1].f_93623_ = newFirstPoseIndex + 4 < ArmorStandPose.valuesLength();
            for (int i = 0; i < this.poseButtons.length; ++i) {
                this.poseButtons[i].f_93624_ = ArmorStandPosesScreen.getPoseAt(i).isPresent();
            }
        }
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (super.m_6050_(mouseX, mouseY, delta)) {
            return true;
        }
        if (mouseX >= (double)this.leftPos) {
            Objects.requireNonNull(this);
            if (mouseX < (double)(this.leftPos + 210) && mouseY >= (double)this.topPos) {
                Objects.requireNonNull(this);
                if (mouseY < (double)(this.topPos + 188) && (delta = Math.signum(delta)) != 0.0) {
                    this.toggleCycleButtons((int)(-1.0 * delta * 4.0));
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected void renderBg(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        super.renderBg(poseStack, partialTick, mouseX, mouseY);
        ArmorStand armorStand = this.holder.getArmorStand();
        ArmorStandPose entityPose = ArmorStandPose.fromEntity(armorStand);
        for (int i = 0; i < 4; ++i) {
            Optional<ArmorStandPose> pose = ArmorStandPosesScreen.getPoseAt(i);
            if (!pose.isPresent()) continue;
            pose.get().applyToEntity(armorStand);
            this.renderArmorStandInInventory(this.leftPos + 112 + i % 2 * 62, this.topPos + 79 + i / 2 * 88, 30, this.leftPos + 112 + i % 2 * 62 - 10 - this.mouseX, this.topPos + 79 + i / 2 * 88 - 44 - this.mouseY);
        }
        entityPose.applyToEntity(armorStand);
    }

    @Override
    protected boolean withCloseButton() {
        return false;
    }

    @Override
    public ArmorStandScreenType getScreenType() {
        return ArmorStandScreenType.POSES;
    }

    private static Optional<ArmorStandPose> getPoseAt(int index) {
        if ((index += firstPoseIndex) >= ArmorStandPose.valuesLength()) {
            return Optional.empty();
        }
        return Optional.of(ArmorStandPose.values()[index]);
    }
}

