/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.client.gui.screens.armorstand;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.armorstatues.api.client.gui.components.NewTextureButton;
import fuzs.armorstatues.api.client.gui.components.NewTextureSliderButton;
import fuzs.armorstatues.api.client.gui.screens.armorstand.AbstractArmorStandScreen;
import fuzs.armorstatues.api.client.gui.screens.armorstand.ArmorStandButtonsScreen;
import fuzs.armorstatues.api.client.gui.screens.armorstand.ArmorStandWidgetsScreen;
import fuzs.armorstatues.api.network.client.data.DataSyncHandler;
import fuzs.armorstatues.api.world.inventory.ArmorStandHolder;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandPose;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandScreenType;
import fuzs.puzzleslib.util.PuzzlesUtil;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.Nullable;

public class ArmorStandPositionScreen
extends ArmorStandButtonsScreen {
    public static final String ROTATION_TRANSLATION_KEY = "statues.screen.position.rotation";
    public static final String POSITION_X_TRANSLATION_KEY = "statues.screen.position.x";
    public static final String POSITION_Y_TRANSLATION_KEY = "statues.screen.position.y";
    public static final String POSITION_Z_TRANSLATION_KEY = "statues.screen.position.z";
    public static final String INCREMENT_TRANSLATION_KEY = "statues.screen.position.increment";
    public static final String DECREMENT_TRANSLATION_KEY = "statues.screen.position.decrement";
    public static final String PIXELS_TRANSLATION_KEY = "statues.screen.position.pixels";
    public static final String BLOCKS_TRANSLATION_KEY = "statues.screen.position.blocks";
    public static final String DEGREES_TRANSLATION_KEY = "statues.screen.position.degrees";
    public static final String MOVE_BY_TRANSLATION_KEY = "statues.screen.position.moveBy";
    public static final String CENTERED_TRANSLATION_KEY = "statues.screen.centered";
    public static final String CENTERED_DESCRIPTION_TRANSLATION_KEY = "statues.screen.centered.description";
    public static final String CORNERED_TRANSLATION_KEY = "statues.screen.cornered";
    public static final String CORNERED_DESCRIPTION_TRANSLATION_KEY = "statues.screen.cornered.description";
    public static final String ALIGNED_TRANSLATION_KEY = "statues.screen.aligned";
    private static final DecimalFormat BLOCK_INCREMENT_FORMAT = (DecimalFormat)Util.m_137469_((Object)new DecimalFormat("#.####"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    private static final double[] INCREMENTS = new double[]{0.0625, 0.25, 0.5, 1.0};
    private static double currentIncrement = INCREMENTS[0];

    public ArmorStandPositionScreen(ArmorStandHolder holder, Inventory inventory, Component component, DataSyncHandler dataSyncHandler) {
        super(holder, inventory, component, dataSyncHandler);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.f_96541_.f_91068_.m_90926_(true);
    }

    @Override
    public void m_7861_() {
        super.m_7861_();
        this.f_96541_.f_91068_.m_90926_(false);
    }

    @Override
    protected List<ArmorStandWidgetsScreen.ArmorStandWidget> buildWidgets(ArmorStand armorStand) {
        Object[] objectArray = new ArmorStandWidgetsScreen.ArmorStandWidget[5];
        objectArray[0] = new RotationWidget((Component)Component.m_237115_((String)ROTATION_TRANSLATION_KEY), () -> ((ArmorStand)armorStand).m_146908_(), this.dataSyncHandler::sendRotation);
        objectArray[1] = new PositionIncrementWidget();
        objectArray[2] = new PositionComponentWidget(POSITION_X_TRANSLATION_KEY, () -> ((ArmorStand)armorStand).m_20185_(), x -> this.dataSyncHandler.sendPosition(x, armorStand.m_20186_(), armorStand.m_20189_()));
        objectArray[3] = new PositionComponentWidget(POSITION_Y_TRANSLATION_KEY, () -> ((ArmorStand)armorStand).m_20186_(), y -> this.dataSyncHandler.sendPosition(armorStand.m_20185_(), y, armorStand.m_20189_()));
        objectArray[4] = new PositionComponentWidget(POSITION_Z_TRANSLATION_KEY, () -> ((ArmorStand)armorStand).m_20189_(), z -> this.dataSyncHandler.sendPosition(armorStand.m_20185_(), armorStand.m_20186_(), z));
        return Lists.newArrayList((Object[])objectArray);
    }

    @Override
    public ArmorStandScreenType getScreenType() {
        return ArmorStandScreenType.POSITION;
    }

    private static Component getPixelIncrementComponent(double increment) {
        return Component.m_237110_((String)PIXELS_TRANSLATION_KEY, (Object[])new Object[]{ArmorStandPositionScreen.getBlockPixelIncrement(increment)});
    }

    private static Component getBlockIncrementComponent(double increment) {
        return Component.m_237110_((String)BLOCKS_TRANSLATION_KEY, (Object[])new Object[]{BLOCK_INCREMENT_FORMAT.format(increment)});
    }

    private static int getBlockPixelIncrement(double increment) {
        return (int)Math.round(increment * 16.0);
    }

    protected class RotationWidget
    extends ArmorStandWidgetsScreen.AbstractArmorStandWidget {
        protected final DoubleSupplier currentValue;
        protected final Consumer<Float> newValue;
        private final double snapInterval;
        @Nullable
        private Runnable reset;

        public RotationWidget(Component title, DoubleSupplier currentValue, Consumer<Float> newValue) {
            this(title, currentValue, newValue, 0.125);
        }

        public RotationWidget(Component title, DoubleSupplier currentValue, Consumer<Float> newValue, double snapInterval) {
            super(ArmorStandPositionScreen.this, title);
            this.currentValue = currentValue;
            this.newValue = newValue;
            this.snapInterval = snapInterval;
        }

        protected double getCurrentValue() {
            return RotationWidget.fromWrappedDegrees(this.currentValue.getAsDouble());
        }

        protected void setNewValue(double newValue) {
            this.newValue.accept(Float.valueOf(RotationWidget.toWrappedDegrees(newValue)));
        }

        protected Component getTooltipComponent(double mouseValue) {
            return Component.m_237110_((String)ArmorStandPositionScreen.DEGREES_TRANSLATION_KEY, (Object[])new Object[]{ArmorStandPose.ROTATION_FORMAT.format(RotationWidget.toWrappedDegrees(mouseValue))});
        }

        protected static double fromWrappedDegrees(double value) {
            return (Mth.m_14175_((double)value) + 180.0) / 360.0;
        }

        protected static float toWrappedDegrees(double value) {
            return (float)Mth.m_14175_((double)(value * 360.0 - 180.0));
        }

        protected void applyClientValue(double newValue) {
        }

        @Override
        public void reset() {
            if (this.reset != null) {
                this.reset.run();
            }
        }

        @Override
        public void init(int posX, int posY) {
            super.init(posX, posY);
            var sliderButton = ArmorStandPositionScreen.this.m_142416_((GuiEventListener)new NewTextureSliderButton(posX + 76, posY + 1, 90, 20, 0, 184, AbstractArmorStandScreen.getArmorStandWidgetsLocation(), CommonComponents.f_237098_, this.getCurrentValue(), (button, poseStack, mouseX, mouseY) -> {
                double mouseValue = ArmorStandPose.snapValue((double)(mouseX - button.f_93620_) / (double)button.m_5711_(), this.snapInterval);
                ArmorStandPositionScreen.this.m_96602_(poseStack, this.getTooltipComponent(mouseValue), mouseX, mouseY);
            }){
                private boolean dirty;

                protected void m_5695_() {
                }

                public void reset() {
                    this.f_93577_ = RotationWidget.this.getCurrentValue();
                }

                protected void m_5697_() {
                    this.dirty = true;
                    RotationWidget.this.applyClientValue(this.f_93577_);
                }

                public void m_7691_(double mouseX, double mouseY) {
                    super.m_7691_(mouseX, mouseY);
                    this.clearDirty();
                }

                @Override
                public boolean isDirty() {
                    return this.dirty;
                }

                @Override
                public void clearDirty() {
                    if (this.isDirty()) {
                        this.dirty = false;
                        RotationWidget.this.setNewValue(this.f_93577_);
                    }
                }
            });
            sliderButton.snapInterval = this.snapInterval;
            this.reset = sliderButton::reset;
            this.children.add(sliderButton);
            this.children.add((AbstractWidget)ArmorStandPositionScreen.this.m_142416_((GuiEventListener)new ImageButton(posX + 174, posY + 1, 20, 20, 236, 64, AbstractArmorStandScreen.getArmorStandWidgetsLocation(), button -> ArmorStandPositionScreen.this.setActiveWidget(this))));
        }
    }

    private class PositionIncrementWidget
    extends ArmorStandWidgetsScreen.AbstractArmorStandWidget {
        public PositionIncrementWidget() {
            super(ArmorStandPositionScreen.this, (Component)Component.m_237115_((String)ArmorStandPositionScreen.MOVE_BY_TRANSLATION_KEY));
        }

        @Override
        public void init(int posX, int posY) {
            super.init(posX, posY);
            for (int i = 0; i < INCREMENTS.length; ++i) {
                double increment = INCREMENTS[i];
                AbstractWidget widget = (AbstractWidget)ArmorStandPositionScreen.this.m_142416_((GuiEventListener)new NewTextureButton(posX + 76 + i * 24 + (i > 1 ? 1 : 0), posY + 1, 20, 20, 0, 184, AbstractArmorStandScreen.getArmorStandWidgetsLocation(), (Component)Component.m_237113_((String)String.valueOf(ArmorStandPositionScreen.getBlockPixelIncrement(increment))), button -> this.setActiveIncrement((AbstractWidget)button, increment), (button, poseStack, mouseX, mouseY) -> {
                    ArrayList lines = Lists.newArrayList((Object[])new Component[]{ArmorStandPositionScreen.getPixelIncrementComponent(increment), ArmorStandPositionScreen.getBlockIncrementComponent(increment)});
                    ArmorStandPositionScreen.this.m_96617_(poseStack, lines.stream().map(Component::m_7532_).collect(Collectors.toList()), mouseX, mouseY);
                }));
                this.children.add(widget);
                if (increment != currentIncrement) continue;
                widget.f_93623_ = false;
            }
            this.children.add((AbstractWidget)ArmorStandPositionScreen.this.m_142416_((GuiEventListener)new ImageButton(posX + 174, posY + 1, 20, 20, 236, 64, AbstractArmorStandScreen.getArmorStandWidgetsLocation(), button -> ArmorStandPositionScreen.this.setActiveWidget(this))));
        }

        private void setActiveIncrement(AbstractWidget source, double increment) {
            currentIncrement = increment;
            for (AbstractWidget widget : this.children) {
                widget.f_93623_ = widget != source;
            }
        }

        @Override
        public boolean alwaysVisible(@Nullable ArmorStandWidgetsScreen.ArmorStandWidget activeWidget) {
            return !(activeWidget instanceof RotationWidget);
        }
    }

    private class PositionComponentWidget
    extends ArmorStandWidgetsScreen.AbstractArmorStandWidget {
        private final DoubleSupplier currentValue;
        private final DoubleConsumer newValue;
        private EditBox editBox;
        private int ticks;

        public PositionComponentWidget(String translationKey, DoubleSupplier currentValue, DoubleConsumer newValue) {
            super(ArmorStandPositionScreen.this, (Component)Component.m_237115_((String)translationKey));
            this.currentValue = currentValue;
            this.newValue = newValue;
        }

        @Override
        public void tick() {
            super.tick();
            if (this.ticks > 0) {
                --this.ticks;
            }
            if (this.ticks == 0 && this.editBox != null) {
                this.ticks = 10;
                this.editBox.m_94144_(BLOCK_INCREMENT_FORMAT.format(this.getPositionValue()));
            }
        }

        @Override
        public void init(int posX, int posY) {
            super.init(posX, posY);
            this.editBox = new EditBox(ArmorStandPositionScreen.this.f_96547_, posX + 77, posY, 66, 22, EntityType.f_20529_.m_20676_());
            this.editBox.m_94199_(50);
            this.editBox.m_94186_(false);
            this.editBox.m_94205_(0xE0E0E0);
            this.editBox.m_94144_(BLOCK_INCREMENT_FORMAT.format(this.getPositionValue()));
            this.children.add(this.editBox);
            this.children.add((AbstractWidget)ArmorStandPositionScreen.this.m_142416_((GuiEventListener)new ImageButton(posX + 149, posY + 1, 20, 10, 196, 64, 20, AbstractArmorStandScreen.getArmorStandWidgetsLocation(), 256, 256, button -> this.setPositionValue(this.getPositionValue() + currentIncrement), (button, poseStack, mouseX, mouseY) -> ArmorStandPositionScreen.this.m_96602_(poseStack, (Component)Component.m_237110_((String)ArmorStandPositionScreen.INCREMENT_TRANSLATION_KEY, (Object[])new Object[]{ArmorStandPositionScreen.getPixelIncrementComponent(currentIncrement)}), mouseX, mouseY), CommonComponents.f_237098_)));
            this.children.add((AbstractWidget)ArmorStandPositionScreen.this.m_142416_((GuiEventListener)new ImageButton(posX + 149, posY + 11, 20, 10, 216, 74, 20, AbstractArmorStandScreen.getArmorStandWidgetsLocation(), 256, 256, button -> this.setPositionValue(this.getPositionValue() - currentIncrement), (button, poseStack, mouseX, mouseY) -> ArmorStandPositionScreen.this.m_96602_(poseStack, (Component)Component.m_237110_((String)ArmorStandPositionScreen.DECREMENT_TRANSLATION_KEY, (Object[])new Object[]{ArmorStandPositionScreen.getPixelIncrementComponent(currentIncrement)}), mouseX, mouseY), CommonComponents.f_237098_)));
            this.children.add((AbstractWidget)ArmorStandPositionScreen.this.m_142416_((GuiEventListener)new ImageButton(posX + 174, posY + 1, 20, 20, 236, 64, AbstractArmorStandScreen.getArmorStandWidgetsLocation(), button -> ArmorStandPositionScreen.this.setActiveWidget(this))));
        }

        private double getPositionValue() {
            return PuzzlesUtil.round((double)((double)Math.round(this.currentValue.getAsDouble() * 16.0) / 16.0), (int)4);
        }

        private void setPositionValue(double newValue) {
            this.ticks = 20;
            newValue = (double)Math.round(newValue * 16.0) / 16.0;
            if (this.getPositionValue() != newValue) {
                this.editBox.m_94144_(BLOCK_INCREMENT_FORMAT.format(newValue));
                this.newValue.accept(newValue);
            }
        }

        @Override
        public void render(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            super.render(poseStack, mouseX, mouseY, partialTick);
            this.editBox.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }

        @Override
        public boolean alwaysVisible(@Nullable ArmorStandWidgetsScreen.ArmorStandWidget activeWidget) {
            return activeWidget instanceof PositionIncrementWidget || super.alwaysVisible(activeWidget);
        }
    }
}

