/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.network.client;

import fuzs.armorstatues.api.StatuesApi;
import fuzs.armorstatues.api.world.inventory.ArmorStandMenu;
import fuzs.puzzleslib.network.Message;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class C2SArmorStandPositionMessage
implements Message<C2SArmorStandPositionMessage> {
    private double posX;
    private double posY;
    private double posZ;

    public C2SArmorStandPositionMessage() {
    }

    public C2SArmorStandPositionMessage(double posX, double posY, double posZ) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    public void read(FriendlyByteBuf buf) {
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
    }

    public Message.MessageHandler<C2SArmorStandPositionMessage> makeHandler() {
        return new Message.MessageHandler<C2SArmorStandPositionMessage>(){

            public void handle(C2SArmorStandPositionMessage message, Player player, Object gameInstance) {
                ArmorStandMenu menu;
                AbstractContainerMenu abstractContainerMenu = player.f_36096_;
                if (abstractContainerMenu instanceof ArmorStandMenu && (menu = (ArmorStandMenu)abstractContainerMenu).m_6875_(player) && !C2SArmorStandPositionMessage.tryMoveArmorStandTo(menu.getArmorStand(), message.posX, message.posY, message.posZ)) {
                    StatuesApi.LOGGER.warn("Player {} attempted to move armor stand further than allowed", (Object)player);
                }
            }
        };
    }

    private static boolean tryMoveArmorStandTo(ArmorStand armorStand, double posX, double posY, double posZ) {
        if (!C2SArmorStandPositionMessage.testDistance(armorStand, posX, posY, posZ)) {
            return false;
        }
        armorStand.m_6027_(posX, posY, posZ);
        return true;
    }

    private static boolean testDistance(ArmorStand armorStand, double posX, double posY, double posZ) {
        return armorStand.m_20275_(posX, posY, posZ) < 64.0;
    }
}

