/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.world.inventory.data;

import fuzs.armorstatues.api.world.inventory.data.PosePartMutator;
import fuzs.armorstatues.mixin.accessor.ArmorStandAccessor;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.Util;
import net.minecraft.core.Rotations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.decoration.ArmorStand;
import org.jetbrains.annotations.Nullable;

public class ArmorStandPose {
    private static final Rotations ZERO_ROTATIONS = new Rotations(0.0f, 0.0f, 0.0f);
    public static final double DEGREES_SNAP_INTERVAL = 0.125;
    public static final DecimalFormat ROTATION_FORMAT = (DecimalFormat)Util.m_137469_((Object)new DecimalFormat("#.##"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    public static final ArmorStandPose EMPTY = new ArmorStandPose(null).withSourceType(SourceType.EMPTY);
    public static final ArmorStandPose ATHENA = new ArmorStandPose("athena").withBodyPose(new Rotations(0.0f, 0.0f, 2.0f)).withHeadPose(new Rotations(-5.0f, 0.0f, 0.0f)).withLeftArmPose(new Rotations(10.0f, 0.0f, -5.0f)).withLeftLegPose(new Rotations(-3.0f, -3.0f, -3.0f)).withRightArmPose(new Rotations(-60.0f, 20.0f, -10.0f)).withRightLegPose(new Rotations(3.0f, 3.0f, 3.0f)).withSourceType(SourceType.MINECRAFT);
    public static final ArmorStandPose BRANDISH = new ArmorStandPose("brandish").withBodyPose(new Rotations(0.0f, 0.0f, -2.0f)).withHeadPose(new Rotations(-15.0f, 0.0f, 0.0f)).withLeftArmPose(new Rotations(20.0f, 0.0f, -10.0f)).withLeftLegPose(new Rotations(5.0f, -3.0f, -3.0f)).withRightArmPose(new Rotations(-110.0f, 50.0f, 0.0f)).withRightLegPose(new Rotations(-5.0f, 3.0f, 3.0f)).withSourceType(SourceType.MINECRAFT);
    public static final ArmorStandPose CANCAN = new ArmorStandPose("cancan").withBodyPose(new Rotations(0.0f, 22.0f, 0.0f)).withHeadPose(new Rotations(-5.0f, 18.0f, 0.0f)).withLeftArmPose(new Rotations(8.0f, 0.0f, -114.0f)).withLeftLegPose(new Rotations(-111.0f, 55.0f, 0.0f)).withRightArmPose(new Rotations(0.0f, 84.0f, 111.0f)).withRightLegPose(new Rotations(0.0f, 23.0f, -13.0f)).withSourceType(SourceType.MINECRAFT);
    public static final ArmorStandPose DEFAULT = new ArmorStandPose("default").withLeftArmPose(new Rotations(-10.0f, 0.0f, -10.0f)).withLeftLegPose(new Rotations(-1.0f, 0.0f, -1.0f)).withRightArmPose(new Rotations(-15.0f, 0.0f, 10.0f)).withRightLegPose(new Rotations(1.0f, 0.0f, 1.0f)).withSourceType(SourceType.MINECRAFT);
    public static final ArmorStandPose ENTERTAIN = new ArmorStandPose("entertain").withHeadPose(new Rotations(-15.0f, 0.0f, 0.0f)).withLeftArmPose(new Rotations(-110.0f, -35.0f, 0.0f)).withLeftLegPose(new Rotations(5.0f, -3.0f, -3.0f)).withRightArmPose(new Rotations(-110.0f, 35.0f, 0.0f)).withRightLegPose(new Rotations(-5.0f, 3.0f, 3.0f)).withSourceType(SourceType.MINECRAFT);
    public static final ArmorStandPose HERO = new ArmorStandPose("hero").withBodyPose(new Rotations(0.0f, 8.0f, 0.0f)).withHeadPose(new Rotations(-4.0f, 67.0f, 0.0f)).withLeftArmPose(new Rotations(16.0f, 32.0f, -8.0f)).withLeftLegPose(new Rotations(0.0f, -75.0f, -8.0f)).withRightArmPose(new Rotations(-99.0f, 63.0f, 0.0f)).withRightLegPose(new Rotations(4.0f, 63.0f, 8.0f)).withSourceType(SourceType.MINECRAFT);
    public static final ArmorStandPose HONOR = new ArmorStandPose("honor").withHeadPose(new Rotations(-15.0f, 0.0f, 0.0f)).withLeftArmPose(new Rotations(-110.0f, 35.0f, 0.0f)).withLeftLegPose(new Rotations(5.0f, -3.0f, -3.0f)).withRightArmPose(new Rotations(-110.0f, -35.0f, 0.0f)).withRightLegPose(new Rotations(-5.0f, 3.0f, 3.0f)).withSourceType(SourceType.MINECRAFT);
    public static final ArmorStandPose RIPOSTE = new ArmorStandPose("riposte").withHeadPose(new Rotations(16.0f, 20.0f, 0.0f)).withLeftArmPose(new Rotations(4.0f, 8.0f, 237.0f)).withLeftLegPose(new Rotations(-14.0f, -18.0f, -16.0f)).withRightArmPose(new Rotations(246.0f, 0.0f, 89.0f)).withRightLegPose(new Rotations(8.0f, 20.0f, 4.0f)).withSourceType(SourceType.MINECRAFT);
    public static final ArmorStandPose SALUTE = new ArmorStandPose("salute").withLeftArmPose(new Rotations(10.0f, 0.0f, -5.0f)).withLeftLegPose(new Rotations(-1.0f, 0.0f, -1.0f)).withRightArmPose(new Rotations(-70.0f, -40.0f, 0.0f)).withRightLegPose(new Rotations(1.0f, 0.0f, 1.0f)).withSourceType(SourceType.MINECRAFT);
    public static final ArmorStandPose SOLEMN = new ArmorStandPose("solemn").withBodyPose(new Rotations(0.0f, 0.0f, 2.0f)).withHeadPose(new Rotations(15.0f, 0.0f, 0.0f)).withLeftArmPose(new Rotations(-30.0f, 15.0f, 15.0f)).withLeftLegPose(new Rotations(-1.0f, 0.0f, -1.0f)).withRightArmPose(new Rotations(-60.0f, -20.0f, -10.0f)).withRightLegPose(new Rotations(1.0f, 0.0f, 1.0f)).withSourceType(SourceType.MINECRAFT);
    public static final ArmorStandPose ZOMBIE = new ArmorStandPose("zombie").withHeadPose(new Rotations(-10.0f, 0.0f, -5.0f)).withLeftArmPose(new Rotations(-105.0f, 0.0f, 0.0f)).withLeftLegPose(new Rotations(7.0f, 0.0f, 0.0f)).withRightArmPose(new Rotations(-100.0f, 0.0f, 0.0f)).withRightLegPose(new Rotations(-46.0f, 0.0f, 0.0f)).withSourceType(SourceType.MINECRAFT);
    public static final ArmorStandPose WALKING = new ArmorStandPose("walking").withRightArmPose(new Rotations(20.0f, 0.0f, 10.0f)).withLeftArmPose(new Rotations(-20.0f, 0.0f, -10.0f)).withRightLegPose(new Rotations(-20.0f, 0.0f, 0.0f)).withLeftLegPose(new Rotations(20.0f, 0.0f, 0.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose RUNNING = new ArmorStandPose("running").withRightArmPose(new Rotations(-40.0f, 0.0f, 10.0f)).withLeftArmPose(new Rotations(40.0f, 0.0f, -10.0f)).withRightLegPose(new Rotations(40.0f, 0.0f, 0.0f)).withLeftLegPose(new Rotations(-40.0f, 0.0f, 0.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose POINTING = new ArmorStandPose("pointing").withHeadPose(new Rotations(0.0f, 20.0f, 0.0f)).withRightArmPose(new Rotations(-90.0f, 18.0f, 0.0f)).withLeftArmPose(new Rotations(0.0f, 0.0f, -10.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose BLOCKING = new ArmorStandPose("blocking").withRightArmPose(new Rotations(-20.0f, -20.0f, 0.0f)).withLeftArmPose(new Rotations(-50.0f, 50.0f, 0.0f)).withRightLegPose(new Rotations(-20.0f, 0.0f, 0.0f)).withLeftLegPose(new Rotations(20.0f, 0.0f, 0.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose LUNGEING = new ArmorStandPose("lungeing").withBodyPose(new Rotations(15.0f, 0.0f, 0.0f)).withRightArmPose(new Rotations(-60.0f, -10.0f, 0.0f)).withLeftArmPose(new Rotations(10.0f, 0.0f, -10.0f)).withRightLegPose(new Rotations(-15.0f, 0.0f, 0.0f)).withLeftLegPose(new Rotations(30.0f, 0.0f, 0.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose WINNING = new ArmorStandPose("winning").withHeadPose(new Rotations(-15.0f, 0.0f, 0.0f)).withRightArmPose(new Rotations(-120.0f, -10.0f, 0.0f)).withLeftArmPose(new Rotations(10.0f, 0.0f, -10.0f)).withLeftLegPose(new Rotations(15.0f, 0.0f, 0.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose SITTING = new ArmorStandPose("sitting").withRightArmPose(new Rotations(-80.0f, 20.0f, 0.0f)).withLeftArmPose(new Rotations(-80.0f, -20.0f, 0.0f)).withRightLegPose(new Rotations(-90.0f, 10.0f, 0.0f)).withLeftLegPose(new Rotations(-90.0f, -10.0f, 0.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose ARABESQUE = new ArmorStandPose("arabesque").withHeadPose(new Rotations(-15.0f, 0.0f, 0.0f)).withBodyPose(new Rotations(10.0f, 0.0f, 0.0f)).withRightArmPose(new Rotations(-140.0f, -10.0f, 0.0f)).withLeftArmPose(new Rotations(70.0f, 0.0f, -10.0f)).withLeftLegPose(new Rotations(75.0f, 0.0f, 0.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose CUPID = new ArmorStandPose("cupid").withBodyPose(new Rotations(10.0f, 0.0f, 0.0f)).withRightArmPose(new Rotations(-90.0f, -10.0f, 0.0f)).withLeftArmPose(new Rotations(-75.0f, 0.0f, 10.0f)).withLeftLegPose(new Rotations(75.0f, 0.0f, 0.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose CONFIDENT = new ArmorStandPose("confident").withHeadPose(new Rotations(-10.0f, 20.0f, 0.0f)).withBodyPose(new Rotations(-2.0f, 0.0f, 0.0f)).withRightArmPose(new Rotations(5.0f, 0.0f, 0.0f)).withLeftArmPose(new Rotations(5.0f, 0.0f, 0.0f)).withRightLegPose(new Rotations(16.0f, 2.0f, 10.0f)).withLeftLegPose(new Rotations(0.0f, -10.0f, -4.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose DEATH = new ArmorStandPose("death").withHeadPose(new Rotations(-85.0f, 0.0f, 0.0f)).withBodyPose(new Rotations(-90.0f, 0.0f, 0.0f)).withRightArmPose(new Rotations(-90.0f, 10.0f, 0.0f)).withLeftArmPose(new Rotations(-90.0f, -10.0f, 0.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose FACEPALM = new ArmorStandPose("facepalm").withHeadPose(new Rotations(45.0f, -4.0f, 1.0f)).withBodyPose(new Rotations(10.0f, 0.0f, 0.0f)).withRightArmPose(new Rotations(18.0f, -14.0f, 0.0f)).withLeftArmPose(new Rotations(-72.0f, 24.0f, 47.0f)).withRightLegPose(new Rotations(25.0f, -2.0f, 0.0f)).withLeftLegPose(new Rotations(-4.0f, -6.0f, -2.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose LAZING = new ArmorStandPose("lazing").withHeadPose(new Rotations(14.0f, -12.0f, 6.0f)).withBodyPose(new Rotations(5.0f, 0.0f, 0.0f)).withRightArmPose(new Rotations(-40.0f, 20.0f, 0.0f)).withLeftArmPose(new Rotations(-4.0f, -20.0f, -10.0f)).withRightLegPose(new Rotations(-88.0f, 71.0f, 0.0f)).withLeftLegPose(new Rotations(-88.0f, 46.0f, 0.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose CONFUSED = new ArmorStandPose("confused").withHeadPose(new Rotations(0.0f, 30.0f, 0.0f)).withBodyPose(new Rotations(0.0f, 13.0f, 0.0f)).withRightArmPose(new Rotations(-22.0f, 31.0f, 10.0f)).withLeftArmPose(new Rotations(145.0f, 22.0f, -49.0f)).withRightLegPose(new Rotations(6.0f, -20.0f, 0.0f)).withLeftLegPose(new Rotations(-6.0f, 0.0f, 0.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose FORMAL = new ArmorStandPose("formal").withHeadPose(new Rotations(4.0f, 0.0f, 0.0f)).withBodyPose(new Rotations(4.0f, 0.0f, 0.0f)).withRightArmPose(new Rotations(30.0f, 22.0f, -20.0f)).withLeftArmPose(new Rotations(30.0f, -20.0f, 21.0f)).withRightLegPose(new Rotations(0.0f, 0.0f, 5.0f)).withLeftLegPose(new Rotations(0.0f, 0.0f, -5.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose SAD = new ArmorStandPose("sad").withHeadPose(new Rotations(63.0f, 0.0f, 0.0f)).withBodyPose(new Rotations(10.0f, 0.0f, 0.0f)).withRightArmPose(new Rotations(-5.0f, 0.0f, 5.0f)).withLeftArmPose(new Rotations(-5.0f, 0.0f, -5.0f)).withRightLegPose(new Rotations(-5.0f, -10.0f, 5.0f)).withLeftLegPose(new Rotations(-5.0f, 16.0f, -5.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose JOYOUS = new ArmorStandPose("joyous").withHeadPose(new Rotations(-11.0f, 0.0f, 0.0f)).withBodyPose(new Rotations(-4.0f, 0.0f, 0.0f)).withRightArmPose(new Rotations(0.0f, 0.0f, 100.0f)).withLeftArmPose(new Rotations(0.0f, 0.0f, -100.0f)).withRightLegPose(new Rotations(-8.0f, 0.0f, 60.0f)).withLeftLegPose(new Rotations(-8.0f, 0.0f, -60.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose STARGAZING = new ArmorStandPose("stargazing").withHeadPose(new Rotations(-22.0f, 25.0f, 0.0f)).withBodyPose(new Rotations(-4.0f, 10.0f, 0.0f)).withRightArmPose(new Rotations(-153.0f, 34.0f, -3.0f)).withLeftArmPose(new Rotations(4.0f, 18.0f, 0.0f)).withRightLegPose(new Rotations(-4.0f, 17.0f, 2.0f)).withLeftLegPose(new Rotations(6.0f, 24.0f, 0.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    private static final ArmorStandPose[] VALUES = new ArmorStandPose[]{DEFAULT, SOLEMN, ATHENA, BRANDISH, HONOR, ENTERTAIN, SALUTE, HERO, RIPOSTE, ZOMBIE, CANCAN, WALKING, RUNNING, POINTING, BLOCKING, LUNGEING, WINNING, SITTING, ARABESQUE, CUPID, CONFIDENT, DEATH, FACEPALM, LAZING, CONFUSED, FORMAL, SAD, JOYOUS, STARGAZING};
    @Nullable
    private final String name;
    @Nullable
    private final SourceType sourceType;
    @Nullable
    private final Rotations headPose;
    @Nullable
    private final Rotations bodyPose;
    @Nullable
    private final Rotations leftArmPose;
    @Nullable
    private final Rotations rightArmPose;
    @Nullable
    private final Rotations leftLegPose;
    @Nullable
    private final Rotations rightLegPose;

    private ArmorStandPose(@Nullable String name) {
        this(name, null, ZERO_ROTATIONS, ZERO_ROTATIONS, ZERO_ROTATIONS, ZERO_ROTATIONS, ZERO_ROTATIONS, ZERO_ROTATIONS);
    }

    private ArmorStandPose(@Nullable String name, @Nullable SourceType sourceType, @Nullable Rotations headPose, @Nullable Rotations bodyPose, @Nullable Rotations leftArmPose, @Nullable Rotations rightArmPose, @Nullable Rotations leftLegPose, @Nullable Rotations rightLegPose) {
        this.name = name;
        this.sourceType = sourceType;
        this.headPose = headPose;
        this.bodyPose = bodyPose;
        this.leftArmPose = leftArmPose;
        this.rightArmPose = rightArmPose;
        this.leftLegPose = leftLegPose;
        this.rightLegPose = rightLegPose;
    }

    public static ArmorStandPose empty() {
        return new ArmorStandPose(null, null, null, null, null, null, null, null);
    }

    public String toString() {
        return this.name != null ? this.name.toUpperCase(Locale.ROOT) : "POSE";
    }

    public String getTranslationKey() {
        return this.name != null ? "statues.screen.pose." + this.name : null;
    }

    public SourceType getSourceType() {
        return this.sourceType != null ? this.sourceType : SourceType.TRANSIENT;
    }

    public Rotations getHeadPose() {
        return this.headPose != null ? this.headPose : ZERO_ROTATIONS;
    }

    public Rotations getBodyPose() {
        return this.bodyPose != null ? this.bodyPose : ZERO_ROTATIONS;
    }

    public Rotations getLeftArmPose() {
        return this.leftArmPose != null ? this.leftArmPose : ZERO_ROTATIONS;
    }

    public Rotations getRightArmPose() {
        return this.rightArmPose != null ? this.rightArmPose : ZERO_ROTATIONS;
    }

    public Rotations getLeftLegPose() {
        return this.leftLegPose != null ? this.leftLegPose : ZERO_ROTATIONS;
    }

    public Rotations getRightLegPose() {
        return this.rightLegPose != null ? this.rightLegPose : ZERO_ROTATIONS;
    }

    @Nullable
    public Rotations getNullableHeadPose() {
        return this.headPose;
    }

    @Nullable
    public Rotations getNullableBodyPose() {
        return this.bodyPose;
    }

    @Nullable
    public Rotations getNullableLeftArmPose() {
        return this.leftArmPose;
    }

    @Nullable
    public Rotations getNullableRightArmPose() {
        return this.rightArmPose;
    }

    @Nullable
    public Rotations getNullableLeftLegPose() {
        return this.leftLegPose;
    }

    @Nullable
    public Rotations getNullableRightLegPose() {
        return this.rightLegPose;
    }

    public ArmorStandPose withHeadPose(Rotations rotation) {
        return new ArmorStandPose(this.name, null, rotation, this.bodyPose, this.leftArmPose, this.rightArmPose, this.leftLegPose, this.rightLegPose);
    }

    public ArmorStandPose withBodyPose(Rotations rotation) {
        return new ArmorStandPose(this.name, null, this.headPose, rotation, this.leftArmPose, this.rightArmPose, this.leftLegPose, this.rightLegPose);
    }

    public ArmorStandPose withLeftArmPose(Rotations rotation) {
        return new ArmorStandPose(this.name, null, this.headPose, this.bodyPose, rotation, this.rightArmPose, this.leftLegPose, this.rightLegPose);
    }

    public ArmorStandPose withRightArmPose(Rotations rotation) {
        return new ArmorStandPose(this.name, null, this.headPose, this.bodyPose, this.leftArmPose, rotation, this.leftLegPose, this.rightLegPose);
    }

    public ArmorStandPose withLeftLegPose(Rotations rotation) {
        return new ArmorStandPose(this.name, null, this.headPose, this.bodyPose, this.leftArmPose, this.rightArmPose, rotation, this.rightLegPose);
    }

    public ArmorStandPose withRightLegPose(Rotations rotation) {
        return new ArmorStandPose(this.name, null, this.headPose, this.bodyPose, this.leftArmPose, this.rightArmPose, this.leftLegPose, rotation);
    }

    public ArmorStandPose withSourceType(SourceType sourceType) {
        return new ArmorStandPose(this.name, sourceType, this.headPose, this.bodyPose, this.leftArmPose, this.rightArmPose, this.leftLegPose, this.rightLegPose);
    }

    public ArmorStandPose mirror() {
        return new ArmorStandPose(this.name, SourceType.MIRRORED, ArmorStandPose.mirrorRotations(this.headPose), ArmorStandPose.mirrorRotations(this.bodyPose), ArmorStandPose.mirrorRotations(this.rightArmPose), ArmorStandPose.mirrorRotations(this.leftArmPose), ArmorStandPose.mirrorRotations(this.rightLegPose), ArmorStandPose.mirrorRotations(this.leftLegPose));
    }

    @Nullable
    private static Rotations mirrorRotations(@Nullable Rotations rotations) {
        return rotations != null ? new Rotations(rotations.m_123156_(), -rotations.m_123157_(), -rotations.m_123158_()) : null;
    }

    public ArmorStandPose copyAndFillFrom(ArmorStandPose fillFrom) {
        return new ArmorStandPose(this.name, this.sourceType, this.headPose != null ? this.headPose : fillFrom.headPose, this.bodyPose != null ? this.bodyPose : fillFrom.bodyPose, this.leftArmPose != null ? this.leftArmPose : fillFrom.leftArmPose, this.rightArmPose != null ? this.rightArmPose : fillFrom.rightArmPose, this.leftLegPose != null ? this.leftLegPose : fillFrom.leftLegPose, this.rightLegPose != null ? this.rightLegPose : fillFrom.rightLegPose);
    }

    public void applyToEntity(ArmorStand armorStand) {
        armorStand.m_31597_(this.getHeadPose());
        armorStand.m_31616_(this.getBodyPose());
        armorStand.m_31623_(this.getLeftArmPose());
        armorStand.m_31628_(this.getRightArmPose());
        armorStand.m_31639_(this.getLeftLegPose());
        armorStand.m_31651_(this.getRightLegPose());
    }

    public void serializeAllPoses(CompoundTag tag) {
        this.serializeBodyPoses(tag, null);
        this.serializeArmPoses(tag, null);
        this.serializeLegPoses(tag, null);
    }

    public boolean serializeBodyPoses(CompoundTag tag, @Nullable ArmorStandPose lastSentPose) {
        boolean hasChanged = false;
        if (!(this.headPose == null || lastSentPose != null && this.headPose.equals((Object)lastSentPose.headPose))) {
            tag.m_128365_("Head", (Tag)this.headPose.m_123155_());
            hasChanged = true;
        }
        if (!(this.bodyPose == null || lastSentPose != null && this.bodyPose.equals((Object)lastSentPose.bodyPose))) {
            tag.m_128365_("Body", (Tag)this.bodyPose.m_123155_());
            hasChanged = true;
        }
        return hasChanged;
    }

    public boolean serializeArmPoses(CompoundTag tag, @Nullable ArmorStandPose lastSentPose) {
        boolean hasChanged = false;
        if (!(this.leftArmPose == null || lastSentPose != null && this.leftArmPose.equals((Object)lastSentPose.leftArmPose))) {
            tag.m_128365_("LeftArm", (Tag)this.leftArmPose.m_123155_());
            hasChanged = true;
        }
        if (!(this.rightArmPose == null || lastSentPose != null && this.rightArmPose.equals((Object)lastSentPose.rightArmPose))) {
            tag.m_128365_("RightArm", (Tag)this.rightArmPose.m_123155_());
            hasChanged = true;
        }
        return hasChanged;
    }

    public boolean serializeLegPoses(CompoundTag tag, @Nullable ArmorStandPose lastSentPose) {
        boolean hasChanged = false;
        if (!(this.leftLegPose == null || lastSentPose != null && this.leftLegPose.equals((Object)lastSentPose.leftLegPose))) {
            tag.m_128365_("LeftLeg", (Tag)this.leftLegPose.m_123155_());
            hasChanged = true;
        }
        if (!(this.rightLegPose == null || lastSentPose != null && this.rightLegPose.equals((Object)lastSentPose.rightLegPose))) {
            tag.m_128365_("RightLeg", (Tag)this.rightLegPose.m_123155_());
            hasChanged = true;
        }
        return hasChanged;
    }

    public static ArmorStandPose fromEntity(ArmorStand armorStand) {
        return new ArmorStandPose(null, null, armorStand.m_31680_(), armorStand.m_31685_(), armorStand.m_31688_(), armorStand.m_31689_(), armorStand.m_31691_(), armorStand.m_31694_());
    }

    public static void applyTagToEntity(ArmorStand armorStand, CompoundTag tag) {
        ((ArmorStandAccessor)armorStand).callReadPose(tag);
    }

    public static ArmorStandPose random(PosePartMutator[] mutators, boolean clampRotations) {
        ArmorStandPose.checkMutatorsSize(mutators);
        return new ArmorStandPose(null, null, mutators[0].randomRotations(clampRotations), mutators[1].randomRotations(clampRotations), mutators[2].randomRotations(clampRotations), mutators[3].randomRotations(clampRotations), mutators[4].randomRotations(clampRotations), mutators[5].randomRotations(clampRotations));
    }

    public static ArmorStandPose[] values() {
        return (ArmorStandPose[])VALUES.clone();
    }

    public static int valuesLength() {
        return VALUES.length;
    }

    public static ArmorStandPose randomValue() {
        List<ArmorStandPose> poses = Arrays.asList(VALUES);
        Collections.shuffle(poses);
        return (ArmorStandPose)poses.stream().findAny().orElseThrow();
    }

    public static void checkMutatorsSize(PosePartMutator[] mutators) {
        if (mutators.length != 6) {
            throw new IllegalArgumentException("Invalid mutators size: Expected 6, was %s".formatted(mutators.length));
        }
    }

    public static double snapValue(double value, double snapInterval) {
        if (snapInterval > 0.0 && snapInterval < 1.0) {
            for (double currentSnap = 0.0; currentSnap < 1.0; currentSnap += snapInterval) {
                double snapRegion = snapInterval * 0.1;
                if (!(value >= currentSnap - snapRegion) || !(value < currentSnap + snapRegion)) continue;
                return currentSnap;
            }
        }
        return value;
    }

    public static enum SourceType {
        MINECRAFT,
        VANILLA_TWEAKS,
        TRANSIENT,
        EMPTY,
        MIRRORED;


        @Nullable
        public String getDisplayName() {
            if (this == MINECRAFT) {
                return "Minecraft";
            }
            if (this == VANILLA_TWEAKS) {
                return "Vanilla Tweaks";
            }
            return null;
        }
    }
}

