/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.client;

import fuzs.armorstatues.api.client.StatuesApiClient;
import fuzs.armorstatues.client.ArmorStatuesClient;
import fuzs.armorstatues.client.handler.ArmorStandTooltipHandler;
import fuzs.armorstatues.client.handler.DataSyncTickHandler;
import fuzs.armorstatues.handler.ArmorStandInteractHandler;
import fuzs.puzzleslib.client.core.ClientCoreServices;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

@Mod.EventBusSubscriber(modid="armorstatues", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ArmorStatuesForgeClient {
    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent evt) {
        ClientCoreServices.FACTORIES.clientModConstructor("armorstatues").accept(new StatuesApiClient());
        ClientCoreServices.FACTORIES.clientModConstructor("armorstatues").accept(new ArmorStatuesClient());
        ArmorStatuesForgeClient.registerHandlers();
    }

    private static void registerHandlers() {
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            Minecraft minecraft = Minecraft.m_91087_();
            if (evt.isUseItem() && minecraft.f_91077_ != null && minecraft.f_91077_.m_6662_() == HitResult.Type.ENTITY) {
                EntityHitResult hitResult = (EntityHitResult)minecraft.f_91077_;
                Entity entity = hitResult.m_82443_();
                if (minecraft.f_91073_.m_6857_().m_61937_(entity.m_20183_()) && minecraft.f_91074_.canInteractWith(entity, 0.0)) {
                    Vec3 hitVector = hitResult.m_82450_().m_82492_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                    Optional<InteractionResult> result = ArmorStandInteractHandler.onUseEntityAt((Player)minecraft.f_91074_, (Level)minecraft.f_91073_, evt.getHand(), entity, hitVector);
                    if (result.filter(t -> t == InteractionResult.FAIL).isPresent()) {
                        evt.setSwingHand(false);
                        evt.setCanceled(true);
                    }
                }
            }
        });
        MinecraftForge.EVENT_BUS.addListener(evt -> ArmorStandTooltipHandler.onItemTooltip(evt.getItemStack(), evt.getFlags(), evt.getToolTip()));
        MinecraftForge.EVENT_BUS.addListener(evt -> ArmorStandInteractHandler.clearPresentServerside());
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            if (evt.phase != TickEvent.Phase.END) {
                return;
            }
            DataSyncTickHandler.onClientTickEnd(Minecraft.m_91087_());
        });
        MinecraftForge.EVENT_BUS.addListener(evt -> DataSyncTickHandler.onScreenClose(evt.getScreen()));
    }
}

