/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.network.client.data;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Unit;
import fuzs.puzzlesapi.api.statues.v1.network.client.data.DataSyncHandler;
import fuzs.puzzlesapi.api.statues.v1.world.inventory.ArmorStandHolder;
import fuzs.puzzlesapi.api.statues.v1.world.inventory.data.ArmorStandAlignment;
import fuzs.puzzlesapi.api.statues.v1.world.inventory.data.ArmorStandPose;
import fuzs.puzzlesapi.api.statues.v1.world.inventory.data.ArmorStandScreenType;
import fuzs.puzzlesapi.api.statues.v1.world.inventory.data.ArmorStandStyleOption;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.function.BiPredicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.decoration.ArmorStand;
import org.jetbrains.annotations.Nullable;

public class CommandDataSyncHandler
implements DataSyncHandler {
    public static final String NO_PERMISSION_TRANSLATION_KEY = "armorstatues.dataSync.failure.noPermission";
    public static final String NO_ARMOR_STAND_TRANSLATION_KEY = "armorstatues.dataSync.failure.noArmorStand";
    public static final String OUT_OF_RANGE_TRANSLATION_KEY = "armorstatues.dataSync.failure.outOfRange";
    public static final String NOT_FINISHED_TRANSLATION_KEY = "armorstatues.dataSync.failure.notFinished";
    public static final String FINISHED_TRANSLATION_KEY = "armorstatues.dataSync.finished";
    public static final String FAILURE_TRANSLATION_KEY = "armorstatues.dataSync.failure";
    private static final Queue<String> CLIENT_COMMAND_QUEUE = new ArrayDeque<String>();
    @Nullable
    private static ArmorStand queueArmorStand;
    private static int itemDequeuedTicks;
    private final ArmorStandHolder holder;
    protected final LocalPlayer player;
    protected ArmorStandPose lastSyncedPose;

    public CommandDataSyncHandler(ArmorStandHolder holder, LocalPlayer player) {
        this.holder = holder;
        this.lastSyncedPose = ArmorStandPose.fromEntity((ArmorStand)this.holder.getArmorStand());
        this.player = player;
    }

    public ArmorStandHolder getArmorStandHolder() {
        return this.holder;
    }

    public void sendName(String name) {
        if (!this.isEditingAllowed()) {
            return;
        }
        DataSyncHandler.setCustomArmorStandName((ArmorStand)this.getArmorStand(), (String)name);
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)Component.m_237113_((String)name)));
        this.enqueueEntityData(tag);
        this.finalizeCurrentOperation();
    }

    public final void sendPose(ArmorStandPose pose) {
        this.sendPose(pose, true);
    }

    public void sendPose(ArmorStandPose pose, boolean finalize) {
        if (!this.isEditingAllowed()) {
            return;
        }
        this.sendPosePart((arg_0, arg_1) -> ((ArmorStandPose)pose).serializeBodyPoses(arg_0, arg_1), this.lastSyncedPose);
        this.sendPosePart((arg_0, arg_1) -> ((ArmorStandPose)pose).serializeArmPoses(arg_0, arg_1), this.lastSyncedPose);
        this.sendPosePart((arg_0, arg_1) -> ((ArmorStandPose)pose).serializeLegPoses(arg_0, arg_1), this.lastSyncedPose);
        pose.applyToEntity(this.getArmorStand());
        this.lastSyncedPose = pose.copyAndFillFrom(this.lastSyncedPose);
        if (finalize) {
            this.finalizeCurrentOperation();
        }
    }

    private void sendPosePart(BiPredicate<CompoundTag, ArmorStandPose> dataWriter, ArmorStandPose lastSyncedPose) {
        CompoundTag tag = new CompoundTag();
        if (dataWriter.test(tag, lastSyncedPose)) {
            CompoundTag tagToSend = new CompoundTag();
            tagToSend.m_128365_("Pose", (Tag)tag);
            this.enqueueEntityData(tagToSend);
        }
    }

    @Nullable
    public ArmorStandPose getLastSyncedPose() {
        return this.lastSyncedPose;
    }

    public final void sendPosition(double posX, double posY, double posZ) {
        this.sendPosition(posX, posY, posZ, true);
    }

    public void sendPosition(double posX, double posY, double posZ, boolean finalize) {
        if (!this.isEditingAllowed()) {
            return;
        }
        ListTag listTag = new ListTag();
        listTag.add((Object)DoubleTag.m_128500_((double)posX));
        listTag.add((Object)DoubleTag.m_128500_((double)posY));
        listTag.add((Object)DoubleTag.m_128500_((double)posZ));
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Pos", (Tag)listTag);
        this.enqueueEntityData(tag);
        if (finalize) {
            this.finalizeCurrentOperation();
        }
    }

    public final void sendRotation(float rotation) {
        this.sendRotation(rotation, true);
    }

    public void sendRotation(float rotation, boolean finalize) {
        if (!this.isEditingAllowed()) {
            return;
        }
        ListTag listTag = new ListTag();
        listTag.add((Object)FloatTag.m_128566_((float)rotation));
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Rotation", (Tag)listTag);
        this.enqueueEntityData(tag);
        if (finalize) {
            this.finalizeCurrentOperation();
        }
    }

    public final void sendStyleOption(ArmorStandStyleOption styleOption, boolean value) {
        this.sendStyleOption(styleOption, value, true);
    }

    public void sendStyleOption(ArmorStandStyleOption styleOption, boolean value, boolean finalize) {
        if (!this.isEditingAllowed()) {
            return;
        }
        CompoundTag tag = new CompoundTag();
        styleOption.toTag(tag, value);
        this.enqueueEntityData(tag);
        styleOption.setOption(this.getArmorStand(), value);
        if (finalize) {
            this.finalizeCurrentOperation();
        }
    }

    public void sendAlignment(ArmorStandAlignment alignment) {
        if (!this.isEditingAllowed()) {
            return;
        }
        super.sendAlignment(alignment);
    }

    public boolean supportsScreenType(ArmorStandScreenType screenType) {
        return !screenType.requiresServer();
    }

    public void tick() {
        if (itemDequeuedTicks > 0) {
            --itemDequeuedTicks;
        }
        if (itemDequeuedTicks == 0 && queueArmorStand != null && !CLIENT_COMMAND_QUEUE.isEmpty()) {
            if (this.testArmorStand(queueArmorStand).right().isPresent()) {
                this.player.f_108617_.m_246623_(CLIENT_COMMAND_QUEUE.poll());
            } else {
                CLIENT_COMMAND_QUEUE.clear();
            }
            itemDequeuedTicks = this.getDequeueDelayTicks();
        } else if (itemDequeuedTicks == 1 && CLIENT_COMMAND_QUEUE.isEmpty()) {
            this.sendDisplayMessage((Component)Component.m_237115_((String)FINISHED_TRANSLATION_KEY), false);
        }
    }

    protected int getDequeueDelayTicks() {
        return 5;
    }

    public boolean shouldContinueTicking() {
        return !CLIENT_COMMAND_QUEUE.isEmpty() || itemDequeuedTicks != 0;
    }

    protected boolean isEditingAllowed() {
        return this.isEditingAllowed(true);
    }

    protected final boolean isEditingAllowed(boolean testPermissionLevel) {
        if (testPermissionLevel && !this.player.m_20310_(2)) {
            this.sendFailureMessage((Component)Component.m_237115_((String)NO_PERMISSION_TRANSLATION_KEY));
            return false;
        }
        return this.testArmorStand(this.getArmorStand()).ifLeft(this::sendFailureMessage).right().isPresent();
    }

    protected Either<Component, Unit> testArmorStand(ArmorStand armorStand) {
        return !armorStand.m_6084_() ? Either.left((Object)Component.m_237115_((String)NO_ARMOR_STAND_TRANSLATION_KEY)) : Either.right((Object)Unit.INSTANCE);
    }

    protected boolean enqueueClientCommand(String clientCommand) {
        if (CLIENT_COMMAND_QUEUE.isEmpty()) {
            queueArmorStand = null;
        } else if (queueArmorStand != null) {
            this.sendFailureMessage((Component)Component.m_237115_((String)NOT_FINISHED_TRANSLATION_KEY));
            return false;
        }
        CLIENT_COMMAND_QUEUE.offer(clientCommand);
        return true;
    }

    public void finalizeCurrentOperation() {
        if (!CLIENT_COMMAND_QUEUE.isEmpty()) {
            queueArmorStand = this.getArmorStand();
        }
    }

    protected void sendFailureMessage(Component component) {
        this.sendDisplayMessage((Component)Component.m_237110_((String)FAILURE_TRANSLATION_KEY, (Object[])new Object[]{component}), true);
    }

    protected void sendDisplayMessage(Component component, boolean failure) {
        this.player.m_5661_((Component)Component.m_237119_().m_7220_(component).m_130940_(failure ? ChatFormatting.RED : ChatFormatting.GREEN), false);
    }

    private void enqueueEntityData(CompoundTag tag) {
        this.enqueueClientCommand("data merge entity %s %s".formatted(this.getArmorStand().m_20149_(), tag.m_7916_()));
    }
}

