/*
 * Decompiled with CFR 0.152.
 */
package net.cloud.betterfog;

import java.util.ArrayList;
import java.util.List;
import net.cloud.betterfog.configuration.BetterFogConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class BiomeColor {
    static double v;
    static int r;
    static int checks;
    static int skip;

    public static List<Double> getColor(Level level, BlockPos pos) {
        v = (Double)BetterFogConfiguration.BIOME_CHECK_VERTICAL_FACTOR.get();
        r = (Integer)BetterFogConfiguration.BIOME_CHECK_RADIUS.get();
        checks = (Integer)BetterFogConfiguration.BIOME_CHECKS_FOR_SIDE.get();
        skip = (int)Math.round((double)(r * 2) / (double)checks);
        return BiomeColor.getColorAverage(level, pos);
    }

    public static List<Double> getColorAverage(Level level, BlockPos pos) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        int red = 0;
        int green = 0;
        int blue = 0;
        double alphaM = 0.0;
        double startM = 0.0;
        double endM = 0.0;
        for (int ix = -r; ix < r; ix += skip) {
            for (int iy = (int)Math.round((double)(-r) * v); iy < (int)Math.round((double)r * v); iy += skip) {
                for (int iz = -r; iz < r; iz += skip) {
                    List<Double> features = BiomeColor.getBiomeFeatures(level, new BlockPos(x + ix, y + iy, z + iz));
                    red = (int)((double)red + features.get(0));
                    green = (int)((double)green + features.get(1));
                    blue = (int)((double)blue + features.get(2));
                    alphaM += features.get(3).doubleValue();
                    startM += features.get(4).doubleValue();
                    endM += features.get(5).doubleValue();
                }
            }
        }
        double tot = (long)(checks * checks) * Math.round((double)checks * v);
        return List.of(Double.valueOf((double)red / tot), Double.valueOf((double)green / tot), Double.valueOf((double)blue / tot), Double.valueOf(alphaM / tot), Double.valueOf(startM / tot), Double.valueOf(endM / tot));
    }

    private static boolean checkForGradient(Level level, BlockPos pos) {
        Biome biome = (Biome)level.m_204166_(pos).m_203334_();
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        for (int j = 0; j < 8; ++j) {
            int mx = j - 4 < 0 ? -1 : 1;
            int ix = mx * r;
            int my = j % 4 - 2 < 0 ? -1 : 1;
            int iy = (int)Math.round((double)(my * r) * v);
            int mz = j % 2 - 1 < 0 ? -1 : 1;
            int iz = mz * r;
            for (int ip = 1; ip < r; ip += skip) {
                for (int i = 0; i < 3; ++i) {
                    if (biome == level.m_204166_(new BlockPos(x + ix + i == 0 ? ip * -mx : 0, y + iy + i == 1 ? ip * -my : 0, z + iz + i == 2 ? ip * -mz : 0)).m_203334_()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static List<Double> getBiomeFeatures(Level level, BlockPos pos) {
        Holder biome = level.m_204166_(pos);
        ArrayList<Double> output = new ArrayList<Double>();
        for (String category_color : (ArrayList)BetterFogConfiguration.BIOME_FEATURES_LIST.get()) {
            if (!category_color.startsWith(((Biome)biome.m_203334_()).getRegistryName().toString()) && !category_color.startsWith(Biome.m_204183_((Holder)biome).m_47645_()) && !category_color.startsWith(level.m_46472_().getRegistryName().toString())) continue;
            String[] input = category_color.split(";");
            for (int i = 1; i < input.length; ++i) {
                if (i == 1) {
                    String hexColor = input[i];
                    double red = Integer.parseInt(hexColor.substring(0, 2), 16);
                    double green = Integer.parseInt(hexColor.substring(2, 4), 16);
                    double blue = Integer.parseInt(hexColor.substring(4, 6), 16);
                    output.add(red);
                    output.add(green);
                    output.add(blue);
                    continue;
                }
                output.add(Double.parseDouble(input[i]));
            }
            return output;
        }
        return List.of(Double.valueOf(255.0), Double.valueOf(255.0), Double.valueOf(255.0), Double.valueOf(1.0), Double.valueOf(1.0), Double.valueOf(1.0));
    }

    public static float getTimeOfDayValue(Level world) {
        long time = world.m_46468_() % 24000L;
        long startDay = 2000L;
        long endDay = 11000L;
        long startTransition = 11000L;
        long endTransition = 14500L;
        long endNight = 21500L;
        if (time < startDay) {
            return 0.5555556f - (float)time / 4500.0f;
        }
        float value = time < endDay ? 0.0f : (time < endTransition ? (float)(time - startTransition) / (float)(endTransition - startTransition) : (time < endNight ? 1.0f : 0.44444445f + (24000.0f - (float)time) / 4500.0f));
        return value;
    }

    public static double fromTo(double a, double b, double f) {
        if (f >= 1.0) {
            return b;
        }
        if (f <= 0.0) {
            return a;
        }
        return a + (b - a) * f;
    }
}

