/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalwindows.world.level.block;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fuzs.diagonalwindows.DiagonalWindows;
import fuzs.diagonalwindows.api.world.level.block.DiagonalBlock;
import fuzs.diagonalwindows.api.world.level.block.EightWayDirection;
import fuzs.diagonalwindows.world.phys.shapes.NoneVoxelShape;
import fuzs.diagonalwindows.world.phys.shapes.VoxelCollection;
import fuzs.diagonalwindows.world.phys.shapes.VoxelUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_156;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2310;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2429;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3612;

public interface StarCollisionBlock
extends DiagonalBlock {
    public static final Map<List<Float>, class_265[]> DIMENSIONS_TO_SHAPE_CACHE = Maps.newHashMap();
    public static final Map<EightWayDirection, class_2746> DIRECTION_TO_PROPERTY_MAP = (Map)class_156.method_654((Object)Maps.newEnumMap(EightWayDirection.class), directions -> {
        directions.put(EightWayDirection.NORTH, class_2429.field_11332);
        directions.put(EightWayDirection.EAST, class_2429.field_11335);
        directions.put(EightWayDirection.SOUTH, class_2429.field_11331);
        directions.put(EightWayDirection.WEST, class_2429.field_11328);
        directions.put(EightWayDirection.NORTH_EAST, DiagonalBlock.NORTH_EAST);
        directions.put(EightWayDirection.SOUTH_EAST, DiagonalBlock.SOUTH_EAST);
        directions.put(EightWayDirection.SOUTH_WEST, DiagonalBlock.SOUTH_WEST);
        directions.put(EightWayDirection.NORTH_WEST, DiagonalBlock.NORTH_WEST);
    });

    public boolean canConnect(class_1922 var1, class_2338 var2, class_2680 var3, class_2350 var4);

    default public class_2680 addDefaultStates(class_2680 defaultState) {
        return (class_2680)((class_2680)((class_2680)((class_2680)defaultState.method_11657((class_2769)DiagonalBlock.NORTH_EAST, (Comparable)Boolean.FALSE)).method_11657((class_2769)DiagonalBlock.SOUTH_EAST, (Comparable)Boolean.FALSE)).method_11657((class_2769)DiagonalBlock.SOUTH_WEST, (Comparable)Boolean.FALSE)).method_11657((class_2769)DiagonalBlock.NORTH_WEST, (Comparable)Boolean.FALSE);
    }

    default public void createBlockStateDefinition2(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{DiagonalBlock.NORTH_EAST, DiagonalBlock.SOUTH_EAST, DiagonalBlock.SOUTH_WEST, DiagonalBlock.NORTH_WEST});
    }

    default public int makeIndex(class_2680 stateIn) {
        int index = 0;
        for (Map.Entry<EightWayDirection, class_2746> entry : DIRECTION_TO_PROPERTY_MAP.entrySet()) {
            if (!((Boolean)stateIn.method_11654((class_2769)entry.getValue())).booleanValue()) continue;
            index |= entry.getKey().getHorizontalIndex();
        }
        return index;
    }

    default public class_2680 makeStateForPlacement(class_2680 placementState, class_1922 blockGetter, class_2338 basePos, class_3610 fluidState) {
        placementState = (class_2680)placementState.method_11657((class_2769)class_2310.field_10900, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        placementState = this.withDirections(EightWayDirection.getCardinalDirections(), basePos, placementState, (mutablePos, newPlacementState, direction) -> this.canConnect(blockGetter, mutablePos, blockGetter.method_8320(mutablePos), direction.toDirection().method_10153()));
        placementState = this.withDirections(EightWayDirection.getIntercardinalDirections(), basePos, placementState, (pos, newPlacementState, direction) -> {
            if (!this.canConnectToMe(blockGetter.method_8320(pos), direction.opposite())) return false;
            if (!Stream.of(direction.getCardinalNeighbors()).map(DIRECTION_TO_PROPERTY_MAP::get).noneMatch(arg_0 -> ((class_2680)newPlacementState).method_11654(arg_0))) return false;
            return true;
        });
        return placementState;
    }

    default public class_2680 withDirections(EightWayDirection[] directions, class_2338 basePos, class_2680 placementState, DirectionStatePredicate predicate) {
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        for (EightWayDirection direction : directions) {
            mutablePos.method_25504((class_2382)basePos, direction.getX(), direction.getY(), direction.getZ());
            placementState = (class_2680)placementState.method_11657((class_2769)DIRECTION_TO_PROPERTY_MAP.get((Object)direction), (Comparable)Boolean.valueOf(predicate.test((class_2338)mutablePos, placementState, direction)));
        }
        return placementState;
    }

    default public class_2680 updateShape2(class_2680 state, class_2350 facing, class_2680 facingState, class_1936 level, class_2338 currentPos, class_2338 facingPos, class_2680 newState) {
        if (facing.method_10166().method_10180() == class_2350.class_2353.field_11062) {
            class_2338.class_2339 diagonalPos = new class_2338.class_2339();
            for (EightWayDirection direction : EightWayDirection.toEightWayDirection(facing).getIntercardinalNeighbors()) {
                diagonalPos.method_25504((class_2382)currentPos, direction.getX(), direction.getY(), direction.getZ());
                class_2680 diagonalState = level.method_8320((class_2338)diagonalPos);
                boolean isBlocked = false;
                for (EightWayDirection cardinal : direction.getCardinalNeighbors()) {
                    isBlocked |= ((Boolean)newState.method_11654((class_2769)DIRECTION_TO_PROPERTY_MAP.get((Object)cardinal))).booleanValue();
                }
                newState = (class_2680)newState.method_11657((class_2769)DIRECTION_TO_PROPERTY_MAP.get((Object)direction), (Comparable)Boolean.valueOf(!isBlocked && this.canConnectToMe(diagonalState, direction)));
            }
            return newState;
        }
        return null;
    }

    default public void updateIndirectNeighbourShapes2(class_2680 state, class_1936 level, class_2338 pos, int flags, int recursionLeft) {
        class_2338.class_2339 diagonalPos = new class_2338.class_2339();
        for (EightWayDirection direction : EightWayDirection.getIntercardinalDirections()) {
            StarCollisionBlock starCollisionBlock;
            diagonalPos.method_25504((class_2382)pos, direction.getX(), direction.getY(), direction.getZ());
            class_2680 diagonalState = level.method_8320((class_2338)diagonalPos);
            class_2248 class_22482 = diagonalState.method_26204();
            if (!(class_22482 instanceof StarCollisionBlock) || !(starCollisionBlock = (StarCollisionBlock)class_22482).supportsDiagonalConnections()) continue;
            boolean isBlocked = false;
            for (EightWayDirection cardinal : direction.opposite().getCardinalNeighbors()) {
                isBlocked |= ((Boolean)diagonalState.method_11654((class_2769)DIRECTION_TO_PROPERTY_MAP.get((Object)cardinal))).booleanValue();
            }
            class_2680 newState = (class_2680)diagonalState.method_11657((class_2769)DIRECTION_TO_PROPERTY_MAP.get((Object)direction.opposite()), (Comparable)Boolean.valueOf(!isBlocked && starCollisionBlock.canConnectToMe(level.method_8320(pos), direction)));
            class_2248.method_9611((class_2680)diagonalState, (class_2680)newState, (class_1936)level, (class_2338)diagonalPos, (int)flags, (int)recursionLeft);
        }
    }

    default public class_265[] getShapes(float nodeWidth, float extensionWidth, float nodeHeight, float extensionBottom, float extensionHeight) {
        ArrayList dimensions = Lists.newArrayList((Object[])new Float[]{Float.valueOf(nodeWidth), Float.valueOf(extensionWidth), Float.valueOf(nodeHeight), Float.valueOf(extensionBottom), Float.valueOf(extensionHeight)});
        return DIMENSIONS_TO_SHAPE_CACHE.computeIfAbsent(dimensions, dimension -> this.makeDiagonalShapes(nodeWidth, extensionWidth, nodeHeight, extensionBottom, extensionHeight));
    }

    default public VoxelCollection[] makeDiagonalShapes(float nodeWidth, float extensionWidth, float nodeHeight, float extensionBottom, float extensionHeight) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        float nodeStart = 8.0f - nodeWidth;
        float nodeEnd = 8.0f + nodeWidth;
        float extensionStart = 8.0f - extensionWidth;
        float extensionEnd = 8.0f + extensionWidth;
        class_265 nodeShape = class_2248.method_9541((double)nodeStart, (double)0.0, (double)nodeStart, (double)nodeEnd, (double)nodeHeight, (double)nodeEnd);
        class_243[] sideShape = new class_243[]{new class_243((double)extensionStart, (double)extensionBottom, 0.0), new class_243((double)extensionEnd, (double)extensionHeight, (double)nodeStart)};
        class_243[] sideParticleShape = new class_243[]{new class_243(0.0, (double)extensionBottom, 0.0), new class_243((double)nodeStart, (double)extensionHeight, (double)nodeStart)};
        class_265[] verticalShapes = (class_265[])Stream.of(EightWayDirection.getCardinalDirections()).map(direction -> direction.transform(sideShape)).map(VoxelUtils::makeCuboidShape).toArray(class_265[]::new);
        class_265[] diagonalShapes = (class_265[])Stream.of(EightWayDirection.getIntercardinalDirections()).map(direction -> this.getDiagonalShape(extensionWidth, extensionBottom, extensionHeight, (EightWayDirection)((Object)direction))).toArray(class_265[]::new);
        class_265[] diagonalParticleShapes = (class_265[])Stream.of(EightWayDirection.getIntercardinalDirections()).map(direction -> {
            class_243[] edges = sideParticleShape;
            if (direction.getX() != 1) {
                edges = VoxelUtils.flipX(edges);
            }
            if (direction.getZ() != 1) {
                edges = VoxelUtils.flipZ(edges);
            }
            return edges;
        }).map(VoxelUtils::makeCuboidShape).toArray(class_265[]::new);
        class_265[] sideShapes = new class_265[]{verticalShapes[2], verticalShapes[3], verticalShapes[0], verticalShapes[1], diagonalShapes[2], diagonalShapes[3], diagonalShapes[0], diagonalShapes[1]};
        class_265[] particleSideShapes = new class_265[]{verticalShapes[2], verticalShapes[3], verticalShapes[0], verticalShapes[1], diagonalParticleShapes[2], diagonalParticleShapes[3], diagonalParticleShapes[0], diagonalParticleShapes[1]};
        VoxelCollection[] stateShapes = this.constructStateShapes(nodeShape, sideShapes, particleSideShapes);
        DiagonalWindows.LOGGER.info("Constructing shapes for nodeWith {}, extensionWidth {}, nodeHeight {}, extensionBottom {}, extensionHeight {} took {} milliseconds", (Object)Float.valueOf(nodeWidth), (Object)Float.valueOf(extensionWidth), (Object)Float.valueOf(nodeHeight), (Object)Float.valueOf(extensionBottom), (Object)Float.valueOf(extensionHeight), (Object)stopwatch.stop().elapsed().toMillis());
        return stateShapes;
    }

    default public VoxelCollection[] constructStateShapes(class_265 nodeShape, class_265[] directionalShapes, class_265[] particleDirectionalShapes) {
        VoxelCollection[] stateShapes = new VoxelCollection[(int)Math.pow(2.0, directionalShapes.length)];
        for (int i = 0; i < stateShapes.length; ++i) {
            stateShapes[i] = new VoxelCollection(nodeShape);
            for (int j = 0; j < directionalShapes.length; ++j) {
                if ((i & 1 << j) == 0) continue;
                stateShapes[i].addVoxelShape(directionalShapes[j], particleDirectionalShapes[j]);
            }
        }
        return stateShapes;
    }

    default public class_265 getDiagonalShape(float extensionWidth, float extensionBottom, float extensionHeight, EightWayDirection direction) {
        class_265 collisionShape = this.getDiagonalCollisionShape(extensionWidth, extensionBottom, extensionHeight, direction);
        extensionWidth = (float)Math.sqrt(extensionWidth * extensionWidth * 2.0f);
        float diagonalSide = 0.70710677f * extensionWidth;
        class_243[] corners = VoxelUtils.createVectorArray(Float.valueOf(-diagonalSide), Float.valueOf(extensionHeight), Float.valueOf(diagonalSide), Float.valueOf(-diagonalSide + 8.0f), Float.valueOf(extensionHeight), Float.valueOf(diagonalSide + 8.0f), Float.valueOf(-diagonalSide), Float.valueOf(extensionBottom), Float.valueOf(diagonalSide), Float.valueOf(-diagonalSide + 8.0f), Float.valueOf(extensionBottom), Float.valueOf(diagonalSide + 8.0f), Float.valueOf(diagonalSide), Float.valueOf(extensionHeight), Float.valueOf(-diagonalSide), Float.valueOf(diagonalSide + 8.0f), Float.valueOf(extensionHeight), Float.valueOf(-diagonalSide + 8.0f), Float.valueOf(diagonalSide), Float.valueOf(extensionBottom), Float.valueOf(-diagonalSide), Float.valueOf(diagonalSide + 8.0f), Float.valueOf(extensionBottom), Float.valueOf(-diagonalSide + 8.0f));
        class_243[] edges = VoxelUtils.create12Edges(corners);
        if (direction.getX() != 1) {
            edges = VoxelUtils.flipX(edges);
        }
        if (direction.getZ() != 1) {
            edges = VoxelUtils.flipZ(edges);
        }
        return new NoneVoxelShape(collisionShape, VoxelUtils.scaleDown(edges));
    }

    default public class_265 getDiagonalCollisionShape(float extensionWidth, float extensionBottom, float extensionHeight, EightWayDirection direction) {
        class_265 collisionShape = class_259.method_1073();
        for (int i = 0; i < 8; ++i) {
            int posX = direction.getX() > 0 ? i : 16 - i;
            int posZ = direction.getZ() > 0 ? i : 16 - i;
            class_265 cuboidShape = class_2248.method_9541((double)((float)posX - extensionWidth), (double)extensionBottom, (double)((float)posZ - extensionWidth), (double)((float)posX + extensionWidth), (double)extensionHeight, (double)((float)posZ + extensionWidth));
            collisionShape = class_259.method_1084((class_265)collisionShape, (class_265)cuboidShape);
        }
        return collisionShape;
    }

    @FunctionalInterface
    public static interface DirectionStatePredicate {
        public boolean test(class_2338 var1, class_2680 var2, EightWayDirection var3);
    }
}

