/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.doomll;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.doomll.DoomLlMod;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.forgespi.language.ModFileScanData;

public class DoomLlModElements {
    public final List<ModElement> elements = new ArrayList<ModElement>();
    public final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    public final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    public final List<Supplier<EntityType<?>>> entities = new ArrayList();
    public final List<Supplier<Enchantment>> enchantments = new ArrayList<Supplier<Enchantment>>();
    public static Map<ResourceLocation, SoundEvent> sounds = new HashMap<ResourceLocation, SoundEvent>();
    private int messageID = 0;

    public DoomLlModElements() {
        sounds.put(new ResourceLocation("doom_ll", "cacodemon_death"), new SoundEvent(new ResourceLocation("doom_ll", "cacodemon_death")));
        sounds.put(new ResourceLocation("doom_ll", "arachnotron_ambient"), new SoundEvent(new ResourceLocation("doom_ll", "arachnotron_ambient")));
        sounds.put(new ResourceLocation("doom_ll", "arachnotron_fire"), new SoundEvent(new ResourceLocation("doom_ll", "arachnotron_fire")));
        sounds.put(new ResourceLocation("doom_ll", "baron_of_hell_death"), new SoundEvent(new ResourceLocation("doom_ll", "baron_of_hell_death")));
        sounds.put(new ResourceLocation("doom_ll", "cyber_demon_death"), new SoundEvent(new ResourceLocation("doom_ll", "cyber_demon_death")));
        sounds.put(new ResourceLocation("doom_ll", "revenant_rocket"), new SoundEvent(new ResourceLocation("doom_ll", "revenant_rocket")));
        sounds.put(new ResourceLocation("doom_ll", "death"), new SoundEvent(new ResourceLocation("doom_ll", "death")));
        sounds.put(new ResourceLocation("doom_ll", "injured"), new SoundEvent(new ResourceLocation("doom_ll", "injured")));
        sounds.put(new ResourceLocation("doom_ll", "injuried_zombie"), new SoundEvent(new ResourceLocation("doom_ll", "injuried_zombie")));
        sounds.put(new ResourceLocation("doom_ll", "lost_soul"), new SoundEvent(new ResourceLocation("doom_ll", "lost_soul")));
        sounds.put(new ResourceLocation("doom_ll", "mancubus_hurt"), new SoundEvent(new ResourceLocation("doom_ll", "mancubus_hurt")));
        sounds.put(new ResourceLocation("doom_ll", "mancubus_death"), new SoundEvent(new ResourceLocation("doom_ll", "mancubus_death")));
        sounds.put(new ResourceLocation("doom_ll", "mancubus_ambient"), new SoundEvent(new ResourceLocation("doom_ll", "mancubus_ambient")));
        sounds.put(new ResourceLocation("doom_ll", "nearby"), new SoundEvent(new ResourceLocation("doom_ll", "nearby")));
        sounds.put(new ResourceLocation("doom_ll", "pinky_ambient"), new SoundEvent(new ResourceLocation("doom_ll", "pinky_ambient")));
        sounds.put(new ResourceLocation("doom_ll", "pistol"), new SoundEvent(new ResourceLocation("doom_ll", "pistol")));
        sounds.put(new ResourceLocation("doom_ll", "revenant_ambient"), new SoundEvent(new ResourceLocation("doom_ll", "revenant_ambient")));
        sounds.put(new ResourceLocation("doom_ll", "revenantdeath"), new SoundEvent(new ResourceLocation("doom_ll", "revenantdeath")));
        sounds.put(new ResourceLocation("doom_ll", "rocket"), new SoundEvent(new ResourceLocation("doom_ll", "rocket")));
        sounds.put(new ResourceLocation("doom_ll", "spider_demon_death"), new SoundEvent(new ResourceLocation("doom_ll", "spider_demon_death")));
        sounds.put(new ResourceLocation("doom_ll", "spider_demon_walk"), new SoundEvent(new ResourceLocation("doom_ll", "spider_demon_walk")));
        sounds.put(new ResourceLocation("doom_ll", "throw_projectile"), new SoundEvent(new ResourceLocation("doom_ll", "throw_projectile")));
        sounds.put(new ResourceLocation("doom_ll", "zombie_ambient"), new SoundEvent(new ResourceLocation("doom_ll", "zombie_ambient")));
        sounds.put(new ResourceLocation("doom_ll", "zombie_death"), new SoundEvent(new ResourceLocation("doom_ll", "zombie_death")));
        sounds.put(new ResourceLocation("doom_ll", "arachnotron_step"), new SoundEvent(new ResourceLocation("doom_ll", "arachnotron_step")));
        sounds.put(new ResourceLocation("doom_ll", "ambient"), new SoundEvent(new ResourceLocation("doom_ll", "ambient")));
        sounds.put(new ResourceLocation("doom_ll", "shotgun"), new SoundEvent(new ResourceLocation("doom_ll", "shotgun")));
        sounds.put(new ResourceLocation("doom_ll", "plasma_bolt"), new SoundEvent(new ResourceLocation("doom_ll", "plasma_bolt")));
        sounds.put(new ResourceLocation("doom_ll", "arachnotron_sight"), new SoundEvent(new ResourceLocation("doom_ll", "arachnotron_sight")));
        sounds.put(new ResourceLocation("doom_ll", "baron_sight"), new SoundEvent(new ResourceLocation("doom_ll", "baron_sight")));
        sounds.put(new ResourceLocation("doom_ll", "cacodemon_sight"), new SoundEvent(new ResourceLocation("doom_ll", "cacodemon_sight")));
        sounds.put(new ResourceLocation("doom_ll", "cyberdemonsight"), new SoundEvent(new ResourceLocation("doom_ll", "cyberdemonsight")));
        sounds.put(new ResourceLocation("doom_ll", "hell_knight_sight"), new SoundEvent(new ResourceLocation("doom_ll", "hell_knight_sight")));
        sounds.put(new ResourceLocation("doom_ll", "imp_sight"), new SoundEvent(new ResourceLocation("doom_ll", "imp_sight")));
        sounds.put(new ResourceLocation("doom_ll", "mancubus_sight"), new SoundEvent(new ResourceLocation("doom_ll", "mancubus_sight")));
        sounds.put(new ResourceLocation("doom_ll", "pain_elemental_sight"), new SoundEvent(new ResourceLocation("doom_ll", "pain_elemental_sight")));
        sounds.put(new ResourceLocation("doom_ll", "pinky_sight"), new SoundEvent(new ResourceLocation("doom_ll", "pinky_sight")));
        sounds.put(new ResourceLocation("doom_ll", "plasma_bolt_hit"), new SoundEvent(new ResourceLocation("doom_ll", "plasma_bolt_hit")));
        sounds.put(new ResourceLocation("doom_ll", "rocket_hit"), new SoundEvent(new ResourceLocation("doom_ll", "rocket_hit")));
        sounds.put(new ResourceLocation("doom_ll", "spider_demon_sight"), new SoundEvent(new ResourceLocation("doom_ll", "spider_demon_sight")));
        sounds.put(new ResourceLocation("doom_ll", "supershotgun"), new SoundEvent(new ResourceLocation("doom_ll", "supershotgun")));
        try {
            ModFileScanData modFileInfo = ModList.get().getModFileById("doom_ll").getFile().getScanResult();
            Set annotations = modFileInfo.getAnnotations();
            for (ModFileScanData.AnnotationData annotationData : annotations) {
                Class<?> clazz;
                if (!annotationData.getAnnotationType().getClassName().equals(ModElement.Tag.class.getName()) || (clazz = Class.forName(annotationData.getClassType().getClassName())).getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (Map.Entry<ResourceLocation, SoundEvent> sound : sounds.entrySet()) {
            event.getRegistry().register(sound.getValue().setRegistryName(sound.getKey()));
        }
    }

    public <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        DoomLlMod.PACKET_HANDLER.registerMessage(this.messageID, messageType, encoder, decoder, messageConsumer);
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<EntityType<?>>> getEntities() {
        return this.entities;
    }

    public List<Supplier<Enchantment>> getEnchantments() {
        return this.enchantments;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final DoomLlModElements elements;
        protected final int sortid;

        public ModElement(DoomLlModElements elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLCommonSetupEvent event) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public void clientLoad(FMLClientSetupEvent event) {
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }
}

