/*
 * Decompiled with CFR 0.152.
 */
package com.dragn.bettas.network;

import com.dragn.bettas.tank.TankTile;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class RemoveDecorRequest {
    private final String decorName;
    private final BlockPos pos;

    public RemoveDecorRequest(String decorName, BlockPos pos) {
        this.decorName = decorName;
        this.pos = pos;
    }

    public static void encode(RemoveDecorRequest msg, FriendlyByteBuf buffer) {
        buffer.m_130087_(msg.decorName.getBytes(StandardCharsets.UTF_8));
        buffer.writeInt(msg.pos.m_123341_());
        buffer.writeInt(msg.pos.m_123342_());
        buffer.writeInt(msg.pos.m_123343_());
    }

    public static RemoveDecorRequest decode(FriendlyByteBuf buffer) {
        String decorName = buffer.m_130277_();
        BlockPos pos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
        return new RemoveDecorRequest(decorName, pos);
    }

    public static void handle(RemoveDecorRequest msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                ((TankTile)Objects.requireNonNull(Minecraft.m_91087_().f_91073_.m_7702_((BlockPos)msg.pos))).decor.remove(msg.decorName);
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

