/*
 * Decompiled with CFR 0.152.
 */
package com.dragn.bettas.snail;

import com.dragn.bettas.BettasMain;
import com.dragn.bettas.snail.Texture;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class SnailEntity
extends AbstractFish
implements IAnimatable {
    private static final EntityDataAccessor<Integer> TEXTURE = SynchedEntityData.m_135353_(SnailEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public static boolean checkSnailSpawnRules(EntityType<? extends WaterAnimal> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos pos, Random random) {
        return levelAccessor.m_46801_(pos);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22279_, 1.0);
    }

    public SnailEntity(EntityType<? extends AbstractFish> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new SnailMovementController((Mob)this);
        this.f_19811_ = true;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, event -> PlayState.CONTINUE));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.25, 30));
        this.f_21345_.m_25352_(2, (Goal)new TryFindWaterGoal((PathfinderMob)this));
    }

    public ItemStack m_142563_() {
        return ((BucketItem)BettasMain.SNAIL_BUCKET.get()).m_7968_();
    }

    protected SoundEvent m_5699_() {
        return null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TEXTURE, (Object)0);
    }

    public int getTexture() {
        return (Integer)this.f_19804_.m_135370_(TEXTURE);
    }

    public void setTexture(int texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Texture", this.getTexture());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("Texture")) {
            this.setTexture(compoundTag.m_128451_("Texture"));
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        if (compoundTag != null && compoundTag.m_128441_("Texture")) {
            this.setTexture(compoundTag.m_128451_("Texture"));
        } else {
            this.setTexture(BettasMain.RANDOM.nextInt(Texture.values().length));
        }
        return super.m_6518_(levelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    static class SnailMovementController
    extends MoveControl {
        public SnailMovementController(Mob mob) {
            super(mob);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
            } else {
                this.f_24974_.m_21564_(0.0f);
            }
        }
    }
}

