/*
 * Decompiled with CFR 0.152.
 */
package com.dragn.bettas.tank;

import com.dragn.bettas.BettasMain;
import com.dragn.bettas.network.NetworkManager;
import com.dragn.bettas.network.RemoveDecorRequest;
import com.dragn.bettas.tank.TankTile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class Tank
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    private static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    private static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    private static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    private static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    private static final VoxelShape NORTH_VOXEL = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)0.5), (VoxelShape)Block.m_49796_((double)0.5, (double)15.5, (double)0.0, (double)15.5, (double)16.0, (double)0.5));
    private static final VoxelShape EAST_VOXEL = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)15.5, (double)15.5, (double)0.5, (double)16.0, (double)16.0, (double)15.5));
    private static final VoxelShape SOUTH_VOXEL = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.5, (double)15.5, (double)15.5, (double)15.5, (double)16.0, (double)16.0));
    private static final VoxelShape WEST_VOXEL = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)15.5, (double)0.5, (double)0.5, (double)16.0, (double)15.5));
    private static final VoxelShape DOWN_VOXEL = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0);
    private static final ArrayList<String> DECOR_ITEMS = new ArrayList<String>(Arrays.asList("big_log_item", "filter_item", "heater_item", "large_rock_item", "medium_rock_item", "small_log_item", "small_rock_item", "kelp", "seagrass", "sand"));

    public Tank() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60955_().m_60978_(0.7f));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_7417_(BlockState state1, Direction direction, BlockState state2, LevelAccessor levelAccessor, BlockPos pos1, BlockPos pos2) {
        boolean adjacent = state2.m_60713_((Block)this);
        switch (direction) {
            case NORTH: {
                return (BlockState)state1.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(adjacent));
            }
            case EAST: {
                return (BlockState)state1.m_61124_((Property)EAST, (Comparable)Boolean.valueOf(adjacent));
            }
            case SOUTH: {
                return (BlockState)state1.m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(adjacent));
            }
            case WEST: {
                return (BlockState)state1.m_61124_((Property)WEST, (Comparable)Boolean.valueOf(adjacent));
            }
            case DOWN: {
                return (BlockState)state1.m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(adjacent));
            }
        }
        return super.m_7417_(state1, direction, state2, levelAccessor, pos1, pos2);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        VoxelShape shape = Shapes.m_83040_();
        if (blockGetter.m_8055_(pos.m_142127_()).m_60734_() != this) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)NORTH_VOXEL, (BooleanOp)BooleanOp.f_82695_);
        }
        if (blockGetter.m_8055_(pos.m_142126_()).m_60734_() != this) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)EAST_VOXEL, (BooleanOp)BooleanOp.f_82695_);
        }
        if (blockGetter.m_8055_(pos.m_142128_()).m_60734_() != this) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)SOUTH_VOXEL, (BooleanOp)BooleanOp.f_82695_);
        }
        if (blockGetter.m_8055_(pos.m_142125_()).m_60734_() != this) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)WEST_VOXEL, (BooleanOp)BooleanOp.f_82695_);
        }
        if (blockGetter.m_8055_(pos.m_7495_()).m_60734_() != this) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)DOWN_VOXEL, (BooleanOp)BooleanOp.f_82695_);
        }
        return shape;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        boolean north = context.m_43725_().m_8055_(pos.m_142127_()).m_60734_() == this;
        boolean east = context.m_43725_().m_8055_(pos.m_142126_()).m_60734_() == this;
        boolean south = context.m_43725_().m_8055_(pos.m_142128_()).m_60734_() == this;
        boolean west = context.m_43725_().m_8055_(pos.m_142125_()).m_60734_() == this;
        boolean down = context.m_43725_().m_8055_(pos.m_7495_()).m_60734_() == this;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(pos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(down));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        return Collections.singletonList(this.m_5456_().m_7968_());
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        super.m_7100_(state, level, pos, random);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (!level.f_46443_) {
            String name = player.m_21120_(hand).m_41720_().getRegistryName().m_135815_();
            TankTile tankTile = (TankTile)level.m_7702_(pos);
            if (DECOR_ITEMS.contains(name)) {
                if (tankTile.decor.put(name, player.m_6350_().m_122428_()) == null) {
                    player.m_21120_(hand).m_41774_(1);
                }
                level.m_7260_(pos, state, state, 3);
                return InteractionResult.CONSUME;
            }
            if (hand == InteractionHand.MAIN_HAND && name.equals("air") && tankTile.decor.size() > 0) {
                Map.Entry decor = (Map.Entry)tankTile.decor.entrySet().toArray()[tankTile.decor.size() - 1];
                tankTile.decor.remove(decor.getKey());
                NetworkManager.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> (LevelChunk)level.m_46865_(pos)), (Object)new RemoveDecorRequest((String)decor.getKey(), pos));
                level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, Tank.decorMap((String)decor.getKey())));
                level.m_7260_(pos, state, state, 3);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, level, pos, player, hand, blockHitResult);
    }

    public static ItemStack decorMap(String decor) {
        return switch (decor) {
            case "big_log_item" -> ((Item)BettasMain.BIG_LOG_ITEM.get()).m_7968_();
            case "filter_item" -> ((Item)BettasMain.FILTER_ITEM.get()).m_7968_();
            case "heater_item" -> ((Item)BettasMain.HEATER_ITEM.get()).m_7968_();
            case "large_rock_item" -> ((Item)BettasMain.LARGE_ROCK_ITEM.get()).m_7968_();
            case "medium_rock_item" -> ((Item)BettasMain.MEDIUM_ROCK_ITEM.get()).m_7968_();
            case "small_log_item" -> ((Item)BettasMain.SMALL_LOG_ITEM.get()).m_7968_();
            case "small_rock_item" -> ((Item)BettasMain.SMALL_ROCK_ITEM.get()).m_7968_();
            case "seagrass" -> Items.f_41867_.m_7968_();
            case "kelp" -> Items.f_41910_.m_7968_();
            case "sand" -> Items.f_41830_.m_7968_();
            default -> Items.f_41852_.m_7968_();
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, NORTH, EAST, SOUTH, WEST, DOWN});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BettasMain.TANK_TILE.get()).m_155264_(pos, state);
    }
}

