/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.monster;

import fuzs.enderzoology.init.ModRegistry;
import fuzs.enderzoology.world.entity.ai.goal.RangedBowEasyAttackGoal;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1338;
import net.minecraft.class_1339;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_1366;
import net.minecraft.class_1380;
import net.minecraft.class_1409;
import net.minecraft.class_1547;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4135;
import net.minecraft.class_5425;
import net.minecraft.class_5493;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class FallenKnight
extends class_1547 {
    private static final Predicate<class_1267> DOOR_BREAKING_PREDICATE = difficulty -> difficulty == class_1267.field_5807;
    private static final float BREAK_DOOR_CHANCE = 0.1f;
    private final class_1339 breakDoorGoal = new class_1339((class_1308)this, DOOR_BREAKING_PREDICATE);
    private class_1380<class_1547> bowGoal;
    private class_1366 meleeGoal;
    private boolean canBreakDoors;

    public FallenKnight(class_1299<? extends class_1547> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_35115().stream().map(class_4135::method_19058).filter(goal -> goal instanceof class_1338).limit(1L).toList().forEach(arg_0 -> ((class_1355)this.field_6201).method_6280(arg_0));
    }

    protected void method_5964(class_5819 random, class_1266 difficulty) {
        this.populateArmorEquipmentSlots(random);
        class_1792 item = random.method_43056() ? (class_1792)ModRegistry.HUNTING_BOW.get() : (random.method_43057() < (this.field_6002.method_8407() == class_1267.field_5807 ? 0.6f : 0.2f) ? class_1802.field_8371 : class_1802.field_8528);
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)item));
    }

    private void populateArmorEquipmentSlots(class_5819 random) {
        float selector = random.method_43057();
        int quality = selector < 0.1f ? 3 : (selector < 0.35f ? 0 : 2);
        List<class_1304> slots = Stream.of(class_1304.values()).filter(slot -> slot.method_5925() == class_1304.class_1305.field_6178).sorted(Comparator.reverseOrder()).toList();
        for (class_1304 slot2 : slots) {
            class_1792 item;
            class_1799 itemStack = this.method_6118(slot2);
            if (slot2 != class_1304.field_6169 && random.method_43057() < (this.field_6002.method_8407() == class_1267.field_5807 ? 0.1f : 0.25f)) break;
            if (!itemStack.method_7960() || (item = FallenKnight.method_5948((class_1304)slot2, (int)quality)) == null) continue;
            this.method_5673(slot2, new class_1799((class_1935)item));
        }
    }

    protected void method_30759(class_5819 random, float chanceMultiplier) {
        class_1799 itemstack;
        super.method_30759(random, chanceMultiplier);
        if (random.method_43048(10) == 0 && (itemstack = this.method_6047()).method_31574((class_1792)ModRegistry.HUNTING_BOW.get())) {
            Map map = class_1890.method_8222((class_1799)itemstack);
            map.putIfAbsent(class_1893.field_9132, 1);
            class_1890.method_8214((Map)map, (class_1799)itemstack);
            this.method_5673(class_1304.field_6173, itemstack);
        }
    }

    public boolean method_25938(class_1811 projectileWeapon) {
        return projectileWeapon instanceof class_1753;
    }

    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        spawnData = super.method_5943(level, difficulty, reason, spawnData, dataTag);
        if (level.method_8409().method_43056()) {
            class_1308 fallenMount = (class_1308)((class_1299)ModRegistry.FALLEN_MOUNT_ENTITY_TYPE.get()).method_5883(this.field_6002);
            fallenMount.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), 0.0f);
            fallenMount.method_5943(level, difficulty, class_3730.field_16460, null, null);
            this.method_5804((class_1297)fallenMount);
            level.method_8649((class_1297)fallenMount);
        }
        this.setCanBreakDoors(level.method_8409().method_43057() < difficulty.method_5458() * 0.1f);
        return spawnData;
    }

    public boolean canBreakDoors() {
        return this.canBreakDoors;
    }

    public void setCanBreakDoors(boolean canBreakDoors) {
        if (class_5493.method_30955((class_1308)this)) {
            if (this.canBreakDoors != canBreakDoors) {
                this.canBreakDoors = canBreakDoors;
                ((class_1409)this.method_5942()).method_6363(canBreakDoors);
                if (canBreakDoors) {
                    this.field_6201.method_6277(1, (class_1352)this.breakDoorGoal);
                } else {
                    this.field_6201.method_6280((class_1352)this.breakDoorGoal);
                }
            }
        } else if (this.canBreakDoors) {
            this.field_6201.method_6280((class_1352)this.breakDoorGoal);
            this.canBreakDoors = false;
        }
    }

    public void method_6997() {
        if (this.field_6002 != null && !this.field_6002.field_9236) {
            this.field_6201.method_6280((class_1352)this.meleeGoal());
            this.field_6201.method_6280(this.bowGoal());
            class_1799 itemStack = this.method_5998(RangedBowEasyAttackGoal.getWeaponHoldingHand((class_1309)this, stack -> stack.method_7909() instanceof class_1753));
            if (itemStack.method_7909() instanceof class_1753) {
                int i = 20;
                if (this.field_6002.method_8407() != class_1267.field_5807) {
                    i = 40;
                }
                this.bowGoal().method_6305(i);
                this.field_6201.method_6277(4, this.bowGoal());
            } else {
                this.field_6201.method_6277(4, (class_1352)this.meleeGoal());
            }
        }
    }

    public class_1799 method_18808(class_1799 weaponStack) {
        class_1268 interactionHand = RangedBowEasyAttackGoal.getWeaponHoldingHand((class_1309)this, stack -> stack.method_7909() instanceof class_1753);
        return super.method_18808(this.method_5998(interactionHand));
    }

    private class_1380<class_1547> bowGoal() {
        if (this.bowGoal == null) {
            this.bowGoal = new RangedBowEasyAttackGoal<FallenKnight>(this, 1.0, 40, 60, 15.0f);
        }
        return this.bowGoal;
    }

    private class_1366 meleeGoal() {
        if (this.meleeGoal == null) {
            this.meleeGoal = new class_1366((class_1314)this, 1.2, false){

                public void method_6270() {
                    super.method_6270();
                    FallenKnight.this.method_19540(false);
                }

                public void method_6269() {
                    super.method_6269();
                    FallenKnight.this.method_19540(true);
                }
            };
        }
        return this.meleeGoal;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return class_3417.field_15088;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14930;
    }

    protected class_3414 method_6998() {
        return class_3417.field_14621;
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("CanBreakDoors", this.canBreakDoors());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setCanBreakDoors(compound.method_10577("CanBreakDoors"));
    }
}

