/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology;

import fuzs.enderzoology.config.CommonConfig;
import fuzs.enderzoology.init.ModRegistry;
import fuzs.enderzoology.world.entity.EntityAttributeProviders;
import fuzs.enderzoology.world.entity.SpawnPlacementRules;
import fuzs.enderzoology.world.entity.item.PrimedCharge;
import fuzs.enderzoology.world.entity.projectile.ThrownOwlEgg;
import fuzs.enderzoology.world.level.EnderExplosion;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.biome.v1.MobSpawnSettingsContext;
import fuzs.puzzleslib.config.ConfigHolder;
import fuzs.puzzleslib.core.CommonFactories;
import fuzs.puzzleslib.core.ModConstructor;
import fuzs.puzzleslib.init.PotionBrewingRegistry;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnderZoology
implements ModConstructor {
    public static final String MOD_ID = "enderzoology";
    public static final String MOD_NAME = "Ender Zoology";
    public static final Logger LOGGER = LogManager.getLogger((String)"Ender Zoology");
    public static final ConfigHolder CONFIG = CommonFactories.INSTANCE.commonConfig(CommonConfig.class, () -> new CommonConfig());

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public void onConstructMod() {
        CONFIG.bakeConfigs(MOD_ID);
        ModRegistry.touch();
    }

    public void onCommonSetup() {
        EnderZoology.registerDispenseBehaviors();
        EnderZoology.registerBrewingRecipes();
    }

    private static void registerDispenseBehaviors() {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.OWL_EGG_ITEM.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile m_6895_(Level level, Position position, ItemStack stack) {
                return (Projectile)Util.m_137469_((Object)((Object)new ThrownOwlEgg(level, position.m_7096_(), position.m_7098_(), position.m_7094_())), thrownEgg -> thrownEgg.m_37446_(stack));
            }
        });
        EnderZoology.registerChargeBehavior((Block)ModRegistry.ENDER_CHARGE_BLOCK.get(), EnderExplosion.EntityInteraction.ENDER);
        EnderZoology.registerChargeBehavior((Block)ModRegistry.CONFUSING_CHARGE_BLOCK.get(), EnderExplosion.EntityInteraction.CONFUSION);
        EnderZoology.registerChargeBehavior((Block)ModRegistry.CONCUSSION_CHARGE_BLOCK.get(), EnderExplosion.EntityInteraction.CONCUSSION);
    }

    private static void registerChargeBehavior(Block block, final EnderExplosion.EntityInteraction entityInteraction) {
        DispenserBlock.m_52672_((ItemLike)block, (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

            protected ItemStack m_7498_(BlockSource blockSource, ItemStack stack) {
                ServerLevel level = blockSource.m_7727_();
                BlockPos blockpos = blockSource.m_7961_().m_121945_((Direction)blockSource.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                PrimedCharge primedtnt = new PrimedCharge((Level)level, (double)blockpos.m_123341_() + 0.5, blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5, null, entityInteraction);
                level.m_7967_((Entity)primedtnt);
                level.m_6263_(null, primedtnt.m_20185_(), primedtnt.m_20186_(), primedtnt.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_(null, GameEvent.f_157810_, blockpos);
                stack.m_41774_(1);
                return stack;
            }
        });
    }

    private static void registerBrewingRecipes() {
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe(Potions.f_43602_, (Item)ModRegistry.ENDER_FRAGMENT_ITEM.get(), (Potion)ModRegistry.DISPLACEMENT_POTION.get());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe((Potion)ModRegistry.DISPLACEMENT_POTION.get(), Items.f_42525_, (Potion)ModRegistry.STRONG_DISPLACEMENT_POTION.get());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe(Potions.f_43602_, (Item)ModRegistry.WITHERING_DUST_ITEM.get(), (Potion)ModRegistry.DECAY_POTION.get());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe((Potion)ModRegistry.DECAY_POTION.get(), Items.f_42451_, (Potion)ModRegistry.LONG_DECAY_POTION.get());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe((Potion)ModRegistry.DECAY_POTION.get(), Items.f_42525_, (Potion)ModRegistry.STRONG_DECAY_POTION.get());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe(Potions.f_43602_, (Item)ModRegistry.CONFUSING_POWDER_ITEM.get(), (Potion)ModRegistry.CONFUSION_POTION.get());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe((Potion)ModRegistry.CONFUSION_POTION.get(), Items.f_42451_, (Potion)ModRegistry.LONG_CONFUSION_POTION.get());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe((Potion)ModRegistry.CONFUSION_POTION.get(), Items.f_42525_, (Potion)ModRegistry.STRONG_CONFUSION_POTION.get());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe(Potions.f_43602_, (Item)ModRegistry.OWL_EGG_ITEM.get(), (Potion)ModRegistry.RISING_POTION.get());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe((Potion)ModRegistry.RISING_POTION.get(), Items.f_42451_, (Potion)ModRegistry.LONG_RISING_POTION.get());
    }

    public void onRegisterFlammableBlocks(ModConstructor.FlammableBlocksContext context) {
        context.registerFlammable(15, 100, new Block[]{(Block)ModRegistry.ENDER_CHARGE_BLOCK.get(), (Block)ModRegistry.CONFUSING_CHARGE_BLOCK.get(), (Block)ModRegistry.CONCUSSION_CHARGE_BLOCK.get()});
    }

    public void onEntityAttributeCreation(ModConstructor.EntityAttributesCreateContext context) {
        context.registerEntityAttributes((EntityType)ModRegistry.CONCUSSION_CREEPER_ENTITY_TYPE.get(), EntityAttributeProviders.createConcussionCreeperAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.INFESTED_ZOMBIE_ENTITY_TYPE.get(), EntityAttributeProviders.createEnderInfestedZombieAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.ENDERMINY_ENTITY_TYPE.get(), EntityAttributeProviders.createEnderminyAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.DIRE_WOLF_ENTITY_TYPE.get(), EntityAttributeProviders.createDireWolfAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.FALLEN_MOUNT_ENTITY_TYPE.get(), EntityAttributeProviders.createFallenMountAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.WITHER_CAT_ENTITY_TYPE.get(), EntityAttributeProviders.createWitherCatAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.WITHER_WITCH_ENTITY_TYPE.get(), EntityAttributeProviders.createWitherWitchAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.OWL_ENTITY_TYPE.get(), EntityAttributeProviders.createOwlAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.FALLEN_KNIGHT_ENTITY_TYPE.get(), EntityAttributeProviders.createFallenKnightAttributes());
    }

    public void onRegisterSpawnPlacements(ModConstructor.SpawnPlacementsContext context) {
        context.registerSpawnPlacement((EntityType)ModRegistry.CONCUSSION_CREEPER_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPlacementRules::checkSurfaceSpawnRules);
        context.registerSpawnPlacement((EntityType)ModRegistry.INFESTED_ZOMBIE_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPlacementRules::checkSurfaceSpawnRules);
        context.registerSpawnPlacement((EntityType)ModRegistry.ENDERMINY_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPlacementRules::checkSurfaceSpawnRules);
        context.registerSpawnPlacement((EntityType)ModRegistry.DIRE_WOLF_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPlacementRules::checkDireWolfSpawnRules);
        context.registerSpawnPlacement((EntityType)ModRegistry.FALLEN_MOUNT_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPlacementRules::checkMonsterSpawnRules);
        context.registerSpawnPlacement((EntityType)ModRegistry.WITHER_CAT_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPlacementRules::checkMonsterSpawnRules);
        context.registerSpawnPlacement((EntityType)ModRegistry.WITHER_WITCH_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPlacementRules::checkSurfaceSpawnRules);
        context.registerSpawnPlacement((EntityType)ModRegistry.OWL_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, SpawnPlacementRules::checkOwlSpawnRules);
        context.registerSpawnPlacement((EntityType)ModRegistry.FALLEN_KNIGHT_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPlacementRules::checkSurfaceSpawnRules);
    }

    public void onRegisterBiomeModifications(ModConstructor.BiomeModificationsContext context) {
        context.register(BiomeLoadingPhase.ADDITIONS, loadingContext -> loadingContext.canGenerateIn(LevelStem.f_63971_), modificationContext -> {
            MobSpawnSettingsContext settings = modificationContext.mobSpawnSettings();
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).concussionCreeper) {
                EnderZoology.registerSpawnData(settings, MobCategory.MONSTER, EntityType.f_20558_, data -> new MobSpawnSettings.SpawnerData((EntityType)ModRegistry.CONCUSSION_CREEPER_ENTITY_TYPE.get(), Math.max(1, data.m_142631_().m_146281_() / 4), data.f_48405_, data.f_48406_));
            }
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).infestedZombie) {
                EnderZoology.registerSpawnData(settings, MobCategory.MONSTER, EntityType.f_20501_, data -> new MobSpawnSettings.SpawnerData((EntityType)ModRegistry.INFESTED_ZOMBIE_ENTITY_TYPE.get(), Math.max(1, data.m_142631_().m_146281_() / 4), 1, data.f_48406_));
            }
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).fallenKnight) {
                EnderZoology.registerSpawnData(settings, MobCategory.MONSTER, EntityType.f_20501_, data -> new MobSpawnSettings.SpawnerData((EntityType)ModRegistry.FALLEN_KNIGHT_ENTITY_TYPE.get(), Math.max(1, data.m_142631_().m_146281_() / 4), 4, 6));
            }
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).enderminy) {
                EnderZoology.registerSpawnData(settings, MobCategory.MONSTER, EntityType.f_20566_, data -> new MobSpawnSettings.SpawnerData((EntityType)ModRegistry.ENDERMINY_ENTITY_TYPE.get(), data.m_142631_().m_146281_() * 3, Math.min(data.f_48406_, data.f_48405_ * 4), data.f_48406_));
            }
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).direWolf && modificationContext.climateSettings().getPrecipitation() == Biome.Precipitation.SNOW) {
                EnderZoology.findVanillaSpawnData(settings, MobCategory.CREATURE, EntityType.f_20499_).ifPresent(data -> settings.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)ModRegistry.DIRE_WOLF_ENTITY_TYPE.get(), Math.max(1, data.m_142631_().m_146281_() / 4), 3, 8)));
            }
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).witherWitch) {
                EnderZoology.registerSpawnData(settings, MobCategory.MONSTER, EntityType.f_20495_, data -> new MobSpawnSettings.SpawnerData((EntityType)ModRegistry.WITHER_WITCH_ENTITY_TYPE.get(), data.m_142631_(), data.f_48405_, data.f_48406_));
            }
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).owl && modificationContext.climateSettings().getPrecipitation() != Biome.Precipitation.NONE) {
                EnderZoology.findVanillaSpawnData(settings, MobCategory.CREATURE, EntityType.f_20517_).ifPresent(data -> settings.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModRegistry.OWL_ENTITY_TYPE.get(), data.m_142631_(), data.f_48405_, data.f_48406_)));
            }
        });
    }

    private static void registerSpawnData(MobSpawnSettingsContext settings, MobCategory category, EntityType<?> vanillaEntityType, Function<MobSpawnSettings.SpawnerData, MobSpawnSettings.SpawnerData> factory) {
        EnderZoology.findVanillaSpawnData(settings, category, vanillaEntityType).ifPresent(data -> settings.addSpawn(category, (MobSpawnSettings.SpawnerData)factory.apply((MobSpawnSettings.SpawnerData)data)));
    }

    private static Optional<MobSpawnSettings.SpawnerData> findVanillaSpawnData(MobSpawnSettingsContext settings, MobCategory category, EntityType<?> entityType) {
        return settings.getSpawnerData(category).stream().filter(data -> data.f_48404_ == entityType).findAny();
    }

    private static void registerSpawnCost(MobSpawnSettingsContext spawnSettings, EntityType<?> vanillaEntityType, EntityType<?> modEntityType, DoubleUnaryOperator chargeConverter, DoubleUnaryOperator energyBudgetConverter) {
        Optional<MobSpawnSettings.MobSpawnCost> optionalMobSpawnCost = Optional.ofNullable(spawnSettings.getSpawnCost(vanillaEntityType));
        optionalMobSpawnCost.ifPresent(cost -> spawnSettings.setSpawnCost(modEntityType, chargeConverter.applyAsDouble(cost.m_48400_()), energyBudgetConverter.applyAsDouble(cost.m_48395_())));
    }
}

