/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology;

import fuzs.enderzoology.EnderZoology;
import fuzs.enderzoology.capability.SoulboundCapability;
import fuzs.enderzoology.data.ModBlockStateProvider;
import fuzs.enderzoology.data.ModBlockTagsProvider;
import fuzs.enderzoology.data.ModEntityTypeTagsProvider;
import fuzs.enderzoology.data.ModItemTagsProvider;
import fuzs.enderzoology.data.ModLanguageProvider;
import fuzs.enderzoology.data.ModLootTableProvider;
import fuzs.enderzoology.data.ModRecipeProvider;
import fuzs.enderzoology.data.ModSoundDefinitionsProvider;
import fuzs.enderzoology.handler.HuntingBowHandler;
import fuzs.enderzoology.handler.MobHuntingHandler;
import fuzs.enderzoology.handler.SoulboundRespawnHandler;
import fuzs.enderzoology.init.ModRegistry;
import fuzs.enderzoology.init.ModRegistryForge;
import fuzs.enderzoology.world.level.EnderExplosion;
import fuzs.puzzleslib.capability.ForgeCapabilityController;
import fuzs.puzzleslib.core.CommonFactories;
import fuzs.puzzleslib.core.ContentRegistrationFlags;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

@Mod(value="enderzoology")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EnderZoologyForge {
    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent evt) {
        CommonFactories.INSTANCE.modConstructor("enderzoology", new ContentRegistrationFlags[]{ContentRegistrationFlags.BIOMES}).accept(new EnderZoology());
        ModRegistryForge.touch();
        EnderZoologyForge.registerCapabilities();
        EnderZoologyForge.registerHandlers();
    }

    private static void registerCapabilities() {
        ForgeCapabilityController.setCapabilityToken(ModRegistry.SOULBOUND_CAPABILITY, (CapabilityToken)new CapabilityToken<SoulboundCapability>(){});
    }

    private static void registerHandlers() {
        MinecraftForge.EVENT_BUS.addListener(evt -> EnderExplosion.onExplosionDetonate(evt.getLevel(), evt.getExplosion(), evt.getAffectedEntities()));
        MinecraftForge.EVENT_BUS.addListener(evt -> SoulboundRespawnHandler.onPlayerClone((ServerPlayer)evt.getOriginal(), (ServerPlayer)evt.getEntity(), !evt.isWasDeath(), action -> {
            evt.getOriginal().reviveCaps();
            action.run();
            evt.getOriginal().invalidateCaps();
        }));
        MinecraftForge.EVENT_BUS.addListener(evt -> HuntingBowHandler.onArrowLoose(evt.getEntity(), evt.getBow(), evt.getLevel(), evt.getCharge(), evt.hasAmmo()).ifPresent(unit -> evt.setCanceled(true)));
        MinecraftForge.EVENT_BUS.addListener(evt -> HuntingBowHandler.onItemUseTick(evt.getEntity(), evt.getItem(), evt.getDuration()).ifPresent(arg_0 -> ((LivingEntityUseItemEvent.Tick)evt).setDuration(arg_0)));
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            Level patt3290$temp = evt.getLevel();
            if (patt3290$temp instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)patt3290$temp;
                MobHuntingHandler.onEntityJoinServerLevel(evt.getEntity(), level);
            }
        });
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent evt) {
        DataGenerator dataGenerator = evt.getGenerator();
        ExistingFileHelper fileHelper = evt.getExistingFileHelper();
        dataGenerator.m_236039_(true, (DataProvider)new ModBlockStateProvider(dataGenerator, "enderzoology", fileHelper));
        dataGenerator.m_236039_(true, (DataProvider)new ModBlockTagsProvider(dataGenerator, "enderzoology", fileHelper));
        dataGenerator.m_236039_(true, (DataProvider)new ModEntityTypeTagsProvider(dataGenerator, "enderzoology", fileHelper));
        dataGenerator.m_236039_(true, (DataProvider)new ModItemTagsProvider(dataGenerator, "enderzoology", fileHelper));
        dataGenerator.m_236039_(true, (DataProvider)new ModLanguageProvider(dataGenerator, "enderzoology"));
        dataGenerator.m_236039_(true, (DataProvider)new ModLootTableProvider(dataGenerator, "enderzoology"));
        dataGenerator.m_236039_(true, (DataProvider)new ModRecipeProvider(dataGenerator));
        dataGenerator.m_236039_(true, (DataProvider)new ModSoundDefinitionsProvider(dataGenerator, "enderzoology", fileHelper));
    }
}

