/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.data;

import fuzs.enderzoology.init.ModRegistry;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(DataGenerator dataGenerator, String modId, ExistingFileHelper fileHelper) {
        super(dataGenerator, modId, fileHelper);
    }

    protected void registerStatesAndModels() {
        this.cubeBottomTopBlock((Block)ModRegistry.ENDER_CHARGE_BLOCK.get());
        this.cubeBottomTopBlock((Block)ModRegistry.CONFUSING_CHARGE_BLOCK.get());
        this.cubeBottomTopBlock((Block)ModRegistry.CONCUSSION_CHARGE_BLOCK.get());
        this.itemModels().basicItem((Item)ModRegistry.CONFUSING_POWDER_ITEM.get());
        this.itemModels().basicItem((Item)ModRegistry.ENDER_FRAGMENT_ITEM.get());
        this.itemModels().basicItem((Item)ModRegistry.OWL_EGG_ITEM.get());
        this.itemModels().basicItem((Item)ModRegistry.WITHERING_DUST_ITEM.get());
        this.spawnEgg((Item)ModRegistry.CONCUSSION_CREEPER_SPAWN_EGG_ITEM.get());
        this.spawnEgg((Item)ModRegistry.INFESTED_ZOMBIE_SPAWN_EGG_ITEM.get());
        this.spawnEgg((Item)ModRegistry.ENDERMINY_SPAWN_EGG_ITEM.get());
        this.spawnEgg((Item)ModRegistry.DIRE_WOLF_SPAWN_EGG_ITEM.get());
        this.spawnEgg((Item)ModRegistry.FALLEN_MOUNT_SPAWN_EGG_ITEM.get());
        this.spawnEgg((Item)ModRegistry.WITHER_CAT_SPAWN_EGG_ITEM.get());
        this.spawnEgg((Item)ModRegistry.WITHER_WITCH_SPAWN_EGG_ITEM.get());
        this.spawnEgg((Item)ModRegistry.OWL_SPAWN_EGG_ITEM.get());
        this.spawnEgg((Item)ModRegistry.FALLEN_KNIGHT_SPAWN_EGG_ITEM.get());
    }

    private void cubeBottomTopBlock(Block block) {
        this.cubeBottomTopBlock(block, this.extend(this.blockTexture(block), "_side"), this.extend(this.blockTexture(block), "_bottom"), this.extend(this.blockTexture(block), "_top"));
        this.itemModels().withExistingParent(this.name(block), this.extendKey(block, "block"));
    }

    public void cubeBottomTopBlock(Block block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(this.name(block), side, bottom, top));
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    private String name(Block block) {
        return this.key(block).m_135815_();
    }

    private ResourceLocation extendKey(Block block, String ... extensions) {
        ResourceLocation loc = this.key(block);
        extensions = (String[])ArrayUtils.add((Object[])extensions, (Object)loc.m_135815_());
        return new ResourceLocation(loc.m_135827_(), String.join((CharSequence)"/", extensions));
    }

    private ResourceLocation extend(ResourceLocation rl, String suffix) {
        return new ResourceLocation(rl.m_135827_(), rl.m_135815_() + suffix);
    }

    public ItemModelBuilder spawnEgg(Item item) {
        return this.spawnEgg(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)));
    }

    public ItemModelBuilder spawnEgg(ResourceLocation item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("minecraft:item/template_spawn_egg"));
    }
}

