/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.monster;

import fuzs.enderzoology.world.entity.ai.goal.FollowMobOwnerGoal;
import fuzs.enderzoology.world.entity.monster.CompanionMob;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class WitherCat
extends Monster
implements CompanionMob<Witch> {
    private static final float NORMAL_SCALE = 1.0f;
    private static final float ANGRY_SCALE = 2.0f;
    private static final float SCALE_INCREMENTS = 0.05f;
    private static final int MIN_DEAGGRESSION_TIME = 600;
    private static final EntityDataAccessor<Float> DATA_SCALE_ID = SynchedEntityData.m_135353_(WitherCat.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("B9662B59-9566-4402-BC1F-2ED2B276D846");
    private static final UUID HEALTH_MODIFIER_ATTACKING_UUID = UUID.fromString("B9662B29-9467-3302-1D1A-2ED2B276D846");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Attacking speed boost", 0.15, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier HEALTH_MODIFIER_ATTACKING = new AttributeModifier(HEALTH_MODIFIER_ATTACKING_UUID, "Attacking health boost", 20.0, AttributeModifier.Operation.ADDITION);
    private int targetLostTime = -600;
    private int ticksUntilNextAlert;
    private float scaleO;

    public WitherCat(EntityType<? extends WitherCat> entityType, Level level) {
        super(entityType, level);
        this.f_19793_ = 1.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new FollowMobOwnerGoal((Mob)this, Witch.class, 1.25));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SCALE_ID, (Object)Float.valueOf(1.0f));
        this.scaleO = 1.0f;
    }

    public void m_6710_(@Nullable LivingEntity target) {
        if (target == null) {
            this.targetLostTime = this.f_19797_;
        } else {
            this.targetLostTime = -600;
            if (this.m_5448_() == null) {
                this.resetTicksUntilNextAlert();
            }
        }
        super.m_6710_(target);
    }

    protected void m_8024_() {
        AttributeInstance movementSpeedAttribute = this.m_21051_(Attributes.f_22279_);
        AttributeInstance maxHealthAttribute = this.m_21051_(Attributes.f_22276_);
        if (this.isAngry()) {
            if (!movementSpeedAttribute.m_22109_(SPEED_MODIFIER_ATTACKING)) {
                movementSpeedAttribute.m_22118_(SPEED_MODIFIER_ATTACKING);
            }
            if (!maxHealthAttribute.m_22109_(HEALTH_MODIFIER_ATTACKING)) {
                maxHealthAttribute.m_22118_(HEALTH_MODIFIER_ATTACKING);
                this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 120, 3));
            }
        } else {
            if (movementSpeedAttribute.m_22109_(SPEED_MODIFIER_ATTACKING)) {
                movementSpeedAttribute.m_22130_(SPEED_MODIFIER_ATTACKING);
            }
            if (maxHealthAttribute.m_22109_(HEALTH_MODIFIER_ATTACKING)) {
                maxHealthAttribute.m_22130_(HEALTH_MODIFIER_ATTACKING);
            }
        }
        this.maybeAlertCompanions();
        if (this.isAngry()) {
            if (this.m_6134_() < 2.0f) {
                this.setScale(Math.min(2.0f, this.m_6134_() + 0.05f));
            }
        } else if (this.m_6134_() > 1.0f) {
            this.setScale(Math.max(1.0f, this.m_6134_() - 0.05f));
        }
        super.m_8024_();
    }

    @Override
    public Mob getCompanionMob() {
        return this;
    }

    @Override
    public int getTicksUntilNextAlert() {
        return this.ticksUntilNextAlert;
    }

    @Override
    public void setTicksUntilNextAlert(int ticksUntilNextAlert) {
        this.ticksUntilNextAlert = ticksUntilNextAlert;
    }

    @Override
    public Class<Witch> getCompanionType() {
        return Witch.class;
    }

    public void m_6210_() {
        double d = this.m_20185_();
        double e = this.m_20186_();
        double f = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d, e, f);
    }

    public float m_6134_() {
        return ((Float)this.f_19804_.m_135370_(DATA_SCALE_ID)).floatValue();
    }

    public float getScaleAmount(float tickDelta) {
        return Mth.m_14179_((float)tickDelta, (float)this.scaleO, (float)this.m_6134_());
    }

    private void setScale(float scale) {
        this.f_19804_.m_135381_(DATA_SCALE_ID, (Object)Float.valueOf(scale));
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (DATA_SCALE_ID.equals(key)) {
            this.m_6210_();
        }
        super.m_7350_(key);
    }

    public boolean isVisuallyAngry() {
        return this.m_6134_() != 1.0f;
    }

    private boolean isAngry() {
        return this.m_5448_() != null || this.f_19797_ < this.targetLostTime + 600;
    }

    public boolean m_6673_(DamageSource source) {
        return super.m_6673_(source) || source.m_7639_() instanceof Witch;
    }

    public boolean m_147207_(MobEffectInstance effectInstance, @Nullable Entity entity) {
        if (!effectInstance.m_19544_().m_19486_() && entity instanceof Witch) {
            return false;
        }
        return super.m_147207_(effectInstance, entity);
    }

    public boolean m_7301_(@Nonnull MobEffectInstance potion) {
        return potion.m_19544_() != MobEffects.f_19615_ && super.m_7301_(potion);
    }

    public void m_8107_() {
        this.scaleO = this.m_6134_();
        super.m_8107_();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.isAngry() ? SoundEvents.f_11789_ : SoundEvents.f_11786_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11791_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11787_;
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.5f;
    }
}

