/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology;

import fuzs.enderzoology.config.CommonConfig;
import fuzs.enderzoology.handler.HuntingBowHandler;
import fuzs.enderzoology.handler.MobHuntingHandler;
import fuzs.enderzoology.init.ModRegistry;
import fuzs.enderzoology.world.entity.EntityAttributeProviders;
import fuzs.enderzoology.world.entity.SpawnPlacementRules;
import fuzs.enderzoology.world.entity.item.PrimedCharge;
import fuzs.enderzoology.world.entity.projectile.ThrownOwlEgg;
import fuzs.enderzoology.world.level.EnderExplosion;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.biome.v1.MobSpawnSettingsContext;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.BiomeModificationsContext;
import fuzs.puzzleslib.api.core.v1.context.CreativeModeTabContext;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesCreateContext;
import fuzs.puzzleslib.api.core.v1.context.FlammableBlocksContext;
import fuzs.puzzleslib.api.core.v1.context.ModLifecycleContext;
import fuzs.puzzleslib.api.core.v1.context.SpawnPlacementsContext;
import fuzs.puzzleslib.api.event.v1.entity.EntityLevelEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.UseItemEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.ArrowLooseCallback;
import fuzs.puzzleslib.api.event.v1.level.ExplosionEvents;
import fuzs.puzzleslib.api.init.v2.PotionBrewingRegistry;
import fuzs.puzzleslib.api.item.v2.CreativeModeTabConfigurator;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_156;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2374;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_2965;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5363;
import net.minecraft.class_5483;
import net.minecraft.class_5712;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnderZoology
implements ModConstructor {
    public static final String MOD_ID = "enderzoology";
    public static final String MOD_NAME = "Ender Zoology";
    public static final Logger LOGGER = LogManager.getLogger((String)"Ender Zoology");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"enderzoology").common(CommonConfig.class);

    public static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }

    public void onConstructMod() {
        ModRegistry.touch();
        EnderZoology.registerHandlers();
    }

    private static void registerHandlers() {
        ExplosionEvents.DETONATE.register(EnderExplosion::onExplosionDetonate);
        ArrowLooseCallback.EVENT.register(HuntingBowHandler::onArrowLoose);
        UseItemEvents.TICK.register(HuntingBowHandler::onUseItemTick);
        EntityLevelEvents.LOAD.register(MobHuntingHandler::onLoad);
    }

    public void onCommonSetup(ModLifecycleContext context) {
        EnderZoology.registerDispenseBehaviors();
        EnderZoology.registerBrewingRecipes();
    }

    private static void registerDispenseBehaviors() {
        class_2315.method_10009((class_1935)((class_1935)ModRegistry.OWL_EGG_ITEM.get()), (class_2357)new class_2965(){

            protected class_1676 method_12844(class_1937 level, class_2374 position, class_1799 stack) {
                return (class_1676)class_156.method_654((Object)((Object)new ThrownOwlEgg(level, position.method_10216(), position.method_10214(), position.method_10215())), thrownEgg -> thrownEgg.method_16940(stack));
            }
        });
        EnderZoology.registerChargeBehavior((class_2248)ModRegistry.ENDER_CHARGE_BLOCK.get(), EnderExplosion.EntityInteraction.ENDER);
        EnderZoology.registerChargeBehavior((class_2248)ModRegistry.CONFUSING_CHARGE_BLOCK.get(), EnderExplosion.EntityInteraction.CONFUSION);
        EnderZoology.registerChargeBehavior((class_2248)ModRegistry.CONCUSSION_CHARGE_BLOCK.get(), EnderExplosion.EntityInteraction.CONCUSSION);
    }

    private static void registerChargeBehavior(class_2248 block, final EnderExplosion.EntityInteraction entityInteraction) {
        class_2315.method_10009((class_1935)block, (class_2357)new class_2347(){

            protected class_1799 method_10135(class_2342 blockSource, class_1799 stack) {
                class_3218 level = blockSource.method_10207();
                class_2338 blockpos = blockSource.method_10122().method_10093((class_2350)blockSource.method_10120().method_11654((class_2769)class_2315.field_10918));
                PrimedCharge primedtnt = new PrimedCharge((class_1937)level, (double)blockpos.method_10263() + 0.5, blockpos.method_10264(), (double)blockpos.method_10260() + 0.5, null, entityInteraction);
                level.method_8649((class_1297)primedtnt);
                level.method_43128(null, primedtnt.method_23317(), primedtnt.method_23318(), primedtnt.method_23321(), class_3417.field_15079, class_3419.field_15245, 1.0f, 1.0f);
                level.method_33596(null, class_5712.field_28738, blockpos);
                stack.method_7934(1);
                return stack;
            }
        });
    }

    private static void registerBrewingRecipes() {
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe(class_1847.field_8999, (class_1792)ModRegistry.ENDER_FRAGMENT_ITEM.get(), (class_1842)ModRegistry.DISPLACEMENT_POTION.get());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe((class_1842)ModRegistry.DISPLACEMENT_POTION.get(), class_1802.field_8601, (class_1842)ModRegistry.STRONG_DISPLACEMENT_POTION.get());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe(class_1847.field_8999, (class_1792)ModRegistry.WITHERING_DUST_ITEM.get(), (class_1842)ModRegistry.DECAY_POTION.get());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe((class_1842)ModRegistry.DECAY_POTION.get(), class_1802.field_8725, (class_1842)ModRegistry.LONG_DECAY_POTION.get());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe((class_1842)ModRegistry.DECAY_POTION.get(), class_1802.field_8601, (class_1842)ModRegistry.STRONG_DECAY_POTION.get());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe(class_1847.field_8999, (class_1792)ModRegistry.CONFUSING_POWDER_ITEM.get(), (class_1842)ModRegistry.CONFUSION_POTION.get());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe((class_1842)ModRegistry.CONFUSION_POTION.get(), class_1802.field_8725, (class_1842)ModRegistry.LONG_CONFUSION_POTION.get());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe((class_1842)ModRegistry.CONFUSION_POTION.get(), class_1802.field_8601, (class_1842)ModRegistry.STRONG_CONFUSION_POTION.get());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe(class_1847.field_8999, (class_1792)ModRegistry.OWL_EGG_ITEM.get(), (class_1842)ModRegistry.RISING_POTION.get());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe((class_1842)ModRegistry.RISING_POTION.get(), class_1802.field_8725, (class_1842)ModRegistry.LONG_RISING_POTION.get());
    }

    public void onRegisterFlammableBlocks(FlammableBlocksContext context) {
        context.registerFlammable(15, 100, (class_2248)ModRegistry.ENDER_CHARGE_BLOCK.get(), new class_2248[]{(class_2248)ModRegistry.CONFUSING_CHARGE_BLOCK.get(), (class_2248)ModRegistry.CONCUSSION_CHARGE_BLOCK.get()});
    }

    public void onEntityAttributeCreation(EntityAttributesCreateContext context) {
        context.registerEntityAttributes((class_1299)ModRegistry.CONCUSSION_CREEPER_ENTITY_TYPE.get(), EntityAttributeProviders.createConcussionCreeperAttributes());
        context.registerEntityAttributes((class_1299)ModRegistry.INFESTED_ZOMBIE_ENTITY_TYPE.get(), EntityAttributeProviders.createEnderInfestedZombieAttributes());
        context.registerEntityAttributes((class_1299)ModRegistry.ENDERMINY_ENTITY_TYPE.get(), EntityAttributeProviders.createEnderminyAttributes());
        context.registerEntityAttributes((class_1299)ModRegistry.DIRE_WOLF_ENTITY_TYPE.get(), EntityAttributeProviders.createDireWolfAttributes());
        context.registerEntityAttributes((class_1299)ModRegistry.FALLEN_MOUNT_ENTITY_TYPE.get(), EntityAttributeProviders.createFallenMountAttributes());
        context.registerEntityAttributes((class_1299)ModRegistry.WITHER_CAT_ENTITY_TYPE.get(), EntityAttributeProviders.createWitherCatAttributes());
        context.registerEntityAttributes((class_1299)ModRegistry.WITHER_WITCH_ENTITY_TYPE.get(), EntityAttributeProviders.createWitherWitchAttributes());
        context.registerEntityAttributes((class_1299)ModRegistry.OWL_ENTITY_TYPE.get(), EntityAttributeProviders.createOwlAttributes());
        context.registerEntityAttributes((class_1299)ModRegistry.FALLEN_KNIGHT_ENTITY_TYPE.get(), EntityAttributeProviders.createFallenKnightAttributes());
    }

    public void onRegisterSpawnPlacements(SpawnPlacementsContext context) {
        context.registerSpawnPlacement((class_1299)ModRegistry.CONCUSSION_CREEPER_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, SpawnPlacementRules::checkSurfaceSpawnRules);
        context.registerSpawnPlacement((class_1299)ModRegistry.INFESTED_ZOMBIE_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, SpawnPlacementRules::checkSurfaceSpawnRules);
        context.registerSpawnPlacement((class_1299)ModRegistry.ENDERMINY_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, SpawnPlacementRules::checkSurfaceSpawnRules);
        context.registerSpawnPlacement((class_1299)ModRegistry.DIRE_WOLF_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, SpawnPlacementRules::checkDireWolfSpawnRules);
        context.registerSpawnPlacement((class_1299)ModRegistry.FALLEN_MOUNT_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, SpawnPlacementRules::checkMonsterSpawnRules);
        context.registerSpawnPlacement((class_1299)ModRegistry.WITHER_CAT_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, SpawnPlacementRules::checkMonsterSpawnRules);
        context.registerSpawnPlacement((class_1299)ModRegistry.WITHER_WITCH_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, SpawnPlacementRules::checkSurfaceSpawnRules);
        context.registerSpawnPlacement((class_1299)ModRegistry.OWL_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13197, SpawnPlacementRules::checkOwlSpawnRules);
        context.registerSpawnPlacement((class_1299)ModRegistry.FALLEN_KNIGHT_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, SpawnPlacementRules::checkSurfaceSpawnRules);
    }

    public void onRegisterBiomeModifications(BiomeModificationsContext context) {
        context.register(BiomeLoadingPhase.ADDITIONS, loadingContext -> loadingContext.canGenerateIn(class_5363.field_25412), modificationContext -> {
            MobSpawnSettingsContext settings = modificationContext.mobSpawnSettings();
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).concussionCreeper) {
                EnderZoology.registerSpawnData(settings, class_1311.field_6302, class_1299.field_6046, data -> new class_5483.class_1964((class_1299)ModRegistry.CONCUSSION_CREEPER_ENTITY_TYPE.get(), Math.max(1, data.method_34979().method_34976() / 4), data.field_9388, data.field_9387));
            }
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).infestedZombie) {
                EnderZoology.registerSpawnData(settings, class_1311.field_6302, class_1299.field_6051, data -> new class_5483.class_1964((class_1299)ModRegistry.INFESTED_ZOMBIE_ENTITY_TYPE.get(), Math.max(1, data.method_34979().method_34976() / 4), 1, data.field_9387));
            }
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).fallenKnight) {
                EnderZoology.registerSpawnData(settings, class_1311.field_6302, class_1299.field_6051, data -> new class_5483.class_1964((class_1299)ModRegistry.FALLEN_KNIGHT_ENTITY_TYPE.get(), Math.max(1, data.method_34979().method_34976() / 4), 4, 6));
            }
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).enderminy) {
                EnderZoology.registerSpawnData(settings, class_1311.field_6302, class_1299.field_6091, data -> new class_5483.class_1964((class_1299)ModRegistry.ENDERMINY_ENTITY_TYPE.get(), data.method_34979().method_34976() * 3, Math.min(data.field_9387, data.field_9388 * 4), data.field_9387));
            }
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).direWolf && modificationContext.climateSettings().getPrecipitation() == class_1959.class_1963.field_9383) {
                EnderZoology.findVanillaSpawnData(settings, class_1311.field_6294, class_1299.field_6055).ifPresent(data -> settings.addSpawn(class_1311.field_6302, new class_5483.class_1964((class_1299)ModRegistry.DIRE_WOLF_ENTITY_TYPE.get(), Math.max(1, data.method_34979().method_34976() / 4), 3, 8)));
            }
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).witherWitch) {
                EnderZoology.registerSpawnData(settings, class_1311.field_6302, class_1299.field_6145, data -> new class_5483.class_1964((class_1299)ModRegistry.WITHER_WITCH_ENTITY_TYPE.get(), data.method_34979(), data.field_9388, data.field_9387));
            }
            if (((CommonConfig)EnderZoology.CONFIG.get(CommonConfig.class)).owl && modificationContext.climateSettings().getPrecipitation() != class_1959.class_1963.field_9384) {
                EnderZoology.findVanillaSpawnData(settings, class_1311.field_6294, class_1299.field_6140).ifPresent(data -> settings.addSpawn(class_1311.field_6294, new class_5483.class_1964((class_1299)ModRegistry.OWL_ENTITY_TYPE.get(), data.method_34979(), data.field_9388, data.field_9387)));
            }
        });
    }

    private static void registerSpawnData(MobSpawnSettingsContext settings, class_1311 category, class_1299<?> vanillaEntityType, Function<class_5483.class_1964, class_5483.class_1964> factory) {
        EnderZoology.findVanillaSpawnData(settings, category, vanillaEntityType).ifPresent(data -> settings.addSpawn(category, (class_5483.class_1964)factory.apply((class_5483.class_1964)data)));
    }

    private static Optional<class_5483.class_1964> findVanillaSpawnData(MobSpawnSettingsContext settings, class_1311 category, class_1299<?> entityType) {
        return settings.getSpawnerData(category).stream().filter(data -> data.field_9389 == entityType).findAny();
    }

    private static void registerSpawnCost(MobSpawnSettingsContext spawnSettings, class_1299<?> vanillaEntityType, class_1299<?> modEntityType, DoubleUnaryOperator chargeConverter, DoubleUnaryOperator energyBudgetConverter) {
        Optional<class_5483.class_5265> optionalMobSpawnCost = Optional.ofNullable(spawnSettings.getSpawnCost(vanillaEntityType));
        optionalMobSpawnCost.ifPresent(cost -> spawnSettings.setSpawnCost(modEntityType, chargeConverter.applyAsDouble(cost.method_27838()), energyBudgetConverter.applyAsDouble(cost.method_27837())));
    }

    public void onRegisterCreativeModeTabs(CreativeModeTabContext context) {
        context.registerCreativeModeTab(CreativeModeTabConfigurator.from((String)MOD_ID).icon(() -> new class_1799((class_1935)ModRegistry.ENDER_FRAGMENT_ITEM.get())).appendEnchantmentsAndPotions().displayItems((featureFlagSet, output, bl) -> {
            output.method_45421((class_1935)ModRegistry.CONCUSSION_CHARGE_ITEM.get());
            output.method_45421((class_1935)ModRegistry.CONFUSING_CHARGE_ITEM.get());
            output.method_45421((class_1935)ModRegistry.ENDER_CHARGE_ITEM.get());
            output.method_45421((class_1935)ModRegistry.CONFUSING_POWDER_ITEM.get());
            output.method_45421((class_1935)ModRegistry.ENDER_FRAGMENT_ITEM.get());
            output.method_45421((class_1935)ModRegistry.HUNTING_BOW.get());
            output.method_45421((class_1935)ModRegistry.OWL_EGG_ITEM.get());
            output.method_45421((class_1935)ModRegistry.WITHERING_DUST_ITEM.get());
            output.method_45421((class_1935)ModRegistry.CONCUSSION_CREEPER_SPAWN_EGG_ITEM.get());
            output.method_45421((class_1935)ModRegistry.INFESTED_ZOMBIE_SPAWN_EGG_ITEM.get());
            output.method_45421((class_1935)ModRegistry.ENDERMINY_SPAWN_EGG_ITEM.get());
            output.method_45421((class_1935)ModRegistry.DIRE_WOLF_SPAWN_EGG_ITEM.get());
            output.method_45421((class_1935)ModRegistry.FALLEN_MOUNT_SPAWN_EGG_ITEM.get());
            output.method_45421((class_1935)ModRegistry.WITHER_CAT_SPAWN_EGG_ITEM.get());
            output.method_45421((class_1935)ModRegistry.WITHER_WITCH_SPAWN_EGG_ITEM.get());
            output.method_45421((class_1935)ModRegistry.OWL_SPAWN_EGG_ITEM.get());
            output.method_45421((class_1935)ModRegistry.FALLEN_KNIGHT_SPAWN_EGG_ITEM.get());
        }));
    }
}

