/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.handler;

import fuzs.enderzoology.init.ModRegistry;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class HuntingBowHandler {
    public static EventResult onArrowLoose(Player player, ItemStack stack, Level level, MutableInt charge, boolean hasAmmo) {
        if (hasAmmo && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)stack) > 0) {
            float velocity = BowItem.m_40661_((int)charge.getAsInt());
            if (!level.f_46443_ && velocity >= 0.1f) {
                ItemStack itemstack = player.m_6298_(stack);
                ArrowItem arrowitem = (ArrowItem)(itemstack.m_41720_() instanceof ArrowItem ? itemstack.m_41720_() : Items.f_42412_);
                float[] shotPitches = HuntingBowHandler.getShotPitches(level.f_46441_, velocity);
                for (int i = 0; i < 2; ++i) {
                    AbstractArrow abstractarrow = arrowitem.m_6394_(level, itemstack, (LivingEntity)player);
                    abstractarrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, velocity * 3.0f, 1.5f);
                    HuntingBowHandler.applyPowerEnchantment(abstractarrow, stack);
                    HuntingBowHandler.applyPunchEnchantment(abstractarrow, stack);
                    HuntingBowHandler.applyFlameEnchantment(abstractarrow, stack);
                    HuntingBowHandler.applyPiercingEnchantment(abstractarrow, stack);
                    HuntingBowHandler.applyWitheringEnchantment(abstractarrow, stack);
                    abstractarrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    level.m_7967_((Entity)abstractarrow);
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, shotPitches[i + 1]);
                }
            }
        }
        return EventResult.PASS;
    }

    private static float[] getShotPitches(RandomSource random, float velocity) {
        boolean flag = random.m_188499_();
        return new float[]{1.0f, HuntingBowHandler.getRandomShotPitch(flag, random, velocity), HuntingBowHandler.getRandomShotPitch(!flag, random, velocity)};
    }

    private static float getRandomShotPitch(boolean p_150798_, RandomSource random, float velocity) {
        float f = p_150798_ ? 0.63f : 0.43f;
        return 1.0f / (random.m_188501_() * 0.5f + 1.8f) + f * velocity;
    }

    public static EventResult onUseItemTick(LivingEntity entity, ItemStack useItem, MutableInt useItemRemaining) {
        if (useItem.m_41720_() instanceof BowItem && useItem.m_41779_() - useItemRemaining.getAsInt() < 20) {
            int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)useItem);
            useItemRemaining.mapInt(duration -> duration - quickChargeLevel);
        }
        return EventResult.PASS;
    }

    public static void applyPowerEnchantment(AbstractArrow arrow, ItemStack stack) {
        int level = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
        if (level > 0) {
            arrow.m_36781_(arrow.m_36789_() + (double)level * 0.5 + 0.5);
        }
    }

    public static void applyPunchEnchantment(AbstractArrow arrow, ItemStack stack) {
        int level = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack);
        if (level > 0) {
            arrow.m_36735_(level);
        }
    }

    public static void applyFlameEnchantment(AbstractArrow arrow, ItemStack stack) {
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
            arrow.m_20254_(100);
        }
    }

    public static void applyPiercingEnchantment(AbstractArrow arrow, ItemStack stack) {
        int level = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)stack);
        if (level > 0) {
            arrow.m_36767_((byte)level);
        }
    }

    public static void applyWitheringEnchantment(AbstractArrow arrow, ItemStack stack) {
        HuntingBowHandler.applyWitheringEnchantment(arrow, EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModRegistry.WITHERING_ENCHANTMENT.get()), (ItemStack)stack));
    }

    public static void applyWitheringEnchantment(AbstractArrow arrow, LivingEntity shooter) {
        HuntingBowHandler.applyWitheringEnchantment(arrow, EnchantmentHelper.m_44836_((Enchantment)((Enchantment)ModRegistry.WITHERING_ENCHANTMENT.get()), (LivingEntity)shooter));
    }

    private static void applyWitheringEnchantment(AbstractArrow arrow, int level) {
        if (level > 0 && arrow instanceof Arrow) {
            ((Arrow)arrow).m_36870_(new MobEffectInstance(MobEffects.f_19615_, 5 * level));
        }
    }
}

