/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.animal;

import fuzs.enderzoology.init.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Owl
extends Animal
implements FlyingAnimal {
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42697_, Items.f_42526_, Items.f_42527_});
    private int eggTime = this.f_19796_.m_188503_(2000) + 2000;
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    private float flapping = 1.0f;
    private float nextFlap = 1.0f;

    public Owl(EntityType<? extends Owl> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, false);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        if (spawnData == null) {
            spawnData = new AgeableMob.AgeableMobGroupData(true);
        }
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(6, (Goal)new OwlWanderGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Rabbit.class, false));
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public void m_8107_() {
        super.m_8107_();
        this.calculateFlapping();
        if (!this.f_19853_.f_46443_ && this.m_6084_() && !this.m_6162_() && this.f_19853_.m_8055_(this.m_20183_().m_7495_()).m_204336_(BlockTags.f_13035_) && --this.eggTime <= 0) {
            this.m_5496_(SoundEvents.f_11752_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.m_19998_((ItemLike)ModRegistry.OWL_EGG_ITEM.get());
            this.m_146850_(GameEvent.f_157810_);
            this.eggTime = this.f_19796_.m_188503_(2000) + 2000;
        }
    }

    private void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed += (float)(!this.f_19861_ && !this.m_20159_() ? 4.0 : -1.0) * 0.3f;
        this.flapSpeed = Mth.m_14036_((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.f_19861_ && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        Vec3 vec3 = this.m_20184_();
        if (!this.f_19861_ && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    public boolean m_6898_(ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("EggLayTime")) {
            this.eggTime = compound.m_128451_("EggLayTime");
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("EggLayTime", this.eggTime);
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModRegistry.OWL_HOOT_SOUND_EVENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModRegistry.OWL_HURT_SOUND_EVENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModRegistry.OWL_DEATH_SOUND_EVENT.get();
    }

    public int m_8100_() {
        return 120;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    protected boolean m_142039_() {
        return this.f_146794_ > this.nextFlap;
    }

    protected void m_142043_() {
        this.m_5496_(SoundEvents.f_12191_, 0.15f, 1.0f);
        this.nextFlap = this.f_146794_ + this.flapSpeed / 2.0f;
    }

    public boolean m_7327_(Entity target) {
        return target.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        return (AgeableMob)((EntityType)ModRegistry.OWL_ENTITY_TYPE.get()).m_20615_((Level)level);
    }

    public boolean m_29443_() {
        return !this.f_19861_;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.5f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    static class OwlWanderGoal
    extends WaterAvoidingRandomFlyingGoal {
        public OwlWanderGoal(PathfinderMob pathfinderMob, double d) {
            super(pathfinderMob, d);
        }

        @Nullable
        protected Vec3 m_7037_() {
            Vec3 vec3 = null;
            if (this.f_25725_.m_20069_()) {
                vec3 = LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)15, (int)15);
            }
            if (this.f_25725_.m_217043_().m_188501_() >= this.f_25985_) {
                vec3 = this.getTreePos();
            }
            return vec3 == null ? super.m_7037_() : vec3;
        }

        @Nullable
        private Vec3 getTreePos() {
            BlockPos blockpos = this.f_25725_.m_20183_();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
            for (BlockPos blockpos1 : BlockPos.m_121976_((int)Mth.m_14107_((double)(this.f_25725_.m_20185_() - 3.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20186_() - 6.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20189_() - 3.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20185_() + 3.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20186_() + 6.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20189_() + 3.0)))) {
                BlockState blockstate;
                boolean flag;
                if (blockpos.equals((Object)blockpos1) || !(flag = (blockstate = this.f_25725_.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos1.m_122159_((Vec3i)blockpos1, Direction.DOWN))).m_60734_() instanceof LeavesBlock || blockstate.m_204336_(BlockTags.f_13106_)) || !this.f_25725_.f_19853_.m_46859_(blockpos1) || !this.f_25725_.f_19853_.m_46859_((BlockPos)blockpos$mutableblockpos.m_122159_((Vec3i)blockpos1, Direction.UP))) continue;
                return Vec3.m_82539_((Vec3i)blockpos1);
            }
            return null;
        }
    }
}

