/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.monster;

import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.sensing.Sensing;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface CompanionMob<T extends Mob> {
    public static final UniformInt ALERT_INTERVAL = TimeUtil.m_145020_((int)4, (int)6);

    public Mob getCompanionMob();

    @Nullable
    default public LivingEntity getCompanionTarget() {
        return this.getCompanionMob().m_5448_();
    }

    public int getTicksUntilNextAlert();

    public void setTicksUntilNextAlert(int var1);

    default public void resetTicksUntilNextAlert() {
        this.setTicksUntilNextAlert(ALERT_INTERVAL.m_214085_(this.getCompanionRandom()));
    }

    default public Level getCompanionLevel() {
        return this.getCompanionMob().m_9236_();
    }

    public Class<T> getCompanionType();

    default public Sensing getCompanionSensing() {
        return this.getCompanionMob().m_21574_();
    }

    default public RandomSource getCompanionRandom() {
        return this.getCompanionMob().m_217043_();
    }

    default public Vec3 getCompanionPosition() {
        return this.getCompanionMob().m_20182_();
    }

    default public double getCompanionAttributeValue(Attribute attribute) {
        return this.getCompanionMob().m_21133_(attribute);
    }

    default public void maybeAlertCompanions() {
        if (this.getCompanionTarget() != null) {
            if (this.getTicksUntilNextAlert() > 0) {
                this.setTicksUntilNextAlert(this.getTicksUntilNextAlert() - 1);
            } else {
                if (this.getCompanionSensing().m_148306_((Entity)this.getCompanionTarget())) {
                    this.alertCompanions();
                }
                this.resetTicksUntilNextAlert();
            }
        }
    }

    private void alertCompanions() {
        double followRange = this.getCompanionAttributeValue(Attributes.f_22277_);
        AABB aabb = AABB.m_82333_((Vec3)this.getCompanionPosition()).m_82377_(followRange, 10.0, followRange);
        for (Mob companion : this.getCompanionLevel().m_6443_(this.getCompanionType(), aabb, EntitySelector.f_20408_)) {
            if (companion.m_5448_() != null || companion.m_7307_((Entity)this.getCompanionTarget())) continue;
            companion.m_6710_(this.getCompanionTarget());
        }
    }
}

