/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.monster;

import fuzs.enderzoology.init.ModRegistry;
import fuzs.enderzoology.world.entity.ai.goal.FollowPackLeaderGoal;
import fuzs.enderzoology.world.entity.monster.PackMob;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class DireWolf
extends Wolf
implements Enemy,
PackMob {
    private static final UniformInt EATING_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private static final Predicate<ItemEntity> ALLOWED_ITEMS = itemEntity -> !itemEntity.m_32063_() && itemEntity.m_6084_() && !(itemEntity.m_32055_().m_41720_() instanceof BlockItem);
    @Nullable
    private DireWolf wolfPackLeader;
    private int wolfPackSize = 1;
    private int ticksSinceEaten;

    public DireWolf(EntityType<? extends Wolf> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 10;
        this.m_21553_(true);
        this.ticksSinceEaten = EATING_TIME.m_214085_(this.f_19796_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(4, (Goal)new SearchForItemsGoal((Mob)this));
        this.f_21345_.m_25352_(5, new FollowPackLeaderGoal<DireWolf>(this));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Wolf.class, 8, true, false, entity -> entity.m_6095_() == EntityType.f_20499_));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 12, true, false, entity -> (entity instanceof Animal || entity instanceof Zombie) && !(entity instanceof Wolf) && this.isHungry() && !this.m_21205_().m_41614_()));
        this.f_21346_.m_25352_(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public int m_213860_() {
        return this.f_21364_;
    }

    protected boolean m_8028_() {
        return true;
    }

    public int m_5792_() {
        return this.getMaxSchoolSize();
    }

    @Override
    public int getMaxSchoolSize() {
        return super.m_5792_();
    }

    @Override
    public boolean isFollower() {
        return this.wolfPackLeader != null && this.wolfPackLeader.m_6084_();
    }

    @Override
    public void startFollowing(PackMob leader) {
        if (leader == this) {
            throw new IllegalStateException("Wolf cannot follow itself");
        }
        this.wolfPackLeader = (DireWolf)leader;
        leader.addFollower();
    }

    @Override
    public void addFollower() {
        ++this.wolfPackSize;
    }

    @Override
    public void removeFollower() {
        --this.wolfPackSize;
    }

    @Override
    public void stopFollowing() {
        this.wolfPackLeader.removeFollower();
        this.wolfPackLeader = null;
    }

    @Override
    public boolean canBeFollowed() {
        return this.hasFollowers() && this.wolfPackSize < this.getMaxSchoolSize();
    }

    public void m_8119_() {
        List list;
        super.m_8119_();
        if (this.hasFollowers() && this.f_19853_.f_46441_.m_188503_(200) == 1 && (list = this.f_19853_.m_45976_(this.getClass(), this.m_20191_().m_82377_(8.0, 8.0, 8.0))).size() <= 1) {
            this.wolfPackSize = 1;
        }
    }

    @Override
    public boolean hasFollowers() {
        return this.wolfPackSize > 1;
    }

    @Override
    public boolean inRangeOfLeader() {
        return this.m_20280_((Entity)this.wolfPackLeader) <= 121.0;
    }

    @Override
    public boolean tooCloseToLeader() {
        return this.m_20280_((Entity)this.wolfPackLeader) < 9.0;
    }

    @Override
    public void pathToLeader() {
        if (this.isFollower()) {
            this.m_21573_().m_5624_((Entity)this.wolfPackLeader, 1.0);
        }
    }

    @Override
    public void addFollowers(Stream<? extends PackMob> followers) {
        followers.limit(this.getMaxSchoolSize() - this.wolfPackSize).filter(packMob -> packMob != this).forEach(packMob -> packMob.startFollowing(this));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pSpawnData == null) {
            pSpawnData = new PackSpawnGroupData(this);
        } else if (pSpawnData instanceof PackSpawnGroupData) {
            PackSpawnGroupData packSpawnData = (PackSpawnGroupData)((Object)pSpawnData);
            this.startFollowing(packSpawnData.leader);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void m_8107_() {
        if (!this.f_19853_.f_46443_ && this.m_6084_() && this.m_6142_()) {
            ItemStack itemStack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (this.canEat(itemStack) && --this.ticksSinceEaten < 40 && this.f_19796_.m_188501_() < 0.1f && !this.m_6117_()) {
                this.m_6672_(InteractionHand.MAIN_HAND);
            } else if (this.ticksSinceEaten < 0) {
                this.ticksSinceEaten = EATING_TIME.m_214085_(this.f_19796_);
            }
        }
        super.m_8107_();
    }

    public ItemStack m_5584_(Level level, ItemStack food) {
        Item item = food.m_41720_();
        if (item.m_41472_()) {
            this.m_5634_((float)item.m_41473_().m_38744_() * (item.m_41473_().m_38746_() ? 2.0f : 1.0f));
            this.f_19853_.m_7605_((Entity)this, (byte)18);
        }
        return super.m_5584_(level, food);
    }

    public void m_7822_(byte id) {
        if (id == 18) {
            for (int i = 0; i < 7; ++i) {
                double d = this.f_19796_.m_188583_() * 0.02;
                double e = this.f_19796_.m_188583_() * 0.02;
                double f = this.f_19796_.m_188583_() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d, e, f);
            }
        } else {
            super.m_7822_(id);
        }
    }

    private boolean isHungry() {
        return this.m_21223_() < this.m_21233_();
    }

    private boolean canEat(ItemStack stack) {
        return stack.m_41720_().m_41472_() && this.m_5448_() == null && this.f_19861_ && this.isHungry();
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    public boolean m_7066_(ItemStack stack) {
        EquipmentSlot equipmentSlot = Mob.m_147233_((ItemStack)stack);
        if (!this.m_6844_(equipmentSlot).m_41619_()) {
            return false;
        }
        return equipmentSlot == EquipmentSlot.MAINHAND && super.m_7066_(stack);
    }

    public boolean m_7252_(ItemStack stack) {
        Item item = stack.m_41720_();
        ItemStack itemStack = this.m_6844_(EquipmentSlot.MAINHAND);
        return itemStack.m_41619_() || item.m_41472_() && !itemStack.m_41720_().m_41472_();
    }

    private void spitOutItem(ItemStack stack) {
        if (!stack.m_41619_() && !this.f_19853_.f_46443_) {
            ItemEntity itemEntity = new ItemEntity(this.f_19853_, this.m_20185_() + this.m_20154_().f_82479_, this.m_20186_() + 1.0, this.m_20189_() + this.m_20154_().f_82481_, stack);
            itemEntity.m_32010_(40);
            itemEntity.m_32052_(this.m_20148_());
            this.m_5496_(SoundEvents.f_11952_, 1.0f, 1.0f);
            this.f_19853_.m_7967_((Entity)itemEntity);
        }
    }

    private void dropItemStack(ItemStack stack) {
        ItemEntity itemEntity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
        this.f_19853_.m_7967_((Entity)itemEntity);
    }

    protected void m_7581_(ItemEntity itemEntity) {
        ItemStack itemStack = itemEntity.m_32055_();
        if (this.m_7252_(itemStack)) {
            int i = itemStack.m_41613_();
            if (i > 1) {
                this.dropItemStack(itemStack.m_41620_(i - 1));
            }
            this.spitOutItem(this.m_6844_(EquipmentSlot.MAINHAND));
            this.m_21053_(itemEntity);
            this.m_8061_(EquipmentSlot.MAINHAND, itemStack.m_41620_(1));
            this.m_21508_(EquipmentSlot.MAINHAND);
            this.m_7938_((Entity)itemEntity, itemStack.m_41613_());
            itemEntity.m_146870_();
            this.ticksSinceEaten = EATING_TIME.m_214085_(this.f_19796_);
        }
    }

    protected void m_6668_(DamageSource damageSource) {
        ItemStack itemStack = this.m_6844_(EquipmentSlot.MAINHAND);
        if (!itemStack.m_41619_()) {
            this.m_19983_(itemStack);
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
        super.m_6668_(damageSource);
    }

    protected SoundEvent m_7515_() {
        return this.f_19796_.m_188501_() < 0.1f ? (SoundEvent)ModRegistry.DIRE_WOLF_HOWL_SOUND_EVENT.get() : (SoundEvent)ModRegistry.DIRE_WOLF_GROWL_SOUND_EVENT.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModRegistry.DIRE_WOLF_HURT_SOUND_EVENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModRegistry.DIRE_WOLF_DEATH_SOUND_EVENT.get();
    }

    public boolean m_21824_() {
        return false;
    }

    public void m_7105_(boolean tamed) {
    }

    public boolean m_21660_() {
        return true;
    }

    public boolean m_30429_() {
        return false;
    }

    public boolean m_21825_() {
        return false;
    }

    public int m_146764_() {
        return 0;
    }

    public void m_146762_(int age) {
    }

    public void m_30444_(boolean isInterested) {
    }

    public Wolf m_142606_(ServerLevel level, AgeableMob otherParent) {
        return null;
    }

    static class SearchForItemsGoal
    extends Goal {
        private final Mob mob;

        public SearchForItemsGoal(Mob mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!this.mob.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
                return false;
            }
            if (this.mob.m_5448_() == null && this.mob.m_21188_() == null) {
                if (this.mob.m_217043_().m_188503_(SearchForItemsGoal.m_186073_((int)10)) != 0) {
                    return false;
                }
                List list = this.mob.f_19853_.m_6443_(ItemEntity.class, this.mob.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
                return !list.isEmpty() && this.mob.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
            }
            return false;
        }

        public void m_8037_() {
            List list = this.mob.f_19853_.m_6443_(ItemEntity.class, this.mob.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            ItemStack itemStack = this.mob.m_6844_(EquipmentSlot.MAINHAND);
            if (itemStack.m_41619_() && !list.isEmpty()) {
                this.mob.m_21573_().m_5624_((Entity)list.get(0), 1.2);
            }
        }

        public void m_8056_() {
            List list = this.mob.f_19853_.m_6443_(ItemEntity.class, this.mob.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            if (!list.isEmpty()) {
                this.mob.m_21573_().m_5624_((Entity)list.get(0), 1.2);
            }
        }
    }

    public static class PackSpawnGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final PackMob leader;

        public PackSpawnGroupData(PackMob leader) {
            super(false);
            this.leader = leader;
        }
    }
}

