/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology;

import fuzs.enderzoology.EnderZoology;
import fuzs.enderzoology.capability.SoulboundCapability;
import fuzs.enderzoology.data.ModBlockLootProvider;
import fuzs.enderzoology.data.ModBlockTagsProvider;
import fuzs.enderzoology.data.ModEntityTypeLootProvider;
import fuzs.enderzoology.data.ModEntityTypeTagsProvider;
import fuzs.enderzoology.data.ModItemTagsProvider;
import fuzs.enderzoology.data.ModLanguageProvider;
import fuzs.enderzoology.data.ModModelProvider;
import fuzs.enderzoology.data.ModRecipeProvider;
import fuzs.enderzoology.data.ModSoundDefinitionsProvider;
import fuzs.enderzoology.init.ModRegistry;
import fuzs.enderzoology.init.ModRegistryForge;
import fuzs.puzzleslib.api.capability.v2.ForgeCapabilityHelper;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

@Mod(value="enderzoology")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EnderZoologyForge {
    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent evt) {
        ModConstructor.construct((String)"enderzoology", EnderZoology::new, (ContentRegistrationFlags[])new ContentRegistrationFlags[]{ContentRegistrationFlags.BIOME_MODIFICATIONS});
        ModRegistryForge.touch();
        EnderZoologyForge.registerCapabilities();
    }

    private static void registerCapabilities() {
        ForgeCapabilityHelper.setCapabilityToken(ModRegistry.SOULBOUND_CAPABILITY, (CapabilityToken)new CapabilityToken<SoulboundCapability>(){});
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent evt) {
        DataGenerator dataGenerator = evt.getGenerator();
        PackOutput packOutput = dataGenerator.getPackOutput();
        CompletableFuture lookupProvider = evt.getLookupProvider();
        ExistingFileHelper fileHelper = evt.getExistingFileHelper();
        dataGenerator.addProvider(true, (DataProvider)new ModBlockLootProvider(packOutput, "enderzoology"));
        dataGenerator.addProvider(true, (DataProvider)new ModBlockTagsProvider(packOutput, lookupProvider, "enderzoology", fileHelper));
        dataGenerator.addProvider(true, (DataProvider)new ModEntityTypeLootProvider(packOutput, "enderzoology"));
        dataGenerator.addProvider(true, (DataProvider)new ModEntityTypeTagsProvider(packOutput, lookupProvider, "enderzoology", fileHelper));
        dataGenerator.addProvider(true, (DataProvider)new ModItemTagsProvider(packOutput, lookupProvider, "enderzoology", fileHelper));
        dataGenerator.addProvider(true, (DataProvider)new ModLanguageProvider(packOutput, "enderzoology"));
        dataGenerator.addProvider(true, (DataProvider)new ModModelProvider(packOutput, "enderzoology", fileHelper));
        dataGenerator.addProvider(true, (DataProvider)new ModRecipeProvider(packOutput));
        dataGenerator.addProvider(true, (DataProvider)new ModSoundDefinitionsProvider(packOutput, "enderzoology", fileHelper));
    }
}

