/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.capability;

import com.google.common.collect.Lists;
import fuzs.enderzoology.capability.SoulboundCapability;
import fuzs.enderzoology.init.ModRegistry;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;

public class SoulboundCapabilityImpl
implements SoulboundCapability {
    private static final String TAG_ITEMS = "Items";
    private final List<ItemStack> items = Lists.newArrayList();

    @Override
    public void saveOnDeath(Player player) {
        if (player.f_19853_.m_46469_().m_46207_(GameRules.f_46133_)) {
            return;
        }
        Inventory inventory = player.m_150109_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            int enchantmentLevel;
            ItemStack itemstack = inventory.m_8020_(i);
            if (itemstack.m_41619_() || (enchantmentLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModRegistry.SOULBOUND_ENCHANTMENT.get()), (ItemStack)itemstack)) <= 0) continue;
            inventory.m_8016_(i);
            if (!player.m_150110_().f_35937_ && player.m_217043_().m_188503_(enchantmentLevel) == 0) {
                this.decreaseEnchantmentLevel((Enchantment)ModRegistry.SOULBOUND_ENCHANTMENT.get(), itemstack);
            }
            this.items.add(itemstack);
        }
    }

    private void decreaseEnchantmentLevel(Enchantment enchantment, ItemStack stack) {
        ResourceLocation resourcelocation = EnchantmentHelper.m_182432_((Enchantment)enchantment);
        ListTag listtag = stack.m_41785_();
        int enchantmentIndex = -1;
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            ResourceLocation resourcelocation1 = EnchantmentHelper.m_182446_((CompoundTag)compoundtag);
            if (resourcelocation1 == null || !resourcelocation1.equals((Object)resourcelocation)) continue;
            enchantmentIndex = i;
            break;
        }
        if (enchantmentIndex != -1) {
            CompoundTag compoundtag = listtag.m_128728_(enchantmentIndex);
            int level = EnchantmentHelper.m_182438_((CompoundTag)compoundtag);
            if (level > 1) {
                EnchantmentHelper.m_182440_((CompoundTag)compoundtag, (int)(level - 1));
            } else {
                listtag.remove(enchantmentIndex);
            }
        }
    }

    @Override
    public void restoreAfterRespawn(Player player) {
        this.giveItemsToPlayer(this.items, player);
        this.items.clear();
    }

    private void giveItemsToPlayer(List<ItemStack> items, Player player) {
        for (ItemStack itemstack : items) {
            boolean flag = player.m_150109_().m_36054_(itemstack);
            if (flag && itemstack.m_41619_()) {
                itemstack.m_41764_(1);
                ItemEntity itementity1 = player.m_36176_(itemstack, false);
                if (itementity1 != null) {
                    itementity1.m_32065_();
                }
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
                player.f_36096_.m_38946_();
                continue;
            }
            ItemEntity itementity = player.m_36176_(itemstack, false);
            if (itementity == null) continue;
            itementity.m_32061_();
            itementity.m_266426_(player.m_20148_());
        }
    }

    public void write(CompoundTag tag) {
        ListTag listtag = new ListTag();
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            listtag.add((Object)itemstack.m_41739_(new CompoundTag()));
        }
        tag.m_128365_(TAG_ITEMS, (Tag)listtag);
    }

    public void read(CompoundTag tag) {
        if (tag.m_128441_(TAG_ITEMS)) {
            ListTag items = tag.m_128437_(TAG_ITEMS, 10);
            for (int i = 0; i < items.size(); ++i) {
                ItemStack itemstack = ItemStack.m_41712_((CompoundTag)items.m_128728_(i));
                if (itemstack.m_41619_()) continue;
                this.items.add(itemstack);
            }
        }
    }
}

