/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.ai.goal;

import java.util.function.Predicate;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;

public class RangedBowEasyAttackGoal<T extends Monster>
extends RangedBowAttackGoal<T> {
    private final T mob;
    private final double speedModifier;
    private int attackIntervalMin;
    private final int maxAttackTime;
    private final float attackRadiusSqr;
    private int attackTime = -1;
    private int seeTime;

    public RangedBowEasyAttackGoal(T mob, double speedModifier, int attackIntervalMin, int maxAttackTime, float attackRadius) {
        super(mob, speedModifier, attackIntervalMin, attackRadius);
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.attackIntervalMin = attackIntervalMin;
        this.maxAttackTime = maxAttackTime;
        this.attackRadiusSqr = attackRadius * attackRadius;
    }

    public void m_25797_(int attackCooldownIn) {
        this.attackIntervalMin = attackCooldownIn;
    }

    protected boolean m_25803_() {
        return this.mob.m_21093_(stack -> stack.m_41720_() instanceof BowItem);
    }

    public void m_8041_() {
        this.mob.m_21561_(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.mob.m_5810_();
    }

    public void m_8037_() {
        LivingEntity attackTarget = this.mob.m_5448_();
        if (attackTarget != null) {
            double distanceToTarget = this.mob.m_20275_(attackTarget.m_20185_(), attackTarget.m_20186_(), attackTarget.m_20189_());
            boolean canSeeTarget = this.mob.m_21574_().m_148306_((Entity)attackTarget);
            if (canSeeTarget != this.seeTime > 0) {
                this.seeTime = 0;
            }
            this.seeTime = canSeeTarget ? ++this.seeTime : --this.seeTime;
            boolean moveTowardsTarget = false;
            if (distanceToTarget <= (double)this.attackRadiusSqr && this.seeTime >= 20) {
                this.mob.m_21573_().m_26573_();
                moveTowardsTarget = distanceToTarget > (double)(this.attackRadiusSqr * 0.75f);
            } else {
                this.mob.m_21573_().m_5624_((Entity)attackTarget, this.speedModifier);
            }
            if (moveTowardsTarget) {
                this.mob.m_21566_().m_24988_(0.5f, 0.0f);
                this.mob.m_21391_((Entity)attackTarget, 30.0f, 30.0f);
            } else {
                this.mob.m_21563_().m_24960_((Entity)attackTarget, 30.0f, 30.0f);
            }
            if (this.mob.m_6117_()) {
                int useCount;
                if (!canSeeTarget && this.seeTime < -this.maxAttackTime) {
                    this.mob.m_5810_();
                } else if (canSeeTarget && (useCount = this.mob.m_21252_()) >= 20) {
                    this.mob.m_5810_();
                    double distanceVelocity = Math.sqrt(distanceToTarget) / Math.sqrt(this.attackRadiusSqr);
                    ((RangedAttackMob)this.mob).m_6504_(attackTarget, Mth.m_14036_((float)((float)distanceVelocity), (float)0.1f, (float)1.0f) * BowItem.m_40661_((int)useCount));
                    this.attackTime = Mth.m_14107_((double)(distanceVelocity * (double)((float)this.maxAttackTime - (float)this.attackIntervalMin / 2.0f) + (double)((float)this.attackIntervalMin / 2.0f)));
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -this.maxAttackTime) {
                this.mob.m_6672_(RangedBowEasyAttackGoal.getWeaponHoldingHand(this.mob, stack -> stack.m_41720_() instanceof BowItem));
            }
        }
    }

    public static InteractionHand getWeaponHoldingHand(LivingEntity entity, Predicate<ItemStack> filter) {
        return filter.test(entity.m_21205_()) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }
}

