/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.monster;

import fuzs.enderzoology.init.ModRegistry;
import fuzs.enderzoology.mixin.accessor.WitchAccessor;
import fuzs.enderzoology.world.entity.monster.CompanionMob;
import fuzs.enderzoology.world.entity.monster.WitherCat;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.goal.target.NearestHealableRaiderTargetGoal;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WitherWitch
extends Witch
implements CompanionMob<WitherCat> {
    private NearestHealableRaiderTargetGoal<WitherCat> healCatsGoal;
    private int ticksUntilNextAlert;

    public WitherWitch(EntityType<? extends WitherWitch> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.healCatsGoal = new NearestHealableRaiderTargetGoal<WitherCat>((Raider)this, WitherCat.class, true, mob -> mob.m_21223_() < mob.m_21233_()){

            public boolean m_8036_() {
                if (this.m_26093_() <= 0 && this.f_26135_.m_217043_().m_188499_()) {
                    this.m_26073_();
                    if (this.f_26050_ != null) {
                        if (this.f_26050_.f_19853_.m_45924_(this.f_26050_.m_20185_(), this.f_26050_.m_20186_(), this.f_26050_.m_20189_(), 12.0, true) != null) {
                            this.f_26050_ = null;
                            return false;
                        }
                        return true;
                    }
                }
                return false;
            }
        };
        this.f_21346_.m_25352_(2, this.healCatsGoal);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            this.healCatsGoal.m_26094_();
            ((WitchAccessor)((Object)this)).enderzoology$getAttackPlayersGoal().m_26083_(((WitchAccessor)((Object)this)).enderzoology$getHealRaidersGoal().m_26093_() <= 0 || this.healCatsGoal.m_26093_() <= 0);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        if (level instanceof ServerLevel && reason == MobSpawnType.NATURAL) {
            this.trySpawnCompanion((ServerLevel)level, this.m_20183_(), 4);
            if (this.f_19796_.m_188503_(4) == 0) {
                this.trySpawnCompanion((ServerLevel)level, this.m_20183_(), 4);
            }
        }
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    private void trySpawnCompanion(ServerLevel serverLevel, BlockPos pos, int maxDistance) {
        BlockPos blockPos = this.findSpawnPositionNear(serverLevel, pos, maxDistance);
        if (blockPos != null) {
            ((EntityType)ModRegistry.WITHER_CAT_ENTITY_TYPE.get()).m_262496_(serverLevel, blockPos, MobSpawnType.EVENT);
        }
    }

    @Override
    public Mob getCompanionMob() {
        return this;
    }

    @Override
    public int getTicksUntilNextAlert() {
        return this.ticksUntilNextAlert;
    }

    @Override
    public void setTicksUntilNextAlert(int ticksUntilNextAlert) {
        this.ticksUntilNextAlert = ticksUntilNextAlert;
    }

    @Override
    public Class<WitherCat> getCompanionType() {
        return WitherCat.class;
    }

    @Nullable
    private BlockPos findSpawnPositionNear(ServerLevel level, BlockPos pos, int maxDistance) {
        BlockPos blockPos = null;
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = pos.m_123341_() + this.f_19796_.m_188503_(maxDistance * 2) - maxDistance;
            BlockPos blockPos2 = new BlockPos(j, l = level.m_6924_(Heightmap.Types.WORLD_SURFACE, j, k = pos.m_123343_() + this.f_19796_.m_188503_(maxDistance * 2) - maxDistance), k);
            if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)level, (BlockPos)blockPos2, (EntityType)((EntityType)ModRegistry.WITHER_WITCH_ENTITY_TYPE.get()))) continue;
            blockPos = blockPos2;
            break;
        }
        return blockPos;
    }

    public void m_6504_(LivingEntity target, float velocity) {
        if (!this.m_34161_()) {
            Potion potion;
            Vec3 vec3 = target.m_20184_();
            double d = target.m_20185_() + vec3.f_82479_ - this.m_20185_();
            double e = target.m_20188_() - 1.1 - this.m_20186_();
            double f = target.m_20189_() + vec3.f_82481_ - this.m_20189_();
            double g = Math.sqrt(d * d + f * f);
            Potion potion2 = potion = target.m_21222_() ? Potions.f_43623_ : Potions.f_43582_;
            if (target instanceof Raider || target instanceof WitherCat) {
                potion = this.f_19796_.m_188503_(4) != 0 || target.m_21223_() <= 4.0f ? Potions.f_43623_ : Potions.f_43587_;
                this.m_6710_(null);
            } else if (target.m_21223_() >= 8.0f && !target.m_21023_(MobEffects.f_19615_)) {
                potion = (Potion)ModRegistry.DECAY_POTION.get();
            } else if (g <= 3.0 && !target.m_21023_(MobEffects.f_19620_) && this.f_19796_.m_188501_() < 0.05f) {
                potion = (Potion)ModRegistry.RISING_POTION.get();
            }
            ThrownPotion thrownPotion = new ThrownPotion(this.f_19853_, (LivingEntity)this);
            thrownPotion.m_37446_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)potion));
            thrownPotion.m_146926_(thrownPotion.m_146909_() - -20.0f);
            thrownPotion.m_6686_(d, e + g * 0.2, f, 0.75f, 8.0f);
            if (!this.m_20067_()) {
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12553_, this.m_5720_(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
            this.f_19853_.m_7967_((Entity)thrownPotion);
        }
    }

    public boolean m_6673_(DamageSource source) {
        return super.m_6673_(source) || source.m_7639_() instanceof Witch;
    }

    public boolean m_147207_(MobEffectInstance effectInstance, @Nullable Entity entity) {
        if (!effectInstance.m_19544_().m_19486_() && entity instanceof Witch) {
            return false;
        }
        return super.m_147207_(effectInstance, entity);
    }

    public boolean m_7301_(@NotNull MobEffectInstance potion) {
        return potion.m_19544_() != MobEffects.f_19615_ && super.m_7301_(potion);
    }
}

