/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.FlyingAnimal;

public class OwlModel<T extends Entity>
extends AgeableListModel<T> {
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart rightWing;
    private final ModelPart leftWing;

    public OwlModel(ModelPart root) {
        super(true, 24.0f, 0.0f, 3.0f, 2.0f, 24.0f);
        this.body = root.m_171324_("body");
        this.head = root.m_171324_("head");
        this.rightLeg = this.body.m_171324_("right_leg");
        this.leftLeg = this.body.m_171324_("left_leg");
        this.rightWing = this.body.m_171324_("right_wing");
        this.leftWing = this.body.m_171324_("left_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, 0.0f, -3.0f, 6.0f, 7.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)0.0f));
        body.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(23, 0).m_171481_(-1.0f, 0.0f, -3.0f, 1.0f, 5.0f, 5.0f), PartPose.m_171419_((float)-3.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(23, 0).m_171480_().m_171481_(0.0f, 0.0f, -2.5f, 1.0f, 5.0f, 5.0f), PartPose.m_171419_((float)3.0f, (float)0.0f, (float)-0.5f));
        PartDefinition rightLeg = body.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(23, 11).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)-1.5f, (float)7.0f, (float)0.0f));
        rightLeg.m_171599_("right_foot", CubeListBuilder.m_171558_().m_171514_(28, 11).m_171481_(-1.0f, 0.0f, -2.0f, 2.0f, 1.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition leftLeg = body.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(23, 11).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)1.5f, (float)7.0f, (float)0.0f));
        leftLeg.m_171599_("left_foot", CubeListBuilder.m_171558_().m_171514_(28, 11).m_171481_(-1.0f, 0.0f, -2.0f, 2.0f, 1.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition tailBase = body.m_171599_("tail_base", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171481_(-1.5f, 1.0f, -1.8f, 3.0f, 3.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)3.5f, (float)2.2f, (float)0.64f, (float)0.0f, (float)0.0f));
        tailBase.m_171599_("tail_part1", CubeListBuilder.m_171558_().m_171514_(58, 5).m_171481_(0.0f, 2.0f, -1.7f, 2.0f, 3.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.96f));
        tailBase.m_171599_("tail_part2", CubeListBuilder.m_171558_().m_171514_(58, 5).m_171480_().m_171481_(-2.0f, 2.0f, -1.7f, 2.0f, 3.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.96f));
        tailBase.m_171599_("tail_part3", CubeListBuilder.m_171558_().m_171514_(58, 5).m_171481_(-1.0f, 2.0f, -1.7f, 2.0f, 3.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171481_(-3.5f, -6.0f, -3.0f, 7.0f, 6.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)15.0f, (float)-0.5f, (float)0.0f, (float)0.05f, (float)0.0f));
        head.m_171599_("beak", CubeListBuilder.m_171558_().m_171514_(36, 29).m_171481_(0.0f, -0.8f, -4.0f, 1.0f, 1.0f, 2.0f), PartPose.m_171423_((float)-0.5f, (float)-2.3f, (float)-0.4f, (float)0.36f, (float)0.0f, (float)0.0f));
        head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(27, 29).m_171481_(-5.0f, -8.0f, -3.0f, 3.0f, 2.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(27, 29).m_171480_().m_171481_(2.0f, -8.0f, -3.0f, 3.0f, 2.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.leftLeg.f_104203_ = -0.0299f;
        this.rightLeg.f_104203_ = -0.0299f;
        if (((FlyingAnimal)entity).m_29443_()) {
            this.leftLeg.f_104203_ += 0.6981317f;
            this.rightLeg.f_104203_ += 0.6981317f;
        }
        this.rightWing.f_104205_ = ageInTicks;
        this.leftWing.f_104205_ = -ageInTicks;
    }
}

