/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.level;

import com.google.common.collect.Lists;
import fuzs.enderzoology.core.CommonAbstractions;
import fuzs.enderzoology.init.ModRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1559;
import net.minecraft.class_1560;
import net.minecraft.class_1606;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2664;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4019;
import net.minecraft.class_5362;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public class EnderExplosion
extends class_1927 {
    private final class_1937 level;
    private final float radius;
    private final class_243 position;
    private final EntityInteraction entityInteraction;
    private final boolean lingeringCloud;

    public EnderExplosion(class_1937 level, @Nullable class_1297 entity, @Nullable class_1282 damageSource, @Nullable class_5362 damageCalculator, double x, double y, double z, float radius, boolean fire, class_1927.class_4179 blockInteraction, EntityInteraction entityInteraction, boolean lingeringCloud) {
        super(level, entity, damageSource, damageCalculator, x, y, z, radius, fire, blockInteraction);
        this.level = level;
        if (radius <= 0.0f) {
            throw new IllegalArgumentException("Explosion radius must be positive!");
        }
        this.radius = radius;
        this.position = new class_243(x, y, z);
        this.entityInteraction = entityInteraction;
        this.lingeringCloud = lingeringCloud;
    }

    public static class_1927 explode(class_1937 level, @Nullable class_1297 exploder, double x, double y, double z, float size, class_1937.class_7867 mode, EntityInteraction entityInteraction, boolean lingeringCloud) {
        return EnderExplosion.explode(level, exploder, null, null, x, y, z, size, false, mode, entityInteraction, lingeringCloud);
    }

    public static class_1927 explode(class_1937 level, @Nullable class_1297 exploder, @Nullable class_1282 damageSource, @Nullable class_5362 context, double x, double y, double z, float size, boolean causesFire, class_1937.class_7867 mode, EntityInteraction entityInteraction, boolean lingeringCloud) {
        class_1927.class_4179 interaction = EnderExplosion.getExplosionInteraction(level, exploder, mode);
        EnderExplosion explosion = new EnderExplosion(level, exploder, damageSource, context, x, y, z, size, causesFire, interaction, entityInteraction, lingeringCloud);
        if (CommonAbstractions.INSTANCE.onExplosionStart(level, explosion)) {
            return explosion;
        }
        explosion.method_8348();
        explosion.method_8350(level.field_9236);
        if (!level.field_9236) {
            if (!explosion.method_46667()) {
                explosion.method_8352();
            }
            for (class_3222 serverPlayer : ((class_3218)level).method_18456()) {
                if (!(serverPlayer.method_5649(x, y, z) < 4096.0)) continue;
                serverPlayer.field_13987.method_14364((class_2596)new class_2664(x, y, z, size, explosion.method_8346(), null));
            }
        }
        return explosion;
    }

    public static class_1927.class_4179 getExplosionInteraction(class_1937 level, @Nullable class_1297 entity, class_1937.class_7867 interaction) {
        return switch (interaction) {
            default -> throw new IncompatibleClassChangeError();
            case class_1937.class_7867.field_40888 -> class_1927.class_4179.field_40878;
            case class_1937.class_7867.field_40889 -> EnderExplosion.getDestroyType(level, (class_1928.class_4313<class_1928.class_4310>)class_1928.field_40880);
            case class_1937.class_7867.field_40890 -> {
                if (CommonAbstractions.INSTANCE.getMobGriefingEvent(level, entity)) {
                    yield EnderExplosion.getDestroyType(level, (class_1928.class_4313<class_1928.class_4310>)class_1928.field_40881);
                }
                yield class_1927.class_4179.field_40878;
            }
            case class_1937.class_7867.field_40891 -> EnderExplosion.getDestroyType(level, (class_1928.class_4313<class_1928.class_4310>)class_1928.field_40882);
        };
    }

    private static class_1927.class_4179 getDestroyType(class_1937 level, class_1928.class_4313<class_1928.class_4310> gameRule) {
        return level.method_8450().method_8355(gameRule) ? class_1927.class_4179.field_40879 : class_1927.class_4179.field_18687;
    }

    public static void onExplosionDetonate(class_1937 level, class_1927 explosion, List<class_2338> affectedBlocks, List<class_1297> affectedEntities) {
        if (!(explosion instanceof EnderExplosion)) {
            return;
        }
        EnderExplosion enderExplosion = (EnderExplosion)explosion;
        if (!level.field_9236) {
            for (class_1297 entity2 : affectedEntities) {
                if (!(entity2 instanceof class_1309)) continue;
                class_1309 livingEntity = (class_1309)entity2;
                if (!entity2.method_5805() || entity2.method_5864().method_20210(ModRegistry.CONCUSSION_IMMUNE_ENTITY_TYPE_TAG)) continue;
                class_243 originalPosition = livingEntity.method_19538();
                if (enderExplosion.entityInteraction.teleport) {
                    EnderExplosion.teleportEntity((class_3218)level, livingEntity, 48, true);
                }
                if (!enderExplosion.entityInteraction.confusion) continue;
                EnderExplosion.applyConfusionPotion(enderExplosion.position, originalPosition, livingEntity, enderExplosion.radius);
            }
        }
        affectedEntities.removeIf(entity -> !(entity instanceof class_1541));
    }

    public static void teleportEntity(class_3218 level, class_1309 entity, int teleportRange, boolean endermiteChance) {
        EnderExplosion.teleportEntity(level, entity, teleportRange, endermiteChance, false);
    }

    public static void teleportEntity(class_3218 level, class_1309 entity, int teleportRange, boolean endermiteChance, boolean forceTeleport) {
        if (!forceTeleport && entity.method_5864().method_20210(ModRegistry.CONCUSSION_IMMUNE_ENTITY_TYPE_TAG)) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            double randomX = entity.method_23317() + (entity.method_6051().method_43058() - 0.5) * (double)teleportRange * 2.0;
            double randomY = class_3532.method_15350((double)(entity.method_23318() + (double)(entity.method_6051().method_43048(teleportRange * 2) - teleportRange)), (double)level.method_31607(), (double)(level.method_31607() + level.method_32819() - 1));
            double randomZ = entity.method_23321() + (entity.method_6051().method_43058() - 0.5) * (double)teleportRange * 2.0;
            if (entity.method_5765()) {
                entity.method_5848();
            }
            class_243 vec3 = entity.method_19538();
            if (!entity.method_6082(randomX, randomY, randomZ, true)) continue;
            level.method_32888(class_5712.field_39446, vec3, class_5712.class_7397.method_43285((class_1297)entity));
            class_3414 soundEvent = EnderExplosion.getEntityTeleportSound((class_1297)entity);
            level.method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), soundEvent, entity.method_5634(), 1.0f, 1.0f);
            entity.method_5783(soundEvent, 1.0f, 1.0f);
            if (endermiteChance && level.field_9229.method_43057() < 0.05f && level.method_8450().method_8355(class_1928.field_19390)) {
                class_1559 endermite = (class_1559)class_1299.field_6128.method_5883((class_1937)level);
                endermite.method_5808(vec3.field_1352, vec3.field_1351, vec3.field_1350, entity.method_36454(), entity.method_36455());
                level.method_8649((class_1297)endermite);
            }
            return;
        }
    }

    private static class_3414 getEntityTeleportSound(class_1297 entity) {
        if (entity instanceof class_4019) {
            return class_3417.field_24630;
        }
        if (entity instanceof class_1606) {
            return class_3417.field_14915;
        }
        if (entity instanceof class_1560) {
            return class_3417.field_14879;
        }
        return class_3417.field_14890;
    }

    public static void applyConfusionPotion(class_243 sourcePosition, class_243 entityPosition, class_1309 entity, float explosionRadius) {
        double distance;
        if (entity.method_6086() && (distance = sourcePosition.method_1025(entityPosition)) < (double)(explosionRadius * explosionRadius)) {
            double multiplier = 1.0 - Math.sqrt(distance) / (double)explosionRadius;
            int duration = 100 + (int)(multiplier * 200.0);
            entity.method_6092(new class_1293(class_1294.field_5916, duration, 0));
        }
    }

    public void method_8350(boolean spawnParticles) {
        this.method_8346().removeIf(pos -> this.level.method_8320(pos).method_26204().method_9533((class_1927)this));
        super.method_8350(spawnParticles);
        if (this.lingeringCloud) {
            this.spawnLingeringCloud(this.entityInteraction.createEffects((int)this.radius));
        }
    }

    private void spawnLingeringCloud(List<class_1293> effects) {
        class_1295 areaEffectCloud = new class_1295(this.level, this.position.field_1352, this.position.field_1351, this.position.field_1350);
        areaEffectCloud.method_5603(2.5f);
        areaEffectCloud.method_5609(-0.5f);
        areaEffectCloud.method_5595(10);
        areaEffectCloud.method_5604(areaEffectCloud.method_5605() / 2);
        areaEffectCloud.method_5596(-areaEffectCloud.method_5599() / (float)areaEffectCloud.method_5605());
        effects.forEach(arg_0 -> ((class_1295)areaEffectCloud).method_5610(arg_0));
        this.level.method_8649((class_1297)areaEffectCloud);
    }

    public static enum EntityInteraction {
        ENDER(true, false),
        CONFUSION(false, true),
        CONCUSSION(true, true);

        public final boolean teleport;
        public final boolean confusion;

        private EntityInteraction(boolean teleport, boolean confusion) {
            this.teleport = teleport;
            this.confusion = confusion;
        }

        public List<class_1293> createEffects(int strength) {
            ArrayList effects = Lists.newArrayList();
            if (this.teleport) {
                effects.add(new class_1293((class_1291)ModRegistry.DISPLACEMENT_MOB_EFFECT.get(), 1, strength));
            }
            if (this.confusion) {
                effects.add(new class_1293(class_1294.field_5916, 100));
            }
            return effects;
        }
    }
}

