/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.monster;

import fuzs.enderzoology.world.entity.monster.ConcussionCreeper;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Enderminy
extends Monster
implements NeutralMob {
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("51560D00-9B48-11ED-A8FC-0242AC120002");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Attacking speed boost", (double)0.15f, AttributeModifier.Operation.ADDITION);
    private static final int MIN_DEAGGRESSION_TIME = 600;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private static final UniformInt FIRST_ANGER_SOUND_DELAY = TimeUtil.m_145020_((int)0, (int)1);
    private static final UniformInt ALERT_INTERVAL = TimeUtil.m_145020_((int)4, (int)6);
    private int targetChangeTime;
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;
    private int playFirstAngerSoundIn;
    private int ticksUntilNextAlert;

    public Enderminy(EntityType<? extends Enderminy> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, false, false, arg_0 -> ((Enderminy)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, ConcussionCreeper.class, true, false));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected void m_8024_() {
        float f;
        if (this.m_21660_()) {
            this.maybePlayFirstAngerSound();
        }
        this.m_21666_((ServerLevel)this.m_9236_(), true);
        if (this.m_5448_() != null) {
            this.maybeAlertOthers();
        }
        if (this.m_9236_().m_46461_() && this.f_19797_ >= this.targetChangeTime + 600 && (f = this.m_213856_()) > 0.5f && this.m_9236_().m_45527_(this.m_20183_()) && this.f_19796_.m_188501_() * 30.0f < (f - 0.4f) * 2.0f) {
            this.m_6710_(null);
            this.teleport();
        }
        super.m_8024_();
    }

    private void maybePlayFirstAngerSound() {
        if (this.playFirstAngerSoundIn > 0) {
            --this.playFirstAngerSoundIn;
            if (this.playFirstAngerSoundIn == 0) {
                this.playAngerSound();
            }
        }
    }

    private void maybeAlertOthers() {
        if (this.ticksUntilNextAlert > 0) {
            --this.ticksUntilNextAlert;
        } else {
            if (this.m_21574_().m_148306_((Entity)this.m_5448_())) {
                this.alertOthers();
            }
            this.ticksUntilNextAlert = ALERT_INTERVAL.m_214085_(this.f_19796_);
        }
    }

    private void alertOthers() {
        double followRange = this.m_21133_(Attributes.f_22277_);
        AABB aABB = AABB.m_82333_((Vec3)this.m_20182_()).m_82377_(followRange, 10.0, followRange);
        List list = this.m_9236_().m_6443_(Enderminy.class, aABB, EntitySelector.f_20402_);
        for (Enderminy enderminy : list) {
            if (enderminy == this || enderminy.m_5448_() != null || enderminy.m_7307_((Entity)this.m_5448_())) continue;
            enderminy.m_6710_(this.m_5448_());
        }
    }

    private void playAngerSound() {
        this.m_5496_(SoundEvents.f_11850_, this.m_6121_() * 2.0f, this.m_6100_() * 1.8f);
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.5f;
    }

    public void m_6710_(@Nullable LivingEntity target) {
        AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22279_);
        if (target == null) {
            this.targetChangeTime = 0;
            attributeInstance.m_22130_(SPEED_MODIFIER_ATTACKING);
        } else {
            this.targetChangeTime = this.f_19797_;
            if (!attributeInstance.m_22109_(SPEED_MODIFIER_ATTACKING)) {
                attributeInstance.m_22118_(SPEED_MODIFIER_ATTACKING);
            }
            if (this.m_5448_() == null) {
                this.playFirstAngerSoundIn = FIRST_ANGER_SOUND_DELAY.m_214085_(this.f_19796_);
                this.ticksUntilNextAlert = ALERT_INTERVAL.m_214085_(this.f_19796_);
            }
        }
        super.m_6710_(target);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int remainingPersistentAngerTime) {
        this.remainingPersistentAngerTime = remainingPersistentAngerTime;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID persistentAngerTarget) {
        this.persistentAngerTarget = persistentAngerTarget;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.m_21678_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_147285_(this.m_9236_(), compound);
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 0.6375f;
    }

    public void m_8107_() {
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
        }
        this.f_20899_ = false;
        super.m_8107_();
    }

    public boolean m_6126_() {
        return true;
    }

    protected boolean teleport() {
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            double d = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            double e = this.m_20186_() + (double)(this.f_19796_.m_188503_(64) - 32);
            double f = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            return this.teleport(d, e, f);
        }
        return false;
    }

    private boolean teleport(double x, double y, double z) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, y, z);
        while (mutableBlockPos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)mutableBlockPos).m_280555_()) {
            mutableBlockPos.m_122173_(Direction.DOWN);
        }
        BlockState blockState = this.m_9236_().m_8055_((BlockPos)mutableBlockPos);
        boolean bl = blockState.m_280555_();
        boolean bl2 = blockState.m_60819_().m_205070_(FluidTags.f_13131_);
        if (bl && !bl2) {
            Vec3 vec3 = this.m_20182_();
            boolean bl3 = this.m_20984_(x, y, z, true);
            if (bl3) {
                this.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                    this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                }
            }
            return bl3;
        }
        return false;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11899_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11849_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11900_;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268524_)) {
            Entity entity = source.m_7640_();
            boolean bl = entity instanceof ThrownPotion ? this.hurtWithCleanWater(source, (ThrownPotion)entity, amount) : false;
            for (int i = 0; i < 64; ++i) {
                if (!this.teleport()) continue;
                return true;
            }
            return bl;
        }
        boolean bl2 = super.m_6469_(source, amount);
        if (!this.m_9236_().m_5776_() && !(source.m_7639_() instanceof LivingEntity) && this.f_19796_.m_188503_(10) != 0) {
            this.teleport();
        }
        return bl2;
    }

    private boolean hurtWithCleanWater(DamageSource source, ThrownPotion potion, float amount) {
        ItemStack itemStack = potion.m_7846_();
        Potion potion2 = PotionUtils.m_43579_((ItemStack)itemStack);
        List list = PotionUtils.m_43547_((ItemStack)itemStack);
        boolean bl = potion2 == Potions.f_43599_ && list.isEmpty();
        return bl && super.m_6469_(source, amount);
    }

    public boolean m_6935_(Player player) {
        return this.m_21674_((LivingEntity)player);
    }
}

