/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.monster;

import fuzs.enderzoology.init.ModRegistry;
import fuzs.enderzoology.world.entity.ai.goal.RangedBowEasyAttackGoal;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class FallenKnight
extends AbstractSkeleton {
    private static final Predicate<Difficulty> DOOR_BREAKING_PREDICATE = difficulty -> difficulty == Difficulty.HARD;
    private static final float BREAK_DOOR_CHANCE = 0.1f;
    private final BreakDoorGoal breakDoorGoal = new BreakDoorGoal((Mob)this, DOOR_BREAKING_PREDICATE);
    private RangedBowAttackGoal<AbstractSkeleton> bowGoal;
    private MeleeAttackGoal meleeGoal;
    private boolean canBreakDoors;

    public FallenKnight(EntityType<? extends AbstractSkeleton> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_148105_().stream().map(WrappedGoal::m_26015_).filter(goal -> goal instanceof AvoidEntityGoal).limit(1L).toList().forEach(arg_0 -> ((GoalSelector)this.f_21345_).m_25363_(arg_0));
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        this.populateArmorEquipmentSlots(random);
        Item item = random.m_188499_() ? (Item)ModRegistry.HUNTING_BOW.get() : (random.m_188501_() < (this.m_9236_().m_46791_() == Difficulty.HARD ? 0.6f : 0.2f) ? Items.f_42383_ : Items.f_42425_);
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)item));
    }

    private void populateArmorEquipmentSlots(RandomSource random) {
        float selector = random.m_188501_();
        int quality = selector < 0.1f ? 3 : (selector < 0.35f ? 0 : 2);
        List<EquipmentSlot> slots = Stream.of(EquipmentSlot.values()).filter(slot -> slot.m_20743_() == EquipmentSlot.Type.ARMOR).sorted(Comparator.reverseOrder()).toList();
        for (EquipmentSlot slot2 : slots) {
            Item item;
            ItemStack itemStack = this.m_6844_(slot2);
            if (slot2 != EquipmentSlot.HEAD && random.m_188501_() < (this.m_9236_().m_46791_() == Difficulty.HARD ? 0.1f : 0.25f)) break;
            if (!itemStack.m_41619_() || (item = FallenKnight.m_21412_((EquipmentSlot)slot2, (int)quality)) == null) continue;
            this.m_8061_(slot2, new ItemStack((ItemLike)item));
        }
    }

    protected void m_214095_(RandomSource random, float chanceMultiplier) {
        ItemStack itemstack;
        super.m_214095_(random, chanceMultiplier);
        if (random.m_188503_(10) == 0 && (itemstack = this.m_21205_()).m_150930_((Item)ModRegistry.HUNTING_BOW.get())) {
            Map map = EnchantmentHelper.m_44831_((ItemStack)itemstack);
            map.putIfAbsent(Enchantments.f_44961_, 1);
            EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemstack);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack);
        }
    }

    public boolean m_5886_(ProjectileWeaponItem projectileWeapon) {
        return projectileWeapon instanceof BowItem;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        spawnData = super.m_6518_(level, difficulty, reason, spawnData, dataTag);
        if (level.m_213780_().m_188499_()) {
            Mob fallenMount = (Mob)((EntityType)ModRegistry.FALLEN_MOUNT_ENTITY_TYPE.get()).m_20615_(this.m_9236_());
            fallenMount.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
            fallenMount.m_6518_(level, difficulty, MobSpawnType.JOCKEY, null, null);
            this.m_20329_((Entity)fallenMount);
            level.m_7967_((Entity)fallenMount);
        }
        this.setCanBreakDoors(level.m_213780_().m_188501_() < difficulty.m_19057_() * 0.1f);
        return spawnData;
    }

    public boolean canBreakDoors() {
        return this.canBreakDoors;
    }

    public void setCanBreakDoors(boolean canBreakDoors) {
        if (GoalUtils.m_26894_((Mob)this)) {
            if (this.canBreakDoors != canBreakDoors) {
                this.canBreakDoors = canBreakDoors;
                ((GroundPathNavigation)this.m_21573_()).m_26477_(canBreakDoors);
                if (canBreakDoors) {
                    this.f_21345_.m_25352_(1, (Goal)this.breakDoorGoal);
                } else {
                    this.f_21345_.m_25363_((Goal)this.breakDoorGoal);
                }
            }
        } else if (this.canBreakDoors) {
            this.f_21345_.m_25363_((Goal)this.breakDoorGoal);
            this.canBreakDoors = false;
        }
    }

    public void m_32164_() {
        if (this.m_9236_() != null && !this.m_9236_().f_46443_) {
            this.f_21345_.m_25363_((Goal)this.meleeGoal());
            this.f_21345_.m_25363_(this.bowGoal());
            ItemStack itemStack = this.m_21120_(RangedBowEasyAttackGoal.getWeaponHoldingHand((LivingEntity)this, stack -> stack.m_41720_() instanceof BowItem));
            if (itemStack.m_41720_() instanceof BowItem) {
                int i = 20;
                if (this.m_9236_().m_46791_() != Difficulty.HARD) {
                    i = 40;
                }
                this.bowGoal().m_25797_(i);
                this.f_21345_.m_25352_(4, this.bowGoal());
            } else {
                this.f_21345_.m_25352_(4, (Goal)this.meleeGoal());
            }
        }
    }

    public ItemStack m_6298_(ItemStack weaponStack) {
        InteractionHand interactionHand = RangedBowEasyAttackGoal.getWeaponHoldingHand((LivingEntity)this, stack -> stack.m_41720_() instanceof BowItem);
        return super.m_6298_(this.m_21120_(interactionHand));
    }

    private RangedBowAttackGoal<AbstractSkeleton> bowGoal() {
        if (this.bowGoal == null) {
            this.bowGoal = new RangedBowEasyAttackGoal<FallenKnight>(this, 1.0, 40, 60, 15.0f);
        }
        return this.bowGoal;
    }

    private MeleeAttackGoal meleeGoal() {
        if (this.meleeGoal == null) {
            this.meleeGoal = new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

                public void m_8041_() {
                    super.m_8041_();
                    FallenKnight.this.m_21561_(false);
                }

                public void m_8056_() {
                    super.m_8056_();
                    FallenKnight.this.m_21561_(true);
                }
            };
        }
        return this.meleeGoal;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    protected SoundEvent m_7878_() {
        return SoundEvents.f_12383_;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("CanBreakDoors", this.canBreakDoors());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setCanBreakDoors(compound.m_128471_("CanBreakDoors"));
    }
}

