/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.monster;

import fuzs.enderzoology.core.CommonAbstractions;
import fuzs.enderzoology.init.ModRegistry;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FallenMount
extends AbstractHorse
implements Enemy {
    public static final String TAG_HORSE_DATA = "HorseData";
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("870A1AC8-9BD8-11ED-A8FC-0242AC120002");
    private static final EntityDataAccessor<Boolean> DATA_CONVERTING_ID = SynchedEntityData.m_135353_(FallenMount.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Nullable
    private CompoundTag horseData;
    private int conversionTime;

    public FallenMount(EntityType<? extends AbstractHorse> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 5;
    }

    protected static String getEncodeId(Entity entity) {
        EntityType entityType = entity.m_6095_();
        ResourceLocation resourceLocation = EntityType.m_20613_((EntityType)entityType);
        return entityType.m_20584_() && resourceLocation != null ? resourceLocation.toString() : null;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new MountRestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new MountFleeSunGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2f, false){

            public boolean m_8036_() {
                return !this.f_25540_.m_20160_() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractHorse.class, false, entity -> entity.m_6095_().m_204039_(ModRegistry.FALLEN_MOUNT_TARGETS_ENTITY_TYPE_TAG)));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public int m_213860_() {
        return this.f_21364_;
    }

    protected boolean m_8028_() {
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CONVERTING_ID, (Object)false);
    }

    protected void m_214179_(RandomSource randomSource) {
        this.m_21051_(Attributes.f_22288_).m_22100_(FallenMount.m_272017_(() -> ((RandomSource)randomSource).m_188500_()));
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.isConverting()) {
            --this.conversionTime;
            if (this.conversionTime <= 0) {
                this.finishConversion();
            }
        }
        super.m_8119_();
    }

    public boolean m_7559_() {
        return false;
    }

    public boolean m_6741_() {
        return false;
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        super.m_19956_(passenger, callback);
        if (passenger instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)passenger;
            living.f_20883_ = this.f_20883_;
            living.f_20885_ = this.f_20885_;
            living.m_146922_(this.m_146908_());
            living.m_146926_(this.m_146909_());
        }
    }

    @Nullable
    public LivingEntity m_6688_() {
        return null;
    }

    public boolean m_6094_() {
        return this.m_6084_() && !this.m_5833_() && !this.m_6147_();
    }

    public boolean m_6107_() {
        return this.m_21224_();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_42677_)) {
            if (this.m_21023_(MobEffects.f_19613_)) {
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                if (!this.m_9236_().f_46443_) {
                    this.startConverting(this.f_19796_.m_188503_(2401) + 3600);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, hand);
    }

    protected void m_6835_(Player player) {
    }

    public void m_8107_() {
        if (this.m_6084_() && this.m_21527_() && !this.m_20160_() && !this.m_7481_()) {
            this.m_20254_(8);
        }
        super.m_8107_();
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        float selector = random.m_188501_();
        Item item = selector < 0.015f ? Items.f_42653_ : (selector < 0.05f ? Items.f_42652_ : (selector < 0.2f ? Items.f_42654_ : Items.f_42651_));
        this.setArmor(new ItemStack((ItemLike)item));
    }

    public boolean m_6254_() {
        return true;
    }

    public boolean m_7482_() {
        return true;
    }

    public boolean m_6010_(ItemStack stack) {
        return stack.m_41720_() instanceof HorseArmorItem;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.horseData != null) {
            tag.m_128365_(TAG_HORSE_DATA, (Tag)this.horseData);
        }
        if (!this.f_30520_.m_8020_(1).m_41619_()) {
            tag.m_128365_("ArmorItem", (Tag)this.f_30520_.m_8020_(1).m_41739_(new CompoundTag()));
        }
    }

    public ItemStack getArmor() {
        return this.m_6844_(EquipmentSlot.CHEST);
    }

    private void setArmor(ItemStack pStack) {
        this.m_8061_(EquipmentSlot.CHEST, pStack);
        this.m_21409_(EquipmentSlot.CHEST, 0.0f);
    }

    public void m_7378_(CompoundTag tag) {
        ItemStack itemstack;
        super.m_7378_(tag);
        this.horseData = tag.m_128469_(TAG_HORSE_DATA);
        if (tag.m_128425_("ArmorItem", 10) && !(itemstack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("ArmorItem"))).m_41619_() && this.m_6010_(itemstack)) {
            this.f_30520_.m_6836_(1, itemstack);
        }
        this.m_7493_();
    }

    protected void m_7493_() {
        if (!this.m_9236_().f_46443_) {
            super.m_7493_();
            this.setArmorEquipment(this.f_30520_.m_8020_(1));
            this.m_21409_(EquipmentSlot.CHEST, 0.0f);
        }
    }

    private void setArmorEquipment(ItemStack stack) {
        this.setArmor(stack);
        if (!this.m_9236_().f_46443_) {
            int i;
            this.m_21051_(Attributes.f_22284_).m_22120_(ARMOR_MODIFIER_UUID);
            if (this.m_6010_(stack) && (i = ((HorseArmorItem)stack.m_41720_()).m_41368_()) != 0) {
                this.m_21051_(Attributes.f_22284_).m_22118_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Horse armor bonus", (double)i, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.isConverting() && (this.horseData == null || !this.horseData.m_128471_("Tame"));
    }

    public boolean isConverting() {
        return (Boolean)this.m_20088_().m_135370_(DATA_CONVERTING_ID);
    }

    private void startConverting(int villagerConversionTime) {
        this.conversionTime = villagerConversionTime;
        this.m_20088_().m_135381_(DATA_CONVERTING_ID, (Object)true);
        this.m_21195_(MobEffects.f_19613_);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, villagerConversionTime, Math.min(this.m_9236_().m_46791_().m_19028_() - 1, 0)));
        this.m_9236_().m_7605_((Entity)this, (byte)16);
    }

    public void m_7822_(byte id) {
        if (id == 16) {
            if (!this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20188_(), this.m_20189_(), SoundEvents.f_12644_, this.m_5720_(), 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() * 0.7f + 0.3f, false);
            }
        } else {
            super.m_7822_(id);
        }
    }

    private void finishConversion() {
        this.recreateHorseFromData(this.m_9236_(), this).or(this::createFreshHorse).ifPresent(entity -> {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
            if (!this.m_20067_()) {
                this.m_9236_().m_5898_(null, 1027, this.m_20183_(), 0);
            }
            CommonAbstractions.INSTANCE.onLivingConvert((LivingEntity)this, (LivingEntity)entity);
        });
    }

    private Optional<AbstractHorse> recreateHorseFromData(Level level, FallenMount source) {
        CompoundTag tag = source.horseData;
        if (!level.f_46443_ && tag != null && !tag.m_128456_()) {
            return EntityType.m_20642_((CompoundTag)tag, (Level)level).map(entity -> {
                AbstractHorse horse = (AbstractHorse)entity;
                horse.m_20359_((Entity)source);
                source.m_146870_();
                level.m_7967_((Entity)horse);
                return horse;
            });
        }
        return Optional.empty();
    }

    private Optional<AbstractHorse> createFreshHorse() {
        EntityType entityType = this.f_19796_.m_188503_(6) == 0 ? EntityType.f_20560_ : EntityType.f_20457_;
        AbstractHorse horse = (AbstractHorse)this.m_21406_(entityType, false);
        for (int i = 0; i < EquipmentSlot.values().length; ++i) {
            EquipmentSlot equipmentSlot = EquipmentSlot.values()[i];
            ItemStack itemStack = this.m_6844_(equipmentSlot);
            if (itemStack.m_41619_()) continue;
            if (EnchantmentHelper.m_44920_((ItemStack)itemStack)) {
                horse.m_141942_(equipmentSlot.m_20749_() + 300).m_142104_(itemStack);
                continue;
            }
            double d = this.m_21519_(equipmentSlot);
            if (!(d > 1.0)) continue;
            this.m_19983_(itemStack);
        }
        horse.m_6518_((ServerLevelAccessor)this.m_9236_(), this.m_9236_().m_6436_(horse.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)new AgeableMob.AgeableMobGroupData(0.0f), null);
        horse.m_30651_(true);
        horse.m_6863_(false);
        return Optional.of(horse);
    }

    public boolean m_214076_(ServerLevel level, LivingEntity entity) {
        boolean flag = super.m_214076_(level, entity);
        if ((level.m_46791_() == Difficulty.NORMAL || level.m_46791_() == Difficulty.HARD) && entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            if (CommonAbstractions.INSTANCE.canLivingConvert(entity, (EntityType<? extends LivingEntity>)((EntityType)ModRegistry.FALLEN_MOUNT_ENTITY_TYPE.get()), timer -> {})) {
                if (level.m_46791_() != Difficulty.HARD && this.f_19796_.m_188499_()) {
                    return flag;
                }
                FallenMount fallenMount = (FallenMount)horse.m_21406_((EntityType)ModRegistry.FALLEN_MOUNT_ENTITY_TYPE.get(), true);
                fallenMount.m_6518_((ServerLevelAccessor)level, level.m_6436_(fallenMount.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)new AgeableMob.AgeableMobGroupData(0.0f), null);
                CompoundTag compoundtag = new CompoundTag();
                compoundtag.m_128359_("id", FallenMount.getEncodeId((Entity)horse));
                horse.m_21153_(horse.m_21233_());
                horse.m_20256_(Vec3.f_82478_);
                horse.m_20240_(compoundtag);
                fallenMount.horseData = compoundtag;
                CommonAbstractions.INSTANCE.onLivingConvert(entity, (LivingEntity)fallenMount);
                if (!this.m_20067_()) {
                    level.m_5898_(null, 1026, this.m_20183_(), 0);
                }
                flag = false;
            }
        }
        return flag;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        SpawnGroupData spawnGroupData = super.m_6518_(level, difficulty, reason, spawnData, dataTag);
        this.m_213945_(level.m_213780_(), difficulty);
        return spawnGroupData;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12605_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12606_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12607_;
    }

    protected void m_5625_(float volume) {
        if (this.m_20096_()) {
            super.m_5625_(0.3f);
        } else {
            super.m_5625_(Math.min(0.1f, volume * 25.0f));
        }
    }

    protected float m_6108_() {
        return 0.96f;
    }

    static class MountRestrictSunGoal
    extends RestrictSunGoal {
        private final PathfinderMob mob;

        public MountRestrictSunGoal(PathfinderMob pathfinderMob) {
            super(pathfinderMob);
            this.mob = pathfinderMob;
        }

        public boolean m_8036_() {
            return !this.mob.m_20160_() && super.m_8036_();
        }
    }

    static class MountFleeSunGoal
    extends FleeSunGoal {
        public MountFleeSunGoal(PathfinderMob pathfinderMob, double d) {
            super(pathfinderMob, d);
        }

        public boolean m_8036_() {
            return !this.f_25214_.m_20160_() && super.m_8036_();
        }
    }
}

