/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.level;

import com.google.common.collect.Lists;
import fuzs.enderzoology.core.CommonAbstractions;
import fuzs.enderzoology.init.ModRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EnderExplosion
extends Explosion {
    private final Level level;
    private final float radius;
    private final Vec3 position;
    private final EntityInteraction entityInteraction;
    private final boolean lingeringCloud;

    public EnderExplosion(Level level, @Nullable Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, boolean fire, Explosion.BlockInteraction blockInteraction, EntityInteraction entityInteraction, boolean lingeringCloud) {
        super(level, entity, damageSource, damageCalculator, x, y, z, radius, fire, blockInteraction);
        this.level = level;
        if (radius <= 0.0f) {
            throw new IllegalArgumentException("Explosion radius must be positive!");
        }
        this.radius = radius;
        this.position = new Vec3(x, y, z);
        this.entityInteraction = entityInteraction;
        this.lingeringCloud = lingeringCloud;
    }

    public static Explosion explode(Level level, @Nullable Entity exploder, double x, double y, double z, float size, Level.ExplosionInteraction mode, EntityInteraction entityInteraction, boolean lingeringCloud) {
        return EnderExplosion.explode(level, exploder, null, null, x, y, z, size, false, mode, entityInteraction, lingeringCloud);
    }

    public static Explosion explode(Level level, @Nullable Entity exploder, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator context, double x, double y, double z, float size, boolean causesFire, Level.ExplosionInteraction mode, EntityInteraction entityInteraction, boolean lingeringCloud) {
        Explosion.BlockInteraction interaction = EnderExplosion.getExplosionInteraction(level, exploder, mode);
        EnderExplosion explosion = new EnderExplosion(level, exploder, damageSource, context, x, y, z, size, causesFire, interaction, entityInteraction, lingeringCloud);
        if (CommonAbstractions.INSTANCE.onExplosionStart(level, explosion)) {
            return explosion;
        }
        explosion.m_46061_();
        explosion.m_46075_(level.f_46443_);
        if (!level.f_46443_) {
            if (!explosion.m_254884_()) {
                explosion.m_46080_();
            }
            for (ServerPlayer serverPlayer : ((ServerLevel)level).m_6907_()) {
                if (!(serverPlayer.m_20275_(x, y, z) < 4096.0)) continue;
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(x, y, z, size, explosion.m_46081_(), null));
            }
        }
        return explosion;
    }

    public static Explosion.BlockInteraction getExplosionInteraction(Level level, @Nullable Entity entity, Level.ExplosionInteraction interaction) {
        return switch (interaction) {
            default -> throw new IncompatibleClassChangeError();
            case Level.ExplosionInteraction.NONE -> Explosion.BlockInteraction.KEEP;
            case Level.ExplosionInteraction.BLOCK -> EnderExplosion.getDestroyType(level, (GameRules.Key<GameRules.BooleanValue>)GameRules.f_254629_);
            case Level.ExplosionInteraction.MOB -> {
                if (CommonAbstractions.INSTANCE.getMobGriefingEvent(level, entity)) {
                    yield EnderExplosion.getDestroyType(level, (GameRules.Key<GameRules.BooleanValue>)GameRules.f_254692_);
                }
                yield Explosion.BlockInteraction.KEEP;
            }
            case Level.ExplosionInteraction.TNT -> EnderExplosion.getDestroyType(level, (GameRules.Key<GameRules.BooleanValue>)GameRules.f_254705_);
        };
    }

    private static Explosion.BlockInteraction getDestroyType(Level level, GameRules.Key<GameRules.BooleanValue> gameRule) {
        return level.m_46469_().m_46207_(gameRule) ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.DESTROY;
    }

    public static void onExplosionDetonate(Level level, Explosion explosion, List<BlockPos> affectedBlocks, List<Entity> affectedEntities) {
        if (!(explosion instanceof EnderExplosion)) {
            return;
        }
        EnderExplosion enderExplosion = (EnderExplosion)explosion;
        if (!level.f_46443_) {
            for (Entity entity2 : affectedEntities) {
                if (!(entity2 instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity2;
                if (!entity2.m_6084_() || entity2.m_6095_().m_204039_(ModRegistry.CONCUSSION_IMMUNE_ENTITY_TYPE_TAG)) continue;
                Vec3 originalPosition = livingEntity.m_20182_();
                if (enderExplosion.entityInteraction.teleport) {
                    EnderExplosion.teleportEntity((ServerLevel)level, livingEntity, 48, true);
                }
                if (!enderExplosion.entityInteraction.confusion) continue;
                EnderExplosion.applyConfusionPotion(enderExplosion.position, originalPosition, livingEntity, enderExplosion.radius);
            }
        }
        affectedEntities.removeIf(entity -> !(entity instanceof PrimedTnt));
    }

    public static void teleportEntity(ServerLevel level, LivingEntity entity, int teleportRange, boolean endermiteChance) {
        EnderExplosion.teleportEntity(level, entity, teleportRange, endermiteChance, false);
    }

    public static void teleportEntity(ServerLevel level, LivingEntity entity, int teleportRange, boolean endermiteChance, boolean forceTeleport) {
        if (!forceTeleport && entity.m_6095_().m_204039_(ModRegistry.CONCUSSION_IMMUNE_ENTITY_TYPE_TAG)) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            double randomX = entity.m_20185_() + (entity.m_217043_().m_188500_() - 0.5) * (double)teleportRange * 2.0;
            double randomY = Mth.m_14008_((double)(entity.m_20186_() + (double)(entity.m_217043_().m_188503_(teleportRange * 2) - teleportRange)), (double)level.m_141937_(), (double)(level.m_141937_() + level.m_143344_() - 1));
            double randomZ = entity.m_20189_() + (entity.m_217043_().m_188500_() - 0.5) * (double)teleportRange * 2.0;
            if (entity.m_20159_()) {
                entity.m_8127_();
            }
            Vec3 vec3 = entity.m_20182_();
            if (!entity.m_20984_(randomX, randomY, randomZ, true)) continue;
            level.m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)entity));
            SoundEvent soundEvent = EnderExplosion.getEntityTeleportSound((Entity)entity);
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), soundEvent, entity.m_5720_(), 1.0f, 1.0f);
            entity.m_5496_(soundEvent, 1.0f, 1.0f);
            if (endermiteChance && level.f_46441_.m_188501_() < 0.05f && level.m_46469_().m_46207_(GameRules.f_46134_)) {
                Endermite endermite = (Endermite)EntityType.f_20567_.m_20615_((Level)level);
                endermite.m_7678_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, entity.m_146908_(), entity.m_146909_());
                level.m_7967_((Entity)endermite);
            }
            return;
        }
    }

    private static SoundEvent getEntityTeleportSound(Entity entity) {
        if (entity instanceof Fox) {
            return SoundEvents.f_11953_;
        }
        if (entity instanceof Shulker) {
            return SoundEvents.f_12418_;
        }
        if (entity instanceof EnderMan) {
            return SoundEvents.f_11852_;
        }
        return SoundEvents.f_11757_;
    }

    public static void applyConfusionPotion(Vec3 sourcePosition, Vec3 entityPosition, LivingEntity entity, float explosionRadius) {
        double distance;
        if (entity.m_5801_() && (distance = sourcePosition.m_82557_(entityPosition)) < (double)(explosionRadius * explosionRadius)) {
            double multiplier = 1.0 - Math.sqrt(distance) / (double)explosionRadius;
            int duration = 100 + (int)(multiplier * 200.0);
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, duration, 0));
        }
    }

    public void m_46075_(boolean spawnParticles) {
        this.m_46081_().removeIf(pos -> this.level.m_8055_(pos).m_60734_().m_6903_((Explosion)this));
        super.m_46075_(spawnParticles);
        if (this.lingeringCloud) {
            this.spawnLingeringCloud(this.entityInteraction.createEffects((int)this.radius));
        }
    }

    private void spawnLingeringCloud(List<MobEffectInstance> effects) {
        AreaEffectCloud areaEffectCloud = new AreaEffectCloud(this.level, this.position.f_82479_, this.position.f_82480_, this.position.f_82481_);
        areaEffectCloud.m_19712_(2.5f);
        areaEffectCloud.m_19732_(-0.5f);
        areaEffectCloud.m_19740_(10);
        areaEffectCloud.m_19734_(areaEffectCloud.m_19748_() / 2);
        areaEffectCloud.m_19738_(-areaEffectCloud.m_19743_() / (float)areaEffectCloud.m_19748_());
        effects.forEach(arg_0 -> ((AreaEffectCloud)areaEffectCloud).m_19716_(arg_0));
        this.level.m_7967_((Entity)areaEffectCloud);
    }

    public static enum EntityInteraction {
        ENDER(true, false),
        CONFUSION(false, true),
        CONCUSSION(true, true);

        public final boolean teleport;
        public final boolean confusion;

        private EntityInteraction(boolean teleport, boolean confusion) {
            this.teleport = teleport;
            this.confusion = confusion;
        }

        public List<MobEffectInstance> createEffects(int strength) {
            ArrayList effects = Lists.newArrayList();
            if (this.teleport) {
                effects.add(new MobEffectInstance((MobEffect)ModRegistry.DISPLACEMENT_MOB_EFFECT.get(), 1, strength));
            }
            if (this.confusion) {
                effects.add(new MobEffectInstance(MobEffects.f_19604_, 100));
            }
            return effects;
        }
    }
}

