/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.EdCatwalkBlock;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.detail.Auxiliaries;

public class EdCatwalkStairsBlock
extends DecorBlock.HorizontalWaterLoggable
implements IDecorBlock {
    public static final BooleanProperty RIGHT_RAILING = BooleanProperty.func_177716_a((String)"right_railing");
    public static final BooleanProperty LEFT_RAILING = BooleanProperty.func_177716_a((String)"left_railing");
    protected final Map<BlockState, VoxelShape> shapes;
    protected final Map<BlockState, VoxelShape> collision_shapes;
    protected final Map<Direction, Integer> y_rotations;

    public EdCatwalkStairsBlock(long config, AbstractBlock.Properties properties, AxisAlignedBB[] base_aabb, AxisAlignedBB[] railing_aabbs) {
        super(config, properties, base_aabb);
        HashMap<BlockState, VoxelShape> sh = new HashMap<BlockState, VoxelShape>();
        HashMap<BlockState, VoxelShape> csh = new HashMap<BlockState, VoxelShape>();
        this.func_176194_O().func_177619_a().forEach(state -> {
            Direction facing = (Direction)state.func_177229_b((Property)HORIZONTAL_FACING);
            VoxelShape base_shape = Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(base_aabb, facing, true));
            if (((Boolean)state.func_177229_b((Property)RIGHT_RAILING)).booleanValue()) {
                VoxelShape right_shape = Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getMirroredAABB(railing_aabbs, Direction.Axis.X), facing, true));
                base_shape = VoxelShapes.func_197882_b((VoxelShape)base_shape, (VoxelShape)right_shape, (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if (((Boolean)state.func_177229_b((Property)LEFT_RAILING)).booleanValue()) {
                VoxelShape left_shape = Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(railing_aabbs, facing, true));
                base_shape = VoxelShapes.func_197882_b((VoxelShape)base_shape, (VoxelShape)left_shape, (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            sh.put((BlockState)state, base_shape);
            csh.put((BlockState)state, base_shape);
        });
        this.shapes = sh;
        this.collision_shapes = csh;
        this.y_rotations = new HashMap<Direction, Integer>();
        this.y_rotations.put(Direction.NORTH, 0);
        this.y_rotations.put(Direction.EAST, 1);
        this.y_rotations.put(Direction.SOUTH, 2);
        this.y_rotations.put(Direction.WEST, 3);
        this.y_rotations.put(Direction.UP, 0);
        this.y_rotations.put(Direction.DOWN, 0);
        this.func_180632_j((BlockState)((BlockState)super.func_176223_P().func_206870_a((Property)LEFT_RAILING, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)RIGHT_RAILING, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shapes.getOrDefault(state, VoxelShapes.func_197868_b());
    }

    @Override
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.collision_shapes.getOrDefault(state, VoxelShapes.func_197868_b());
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{RIGHT_RAILING, LEFT_RAILING});
    }

    @Override
    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return super.func_196258_a(context);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        Item item = player.func_184586_b(hand).func_77973_b();
        if (!(item instanceof BlockItem)) {
            return ActionResultType.PASS;
        }
        Block block = ((BlockItem)item).func_179223_d();
        Direction facing = (Direction)state.func_177229_b((Property)HORIZONTAL_FACING);
        if (block == this) {
            BlockPos adjacent_pos;
            Direction hlv = Arrays.stream(Direction.func_196054_a((Entity)player)).filter(d -> d.func_176740_k().func_176722_c()).findFirst().orElse(Direction.NORTH);
            if (hlv == facing) {
                adjacent_pos = pos.func_177984_a().func_177972_a(hlv);
            } else if (hlv == facing.func_176734_d()) {
                adjacent_pos = pos.func_177977_b().func_177972_a(hlv);
            } else {
                return world.func_201670_d() ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
            }
            BlockState adjacent_state = world.func_180495_p(adjacent_pos);
            if (adjacent_state == null) {
                return world.func_201670_d() ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
            }
            if (!adjacent_state.func_196953_a((BlockItemUseContext)new DirectionalPlaceContext(world, adjacent_pos, hit.func_216354_b().func_176734_d(), player.func_184586_b(hand), hit.func_216354_b()))) {
                return ActionResultType.CONSUME;
            }
            BlockState place_state = (BlockState)this.func_176223_P().func_206870_a((Property)HORIZONTAL_FACING, (Comparable)facing);
            place_state = (BlockState)place_state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(adjacent_state.func_204520_s().func_206886_c() == Fluids.field_204546_a));
            EdCatwalkBlock.place_consume(place_state, world, adjacent_pos, player, hand, 1);
            return world.func_201670_d() ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
        }
        if (block == ModContent.STEEL_CATWALK || block == ModContent.STEEL_CATWALK_TOP_ALIGNED) {
            BlockPos adjacent_pos = pos.func_177972_a(facing);
            BlockState adjacent_state = world.func_180495_p(adjacent_pos);
            if (adjacent_state == null) {
                return ActionResultType.CONSUME;
            }
            if (!adjacent_state.func_196953_a((BlockItemUseContext)new DirectionalPlaceContext(world, adjacent_pos, hit.func_216354_b().func_176734_d(), player.func_184586_b(hand), hit.func_216354_b()))) {
                return ActionResultType.CONSUME;
            }
            BlockState place_state = ModContent.STEEL_CATWALK_TOP_ALIGNED.func_176223_P();
            place_state = (BlockState)place_state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(adjacent_state.func_204520_s().func_206886_c() == Fluids.field_204546_a));
            EdCatwalkBlock.place_consume(place_state, world, adjacent_pos, player, hand, 1);
            return world.func_201670_d() ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
        }
        if (block == ModContent.STEEL_RAILING) {
            Direction face = hit.func_216354_b();
            int shrink = 0;
            BlockState place_state = state;
            if (face == Direction.UP) {
                Vector3d rhv = hit.func_216347_e().func_178788_d(Vector3d.func_237489_a_((Vector3i)hit.func_216350_a())).func_216369_h(new Vector3d(1.0, 0.0, 1.0)).func_72431_c(Vector3d.func_237491_b_((Vector3i)facing.func_176730_m()));
                Direction direction = face = rhv.field_72448_b > 0.0 ? facing.func_176746_e() : facing.func_176735_f();
            }
            if (face == facing.func_176746_e()) {
                if (((Boolean)state.func_177229_b((Property)RIGHT_RAILING)).booleanValue()) {
                    place_state = (BlockState)state.func_206870_a((Property)RIGHT_RAILING, (Comparable)Boolean.valueOf(false));
                    shrink = -1;
                } else {
                    place_state = (BlockState)state.func_206870_a((Property)RIGHT_RAILING, (Comparable)Boolean.valueOf(true));
                    shrink = 1;
                }
            } else if (face == facing.func_176735_f()) {
                if (((Boolean)state.func_177229_b((Property)LEFT_RAILING)).booleanValue()) {
                    place_state = (BlockState)state.func_206870_a((Property)LEFT_RAILING, (Comparable)Boolean.valueOf(false));
                    shrink = -1;
                } else {
                    place_state = (BlockState)state.func_206870_a((Property)LEFT_RAILING, (Comparable)Boolean.valueOf(true));
                    shrink = 1;
                }
            }
            if (shrink != 0) {
                EdCatwalkBlock.place_consume(place_state, world, pos, player, hand, shrink);
            }
            return world.func_201670_d() ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    @Override
    public boolean hasDynamicDropList() {
        return true;
    }

    @Override
    public List<ItemStack> dropList(BlockState state, World world, @Nullable TileEntity te, boolean explosion) {
        if (world.func_201670_d()) {
            return Collections.singletonList(ItemStack.field_190927_a);
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((IItemProvider)state.func_177230_c().func_199767_j()));
        int n = ((Boolean)state.func_177229_b((Property)LEFT_RAILING) != false ? 1 : 0) + ((Boolean)state.func_177229_b((Property)RIGHT_RAILING) != false ? 1 : 0);
        if (n > 0) {
            drops.add(new ItemStack((IItemProvider)ModContent.STEEL_RAILING, n));
        }
        return drops;
    }
}

