/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.detail.Auxiliaries;
import wile.engineersdecor.libmc.detail.Inventories;
import wile.engineersdecor.libmc.detail.Overlay;
import wile.engineersdecor.libmc.detail.RfEnergy;

public class EdBreaker {
    public static void on_config(int boost_energy_per_tick, int breaking_time_per_hardness, int min_breaking_time_ticks, boolean power_required) {
        BreakerTileEntity.on_config(boost_energy_per_tick, breaking_time_per_hardness, min_breaking_time_ticks, power_required);
    }

    public static class BreakerTileEntity
    extends TileEntity
    implements ITickableTileEntity {
        public static final int IDLE_TICK_INTERVAL = 40;
        public static final int TICK_INTERVAL = 5;
        public static final int BOOST_FACTOR = 8;
        public static final int DEFAULT_BOOST_ENERGY = 64;
        public static final int DEFAULT_BREAKING_RELUCTANCE = 17;
        public static final int DEFAULT_MIN_BREAKING_TIME = 15;
        public static final int MAX_BREAKING_TIME = 800;
        private static int boost_energy_consumption = 64;
        private static int energy_max = 32000;
        private static int breaking_reluctance = 17;
        private static int min_breaking_time = 15;
        private static boolean requires_power = false;
        private int tick_timer_;
        private int active_timer_;
        private int proc_time_elapsed_;
        private int time_needed_;
        private final RfEnergy.Battery battery_ = new RfEnergy.Battery(energy_max, boost_energy_consumption, 0);
        private final LazyOptional<IEnergyStorage> energy_handler_ = this.battery_.createEnergyHandler();
        private static HashSet<Block> blacklist = new HashSet();

        public static void on_config(int boost_energy_per_tick, int breaking_time_per_hardness, int min_breaking_time_ticks, boolean power_required) {
            boost_energy_consumption = 5 * MathHelper.func_76125_a((int)boost_energy_per_tick, (int)4, (int)4096);
            energy_max = Math.max(boost_energy_consumption * 10, 100000);
            breaking_reluctance = MathHelper.func_76125_a((int)breaking_time_per_hardness, (int)5, (int)50);
            min_breaking_time = MathHelper.func_76125_a((int)min_breaking_time_ticks, (int)10, (int)100);
            requires_power = power_required;
            ModConfig.log("Config block breaker: Boost energy consumption:" + boost_energy_consumption / 5 + "rf/t, reluctance=" + breaking_reluctance + "t/hrdn, break time offset=" + min_breaking_time + "t.");
        }

        public BreakerTileEntity() {
            this(ModContent.TET_SMALL_BLOCK_BREAKER);
        }

        public BreakerTileEntity(TileEntityType<?> te_type) {
            super(te_type);
        }

        public void block_updated() {
            if (this.tick_timer_ > 2) {
                this.tick_timer_ = 2;
            }
        }

        public void readnbt(CompoundNBT nbt) {
            this.battery_.load(nbt);
        }

        private void writenbt(CompoundNBT nbt) {
            this.battery_.save(nbt);
        }

        public void state_message(PlayerEntity player) {
            String progress = "0";
            if (this.proc_time_elapsed_ > 0 && this.time_needed_ > 0) {
                progress = Integer.toString((int)MathHelper.func_151237_a((double)((double)this.proc_time_elapsed_ / (double)this.time_needed_ * 100.0), (double)0.0, (double)100.0));
            }
            Overlay.show(player, (ITextComponent)Auxiliaries.localizable("block.engineersdecor.small_block_breaker.status", this.battery_.getSOC(), energy_max, progress));
        }

        public void func_230337_a_(BlockState state, CompoundNBT nbt) {
            super.func_230337_a_(state, nbt);
            this.readnbt(nbt);
        }

        public CompoundNBT func_189515_b(CompoundNBT nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt);
            return nbt;
        }

        public void func_145843_s() {
            super.func_145843_s();
            this.energy_handler_.invalidate();
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityEnergy.ENERGY) {
                return this.energy_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        private static boolean isBreakable(BlockState state, BlockPos pos, World world) {
            Block block = state.func_177230_c();
            if (blacklist.contains(block)) {
                return false;
            }
            if (state.func_185904_a().func_76224_d()) {
                return false;
            }
            if (block.isAir(state, (IBlockReader)world, pos)) {
                return false;
            }
            float bh = state.func_185887_b((IBlockReader)world, pos);
            return !(bh < 0.0f) && !(bh > 55.0f);
        }

        private static void spawnBlockAsEntity(World world, BlockPos pos, ItemStack stack) {
            if (world.field_72995_K || stack.func_190926_b() || !world.func_82736_K().func_223586_b(GameRules.field_223603_f) || world.restoringBlockSnapshots) {
                return;
            }
            ItemEntity e = new ItemEntity(world, (double)world.field_73012_v.nextFloat() * 0.1 + 0.5 + (double)pos.func_177958_n(), (double)world.field_73012_v.nextFloat() * 0.1 + 0.5 + (double)pos.func_177956_o(), (double)world.field_73012_v.nextFloat() * 0.1 + 0.5 + (double)pos.func_177952_p(), stack);
            e.func_174869_p();
            e.func_213293_j((double)world.field_73012_v.nextFloat() * 0.1 - 0.05, (double)world.field_73012_v.nextFloat() * 0.1 - 0.03, (double)world.field_73012_v.nextFloat() * 0.1 - 0.05);
            world.func_217376_c((Entity)e);
        }

        private static boolean canInsertInto(World world, BlockPos pos) {
            BlockState state = world.func_180495_p(pos);
            return state.func_177230_c() == ModContent.FACTORY_HOPPER || state.func_177230_c() == Blocks.field_150438_bZ;
        }

        private boolean breakBlock(BlockState state, BlockPos pos, World world) {
            if (world.field_72995_K || !(world instanceof ServerWorld) || world.restoringBlockSnapshots) {
                return false;
            }
            Block block = state.func_177230_c();
            boolean insert = BreakerTileEntity.canInsertInto(world, this.func_174877_v().func_177977_b());
            List drops = Block.func_220070_a((BlockState)state, (ServerWorld)((ServerWorld)world), (BlockPos)pos, (TileEntity)world.func_175625_s(pos));
            world.func_217377_a(pos, false);
            for (ItemStack drop : drops) {
                if (!insert) {
                    BreakerTileEntity.spawnBlockAsEntity(world, pos, drop);
                    continue;
                }
                ItemStack remaining = Inventories.insert(world, this.func_174877_v().func_177977_b(), Direction.UP, drop, false);
                if (remaining.func_190926_b()) continue;
                BreakerTileEntity.spawnBlockAsEntity(world, pos, remaining);
            }
            SoundType stype = state.func_177230_c().getSoundType(state, (IWorldReader)world, pos, null);
            if (stype != null) {
                world.func_184133_a(null, pos, stype.func_185841_e(), SoundCategory.BLOCKS, stype.func_185843_a() * 0.6f, stype.func_185847_b());
            }
            return true;
        }

        public void func_73660_a() {
            if (--this.tick_timer_ > 0) {
                return;
            }
            BlockState device_state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(device_state.func_177230_c() instanceof BreakerBlock)) {
                return;
            }
            if (this.field_145850_b.field_72995_K) {
                if (!((Boolean)device_state.func_177229_b((Property)BreakerBlock.ACTIVE)).booleanValue()) {
                    this.tick_timer_ = 5;
                } else {
                    this.tick_timer_ = 1;
                    SoundEvent sound = SoundEvents.field_187889_gU;
                    BlockState target_state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a((Direction)device_state.func_177229_b((Property)BreakerBlock.HORIZONTAL_FACING)));
                    SoundType stype = target_state.func_177230_c().func_220072_p(target_state);
                    if (stype == SoundType.field_185854_g || stype == SoundType.field_185850_c || stype == SoundType.field_185856_i) {
                        sound = SoundEvents.field_187550_ag;
                    } else if (stype == SoundType.field_185849_b || stype == SoundType.field_185855_h) {
                        sound = SoundEvents.field_187585_bY;
                    }
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), sound, SoundCategory.BLOCKS, 0.1f, 1.2f, false);
                }
            } else {
                boolean active;
                this.tick_timer_ = 5;
                BlockPos target_pos = this.field_174879_c.func_177972_a((Direction)device_state.func_177229_b((Property)BreakerBlock.HORIZONTAL_FACING));
                BlockState target_state = this.field_145850_b.func_180495_p(target_pos);
                if (this.field_145850_b.func_175640_z(this.field_174879_c) || !BreakerTileEntity.isBreakable(target_state, target_pos, this.field_145850_b)) {
                    if (((Boolean)device_state.func_177229_b((Property)BreakerBlock.ACTIVE)).booleanValue()) {
                        this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)device_state.func_206870_a((Property)BreakerBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
                    }
                    this.proc_time_elapsed_ = 0;
                    this.tick_timer_ = 40;
                    return;
                }
                this.time_needed_ = MathHelper.func_76125_a((int)((int)(target_state.func_185887_b((IBlockReader)this.field_145850_b, this.field_174879_c) * (float)breaking_reluctance) + min_breaking_time), (int)min_breaking_time, (int)800);
                if (this.battery_.draw(boost_energy_consumption)) {
                    this.proc_time_elapsed_ += 45;
                    this.time_needed_ += min_breaking_time * 4;
                    this.active_timer_ = 2;
                } else if (!requires_power) {
                    this.proc_time_elapsed_ += 5;
                    this.active_timer_ = 1024;
                } else if (this.active_timer_ > 0) {
                    --this.active_timer_;
                }
                boolean bl = active = this.active_timer_ > 0;
                if (requires_power && !active) {
                    this.proc_time_elapsed_ = Math.max(0, this.proc_time_elapsed_ - 10);
                }
                if (this.proc_time_elapsed_ >= this.time_needed_) {
                    this.proc_time_elapsed_ = 0;
                    this.breakBlock(target_state, target_pos, this.field_145850_b);
                    active = false;
                }
                if ((Boolean)device_state.func_177229_b((Property)BreakerBlock.ACTIVE) != active) {
                    this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)device_state.func_206870_a((Property)BreakerBlock.ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
                }
            }
        }

        static {
            blacklist.add(Blocks.field_150350_a);
            blacklist.add(Blocks.field_150357_h);
            blacklist.add(Blocks.field_150480_ab);
            blacklist.add(Blocks.field_150384_bq);
            blacklist.add(Blocks.field_185775_db);
            blacklist.add(Blocks.field_150378_br);
            blacklist.add(Blocks.field_150427_aO);
            blacklist.add(Blocks.field_180401_cv);
        }
    }

    public static class BreakerBlock
    extends DecorBlock.HorizontalWaterLoggable
    implements IDecorBlock {
        public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");

        public BreakerBlock(long config, AbstractBlock.Properties builder, AxisAlignedBB[] unrotatedAABBs) {
            super(config, builder, unrotatedAABBs);
        }

        @Override
        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new Property[]{ACTIVE});
        }

        @Override
        @Nullable
        public BlockState func_196258_a(BlockItemUseContext context) {
            return (BlockState)super.func_196258_a(context).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
        }

        public boolean hasTileEntity(BlockState state) {
            return true;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new BreakerTileEntity();
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_180655_c(BlockState state, World world, BlockPos pos, Random rnd) {
            if (state.func_177230_c() != this || !((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue()) {
                return;
            }
            double rv = rnd.nextDouble();
            if (rv > 0.8) {
                return;
            }
            double x = 0.5 + (double)pos.func_177958_n();
            double y = 0.5 + (double)pos.func_177956_o();
            double z = 0.5 + (double)pos.func_177952_p();
            double xc = 0.52;
            double xr = rnd.nextDouble() * 0.4 - 0.2;
            double yr = y - 0.3 + rnd.nextDouble() * 0.2;
            switch ((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)) {
                case WEST: {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x - 0.52, yr, z + xr, 0.0, 0.0, 0.0);
                    break;
                }
                case EAST: {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.52, yr, z + xr, 0.0, 0.0, 0.0);
                    break;
                }
                case NORTH: {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + xr, yr, z - 0.52, 0.0, 0.0, 0.0);
                    break;
                }
                default: {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + xr, yr, z + 0.52, 0.0, 0.0, 0.0);
                }
            }
        }

        public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean unused) {
            if (!(world instanceof World) || world.field_72995_K) {
                return;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof BreakerTileEntity)) {
                return;
            }
            ((BreakerTileEntity)te).block_updated();
        }

        public boolean func_149744_f(BlockState state) {
            return true;
        }

        public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
            return 0;
        }

        public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
            return 0;
        }

        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
            if (world.func_201670_d()) {
                return ActionResultType.SUCCESS;
            }
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof BreakerTileEntity) {
                ((BreakerTileEntity)te).state_message(player);
            }
            return ActionResultType.CONSUME;
        }
    }
}

