/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IIntArray;
import net.minecraft.util.INameable;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntArray;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.EdFurnace;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.client.ContainerGui;
import wile.engineersdecor.libmc.detail.Inventories;
import wile.engineersdecor.libmc.detail.Networking;
import wile.engineersdecor.libmc.detail.TooltipDisplay;

public class EdElectricalFurnace {
    public static void on_config(int speed_percent, int standard_energy_per_tick, boolean with_automatic_inventory_pulling) {
        ElectricalFurnaceTileEntity.on_config(speed_percent, standard_energy_per_tick, with_automatic_inventory_pulling);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ElectricalFurnaceGui
    extends ContainerGui<ElectricalFurnaceContainer> {
        protected final PlayerEntity player_;
        protected final TooltipDisplay tooltip_ = new TooltipDisplay();

        public ElectricalFurnaceGui(ElectricalFurnaceContainer container, PlayerInventory player_inventory, ITextComponent title) {
            super(container, player_inventory, title);
            this.player_ = player_inventory.field_70458_d;
        }

        public void func_231160_c_() {
            super.func_231160_c_();
            String prefix = ModContent.SMALL_ELECTRICAL_FURNACE.func_149739_a() + ".tooltips.";
            int x0 = this.getGuiLeft();
            int y0 = this.getGuiTop();
            Slot aux = ((ElectricalFurnaceContainer)this.field_147002_h).func_75139_a(1);
            this.tooltip_.init(new TooltipDisplay.TipRange(x0 + 135, y0 + 50, 25, 25, (ITextComponent)new TranslationTextComponent(prefix + "speed")), new TooltipDisplay.TipRange(x0 + aux.field_75223_e, y0 + aux.field_75221_f, 16, 16, (ITextComponent)new TranslationTextComponent(prefix + "auxslot")), new TooltipDisplay.TipRange(x0 + 80, y0 + 55, 50, 14, () -> {
                int soc = ((ElectricalFurnaceContainer)this.func_212873_a_()).field(1) * 100 / Math.max(((ElectricalFurnaceContainer)this.func_212873_a_()).field(5), 1);
                int consumption = ((ElectricalFurnaceContainer)this.func_212873_a_()).field(7);
                return new TranslationTextComponent(prefix + "capacitors", new Object[]{soc, consumption});
            }));
        }

        public void func_230430_a_(MatrixStack mx, int mouseX, int mouseY, float partialTicks) {
            this.func_230446_a_(mx);
            super.func_230430_a_(mx, mouseX, mouseY, partialTicks);
            if (!this.tooltip_.render(mx, this, mouseX, mouseY)) {
                this.func_230459_a_(mx, mouseX, mouseY);
            }
        }

        protected void func_230451_b_(MatrixStack mx, int x, int y) {
        }

        protected void func_230450_a_(MatrixStack mx, float partialTicks, int mouseX, int mouseY) {
            RenderSystem.enableBlend();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.getMinecraft().func_110434_K().func_110577_a(new ResourceLocation("engineersdecor", "textures/gui/small_electrical_furnace_gui.png"));
            int x0 = this.field_147003_i;
            int y0 = this.field_147009_r;
            int w = this.field_146999_f;
            int h = this.field_147000_g;
            this.func_238474_b_(mx, x0, y0, 0, 0, w, h);
            if (((ElectricalFurnaceContainer)this.func_212873_a_()).field(6) != 0) {
                int hi = 13;
                int k = this.heat_px(13);
                this.func_238474_b_(mx, x0 + 62, y0 + 55 + 13 - k, 177, 13 - k, 13, k);
            }
            this.func_238474_b_(mx, x0 + 79, y0 + 30, 176, 15, 1 + this.progress_px(17), 15);
            int we = this.energy_px(32, 8);
            if (we > 0) {
                this.func_238474_b_(mx, x0 + 90, y0 + 54, 185, 30, we, 13);
            }
            switch (((ElectricalFurnaceContainer)this.func_212873_a_()).field(4)) {
                case 0: {
                    this.func_238474_b_(mx, x0 + 144, y0 + 57, 180, 57, 6, 9);
                    break;
                }
                case 1: {
                    this.func_238474_b_(mx, x0 + 142, y0 + 58, 190, 58, 9, 6);
                    break;
                }
                case 2: {
                    this.func_238474_b_(mx, x0 + 144, y0 + 56, 200, 57, 6, 9);
                    break;
                }
                case 3: {
                    this.func_238474_b_(mx, x0 + 143, y0 + 58, 210, 58, 9, 6);
                    break;
                }
            }
            RenderSystem.disableBlend();
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
            this.tooltip_.resetTimer();
            ElectricalFurnaceContainer container = (ElectricalFurnaceContainer)this.func_212873_a_();
            int mx = (int)(mouseX - (double)this.getGuiLeft() + 0.5);
            int my = (int)(mouseY - (double)this.getGuiTop() + 0.5);
            if (!this.func_195359_a(136, 48, 28, 28, mouseX, mouseY)) {
                return super.func_231044_a_(mouseX, mouseY, mouseButton);
            }
            if (this.func_195359_a(144, 64, 6, 10, mouseX, mouseY)) {
                container.onGuiAction("speed", 0);
            } else if (this.func_195359_a(134, 58, 10, 6, mouseX, mouseY)) {
                container.onGuiAction("speed", 1);
            } else if (this.func_195359_a(144, 48, 6, 10, mouseX, mouseY)) {
                container.onGuiAction("speed", 2);
            } else if (this.func_195359_a(150, 58, 10, 6, mouseX, mouseY)) {
                container.onGuiAction("speed", 3);
            }
            return true;
        }

        private int progress_px(int pixels) {
            int tc = ((ElectricalFurnaceContainer)this.func_212873_a_()).field(2);
            int T = ((ElectricalFurnaceContainer)this.func_212873_a_()).field(3);
            return T > 0 && tc > 0 ? tc * pixels / T : 0;
        }

        private int heat_px(int pixels) {
            int k = ((ElectricalFurnaceContainer)this.func_212873_a_()).field(0) * (pixels + 1) / 200;
            return k < pixels ? k : pixels;
        }

        private int energy_px(int maxwidth, int quantization) {
            int emax = ((ElectricalFurnaceContainer)this.func_212873_a_()).field(5);
            int k = maxwidth * ((ElectricalFurnaceContainer)this.func_212873_a_()).field(1) * 9 / 8 / ((emax > 0 ? emax : 1) + 1);
            int n = k = k >= maxwidth - 2 ? maxwidth : k;
            if (quantization > 0) {
                k = (k + quantization / 2) / quantization * quantization;
            }
            return k;
        }
    }

    public static class ElectricalFurnaceContainer
    extends Container
    implements Networking.INetworkSynchronisableContainer {
        private static final int PLAYER_INV_START_SLOTNO = 7;
        protected final PlayerEntity player_;
        protected final IInventory inventory_;
        protected final IWorldPosCallable wpc_;
        private final IIntArray fields_;
        private final IRecipeType<? extends AbstractCookingRecipe> recipe_type_;

        public int field(int index) {
            return this.fields_.func_221476_a(index);
        }

        public PlayerEntity player() {
            return this.player_;
        }

        public IInventory inventory() {
            return this.inventory_;
        }

        public World world() {
            return this.player_.field_70170_p;
        }

        public ElectricalFurnaceContainer(int cid, PlayerInventory player_inventory) {
            this(cid, player_inventory, (IInventory)new Inventory(7), IWorldPosCallable.field_221489_a, (IIntArray)new IntArray(8));
        }

        private ElectricalFurnaceContainer(int cid, PlayerInventory player_inventory, IInventory block_inventory, IWorldPosCallable wpc, IIntArray fields) {
            super(ModContent.CT_SMALL_ELECTRICAL_FURNACE, cid);
            this.player_ = player_inventory.field_70458_d;
            this.inventory_ = block_inventory;
            this.wpc_ = wpc;
            this.fields_ = fields;
            this.recipe_type_ = EdFurnace.FurnaceTileEntity.RECIPE_TYPE;
            this.func_75146_a(new Slot(this.inventory_, 0, 59, 28));
            this.func_75146_a(new Slot(this.inventory_, 1, 16, 52));
            this.func_75146_a(new EdFurnace.FurnaceContainer.BSlotResult(this.player_, this.inventory_, 2, 101, 28));
            this.func_75146_a(new EdFurnace.FurnaceContainer.BSlotInpFifo(this.inventory_, 3, 34, 28));
            this.func_75146_a(new EdFurnace.FurnaceContainer.BSlotInpFifo(this.inventory_, 4, 16, 28));
            this.func_75146_a(new EdFurnace.FurnaceContainer.BSlotOutFifo(this.player_, this.inventory_, 5, 126, 28));
            this.func_75146_a(new EdFurnace.FurnaceContainer.BSlotOutFifo(this.player_, this.inventory_, 6, 144, 28));
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)player_inventory, x, 8 + x * 18, 144));
            }
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.func_75146_a(new Slot((IInventory)player_inventory, x + y * 9 + 9, 8 + x * 18, 86 + y * 18));
                }
            }
            this.func_216961_a(this.fields_);
        }

        public boolean func_75145_c(PlayerEntity player) {
            return this.inventory_.func_70300_a(player);
        }

        public ItemStack func_82846_b(PlayerEntity player, int index) {
            Slot slot = this.func_75139_a(index);
            if (slot == null || !slot.func_75216_d()) {
                return ItemStack.field_190927_a;
            }
            ItemStack slot_stack = slot.func_75211_c();
            ItemStack transferred = slot_stack.func_77946_l();
            if (index == 2 || index == 5 || index == 6) {
                if (!this.func_75135_a(slot_stack, 7, 43, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(slot_stack, transferred);
            } else if (index == 0 || index == 3 || index == 4) {
                if (!this.func_75135_a(slot_stack, 7, 43, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index == 1) {
                if (!this.func_75135_a(slot_stack, 7, 43, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= 7 && index <= 43) {
                if (ElectricalFurnaceTileEntity.canSmelt(this.world(), slot_stack) ? !this.func_75135_a(slot_stack, 0, 1, false) && !this.func_75135_a(slot_stack, 3, 4, false) && !this.func_75135_a(slot_stack, 4, 5, false) : (index >= 7 && index < 34 ? !this.func_75135_a(slot_stack, 34, 43, false) : index >= 34 && index < 43 && !this.func_75135_a(slot_stack, 7, 34, false))) {
                    return ItemStack.field_190927_a;
                }
            } else {
                return ItemStack.field_190927_a;
            }
            if (slot_stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slot_stack.func_190916_E() == transferred.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slot_stack);
            return transferred;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(CompoundNBT nbt) {
            Networking.PacketContainerSyncClientToServer.sendToServer(this.field_75152_c, nbt);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String key, int value) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a(key, value);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.field_75152_c, nbt);
        }

        @Override
        public void onServerPacketReceived(int windowId, CompoundNBT nbt) {
        }

        @Override
        public void onClientPacketReceived(int windowId, PlayerEntity player, CompoundNBT nbt) {
            if (!(this.inventory_ instanceof Inventories.StorageInventory)) {
                return;
            }
            ElectricalFurnaceTileEntity te = (ElectricalFurnaceTileEntity)((Inventories.StorageInventory)this.inventory_).getTileEntity();
            if (nbt.func_74764_b("speed")) {
                te.speed_ = MathHelper.func_76125_a((int)nbt.func_74762_e("speed"), (int)0, (int)3);
            }
            te.func_70296_d();
        }
    }

    public static class ElectricalFurnaceTileEntity
    extends EdFurnace.FurnaceTileEntity
    implements ITickableTileEntity,
    INameable,
    INamedContainerProvider {
        private static final int NUM_OF_FIELDS = 8;
        private static final int TICK_INTERVAL = 4;
        private static final int FIFO_INTERVAL = 20;
        private static final int HEAT_CAPACITY = 200;
        private static final int HEAT_INCREMENT = 20;
        private static final int MAX_BURNTIME = Short.MAX_VALUE;
        private static final int MAX_XP_STORED = 65535;
        private static final int MAX_ENERGY_TRANSFER = 1024;
        private static final int MAX_ENERGY_BUFFER = 32000;
        private static final int MAX_SPEED_SETTING = 3;
        private static final int NUM_OF_SLOTS = 7;
        private static final int SMELTING_INPUT_SLOT_NO = 0;
        private static final int SMELTING_AUX_SLOT_NO = 1;
        private static final int SMELTING_OUTPUT_SLOT_NO = 2;
        private static final int FIFO_INPUT_0_SLOT_NO = 3;
        private static final int FIFO_INPUT_1_SLOT_NO = 4;
        private static final int FIFO_OUTPUT_0_SLOT_NO = 5;
        private static final int FIFO_OUTPUT_1_SLOT_NO = 6;
        public static final int DEFAULT_SPEED_PERCENT = 290;
        public static final int DEFAULT_ENERGY_CONSUMPTION = 16;
        public static final int DEFAULT_SCALED_ENERGY_CONSUMPTION = 64;
        private static boolean with_automatic_inventory_pulling_ = false;
        private static int energy_consumption_ = 64;
        private static int transfer_energy_consumption_ = 8;
        private static int proc_speed_percent_ = 290;
        private static double[] speed_setting_factor_ = new double[]{0.0, 1.0, 1.5, 2.0};
        private int speed_ = 1;
        private boolean enabled_ = false;
        protected int field_power_consumption_;
        protected int power_consumption_accumulator_;
        protected int power_consumption_timer_;
        private final LazyOptional<IItemHandler> item_handler_;
        protected final IIntArray fields = new IntArray(8){

            public int func_221476_a(int id) {
                switch (id) {
                    case 0: {
                        return burntime_left_;
                    }
                    case 1: {
                        return battery_.getEnergyStored();
                    }
                    case 2: {
                        return (int)proc_time_elapsed_;
                    }
                    case 3: {
                        return proc_time_needed_;
                    }
                    case 4: {
                        return speed_;
                    }
                    case 5: {
                        return battery_.getMaxEnergyStored();
                    }
                    case 6: {
                        return field_is_burning_;
                    }
                    case 7: {
                        return field_power_consumption_;
                    }
                }
                return 0;
            }

            public void func_221477_a(int id, int value) {
                switch (id) {
                    case 0: {
                        burntime_left_ = value;
                        break;
                    }
                    case 1: {
                        battery_.setEnergyStored(value);
                        break;
                    }
                    case 2: {
                        proc_time_elapsed_ = value;
                        break;
                    }
                    case 3: {
                        proc_time_needed_ = value;
                        break;
                    }
                    case 4: {
                        speed_ = value;
                        break;
                    }
                    case 5: {
                        battery_.setMaxEnergyStored(value);
                        break;
                    }
                    case 6: {
                        field_is_burning_ = value;
                        break;
                    }
                    case 7: {
                        field_power_consumption_ = value;
                    }
                }
            }
        };

        public static void on_config(int speed_percent, int standard_energy_per_tick, boolean with_automatic_inventory_pulling) {
            proc_speed_percent_ = MathHelper.func_76125_a((int)speed_percent, (int)10, (int)800);
            energy_consumption_ = MathHelper.func_76125_a((int)standard_energy_per_tick, (int)4, (int)4096) * 4;
            transfer_energy_consumption_ = MathHelper.func_76125_a((int)(energy_consumption_ / 8), (int)8, (int)20);
            with_automatic_inventory_pulling_ = with_automatic_inventory_pulling;
            ModConfig.log("Config electrical furnace speed:" + proc_speed_percent_ + "%, heat-loss: 1K/t, heating consumption:" + energy_consumption_ / 4 + "rf/t.");
        }

        public ElectricalFurnaceTileEntity() {
            this(ModContent.TET_SMALL_ELECTRICAL_FURNACE);
        }

        public ElectricalFurnaceTileEntity(TileEntityType<?> te_type) {
            super(te_type, 7);
            this.battery_.setMaxEnergyStored(32000);
            this.battery_.setChargeRate(1024);
            this.battery_.setDischargeRate(0);
            this.inventory_.setValidator((index, stack) -> {
                switch (index) {
                    case 0: 
                    case 3: 
                    case 4: {
                        return true;
                    }
                }
                return false;
            });
            this.item_handler_ = Inventories.MappedItemHandler.createGenericHandler(this.inventory_, (slot, stack) -> slot == 5 || slot == 6, (slot, stack) -> slot == 3 || slot == 4, Arrays.asList(5, 6, 3, 4));
        }

        @Override
        public void reset() {
            this.inventory_.func_174888_l();
            this.burntime_left_ = 0;
            this.proc_time_elapsed_ = 0.0;
            this.proc_time_needed_ = 0;
            this.fifo_timer_ = 0;
            this.tick_timer_ = 0;
            this.battery_.clear();
            this.speed_ = 1;
            this.field_is_burning_ = 0;
        }

        @Override
        public void readnbt(CompoundNBT nbt) {
            this.burntime_left_ = nbt.func_74762_e("BurnTime");
            this.proc_time_elapsed_ = nbt.func_74762_e("CookTime");
            this.proc_time_needed_ = nbt.func_74762_e("CookTimeTotal");
            this.xp_stored_ = nbt.func_74760_g("XpStored");
            this.speed_ = nbt.func_74762_e("SpeedSetting");
            this.speed_ = this.speed_ < 0 ? 1 : (this.speed_ > 3 ? 3 : this.speed_);
            this.battery_.load(nbt, "Energy");
            this.inventory_.load(nbt);
        }

        @Override
        protected void writenbt(CompoundNBT nbt) {
            nbt.func_74768_a("BurnTime", MathHelper.func_76125_a((int)this.burntime_left_, (int)0, (int)200));
            nbt.func_74768_a("CookTime", MathHelper.func_76125_a((int)((int)this.proc_time_elapsed_), (int)0, (int)Short.MAX_VALUE));
            nbt.func_74768_a("CookTimeTotal", MathHelper.func_76125_a((int)this.proc_time_needed_, (int)0, (int)Short.MAX_VALUE));
            nbt.func_74768_a("SpeedSetting", MathHelper.func_76125_a((int)this.speed_, (int)-1, (int)3));
            nbt.func_74776_a("XpStored", MathHelper.func_76131_a((float)this.xp_stored_, (float)0.0f, (float)65535.0f));
            this.battery_.save(nbt, "Energy");
            this.inventory_.save(nbt);
        }

        @Override
        public int getComparatorOutput() {
            return this.battery_.isEmpty() ? 0 : (this.inventory_.func_70301_a(4).func_190926_b() ? 0 : 5) + (this.inventory_.func_70301_a(3).func_190926_b() ? 0 : 5) + (this.inventory_.func_70301_a(0).func_190926_b() ? 0 : 5);
        }

        @Override
        public void func_230337_a_(BlockState state, CompoundNBT nbt) {
            super.func_230337_a_(state, nbt);
            this.readnbt(nbt);
        }

        @Override
        public CompoundNBT func_189515_b(CompoundNBT nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt);
            return nbt;
        }

        @Override
        public void func_145843_s() {
            super.func_145843_s();
            this.item_handler_.invalidate();
            this.energy_handler_.invalidate();
        }

        @Override
        public ITextComponent func_200200_C_() {
            Block block = this.func_195044_w().func_177230_c();
            return new StringTextComponent(block != null ? block.func_149739_a() : "Small electrical furnace");
        }

        @Override
        public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
            return new ElectricalFurnaceContainer(id, inventory, this.inventory_, IWorldPosCallable.func_221488_a((World)this.field_145850_b, (BlockPos)this.field_174879_c), this.fields);
        }

        @Override
        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return this.item_handler_.cast();
            }
            if (capability == CapabilityEnergy.ENERGY) {
                return this.energy_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        @Override
        public void func_73660_a() {
            boolean update_blockstate;
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 4;
            if (!(this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof ElectricalFurnaceBlock)) {
                return;
            }
            boolean was_burning = this.burning();
            if (was_burning) {
                this.burntime_left_ -= 4;
            }
            if (this.burntime_left_ < 0) {
                this.burntime_left_ = 0;
            }
            if (this.field_145850_b.func_201670_d()) {
                return;
            }
            int battery_energy = this.battery_.getEnergyStored();
            boolean dirty = update_blockstate = was_burning != this.burning();
            boolean shift_in = false;
            boolean shift_out = false;
            if (--this.fifo_timer_ <= 0) {
                this.fifo_timer_ = 5;
                if (this.transferItems(5, 6, 64)) {
                    dirty = true;
                } else {
                    shift_out = true;
                }
                if (this.transferItems(2, 5, 64)) {
                    dirty = true;
                }
                if (this.transferItems(3, 0, 64)) {
                    dirty = true;
                }
                if (this.transferItems(4, 3, 64)) {
                    dirty = true;
                } else {
                    shift_in = true;
                }
            }
            if (this.battery_.getEnergyStored() < this.energy_consumption()) {
                this.enabled_ = false;
            } else if (this.battery_.getEnergyStored() >= 16000) {
                this.enabled_ = true;
            }
            if (!this.inventory_.func_70301_a(0).func_190926_b() && this.enabled_ && this.speed_ > 0) {
                boolean can_smelt;
                IRecipe last_recipe = this.currentRecipe();
                this.updateCurrentRecipe();
                if (this.currentRecipe() != last_recipe) {
                    this.proc_time_elapsed_ = 0.0;
                    this.proc_time_needed_ = this.getSmeltingTimeNeeded(this.field_145850_b, this.inventory_.func_70301_a(0));
                }
                if (!(can_smelt = this.canSmeltCurrentItem()) && this.getSmeltingResult(this.inventory_.func_70301_a(0)).func_190926_b()) {
                    if (this.transferItems(0, 2, 1)) {
                        dirty = true;
                    }
                } else {
                    int speed = MathHelper.func_76125_a((int)(this.battery_.getSOC() >= 25 ? this.speed_ : 1), (int)0, (int)3);
                    if (!this.burning() && can_smelt && this.heat_up(speed)) {
                        dirty = true;
                        update_blockstate = true;
                    }
                    if (this.burning() && can_smelt) {
                        if (this.heat_up(speed)) {
                            dirty = true;
                        }
                        this.proc_time_elapsed_ += (double)((int)((double)(4 * proc_speed_percent_) * speed_setting_factor_[speed] / 100.0));
                        if (this.proc_time_elapsed_ >= (double)this.proc_time_needed_) {
                            this.proc_time_elapsed_ = 0.0;
                            this.proc_time_needed_ = this.getSmeltingTimeNeeded(this.field_145850_b, this.inventory_.func_70301_a(0));
                            this.smeltCurrentItem();
                            dirty = true;
                            shift_out = true;
                        }
                    } else {
                        this.proc_time_elapsed_ = 0.0;
                    }
                }
            } else if (this.proc_time_elapsed_ > 0.0) {
                this.proc_time_elapsed_ -= (double)(this.inventory_.func_70301_a(0).func_190926_b() ? 20 : 1);
                if (this.proc_time_elapsed_ < 0.0) {
                    this.proc_time_elapsed_ = 0.0;
                    shift_out = true;
                    update_blockstate = true;
                }
            }
            if (update_blockstate) {
                dirty = true;
                this.sync_blockstate();
            }
            if (this.adjacent_inventory_shift(shift_in, shift_out)) {
                dirty = true;
            }
            this.field_is_burning_ = this.burning() ? 1 : 0;
            this.power_consumption_timer_ += 4;
            this.power_consumption_accumulator_ += this.battery_.getEnergyStored() - battery_energy;
            if (this.power_consumption_timer_ >= 20) {
                this.field_power_consumption_ = this.power_consumption_accumulator_ / this.power_consumption_timer_;
                this.power_consumption_accumulator_ = 0;
                this.power_consumption_timer_ = 0;
            }
            if (dirty) {
                this.func_70296_d();
            }
        }

        private boolean is_accepted_hopper(ItemStack stack) {
            return stack.func_77973_b() == Blocks.field_150438_bZ.func_199767_j() || stack.func_77973_b() == ModContent.FACTORY_HOPPER.func_199767_j();
        }

        private boolean transferItems(int index_from, int index_to, int count) {
            ItemStack from = this.inventory_.func_70301_a(index_from);
            if (from.func_190926_b()) {
                return false;
            }
            ItemStack to = this.inventory_.func_70301_a(index_to);
            if (from.func_190916_E() < count) {
                count = from.func_190916_E();
            }
            if (count <= 0) {
                return false;
            }
            boolean changed = true;
            if (to.func_190926_b()) {
                this.inventory_.func_70299_a(index_to, from.func_77979_a(count));
            } else if (to.func_190916_E() >= to.func_77976_d()) {
                changed = false;
            } else if (Inventories.areItemStacksDifferent(from, to)) {
                changed = false;
            } else if (to.func_190916_E() + count >= to.func_77976_d()) {
                from.func_190918_g(to.func_77976_d() - to.func_190916_E());
                to.func_190920_e(to.func_77976_d());
            } else {
                from.func_190918_g(count);
                to.func_190917_f(count);
            }
            if (from.func_190926_b() && from != ItemStack.field_190927_a) {
                this.inventory_.func_70299_a(index_from, ItemStack.field_190927_a);
                changed = true;
            }
            return changed;
        }

        private boolean adjacent_inventory_shift(boolean inp, boolean out) {
            IItemHandler hnd;
            TileEntity te;
            boolean dirty = false;
            if (this.battery_.getEnergyStored() < transfer_energy_consumption_) {
                return false;
            }
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof ElectricalFurnaceBlock)) {
                return false;
            }
            Direction out_facing = (Direction)state.func_177229_b((Property)ElectricalFurnaceBlock.HORIZONTAL_FACING);
            if (out && !this.inventory_.func_70301_a(6).func_190926_b() && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(out_facing))) != null && (hnd = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, out_facing).orElse(null)) != null) {
                ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)hnd, (ItemStack)this.inventory_.func_70301_a(6).func_77946_l(), (boolean)false);
                this.inventory_.func_70299_a(6, remaining);
                this.battery_.draw(transfer_energy_consumption_);
                dirty = true;
            }
            if (with_automatic_inventory_pulling_ || this.is_accepted_hopper(this.inventory_.func_70301_a(1))) {
                Direction inp_facing = ((Direction)state.func_177229_b((Property)ElectricalFurnaceBlock.HORIZONTAL_FACING)).func_176734_d();
                if (inp && this.inventory_.func_70301_a(4).func_190926_b() && this.battery_.getEnergyStored() >= transfer_energy_consumption_) {
                    int max_count = MathHelper.func_76125_a((int)(transfer_energy_consumption_ <= 0 ? 64 : this.battery_.getEnergyStored() / transfer_energy_consumption_), (int)1, (int)64);
                    ItemStack retrieved = Inventories.extract(Inventories.itemhandler(this.field_145850_b, this.field_174879_c.func_177972_a(inp_facing), inp_facing), null, max_count, false);
                    if (!retrieved.func_190926_b()) {
                        this.inventory_.func_70299_a(4, retrieved);
                        this.battery_.draw(max_count * transfer_energy_consumption_);
                        dirty = true;
                    }
                }
            }
            return dirty;
        }

        private int energy_consumption() {
            return this.energy_consumption(this.speed_);
        }

        private int energy_consumption(int speed) {
            switch (speed) {
                case 1: {
                    return energy_consumption_;
                }
                case 2: {
                    return energy_consumption_ * 2;
                }
                case 3: {
                    return energy_consumption_ * 4;
                }
            }
            return 0;
        }

        private boolean heat_up(int speed) {
            if (!this.enabled_) {
                return false;
            }
            int p = this.energy_consumption(speed);
            if (p <= 0 || !this.battery_.draw(p)) {
                return false;
            }
            this.burntime_left_ = Math.min(this.burntime_left_ + 20, 200);
            return true;
        }

        private void sync_blockstate() {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177230_c() instanceof ElectricalFurnaceBlock && ((Boolean)state.func_177229_b((Property)ElectricalFurnaceBlock.LIT)).booleanValue() != this.burning()) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)ElectricalFurnaceBlock.LIT, (Comparable)Boolean.valueOf(this.burning())), 2);
            }
        }
    }

    public static class ElectricalFurnaceBlock
    extends EdFurnace.FurnaceBlock
    implements IDecorBlock {
        public ElectricalFurnaceBlock(long config, AbstractBlock.Properties builder, AxisAlignedBB[] unrotatedAABBs) {
            super(config, builder, unrotatedAABBs);
        }

        @Override
        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new ElectricalFurnaceTileEntity();
        }

        @Override
        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
            if (world.func_201670_d()) {
                return ActionResultType.SUCCESS;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof ElectricalFurnaceTileEntity)) {
                return ActionResultType.FAIL;
            }
            if (!(player instanceof ServerPlayerEntity) && !(player instanceof FakePlayer)) {
                return ActionResultType.FAIL;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)te));
            player.func_195066_a(Stats.field_188061_aa);
            return ActionResultType.CONSUME;
        }

        @Override
        public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)));
            if (world.field_72995_K) {
                return;
            }
            if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("inventory")) {
                return;
            }
            CompoundNBT inventory_nbt = stack.func_77978_p().func_74775_l("inventory");
            if (inventory_nbt.isEmpty()) {
                return;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof ElectricalFurnaceTileEntity)) {
                return;
            }
            ElectricalFurnaceTileEntity bte = (ElectricalFurnaceTileEntity)te;
            bte.readnbt(inventory_nbt);
            bte.func_70296_d();
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(bte.burning())));
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void func_180655_c(BlockState state, World world, BlockPos pos, Random rnd) {
        }
    }
}

