/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.libmc.detail;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class Inventories {
    public static boolean areItemStacksIdentical(ItemStack a, ItemStack b) {
        return a.func_77973_b() == b.func_77973_b() && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    public static boolean areItemStacksDifferent(ItemStack a, ItemStack b) {
        return a.func_77973_b() != b.func_77973_b() || !ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    public static IItemHandler itemhandler(World world, BlockPos pos, @Nullable Direction side) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        IItemHandler ih = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).orElse(null);
        if (ih != null) {
            return ih;
        }
        if (side != null && te instanceof ISidedInventory) {
            return new SidedInvWrapper((ISidedInventory)te, side);
        }
        if (te instanceof IInventory) {
            return new InvWrapper((IInventory)te);
        }
        return null;
    }

    public static IItemHandler itemhandler(Entity entity) {
        return entity instanceof IInventory ? new InvWrapper((IInventory)entity) : null;
    }

    public static IItemHandler itemhandler(Entity entity, @Nullable Direction side) {
        return entity instanceof IInventory ? new InvWrapper((IInventory)entity) : null;
    }

    public static ItemStack insert(IItemHandler handler, ItemStack stack, boolean simulate) {
        return ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
    }

    public static ItemStack insert(TileEntity te, @Nullable Direction side, ItemStack stack, boolean simulate) {
        if (te == null) {
            return stack;
        }
        IItemHandler hnd = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).orElse(null);
        if (hnd == null) {
            hnd = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        } else if (side != null && te instanceof ISidedInventory) {
            hnd = new SidedInvWrapper((ISidedInventory)te, side);
        } else if (te instanceof IInventory) {
            hnd = new InvWrapper((IInventory)te);
        }
        return hnd == null ? stack : Inventories.insert(hnd, stack, simulate);
    }

    public static ItemStack insert(World world, BlockPos pos, @Nullable Direction side, ItemStack stack, boolean simulate) {
        return Inventories.insert(world.func_175625_s(pos), side, stack, simulate);
    }

    public static ItemStack extract(@Nullable IItemHandler inventory, @Nullable ItemStack match, int amount, boolean simulate) {
        if (inventory == null || amount <= 0) {
            return ItemStack.field_190927_a;
        }
        int max = inventory.getSlots();
        ItemStack out_stack = ItemStack.field_190927_a;
        for (int i = 0; i < max; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            if (out_stack.func_190926_b()) {
                if (match != null && Inventories.areItemStacksDifferent(stack, match)) continue;
                out_stack = inventory.extractItem(i, amount, simulate);
            } else if (Inventories.areItemStacksIdentical(stack, out_stack)) {
                ItemStack es = inventory.extractItem(i, amount - out_stack.func_190916_E(), simulate);
                out_stack.func_190917_f(es.func_190916_E());
            }
            if (out_stack.func_190916_E() >= amount) break;
        }
        return out_stack;
    }

    private static ItemStack checked(ItemStack stack) {
        return stack.func_190926_b() ? ItemStack.field_190927_a : stack;
    }

    public static ItemStack insert(InventoryRange[] to_ranges, ItemStack stack) {
        ItemStack remaining = stack.func_77946_l();
        for (InventoryRange range : to_ranges) {
            if (!(remaining = range.insert(remaining, false, 0, false, true)).func_190926_b()) continue;
            return remaining;
        }
        return remaining;
    }

    public static void give(PlayerEntity entity, ItemStack stack) {
        ItemHandlerHelper.giveItemToPlayer((PlayerEntity)entity, (ItemStack)stack);
    }

    public static void setItemInPlayerHand(PlayerEntity player, Hand hand, ItemStack stack) {
        if (stack.func_190926_b()) {
            stack = ItemStack.field_190927_a;
        }
        if (hand == Hand.MAIN_HAND) {
            player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)stack);
        } else {
            player.field_71071_by.field_184439_c.set(0, (Object)stack);
        }
    }

    public static IInventory readNbtStacks(CompoundNBT nbt, String key, IInventory target) {
        NonNullList<ItemStack> stacks = Inventories.readNbtStacks(nbt, key, target.func_70302_i_());
        for (int i = 0; i < stacks.size(); ++i) {
            target.func_70299_a(i, (ItemStack)stacks.get(i));
        }
        return target;
    }

    public static NonNullList<ItemStack> readNbtStacks(CompoundNBT nbt, String key, int size) {
        NonNullList stacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        if (nbt == null || !nbt.func_150297_b(key, 10)) {
            return stacks;
        }
        CompoundNBT stacknbt = nbt.func_74775_l(key);
        ItemStackHelper.func_191283_b((CompoundNBT)stacknbt, (NonNullList)stacks);
        return stacks;
    }

    public static CompoundNBT writeNbtStacks(CompoundNBT nbt, String key, NonNullList<ItemStack> stacks, boolean omit_trailing_empty) {
        CompoundNBT stacknbt = new CompoundNBT();
        if (omit_trailing_empty) {
            for (int i = stacks.size() - 1; i >= 0 && ((ItemStack)stacks.get(i)).func_190926_b(); --i) {
                stacks.remove(i);
            }
        }
        ItemStackHelper.func_191282_a((CompoundNBT)stacknbt, stacks);
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        nbt.func_218657_a(key, (INBT)stacknbt);
        return nbt;
    }

    public static CompoundNBT writeNbtStacks(CompoundNBT nbt, String key, NonNullList<ItemStack> stacks) {
        return Inventories.writeNbtStacks(nbt, key, stacks, false);
    }

    public static class StorageInventory
    implements IInventory,
    Iterable<ItemStack> {
        protected final NonNullList<ItemStack> stacks_;
        protected final TileEntity te_;
        protected final int size_;
        protected final int num_rows_;
        protected int stack_limit_ = 64;
        protected BiPredicate<Integer, ItemStack> validator_ = (index, stack) -> true;
        protected Consumer<PlayerEntity> open_action_ = player -> {};
        protected Consumer<PlayerEntity> close_action_ = player -> {};
        protected BiConsumer<Integer, ItemStack> slot_set_action_ = (index, stack) -> {};

        public StorageInventory(TileEntity te, int size) {
            this(te, size, 1);
        }

        public StorageInventory(TileEntity te, int size, int num_rows) {
            this.te_ = te;
            this.size_ = Math.max(size, 1);
            this.stacks_ = NonNullList.func_191197_a((int)this.size_, (Object)ItemStack.field_190927_a);
            this.num_rows_ = MathHelper.func_76125_a((int)num_rows, (int)1, (int)this.size_);
        }

        public CompoundNBT save(CompoundNBT nbt) {
            return ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.stacks_);
        }

        public CompoundNBT save(CompoundNBT nbt, boolean save_empty) {
            return ItemStackHelper.func_191281_a((CompoundNBT)nbt, this.stacks_, (boolean)save_empty);
        }

        public CompoundNBT save(boolean save_empty) {
            return this.save(new CompoundNBT(), save_empty);
        }

        public StorageInventory load(CompoundNBT nbt) {
            this.stacks_.clear();
            ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.stacks_);
            return this;
        }

        public NonNullList<ItemStack> stacks() {
            return this.stacks_;
        }

        public TileEntity getTileEntity() {
            return this.te_;
        }

        public StorageInventory setOpenAction(Consumer<PlayerEntity> fn) {
            this.open_action_ = fn;
            return this;
        }

        public StorageInventory setCloseAction(Consumer<PlayerEntity> fn) {
            this.close_action_ = fn;
            return this;
        }

        public StorageInventory setSlotChangeAction(BiConsumer<Integer, ItemStack> fn) {
            this.slot_set_action_ = fn;
            return this;
        }

        public StorageInventory setStackLimit(int max_slot_stack_size) {
            this.stack_limit_ = Math.max(max_slot_stack_size, 1);
            return this;
        }

        public StorageInventory setValidator(BiPredicate<Integer, ItemStack> validator) {
            this.validator_ = validator;
            return this;
        }

        public BiPredicate<Integer, ItemStack> getValidator() {
            return this.validator_;
        }

        @Override
        public Iterator<ItemStack> iterator() {
            return this.stacks_.iterator();
        }

        public Stream<ItemStack> stream() {
            return this.stacks_.stream();
        }

        public int func_70302_i_() {
            return this.size_;
        }

        public boolean func_191420_l() {
            for (ItemStack stack : this.stacks_) {
                if (stack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return index < this.size_ ? (ItemStack)this.stacks_.get(index) : ItemStack.field_190927_a;
        }

        public ItemStack func_70298_a(int index, int count) {
            return ItemStackHelper.func_188382_a(this.stacks_, (int)index, (int)count);
        }

        public ItemStack func_70304_b(int index) {
            return ItemStackHelper.func_188383_a(this.stacks_, (int)index);
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.stacks_.set(index, (Object)stack);
            if (stack.func_190916_E() != ((ItemStack)this.stacks_.get(index)).func_190916_E() || !Inventories.areItemStacksDifferent((ItemStack)this.stacks_.get(index), stack)) {
                this.slot_set_action_.accept(index, stack);
            }
        }

        public int func_70297_j_() {
            return this.stack_limit_;
        }

        public void func_70296_d() {
            this.te_.func_70296_d();
        }

        public boolean func_70300_a(PlayerEntity player) {
            return this.te_.func_145831_w().func_175625_s(this.te_.func_174877_v()) == this.te_ && this.te_.func_174877_v().func_177951_i((Vector3i)player.func_233580_cy_()) < 64.0;
        }

        public void func_174889_b(PlayerEntity player) {
            this.open_action_.accept(player);
        }

        public void func_174886_c(PlayerEntity player) {
            this.func_70296_d();
            this.close_action_.accept(player);
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return this.validator_.test(index, stack);
        }

        public void func_174888_l() {
            this.stacks_.clear();
            this.func_70296_d();
        }
    }

    public static class InventoryRange
    implements IInventory,
    Iterable<ItemStack> {
        public final IInventory inventory;
        public final int offset;
        public final int size;
        public final int num_rows;
        protected int max_stack_size_ = 64;
        protected BiPredicate<Integer, ItemStack> validator_ = (index, stack) -> true;

        public InventoryRange(IInventory inventory, int offset, int size, int num_rows) {
            this.inventory = inventory;
            this.offset = MathHelper.func_76125_a((int)offset, (int)0, (int)(inventory.func_70302_i_() - 1));
            this.size = MathHelper.func_76125_a((int)size, (int)0, (int)(inventory.func_70302_i_() - this.offset));
            this.num_rows = num_rows;
        }

        public InventoryRange(IInventory inventory, int offset, int size) {
            this(inventory, offset, size, 1);
        }

        public static InventoryRange fromPlayerHotbar(PlayerEntity player) {
            return new InventoryRange((IInventory)player.field_71071_by, 0, 9, 1);
        }

        public static InventoryRange fromPlayerStorage(PlayerEntity player) {
            return new InventoryRange((IInventory)player.field_71071_by, 9, 27, 3);
        }

        public static InventoryRange fromPlayerInventory(PlayerEntity player) {
            return new InventoryRange((IInventory)player.field_71071_by, 0, 36, 4);
        }

        public InventoryRange setValidator(BiPredicate<Integer, ItemStack> validator) {
            this.validator_ = validator;
            return this;
        }

        public BiPredicate<Integer, ItemStack> getValidator() {
            return this.validator_;
        }

        public InventoryRange setMaxStackSize(int count) {
            this.max_stack_size_ = Math.max(count, 1);
            return this;
        }

        public int getMaxStackSize() {
            return this.max_stack_size_;
        }

        public void func_174888_l() {
            this.inventory.func_174888_l();
        }

        public int func_70302_i_() {
            return this.size;
        }

        public boolean func_191420_l() {
            for (int i = 0; i < this.size; ++i) {
                if (this.inventory.func_70301_a(this.offset + i).func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return this.inventory.func_70301_a(this.offset + index);
        }

        public ItemStack func_70298_a(int index, int count) {
            return this.inventory.func_70298_a(this.offset + index, count);
        }

        public ItemStack func_70304_b(int index) {
            return this.inventory.func_70304_b(this.offset + index);
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.inventory.func_70299_a(this.offset + index, stack);
        }

        public int func_70297_j_() {
            return Math.min(this.max_stack_size_, this.inventory.func_70297_j_());
        }

        public void func_70296_d() {
            this.inventory.func_70296_d();
        }

        public boolean func_70300_a(PlayerEntity player) {
            return this.inventory.func_70300_a(player);
        }

        public void func_174889_b(PlayerEntity player) {
            this.inventory.func_174889_b(player);
        }

        public void func_174886_c(PlayerEntity player) {
            this.inventory.func_174886_c(player);
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return this.validator_.test(this.offset + index, stack) && this.inventory.func_94041_b(this.offset + index, stack);
        }

        public int stackMatchCount(ItemStack ref_stack) {
            int n = 0;
            for (int i = 0; i < this.size; ++i) {
                if (!Inventories.areItemStacksIdentical(ref_stack, this.func_70301_a(i))) continue;
                ++n;
            }
            return n;
        }

        public int totalMatchingItemCount(ItemStack ref_stack) {
            int n = 0;
            for (int i = 0; i < this.size; ++i) {
                ItemStack stack = this.func_70301_a(i);
                if (!Inventories.areItemStacksIdentical(ref_stack, stack)) continue;
                n += stack.func_190916_E();
            }
            return n;
        }

        public ItemStack insert(ItemStack input_stack, boolean only_fillup, int limit, boolean reverse, boolean force_group_stacks) {
            int nmax;
            ItemStack stack;
            int sno;
            int i;
            ItemStack mvstack = input_stack.func_77946_l();
            if (mvstack.func_190926_b()) {
                return Inventories.checked(mvstack);
            }
            int limit_left = limit > 0 ? Math.min(limit, mvstack.func_77976_d()) : mvstack.func_77976_d();
            boolean[] matches = new boolean[this.size];
            boolean[] empties = new boolean[this.size];
            int num_matches = 0;
            for (i = 0; i < this.size; ++i) {
                sno = reverse ? this.size - 1 - i : i;
                stack = this.func_70301_a(sno);
                if (stack.func_190926_b()) {
                    empties[sno] = true;
                    continue;
                }
                if (!Inventories.areItemStacksIdentical(stack, mvstack)) continue;
                matches[sno] = true;
                ++num_matches;
            }
            for (i = 0; i < this.size; ++i) {
                int n = sno = reverse ? this.size - 1 - i : i;
                if (empties[sno] || !matches[sno]) continue;
                stack = this.func_70301_a(sno);
                nmax = Math.min(limit_left, stack.func_77976_d() - stack.func_190916_E());
                if (mvstack.func_190916_E() <= nmax) {
                    stack.func_190920_e(stack.func_190916_E() + mvstack.func_190916_E());
                    this.func_70299_a(sno, stack);
                    return ItemStack.field_190927_a;
                }
                stack.func_190917_f(nmax);
                mvstack.func_190918_g(nmax);
                this.func_70299_a(sno, stack);
                limit_left -= nmax;
            }
            if (only_fillup) {
                return Inventories.checked(mvstack);
            }
            if (num_matches > 0 && (force_group_stacks || this.inventory instanceof PlayerInventory)) {
                int sno2;
                int i2;
                int insert_start = -1;
                int insert_end = -1;
                for (i2 = 1; i2 < this.size - 1; ++i2) {
                    int n = sno2 = reverse ? this.size - 1 - i2 : i2;
                    if (insert_start < 0) {
                        if (!matches[sno2]) continue;
                        insert_start = sno2;
                        continue;
                    }
                    if (!matches[sno2]) continue;
                    insert_end = sno2;
                }
                for (i2 = insert_start; i2 < insert_end; ++i2) {
                    int n = sno2 = reverse ? this.size - 1 - i2 : i2;
                    if (!empties[sno2] || !this.func_94041_b(sno2, mvstack)) continue;
                    int nmax2 = Math.min(limit_left, mvstack.func_190916_E());
                    ItemStack moved = mvstack.func_77946_l();
                    moved.func_190920_e(nmax2);
                    mvstack.func_190918_g(nmax2);
                    this.func_70299_a(sno2, moved);
                    return Inventories.checked(mvstack);
                }
                for (i = 1; i < this.size - 1; ++i) {
                    int ii;
                    int n = sno = reverse ? this.size - 1 - i : i;
                    if (!matches[sno]) continue;
                    int n2 = empties[sno - 1] ? sno - 1 : (ii = empties[sno + 1] ? sno + 1 : -1);
                    if (ii < 0 || !this.func_94041_b(ii, mvstack)) continue;
                    nmax = Math.min(limit_left, mvstack.func_190916_E());
                    ItemStack moved = mvstack.func_77946_l();
                    moved.func_190920_e(nmax);
                    mvstack.func_190918_g(nmax);
                    this.func_70299_a(ii, moved);
                    return Inventories.checked(mvstack);
                }
            }
            for (i = 0; i < this.size; ++i) {
                int n = sno = reverse ? this.size - 1 - i : i;
                if (!empties[sno] || !this.func_94041_b(sno, mvstack)) continue;
                int nmax3 = Math.min(limit_left, mvstack.func_190916_E());
                ItemStack placed = mvstack.func_77946_l();
                placed.func_190920_e(nmax3);
                mvstack.func_190918_g(nmax3);
                this.func_70299_a(sno, placed);
                return Inventories.checked(mvstack);
            }
            return Inventories.checked(mvstack);
        }

        public ItemStack insert(ItemStack stack_to_move) {
            return this.insert(stack_to_move, false, 0, false, true);
        }

        public ItemStack extract(ItemStack request_stack) {
            ItemStack stack;
            if (request_stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            ArrayList<ItemStack> matches = new ArrayList<ItemStack>();
            for (int i = 0; i < this.size; ++i) {
                ItemStack stack2 = this.func_70301_a(i);
                if (stack2.func_190926_b() || !Inventories.areItemStacksIdentical(stack2, request_stack)) continue;
                if (stack2.func_77942_o()) {
                    CompoundNBT nbt = stack2.func_77978_p();
                    int n = nbt.func_186856_d();
                    if (n > 0 && nbt.func_74764_b("Damage")) {
                        --n;
                    }
                    if (n > 0) continue;
                }
                matches.add(stack2);
            }
            matches.sort((a, b) -> Integer.compare(a.func_190916_E(), b.func_190916_E()));
            if (matches.isEmpty()) {
                return ItemStack.field_190927_a;
            }
            int n_left = request_stack.func_190916_E();
            ItemStack fetched_stack = ((ItemStack)matches.get(0)).func_77979_a(n_left);
            n_left -= fetched_stack.func_190916_E();
            for (int i = 1; i < matches.size() && n_left > 0; n_left -= stack.func_190916_E(), ++i) {
                stack = ((ItemStack)matches.get(i)).func_77979_a(n_left);
                fetched_stack.func_190917_f(stack.func_190916_E());
            }
            return Inventories.checked(fetched_stack);
        }

        public boolean move(int index, InventoryRange target_range, boolean all_identical_stacks, boolean only_fillup, boolean reverse, boolean force_group_stacks) {
            ItemStack source_stack = this.func_70301_a(index);
            if (source_stack.func_190926_b()) {
                return false;
            }
            if (!all_identical_stacks) {
                ItemStack remaining = target_range.insert(source_stack, only_fillup, 0, reverse, force_group_stacks);
                this.func_70299_a(index, remaining);
                return remaining.func_190916_E() != source_stack.func_190916_E();
            }
            ItemStack remaining = source_stack.func_77946_l();
            this.func_70299_a(index, ItemStack.field_190927_a);
            ItemStack ref_stack = remaining.func_77946_l();
            ref_stack.func_190920_e(ref_stack.func_77976_d());
            for (int i = this.size; i > 0 && !remaining.func_190926_b() && (remaining = target_range.insert(remaining, only_fillup, 0, reverse, force_group_stacks)).func_190926_b(); --i) {
                remaining = this.extract(ref_stack);
            }
            if (!remaining.func_190926_b()) {
                this.func_70299_a(index, remaining);
            }
            return remaining.func_190916_E() != source_stack.func_190916_E();
        }

        public boolean move(int index, InventoryRange target_range) {
            return this.move(index, target_range, false, false, false, true);
        }

        public boolean move(InventoryRange target_range, boolean only_fillup, boolean reverse, boolean force_group_stacks) {
            boolean changed = false;
            for (int i = 0; i < this.size; ++i) {
                changed |= this.move(i, target_range, false, only_fillup, reverse, force_group_stacks);
            }
            return changed;
        }

        public boolean move(InventoryRange target_range, boolean only_fillup) {
            return this.move(target_range, only_fillup, false, true);
        }

        public boolean move(InventoryRange target_range) {
            return this.move(target_range, false, false, true);
        }

        public Stream<ItemStack> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        @Override
        public Iterator<ItemStack> iterator() {
            return new InventoryRangeIterator(this);
        }

        public static class InventoryRangeIterator
        implements Iterator<ItemStack> {
            private final InventoryRange parent_;
            private int index = 0;

            public InventoryRangeIterator(InventoryRange range) {
                this.parent_ = range;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.parent_.size;
            }

            @Override
            public ItemStack next() {
                if (this.index >= this.parent_.size) {
                    throw new NoSuchElementException();
                }
                return this.parent_.func_70301_a(this.index++);
            }
        }
    }

    public static class MappedItemHandler
    implements IItemHandler {
        private BiPredicate<Integer, ItemStack> extraction_predicate_;
        private BiPredicate<Integer, ItemStack> insertion_predicate_;
        private List<Integer> slot_map_;
        private final IInventory inv_;

        public MappedItemHandler(IInventory inv, List<Integer> slot_map, BiPredicate<Integer, ItemStack> extraction_predicate, BiPredicate<Integer, ItemStack> insertion_predicate) {
            this.inv_ = inv;
            this.extraction_predicate_ = extraction_predicate;
            this.insertion_predicate_ = insertion_predicate;
            this.slot_map_ = slot_map;
        }

        public MappedItemHandler(IInventory inv, BiPredicate<Integer, ItemStack> extraction_predicate, BiPredicate<Integer, ItemStack> insertion_predicate) {
            this(inv, IntStream.range(0, inv.func_70302_i_()).boxed().collect(Collectors.toList()), extraction_predicate, insertion_predicate);
        }

        public MappedItemHandler(IInventory inv) {
            this(inv, (i, s) -> true, (i, s) -> true);
        }

        public int hashCode() {
            return this.inv_.hashCode();
        }

        public boolean equals(Object o) {
            return o == this || o != null && this.getClass() == o.getClass() && this.inv_.equals(((MappedItemHandler)o).inv_);
        }

        public int getSlots() {
            return this.slot_map_.size();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return slot >= this.slot_map_.size() ? ItemStack.field_190927_a : this.inv_.func_70301_a(this.slot_map_.get(slot).intValue());
        }

        public int getSlotLimit(int slot) {
            return this.inv_.func_70297_j_();
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (slot >= this.slot_map_.size()) {
                return false;
            }
            return this.insertion_predicate_.test(slot = this.slot_map_.get(slot).intValue(), stack) && this.inv_.func_94041_b(slot, stack);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (slot >= this.slot_map_.size()) {
                return stack;
            }
            if (!this.insertion_predicate_.test(slot = this.slot_map_.get(slot).intValue(), stack)) {
                return stack;
            }
            if (!this.inv_.func_94041_b(slot, stack)) {
                return stack;
            }
            ItemStack sst = this.inv_.func_70301_a(slot);
            int slot_limit = this.inv_.func_70297_j_();
            if (!sst.func_190926_b()) {
                if (sst.func_190916_E() >= Math.min(sst.func_77976_d(), slot_limit)) {
                    return stack;
                }
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)sst)) {
                    return stack;
                }
                int limit = Math.min(stack.func_77976_d(), slot_limit) - sst.func_190916_E();
                if (stack.func_190916_E() <= limit) {
                    if (!simulate) {
                        stack = stack.func_77946_l();
                        stack.func_190917_f(sst.func_190916_E());
                        this.inv_.func_70299_a(slot, stack);
                        this.inv_.func_70296_d();
                    }
                    return ItemStack.field_190927_a;
                }
                stack = stack.func_77946_l();
                if (simulate) {
                    stack.func_190918_g(limit);
                } else {
                    ItemStack diff = stack.func_77979_a(limit);
                    diff.func_190917_f(sst.func_190916_E());
                    this.inv_.func_70299_a(slot, diff);
                    this.inv_.func_70296_d();
                }
                return stack;
            }
            int limit = Math.min(slot_limit, stack.func_77976_d());
            if (stack.func_190916_E() >= limit) {
                stack = stack.func_77946_l();
                if (simulate) {
                    stack.func_190918_g(limit);
                } else {
                    this.inv_.func_70299_a(slot, stack.func_77979_a(limit));
                    this.inv_.func_70296_d();
                }
                return stack;
            }
            if (!simulate) {
                this.inv_.func_70299_a(slot, stack.func_77946_l());
                this.inv_.func_70296_d();
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount <= 0) {
                return ItemStack.field_190927_a;
            }
            if (slot >= this.slot_map_.size()) {
                return ItemStack.field_190927_a;
            }
            slot = this.slot_map_.get(slot);
            ItemStack stack = this.inv_.func_70301_a(slot);
            if (!this.extraction_predicate_.test(slot, stack)) {
                return ItemStack.field_190927_a;
            }
            if (simulate) {
                if (amount < (stack = stack.func_77946_l()).func_190916_E()) {
                    stack.func_190920_e(amount);
                }
            } else {
                stack = this.inv_.func_70298_a(slot, Math.min(stack.func_190916_E(), amount));
                this.inv_.func_70296_d();
            }
            return stack;
        }

        public static LazyOptional<IItemHandler> createGenericHandler(IInventory inv, BiPredicate<Integer, ItemStack> extraction_predicate, BiPredicate<Integer, ItemStack> insertion_predicate, List<Integer> slot_map) {
            return LazyOptional.of(() -> new MappedItemHandler(inv, slot_map, extraction_predicate, insertion_predicate));
        }

        public static LazyOptional<IItemHandler> createGenericHandler(IInventory inv, BiPredicate<Integer, ItemStack> extraction_predicate, BiPredicate<Integer, ItemStack> insertion_predicate) {
            return LazyOptional.of(() -> new MappedItemHandler(inv, extraction_predicate, insertion_predicate));
        }

        public static LazyOptional<IItemHandler> createGenericHandler(IInventory inv) {
            return LazyOptional.of(() -> new MappedItemHandler(inv));
        }

        public static LazyOptional<IItemHandler> createExtractionHandler(IInventory inv, BiPredicate<Integer, ItemStack> extraction_predicate, List<Integer> slot_map) {
            return LazyOptional.of(() -> new MappedItemHandler(inv, slot_map, extraction_predicate, (i, s) -> false));
        }

        public static LazyOptional<IItemHandler> createExtractionHandler(IInventory inv, BiPredicate<Integer, ItemStack> extraction_predicate) {
            return LazyOptional.of(() -> new MappedItemHandler(inv, extraction_predicate, (i, s) -> false));
        }

        public static LazyOptional<IItemHandler> createExtractionHandler(IInventory inv, Integer ... slots) {
            return LazyOptional.of(() -> new MappedItemHandler(inv, Arrays.asList(slots), (i, s) -> true, (i, s) -> false));
        }

        public static LazyOptional<IItemHandler> createExtractionHandler(IInventory inv) {
            return LazyOptional.of(() -> new MappedItemHandler(inv, (i, s) -> true, (i, s) -> false));
        }

        public static LazyOptional<IItemHandler> createInsertionHandler(IInventory inv, BiPredicate<Integer, ItemStack> insertion_predicate, List<Integer> slot_map) {
            return LazyOptional.of(() -> new MappedItemHandler(inv, slot_map, (i, s) -> false, insertion_predicate));
        }

        public static LazyOptional<IItemHandler> createInsertionHandler(IInventory inv, Integer ... slots) {
            return LazyOptional.of(() -> new MappedItemHandler(inv, Arrays.asList(slots), (i, s) -> false, (i, s) -> true));
        }

        public static LazyOptional<IItemHandler> createInsertionHandler(IInventory inv, BiPredicate<Integer, ItemStack> insertion_predicate) {
            return LazyOptional.of(() -> new MappedItemHandler(inv, (i, s) -> false, insertion_predicate));
        }

        public static LazyOptional<IItemHandler> createInsertionHandler(IInventory inv) {
            return LazyOptional.of(() -> new MappedItemHandler(inv, (i, s) -> false, (i, s) -> true));
        }
    }
}

