/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fmllegacy.hooks.BasicEventHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.blocks.StandardEntityBlocks;
import wile.engineersdecor.libmc.detail.Crafting;
import wile.engineersdecor.libmc.detail.Inventories;
import wile.engineersdecor.libmc.detail.Networking;
import wile.engineersdecor.libmc.detail.RfEnergy;
import wile.engineersdecor.libmc.detail.TooltipDisplay;
import wile.engineersdecor.libmc.ui.Guis;

public class EdElectricalFurnace {
    public static void on_config(int speed_percent, int standard_energy_per_tick, boolean with_automatic_inventory_pulling) {
        ElectricalFurnaceTileEntity.on_config(speed_percent, standard_energy_per_tick, with_automatic_inventory_pulling);
    }

    public static class ElectricalFurnaceTileEntity
    extends StandardEntityBlocks.StandardBlockEntity
    implements MenuProvider,
    Nameable {
        private static final RecipeType<SmeltingRecipe> RECIPE_TYPE = RecipeType.f_44108_;
        private static final int DEFAULT_SMELTING_TIME = 200;
        private static final int NUM_OF_FIELDS = 8;
        private static final int TICK_INTERVAL = 4;
        private static final int FIFO_INTERVAL = 20;
        private static final int HEAT_CAPACITY = 200;
        private static final int HEAT_INCREMENT = 20;
        private static final int MAX_BURNTIME = Short.MAX_VALUE;
        private static final int MAX_XP_STORED = 65535;
        private static final int MAX_ENERGY_TRANSFER = 1024;
        private static final int MAX_ENERGY_BUFFER = 32000;
        private static final int MAX_SPEED_SETTING = 3;
        private static final int NUM_OF_SLOTS = 7;
        private static final int SMELTING_INPUT_SLOT_NO = 0;
        private static final int SMELTING_AUX_SLOT_NO = 1;
        private static final int SMELTING_OUTPUT_SLOT_NO = 2;
        private static final int FIFO_INPUT_0_SLOT_NO = 3;
        private static final int FIFO_INPUT_1_SLOT_NO = 4;
        private static final int FIFO_OUTPUT_0_SLOT_NO = 5;
        private static final int FIFO_OUTPUT_1_SLOT_NO = 6;
        public static final int DEFAULT_SPEED_PERCENT = 290;
        public static final int DEFAULT_ENERGY_CONSUMPTION = 16;
        public static final int DEFAULT_SCALED_ENERGY_CONSUMPTION = 64;
        private static boolean with_automatic_inventory_pulling_ = false;
        private static int energy_consumption_ = 64;
        private static int transfer_energy_consumption_ = 8;
        private static int proc_speed_percent_ = 290;
        private static final double[] speed_setting_factor_ = new double[]{0.0, 1.0, 1.5, 2.0};
        private int tick_timer_;
        private int fifo_timer_;
        private double proc_time_elapsed_;
        private int proc_time_needed_;
        private int burntime_left_;
        private int field_is_burning_;
        private float xp_stored_;
        @Nullable
        private Recipe<?> current_recipe_ = null;
        private int fuel_burntime_;
        private int field_proc_time_elapsed_;
        private final Inventories.StorageInventory inventory_;
        private final LazyOptional<IItemHandler> item_handler_;
        private final RfEnergy.Battery battery_;
        private final LazyOptional<IEnergyStorage> energy_handler_;
        private int speed_ = 1;
        private boolean enabled_ = false;
        private int field_power_consumption_;
        private int power_consumption_accumulator_;
        private int power_consumption_timer_;
        protected final ContainerData fields = new ContainerData(){

            public int m_6499_() {
                return 8;
            }

            public int m_6413_(int id) {
                return switch (id) {
                    case 0 -> burntime_left_;
                    case 1 -> battery_.getEnergyStored();
                    case 2 -> (int)proc_time_elapsed_;
                    case 3 -> proc_time_needed_;
                    case 4 -> speed_;
                    case 5 -> battery_.getMaxEnergyStored();
                    case 6 -> field_is_burning_;
                    case 7 -> field_power_consumption_;
                    default -> 0;
                };
            }

            public void m_8050_(int id, int value) {
                switch (id) {
                    case 0: {
                        burntime_left_ = value;
                        break;
                    }
                    case 1: {
                        battery_.setEnergyStored(value);
                        break;
                    }
                    case 2: {
                        proc_time_elapsed_ = value;
                        break;
                    }
                    case 3: {
                        proc_time_needed_ = value;
                        break;
                    }
                    case 4: {
                        speed_ = value;
                        break;
                    }
                    case 5: {
                        battery_.setMaxEnergyStored(value);
                        break;
                    }
                    case 6: {
                        field_is_burning_ = value;
                        break;
                    }
                    case 7: {
                        field_power_consumption_ = value;
                    }
                }
            }
        };

        public static void on_config(int speed_percent, int standard_energy_per_tick, boolean with_automatic_inventory_pulling) {
            proc_speed_percent_ = Mth.m_14045_((int)speed_percent, (int)10, (int)800);
            energy_consumption_ = Mth.m_14045_((int)standard_energy_per_tick, (int)4, (int)4096) * 4;
            transfer_energy_consumption_ = Mth.m_14045_((int)(energy_consumption_ / 8), (int)8, (int)20);
            with_automatic_inventory_pulling_ = with_automatic_inventory_pulling;
            ModConfig.log("Config electrical furnace speed:" + proc_speed_percent_ + "%, heat-loss: 1K/t, heating consumption:" + energy_consumption_ / 4 + "rf/t.");
        }

        public ElectricalFurnaceTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.TET_SMALL_ELECTRICAL_FURNACE, pos, state);
            this.inventory_ = new Inventories.StorageInventory(this, 7){

                @Override
                public void m_6836_(int index, ItemStack stack) {
                    ItemStack slot_stack = (ItemStack)this.stacks_.get(index);
                    boolean already_in_slot = !stack.m_41619_() && Inventories.areItemStacksIdentical(stack, slot_stack);
                    this.stacks_.set(index, (Object)stack);
                    if (stack.m_41613_() > this.m_6893_()) {
                        stack.m_41764_(this.m_6893_());
                    }
                    if (index == 0 && !already_in_slot) {
                        proc_time_needed_ = Crafting.getSmeltingTimeNeeded(RECIPE_TYPE, f_58857_, stack);
                        proc_time_elapsed_ = 0.0;
                        this.m_6596_();
                    }
                }
            };
            this.inventory_.setValidator((index, stack) -> switch (index) {
                case 0, 3, 4 -> true;
                default -> false;
            });
            this.item_handler_ = Inventories.MappedItemHandler.createGenericHandler(this.inventory_, (slot, stack) -> slot == 5 || slot == 6, (slot, stack) -> slot == 3 || slot == 4, Arrays.asList(5, 6, 3, 4));
            this.battery_ = new RfEnergy.Battery(32000, 1024, 0);
            this.energy_handler_ = this.battery_.createEnergyHandler();
        }

        public void reset() {
            this.inventory_.m_6211_();
            this.burntime_left_ = 0;
            this.proc_time_elapsed_ = 0.0;
            this.proc_time_needed_ = 0;
            this.fifo_timer_ = 0;
            this.tick_timer_ = 0;
            this.battery_.clear();
            this.speed_ = 1;
            this.field_is_burning_ = 0;
        }

        public CompoundTag reset_getnbt() {
            CompoundTag nbt = new CompoundTag();
            this.writenbt(nbt);
            this.reset();
            return nbt;
        }

        public void readnbt(CompoundTag nbt) {
            this.burntime_left_ = nbt.m_128451_("BurnTime");
            this.proc_time_elapsed_ = nbt.m_128451_("CookTime");
            this.proc_time_needed_ = nbt.m_128451_("CookTimeTotal");
            this.xp_stored_ = nbt.m_128457_("XpStored");
            this.speed_ = nbt.m_128451_("SpeedSetting");
            this.speed_ = this.speed_ < 0 ? 1 : Math.min(this.speed_, 3);
            this.battery_.load(nbt, "Energy");
            this.inventory_.load(nbt);
        }

        protected void writenbt(CompoundTag nbt) {
            nbt.m_128405_("BurnTime", Mth.m_14045_((int)this.burntime_left_, (int)0, (int)200));
            nbt.m_128405_("CookTime", Mth.m_14045_((int)((int)this.proc_time_elapsed_), (int)0, (int)Short.MAX_VALUE));
            nbt.m_128405_("CookTimeTotal", Mth.m_14045_((int)this.proc_time_needed_, (int)0, (int)Short.MAX_VALUE));
            nbt.m_128405_("SpeedSetting", Mth.m_14045_((int)this.speed_, (int)-1, (int)3));
            nbt.m_128350_("XpStored", Mth.m_14036_((float)this.xp_stored_, (float)0.0f, (float)65535.0f));
            this.battery_.save(nbt, "Energy");
            this.inventory_.save(nbt);
        }

        public int getComparatorOutput() {
            return this.battery_.isEmpty() ? 0 : (this.inventory_.m_8020_(4).m_41619_() ? 0 : 5) + (this.inventory_.m_8020_(3).m_41619_() ? 0 : 5) + (this.inventory_.m_8020_(0).m_41619_() ? 0 : 5);
        }

        public void m_142466_(CompoundTag nbt) {
            super.m_142466_(nbt);
            this.readnbt(nbt);
        }

        public CompoundTag m_6945_(CompoundTag nbt) {
            super.m_6945_(nbt);
            this.writenbt(nbt);
            return nbt;
        }

        public void m_7651_() {
            super.m_7651_();
            this.item_handler_.invalidate();
            this.energy_handler_.invalidate();
        }

        public Component m_7755_() {
            Block block = this.m_58900_().m_60734_();
            return new TextComponent(block != null ? block.m_7705_() : "Small electrical furnace");
        }

        public Component m_5446_() {
            return super.m_5446_();
        }

        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
            return new ElectricalFurnaceContainer(id, inventory, this.inventory_, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.f_58858_), this.fields);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return this.item_handler_.cast();
            }
            if (capability == CapabilityEnergy.ENERGY) {
                return this.energy_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        @Override
        public void tick() {
            boolean update_blockstate;
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 4;
            if (!(this.f_58857_.m_8055_(this.f_58858_).m_60734_() instanceof ElectricalFurnaceBlock)) {
                return;
            }
            boolean was_burning = this.burning();
            if (was_burning) {
                this.burntime_left_ -= 4;
            }
            if (this.burntime_left_ < 0) {
                this.burntime_left_ = 0;
            }
            if (this.f_58857_.m_5776_()) {
                return;
            }
            int battery_energy = this.battery_.getEnergyStored();
            boolean dirty = update_blockstate = was_burning != this.burning();
            boolean shift_in = false;
            boolean shift_out = false;
            if (--this.fifo_timer_ <= 0) {
                this.fifo_timer_ = 5;
                if (this.transferItems(5, 6, 64)) {
                    dirty = true;
                } else {
                    shift_out = true;
                }
                if (this.transferItems(2, 5, 64)) {
                    dirty = true;
                }
                if (this.transferItems(3, 0, 64)) {
                    dirty = true;
                }
                if (this.transferItems(4, 3, 64)) {
                    dirty = true;
                } else {
                    shift_in = true;
                }
            }
            if (this.battery_.getEnergyStored() < this.energy_consumption()) {
                this.enabled_ = false;
            } else if (this.battery_.getEnergyStored() >= 16000) {
                this.enabled_ = true;
            }
            if (!this.inventory_.m_8020_(0).m_41619_() && this.enabled_ && this.speed_ > 0) {
                boolean can_smelt;
                Recipe<?> last_recipe = this.currentRecipe();
                this.updateCurrentRecipe();
                if (this.currentRecipe() != last_recipe) {
                    this.proc_time_elapsed_ = 0.0;
                    this.proc_time_needed_ = this.getSmeltingTimeNeeded(this.f_58857_, this.inventory_.m_8020_(0));
                }
                if (!(can_smelt = this.canSmeltCurrentItem()) && this.getSmeltingResult(this.inventory_.m_8020_(0)).m_41619_()) {
                    if (this.transferItems(0, 2, 1)) {
                        dirty = true;
                    }
                } else {
                    int speed = Mth.m_14045_((int)(this.battery_.getSOC() >= 25 ? this.speed_ : 1), (int)0, (int)3);
                    if (!this.burning() && can_smelt && this.heat_up(speed)) {
                        dirty = true;
                        update_blockstate = true;
                    }
                    if (this.burning() && can_smelt) {
                        if (this.heat_up(speed)) {
                            dirty = true;
                        }
                        this.proc_time_elapsed_ += (double)((int)((double)(4 * proc_speed_percent_) * speed_setting_factor_[speed] / 100.0));
                        if (this.proc_time_elapsed_ >= (double)this.proc_time_needed_) {
                            this.proc_time_elapsed_ = 0.0;
                            this.proc_time_needed_ = this.getSmeltingTimeNeeded(this.f_58857_, this.inventory_.m_8020_(0));
                            this.smeltCurrentItem();
                            dirty = true;
                            shift_out = true;
                        }
                    } else {
                        this.proc_time_elapsed_ = 0.0;
                    }
                }
            } else if (this.proc_time_elapsed_ > 0.0) {
                this.proc_time_elapsed_ -= (double)(this.inventory_.m_8020_(0).m_41619_() ? 20 : 1);
                if (this.proc_time_elapsed_ < 0.0) {
                    this.proc_time_elapsed_ = 0.0;
                    shift_out = true;
                    update_blockstate = true;
                }
            }
            if (update_blockstate) {
                dirty = true;
                this.sync_blockstate();
            }
            if (this.adjacent_inventory_shift(shift_in, shift_out)) {
                dirty = true;
            }
            this.field_is_burning_ = this.burning() ? 1 : 0;
            this.power_consumption_timer_ += 4;
            this.power_consumption_accumulator_ += this.battery_.getEnergyStored() - battery_energy;
            if (this.power_consumption_timer_ >= 20) {
                this.field_power_consumption_ = this.power_consumption_accumulator_ / this.power_consumption_timer_;
                this.power_consumption_accumulator_ = 0;
                this.power_consumption_timer_ = 0;
            }
            if (dirty) {
                this.m_6596_();
            }
        }

        private boolean is_accepted_hopper(ItemStack stack) {
            return stack.m_41720_() == Blocks.f_50332_.m_5456_() || stack.m_41720_() == ModContent.FACTORY_HOPPER.m_5456_();
        }

        private boolean transferItems(int index_from, int index_to, int count) {
            ItemStack from = this.inventory_.m_8020_(index_from);
            if (from.m_41619_()) {
                return false;
            }
            ItemStack to = this.inventory_.m_8020_(index_to);
            if (from.m_41613_() < count) {
                count = from.m_41613_();
            }
            if (count <= 0) {
                return false;
            }
            boolean changed = true;
            if (to.m_41619_()) {
                this.inventory_.m_6836_(index_to, from.m_41620_(count));
            } else if (to.m_41613_() >= to.m_41741_()) {
                changed = false;
            } else if (Inventories.areItemStacksDifferent(from, to)) {
                changed = false;
            } else if (to.m_41613_() + count >= to.m_41741_()) {
                from.m_41774_(to.m_41741_() - to.m_41613_());
                to.m_41764_(to.m_41741_());
            } else {
                from.m_41774_(count);
                to.m_41769_(count);
            }
            if (from.m_41619_() && from != ItemStack.f_41583_) {
                this.inventory_.m_6836_(index_from, ItemStack.f_41583_);
                changed = true;
            }
            return changed;
        }

        private boolean adjacent_inventory_shift(boolean inp, boolean out) {
            IItemHandler hnd;
            BlockEntity te;
            boolean dirty = false;
            if (this.battery_.getEnergyStored() < transfer_energy_consumption_) {
                return false;
            }
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            if (!(state.m_60734_() instanceof ElectricalFurnaceBlock)) {
                return false;
            }
            Direction out_facing = (Direction)state.m_61143_((Property)ElectricalFurnaceBlock.HORIZONTAL_FACING);
            if (out && !this.inventory_.m_8020_(6).m_41619_() && (te = this.f_58857_.m_7702_(this.f_58858_.m_142300_(out_facing))) != null && (hnd = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, out_facing).orElse(null)) != null) {
                ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)hnd, (ItemStack)this.inventory_.m_8020_(6).m_41777_(), (boolean)false);
                this.inventory_.m_6836_(6, remaining);
                this.battery_.draw(transfer_energy_consumption_);
                dirty = true;
            }
            if (with_automatic_inventory_pulling_ || this.is_accepted_hopper(this.inventory_.m_8020_(1))) {
                Direction inp_facing = ((Direction)state.m_61143_((Property)ElectricalFurnaceBlock.HORIZONTAL_FACING)).m_122424_();
                if (inp && this.inventory_.m_8020_(4).m_41619_() && this.battery_.getEnergyStored() >= transfer_energy_consumption_) {
                    int max_count = Mth.m_14045_((int)(transfer_energy_consumption_ <= 0 ? 64 : this.battery_.getEnergyStored() / transfer_energy_consumption_), (int)1, (int)64);
                    ItemStack retrieved = Inventories.extract(Inventories.itemhandler(this.f_58857_, this.f_58858_.m_142300_(inp_facing), inp_facing), null, max_count, false);
                    if (!retrieved.m_41619_()) {
                        this.inventory_.m_6836_(4, retrieved);
                        this.battery_.draw(max_count * transfer_energy_consumption_);
                        dirty = true;
                    }
                }
            }
            return dirty;
        }

        private int energy_consumption() {
            return this.energy_consumption(this.speed_);
        }

        private int energy_consumption(int speed) {
            return switch (speed) {
                case 1 -> energy_consumption_;
                case 2 -> energy_consumption_ * 2;
                case 3 -> energy_consumption_ * 4;
                default -> 0;
            };
        }

        private boolean heat_up(int speed) {
            if (!this.enabled_) {
                return false;
            }
            int p = this.energy_consumption(speed);
            if (p <= 0 || !this.battery_.draw(p)) {
                return false;
            }
            this.burntime_left_ = Math.min(this.burntime_left_ + 20, 200);
            return true;
        }

        private void sync_blockstate() {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            if (state.m_60734_() instanceof ElectricalFurnaceBlock && ((Boolean)state.m_61143_((Property)ElectricalFurnaceBlock.LIT)).booleanValue() != this.burning()) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)ElectricalFurnaceBlock.LIT, (Comparable)Boolean.valueOf(this.burning())), 2);
            }
        }

        @Nullable
        public static <T extends AbstractCookingRecipe> T getSmeltingResult(RecipeType<T> recipe_type, Level world, ItemStack stack) {
            if (stack.m_41619_()) {
                return null;
            }
            SimpleContainer inventory = new SimpleContainer(3);
            inventory.m_6836_(0, stack);
            return (T)((AbstractCookingRecipe)world.m_7465_().m_44015_(recipe_type, (Container)inventory, world).orElse(null));
        }

        public boolean burning() {
            return this.burntime_left_ > 0;
        }

        public int getSmeltingTimeNeeded(Level world, ItemStack stack) {
            if (stack.m_41619_()) {
                return 0;
            }
            SmeltingRecipe recipe = ElectricalFurnaceTileEntity.getSmeltingResult(RECIPE_TYPE, world, stack);
            if (recipe == null) {
                return 0;
            }
            int t = recipe.m_43753_();
            return t <= 0 ? 200 : t;
        }

        protected boolean canSmeltCurrentItem() {
            if (this.currentRecipe() == null || this.inventory_.m_8020_(0).m_41619_()) {
                return false;
            }
            ItemStack recipe_result_items = this.getSmeltingResult(this.inventory_.m_8020_(0));
            if (recipe_result_items.m_41619_()) {
                return false;
            }
            ItemStack result_stack = this.inventory_.m_8020_(2);
            if (result_stack.m_41619_()) {
                return true;
            }
            if (!result_stack.m_41656_(recipe_result_items)) {
                return false;
            }
            if (result_stack.m_41613_() + recipe_result_items.m_41613_() <= this.inventory_.m_6893_() && result_stack.m_41613_() + recipe_result_items.m_41613_() <= result_stack.m_41741_()) {
                return true;
            }
            return result_stack.m_41613_() + recipe_result_items.m_41613_() <= recipe_result_items.m_41741_();
        }

        protected void smeltCurrentItem() {
            if (!this.canSmeltCurrentItem()) {
                return;
            }
            ItemStack smelting_input_stack = this.inventory_.m_8020_(0);
            ItemStack recipe_result_items = this.getSmeltingResult(smelting_input_stack);
            ItemStack smelting_output_stack = this.inventory_.m_8020_(2);
            float xp = this.getCurrentSmeltingXp(smelting_output_stack);
            if (smelting_output_stack.m_41619_()) {
                this.inventory_.m_6836_(2, recipe_result_items.m_41777_());
            } else if (smelting_output_stack.m_41720_() == recipe_result_items.m_41720_()) {
                smelting_output_stack.m_41769_(recipe_result_items.m_41613_());
            }
            smelting_input_stack.m_41774_(1);
            this.xp_stored_ += xp;
        }

        public static int getFuelBurntime(Level world, ItemStack stack) {
            if (stack.m_41619_()) {
                return 0;
            }
            int t = ForgeHooks.getBurnTime((ItemStack)stack, null);
            return Math.max(t, 0);
        }

        public static boolean isFuel(Level world, ItemStack stack) {
            return ElectricalFurnaceTileEntity.getFuelBurntime(world, stack) > 0 || stack.m_41720_() == Items.f_42448_;
        }

        public int consumeSmeltingExperience(ItemStack stack) {
            if (this.xp_stored_ < 1.0f) {
                return 0;
            }
            float xp = this.xp_stored_;
            if (xp >= 15.0f) {
                xp /= 2.0f;
            }
            xp = Math.min((float)Math.floor(xp), 150.0f);
            this.xp_stored_ -= xp;
            return (int)xp;
        }

        public ItemStack getSmeltingResult(ItemStack stack) {
            return this.currentRecipe() == null ? ItemStack.f_41583_ : this.currentRecipe().m_8043_();
        }

        public float getCurrentSmeltingXp(ItemStack stack) {
            float xp = this.currentRecipe() instanceof AbstractCookingRecipe ? ((AbstractCookingRecipe)this.currentRecipe()).m_43750_() : stack.m_41720_().getSmeltingExperience(stack);
            return xp <= 0.0f ? 0.7f : xp;
        }

        public static boolean canSmelt(Level world, ItemStack stack) {
            return ElectricalFurnaceTileEntity.getSmeltingResult(RECIPE_TYPE, world, stack) != null;
        }

        @Nullable
        protected Recipe<?> currentRecipe() {
            return this.current_recipe_;
        }

        protected void updateCurrentRecipe() {
            this.setCurrentRecipe((Recipe<?>)ElectricalFurnaceTileEntity.getSmeltingResult(RECIPE_TYPE, this.m_58904_(), this.inventory_.m_8020_(0)));
        }

        protected void setCurrentRecipe(Recipe<?> recipe) {
            this.current_recipe_ = recipe;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ElectricalFurnaceGui
    extends Guis.ContainerGui<ElectricalFurnaceContainer> {
        public ElectricalFurnaceGui(ElectricalFurnaceContainer container, Inventory player_inventory, Component title) {
            super(container, player_inventory, title, "textures/gui/small_electrical_furnace_gui.png");
        }

        @Override
        public void m_7856_() {
            super.m_7856_();
            String prefix = ModContent.SMALL_ELECTRICAL_FURNACE.m_7705_() + ".tooltips.";
            int x0 = this.getGuiLeft();
            int y0 = this.getGuiTop();
            Slot aux = ((ElectricalFurnaceContainer)this.f_97732_).m_38853_(1);
            this.tooltip_.init(new TooltipDisplay.TipRange(x0 + 135, y0 + 50, 25, 25, (Component)new TranslatableComponent(prefix + "speed")), new TooltipDisplay.TipRange(x0 + aux.f_40220_, y0 + aux.f_40221_, 16, 16, (Component)new TranslatableComponent(prefix + "auxslot")), new TooltipDisplay.TipRange(x0 + 80, y0 + 55, 50, 14, () -> {
                int soc = ((ElectricalFurnaceContainer)this.m_6262_()).field(1) * 100 / Math.max(((ElectricalFurnaceContainer)this.m_6262_()).field(5), 1);
                int consumption = ((ElectricalFurnaceContainer)this.m_6262_()).field(7);
                return new TranslatableComponent(prefix + "capacitors", new Object[]{soc, consumption});
            }));
        }

        @Override
        protected void renderBgWidgets(PoseStack mx, float partialTicks, int mouseX, int mouseY) {
            int x0 = this.f_97735_;
            int y0 = this.f_97736_;
            int w = this.f_97726_;
            int h = this.f_97727_;
            this.m_93228_(mx, x0, y0, 0, 0, w, h);
            if (((ElectricalFurnaceContainer)this.m_6262_()).field(6) != 0) {
                int hi = 13;
                int k = this.heat_px(13);
                this.m_93228_(mx, x0 + 62, y0 + 55 + 13 - k, 177, 13 - k, 13, k);
            }
            this.m_93228_(mx, x0 + 79, y0 + 30, 176, 15, 1 + this.progress_px(17), 15);
            int we = this.energy_px(32, 8);
            if (we > 0) {
                this.m_93228_(mx, x0 + 90, y0 + 54, 185, 30, we, 13);
            }
            switch (((ElectricalFurnaceContainer)this.m_6262_()).field(4)) {
                case 0: {
                    this.m_93228_(mx, x0 + 144, y0 + 57, 180, 57, 6, 9);
                    break;
                }
                case 1: {
                    this.m_93228_(mx, x0 + 142, y0 + 58, 190, 58, 9, 6);
                    break;
                }
                case 2: {
                    this.m_93228_(mx, x0 + 144, y0 + 56, 200, 57, 6, 9);
                    break;
                }
                case 3: {
                    this.m_93228_(mx, x0 + 143, y0 + 58, 210, 58, 9, 6);
                    break;
                }
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
            this.tooltip_.resetTimer();
            ElectricalFurnaceContainer container = (ElectricalFurnaceContainer)this.m_6262_();
            int mx = (int)(mouseX - (double)this.getGuiLeft() + 0.5);
            int my = (int)(mouseY - (double)this.getGuiTop() + 0.5);
            if (!this.m_6774_(136, 48, 28, 28, mouseX, mouseY)) {
                return super.m_6375_(mouseX, mouseY, mouseButton);
            }
            if (this.m_6774_(144, 64, 6, 10, mouseX, mouseY)) {
                container.onGuiAction("speed", 0);
            } else if (this.m_6774_(134, 58, 10, 6, mouseX, mouseY)) {
                container.onGuiAction("speed", 1);
            } else if (this.m_6774_(144, 48, 6, 10, mouseX, mouseY)) {
                container.onGuiAction("speed", 2);
            } else if (this.m_6774_(150, 58, 10, 6, mouseX, mouseY)) {
                container.onGuiAction("speed", 3);
            }
            return true;
        }

        private int progress_px(int pixels) {
            int tc = ((ElectricalFurnaceContainer)this.m_6262_()).field(2);
            int T = ((ElectricalFurnaceContainer)this.m_6262_()).field(3);
            return T > 0 && tc > 0 ? tc * pixels / T : 0;
        }

        private int heat_px(int pixels) {
            int k = ((ElectricalFurnaceContainer)this.m_6262_()).field(0) * (pixels + 1) / 200;
            return Math.min(k, pixels);
        }

        private int energy_px(int maxwidth, int quantization) {
            int emax = ((ElectricalFurnaceContainer)this.m_6262_()).field(5);
            int k = maxwidth * ((ElectricalFurnaceContainer)this.m_6262_()).field(1) * 9 / 8 / ((emax > 0 ? emax : 1) + 1);
            int n = k = k >= maxwidth - 2 ? maxwidth : k;
            if (quantization > 0) {
                k = (k + quantization / 2) / quantization * quantization;
            }
            return k;
        }
    }

    public static class ElectricalFurnaceContainer
    extends AbstractContainerMenu
    implements Networking.INetworkSynchronisableContainer {
        private static final int PLAYER_INV_START_SLOTNO = 7;
        protected final Player player_;
        protected final Container inventory_;
        protected final ContainerLevelAccess wpc_;
        private final ContainerData fields_;
        private final RecipeType<? extends AbstractCookingRecipe> recipe_type_;

        public int field(int index) {
            return this.fields_.m_6413_(index);
        }

        public Player player() {
            return this.player_;
        }

        public Container inventory() {
            return this.inventory_;
        }

        public Level world() {
            return this.player_.f_19853_;
        }

        public ElectricalFurnaceContainer(int cid, Inventory player_inventory) {
            this(cid, player_inventory, (Container)new SimpleContainer(7), ContainerLevelAccess.f_39287_, (ContainerData)new SimpleContainerData(8));
        }

        private ElectricalFurnaceContainer(int cid, Inventory player_inventory, Container block_inventory, ContainerLevelAccess wpc, ContainerData fields) {
            super(ModContent.CT_SMALL_ELECTRICAL_FURNACE, cid);
            this.player_ = player_inventory.f_35978_;
            this.inventory_ = block_inventory;
            this.wpc_ = wpc;
            this.fields_ = fields;
            this.recipe_type_ = ElectricalFurnaceTileEntity.RECIPE_TYPE;
            this.m_38897_(new Slot(this.inventory_, 0, 59, 28));
            this.m_38897_(new Slot(this.inventory_, 1, 16, 52));
            this.m_38897_(new OutputSlot(this.player_, this.inventory_, 2, 101, 28));
            this.m_38897_(new Slot(this.inventory_, 3, 34, 28));
            this.m_38897_(new Slot(this.inventory_, 4, 16, 28));
            this.m_38897_(new OutputSlot(this.player_, this.inventory_, 5, 126, 28));
            this.m_38897_(new OutputSlot(this.player_, this.inventory_, 6, 144, 28));
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)player_inventory, x, 8 + x * 18, 144));
            }
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.m_38897_(new Slot((Container)player_inventory, x + y * 9 + 9, 8 + x * 18, 86 + y * 18));
                }
            }
            this.m_38884_(this.fields_);
        }

        public boolean m_6875_(Player player) {
            return this.inventory_.m_6542_(player);
        }

        public ItemStack m_7648_(Player player, int index) {
            Slot slot = this.m_38853_(index);
            if (slot == null || !slot.m_6657_()) {
                return ItemStack.f_41583_;
            }
            ItemStack slot_stack = slot.m_7993_();
            ItemStack transferred = slot_stack.m_41777_();
            if (index == 2 || index == 5 || index == 6) {
                if (!this.m_38903_(slot_stack, 7, 43, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slot_stack, transferred);
            } else if (index == 0 || index == 3 || index == 4) {
                if (!this.m_38903_(slot_stack, 7, 43, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (index == 1) {
                if (!this.m_38903_(slot_stack, 7, 43, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (index >= 7 && index <= 43) {
                if (ElectricalFurnaceTileEntity.canSmelt(this.world(), slot_stack) ? !this.m_38903_(slot_stack, 0, 1, false) && !this.m_38903_(slot_stack, 3, 4, false) && !this.m_38903_(slot_stack, 4, 5, false) : (index >= 7 && index < 34 ? !this.m_38903_(slot_stack, 34, 43, false) : index >= 34 && index < 43 && !this.m_38903_(slot_stack, 7, 34, false))) {
                    return ItemStack.f_41583_;
                }
            } else {
                return ItemStack.f_41583_;
            }
            if (slot_stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slot_stack.m_41613_() == transferred.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slot_stack);
            return transferred;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(CompoundTag nbt) {
            Networking.PacketContainerSyncClientToServer.sendToServer(this.f_38840_, nbt);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String key, int value) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_(key, value);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.f_38840_, nbt);
        }

        @Override
        public void onServerPacketReceived(int windowId, CompoundTag nbt) {
        }

        @Override
        public void onClientPacketReceived(int windowId, Player player, CompoundTag nbt) {
            if (!(this.inventory_ instanceof Inventories.StorageInventory)) {
                return;
            }
            BlockEntity blockEntity = ((Inventories.StorageInventory)this.inventory_).getTileEntity();
            if (!(blockEntity instanceof ElectricalFurnaceTileEntity)) {
                return;
            }
            ElectricalFurnaceTileEntity te = (ElectricalFurnaceTileEntity)blockEntity;
            if (nbt.m_128441_("speed")) {
                te.speed_ = Mth.m_14045_((int)nbt.m_128451_("speed"), (int)0, (int)3);
            }
            te.m_6596_();
        }

        public static class OutputSlot
        extends Slot {
            private final Container inventory_;
            private final Player player_;
            private int removeCount = 0;

            public OutputSlot(Player player, Container inventory, int index, int xpos, int ypos) {
                super(inventory, index, xpos, ypos);
                this.inventory_ = inventory;
                this.player_ = player;
            }

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public ItemStack m_6201_(int amount) {
                this.removeCount += this.m_6657_() ? Math.min(amount, this.m_7993_().m_41613_()) : 0;
                return super.m_6201_(amount);
            }

            public void m_142406_(Player thePlayer, ItemStack stack) {
                this.m_5845_(stack);
                super.m_142406_(thePlayer, stack);
            }

            protected void m_7169_(ItemStack stack, int amount) {
                this.removeCount += amount;
                this.m_5845_(stack);
            }

            protected void m_5845_(ItemStack stack) {
                BlockEntity blockEntity;
                stack.m_41678_(this.player_.f_19853_, this.player_, this.removeCount);
                if (!this.player_.f_19853_.m_5776_() && this.inventory_ instanceof Inventories.StorageInventory && (blockEntity = ((Inventories.StorageInventory)this.inventory_).getTileEntity()) instanceof ElectricalFurnaceTileEntity) {
                    int k;
                    ElectricalFurnaceTileEntity te = (ElectricalFurnaceTileEntity)blockEntity;
                    for (int xp = te.consumeSmeltingExperience(stack); xp > 0; xp -= k) {
                        k = ExperienceOrb.m_20782_((int)xp);
                        this.player_.f_19853_.m_7967_((Entity)new ExperienceOrb(this.player_.f_19853_, (double)this.player_.m_142538_().m_123341_(), (double)this.player_.m_142538_().m_123342_() + 0.5, (double)this.player_.m_142538_().m_123343_() + 0.5, k));
                    }
                }
                this.removeCount = 0;
                BasicEventHooks.firePlayerSmeltedEvent((Player)this.player_, (ItemStack)stack);
            }
        }
    }

    public static class ElectricalFurnaceBlock
    extends StandardBlocks.Horizontal
    implements StandardEntityBlocks.IStandardEntityBlock<ElectricalFurnaceTileEntity> {
        public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

        public ElectricalFurnaceBlock(long config, BlockBehaviour.Properties builder, AABB[] unrotatedAABBs) {
            super(config, builder, unrotatedAABBs);
        }

        @Override
        @Nullable
        public BlockEntityType<ElectricalFurnaceTileEntity> getBlockEntityType() {
            return ModContent.TET_SMALL_ELECTRICAL_FURNACE;
        }

        @Override
        public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
            return Shapes.m_83144_();
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{LIT});
        }

        public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
            return (Boolean)state.m_61143_((Property)LIT) != false ? super.getLightEmission(state, world, pos) : 0;
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            return (BlockState)super.m_5573_(context).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
        }

        public boolean m_7278_(BlockState state) {
            return true;
        }

        public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
            BlockEntity te = world.m_7702_(pos);
            return te instanceof ElectricalFurnaceTileEntity ? ((ElectricalFurnaceTileEntity)te).getComparatorOutput() : 0;
        }

        public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
            return false;
        }

        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
            return this.useOpenGui(state, world, pos, player);
        }

        public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
            if (world.f_46443_) {
                return;
            }
            if (!stack.m_41782_() || !stack.m_41783_().m_128441_("inventory")) {
                return;
            }
            CompoundTag inventory_nbt = stack.m_41783_().m_128469_("inventory");
            if (inventory_nbt.m_128456_()) {
                return;
            }
            BlockEntity te = world.m_7702_(pos);
            BlockEntity blockEntity = te;
            if (!(blockEntity instanceof ElectricalFurnaceTileEntity)) {
                return;
            }
            ElectricalFurnaceTileEntity bte = (ElectricalFurnaceTileEntity)blockEntity;
            bte.readnbt(inventory_nbt);
            bte.m_6596_();
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(bte.burning())));
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, Level world, BlockEntity te, boolean explosion) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (world.f_46443_) {
                return stacks;
            }
            if (!(te instanceof ElectricalFurnaceTileEntity)) {
                return stacks;
            }
            if (!explosion) {
                ItemStack stack = new ItemStack((ItemLike)this, 1);
                CompoundTag inventory_nbt = ((ElectricalFurnaceTileEntity)te).reset_getnbt();
                if (!inventory_nbt.m_128456_()) {
                    CompoundTag nbt = new CompoundTag();
                    nbt.m_128365_("inventory", (Tag)inventory_nbt);
                    stack.m_41751_(nbt);
                }
                stacks.add(stack);
            } else {
                for (ItemStack stack : ((ElectricalFurnaceTileEntity)te).inventory_) {
                    stacks.add(stack);
                }
                ((ElectricalFurnaceTileEntity)te).reset();
            }
            return stacks;
        }
    }
}

