/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import wile.engineersdecor.libmc.blocks.StandardBlocks;

public class EdHatchBlock
extends StandardBlocks.HorizontalWaterLoggable {
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    protected final ArrayList<VoxelShape> vshapes_open;

    public EdHatchBlock(long config, BlockBehaviour.Properties builder, AABB unrotatedAABBClosed, AABB unrotatedAABBOpen) {
        super(config, builder, unrotatedAABBClosed);
        this.vshapes_open = EdHatchBlock.makeHorizontalShapeLookup(new AABB[]{unrotatedAABBOpen});
        this.m_49959_((BlockState)((BlockState)super.m_49966_().m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public EdHatchBlock(long config, BlockBehaviour.Properties builder, AABB[] unrotatedAABBsClosed, AABB[] unrotatedAABBsOpen) {
        super(config, builder, unrotatedAABBsClosed);
        this.vshapes_open = EdHatchBlock.makeHorizontalShapeLookup(unrotatedAABBsOpen);
    }

    @Override
    public StandardBlocks.IStandardBlock.RenderTypeHint getRenderTypeHint() {
        return StandardBlocks.IStandardBlock.RenderTypeHint.CUTOUT;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter source, BlockPos pos, CollisionContext selectionContext) {
        return (Boolean)state.m_61143_((Property)OPEN) != false ? this.vshapes_open.get(((Direction)state.m_61143_((Property)HORIZONTAL_FACING)).m_122411_() & 7) : super.m_5940_(state, source, pos, selectionContext);
    }

    @Override
    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)OPEN);
    }

    @Override
    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return (Boolean)state.m_61143_((Property)OPEN) == false;
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        if (!((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return false;
        }
        BlockState up_state = world.m_8055_(pos.m_7494_());
        if (up_state.m_60713_((Block)this) && ((Boolean)up_state.m_61143_((Property)OPEN)).booleanValue()) {
            return true;
        }
        if (up_state.isLadder(world, pos.m_7494_(), entity)) {
            return true;
        }
        BlockState down_state = world.m_8055_(pos.m_7495_());
        if (down_state.m_60713_((Block)this) && ((Boolean)down_state.m_61143_((Property)OPEN)).booleanValue()) {
            return true;
        }
        return down_state.isLadder(world, pos.m_7495_(), entity);
    }

    public boolean canCreatureSpawn(BlockState state, BlockGetter world, BlockPos pos, SpawnPlacements.Type type, @Nullable EntityType<?> entityType) {
        return false;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{OPEN, POWERED});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        boolean open = (Boolean)state.m_61143_((Property)OPEN) == false;
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
        world.m_5594_(null, pos, open ? SoundEvents.f_12056_ : SoundEvents.f_12055_, SoundSource.BLOCKS, 0.7f, 1.4f);
        return InteractionResult.CONSUME;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (world.f_46443_ || !(state.m_60734_() instanceof EdHatchBlock)) {
            return;
        }
        boolean powered = world.m_46753_(pos);
        if (powered == (Boolean)state.m_61143_((Property)POWERED)) {
            return;
        }
        if (powered != (Boolean)state.m_61143_((Property)OPEN)) {
            world.m_5594_(null, pos, powered ? SoundEvents.f_12056_ : SoundEvents.f_12055_, SoundSource.BLOCKS, 0.7f, 1.4f);
        }
        world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(powered))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 3);
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return false;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        Entity entity2;
        if (!((Boolean)state.m_61143_((Property)OPEN)).booleanValue() || !((entity2 = entity) instanceof Player)) {
            return;
        }
        Player player = (Player)entity2;
        if (entity.m_20154_().m_7098_() > -0.75) {
            return;
        }
        if (player.m_6350_() != state.m_61143_((Property)HORIZONTAL_FACING)) {
            return;
        }
        Vec3 ppos = player.m_20182_();
        Vec3 centre = Vec3.m_82539_((Vec3i)pos);
        Vec3 v = centre.m_82546_(ppos);
        if (ppos.m_7098_() < centre.m_7098_() - 0.1 || v.m_82556_() > 0.3) {
            return;
        }
        v = v.m_82490_(0.3);
        player.m_5997_(v.f_82479_, 0.0, v.f_82481_);
    }
}

