/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.detail.Auxiliaries;

public class EdLadderBlock
extends LadderBlock
implements StandardBlocks.IStandardBlock {
    protected static final AABB EDLADDER_UNROTATED_AABB = Auxiliaries.getPixeledAABB(3.0, 0.0, 0.0, 13.0, 16.0, 3.0);
    protected static final VoxelShape EDLADDER_SOUTH_AABB = Shapes.m_83064_((AABB)Auxiliaries.getRotatedAABB(EDLADDER_UNROTATED_AABB, Direction.SOUTH, false));
    protected static final VoxelShape EDLADDER_EAST_AABB = Shapes.m_83064_((AABB)Auxiliaries.getRotatedAABB(EDLADDER_UNROTATED_AABB, Direction.EAST, false));
    protected static final VoxelShape EDLADDER_WEST_AABB = Shapes.m_83064_((AABB)Auxiliaries.getRotatedAABB(EDLADDER_UNROTATED_AABB, Direction.WEST, false));
    protected static final VoxelShape EDLADDER_NORTH_AABB = Shapes.m_83064_((AABB)Auxiliaries.getRotatedAABB(EDLADDER_UNROTATED_AABB, Direction.NORTH, false));
    private static boolean without_speed_boost_ = false;

    public static void on_config(boolean without_speed_boost) {
        without_speed_boost_ = without_speed_boost;
        ModConfig.log("Config ladder: without-speed-boost:" + without_speed_boost_);
    }

    public EdLadderBlock(long config, BlockBehaviour.Properties builder) {
        super(builder);
    }

    @Override
    public StandardBlocks.IStandardBlock.RenderTypeHint getRenderTypeHint() {
        return StandardBlocks.IStandardBlock.RenderTypeHint.CUTOUT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        Auxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return switch ((Direction)state.m_61143_((Property)f_54337_)) {
            case Direction.NORTH -> EDLADDER_NORTH_AABB;
            case Direction.SOUTH -> EDLADDER_SOUTH_AABB;
            case Direction.WEST -> EDLADDER_WEST_AABB;
            default -> EDLADDER_EAST_AABB;
        };
    }

    public boolean m_5568_() {
        return false;
    }

    public boolean canCreatureSpawn(BlockState state, BlockGetter world, BlockPos pos, SpawnPlacements.Type type, @Nullable EntityType<?> entityType) {
        return false;
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.NORMAL;
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public static void onPlayerUpdateEvent(Player player) {
        if (without_speed_boost_ || player.m_20096_() || !player.m_6147_() || player.m_20161_() || player.m_5833_()) {
            return;
        }
        double lvy = player.m_20154_().f_82480_;
        if (Math.abs(lvy) < 0.92) {
            return;
        }
        BlockPos pos = player.m_142538_();
        BlockState state = player.f_19853_.m_8055_(pos);
        if (!(state.m_60734_() instanceof EdLadderBlock)) {
            return;
        }
        player.f_19789_ = 0.0f;
        if (player.m_20184_().m_7098_() < 0.0 == player.m_20154_().f_82480_ < 0.0) {
            player.m_7601_(state, new Vec3(0.2, lvy > 0.0 ? 3.0 : 6.0, 0.2));
            if (Math.abs(player.m_20184_().m_7098_()) > 0.1) {
                Vec3 vdiff = Vec3.m_82539_((Vec3i)pos).m_82546_(player.m_20182_()).m_82490_(1.0);
                vdiff.m_82549_(Vec3.m_82539_((Vec3i)((Direction)state.m_61143_((Property)f_54337_)).m_122436_()).m_82490_(0.5));
                vdiff = new Vec3(vdiff.f_82479_, player.m_20184_().f_82480_, vdiff.f_82481_);
                player.m_20256_(vdiff);
            }
        } else if (player.m_20154_().f_82480_ > 0.0) {
            player.m_7601_(state, new Vec3(1.0, 0.05, 1.0));
        }
    }
}

