/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.EdFurnace;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.blocks.StandardEntityBlocks;
import wile.engineersdecor.libmc.detail.Inventories;
import wile.engineersdecor.libmc.detail.RfEnergy;
import wile.engineersdecor.libmc.detail.RsSignals;
import wile.engineersdecor.libmc.ui.Guis;

public class EdWasteIncinerator {
    public static final int MAX_ENERGY_BUFFER = 16000;
    public static final int MAX_ENERGY_TRANSFER = 256;
    public static final int DEFAULT_ENERGY_CONSUMPTION = 16;
    private static int energy_consumption = 16;

    public static void on_config(int boost_energy_per_tick) {
        energy_consumption = Mth.m_14045_((int)boost_energy_per_tick, (int)4, (int)4096);
        ModConfig.log("Config waste incinerator: boost energy consumption:" + energy_consumption + ".");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WasteIncineratorGui
    extends Guis.ContainerGui<WasteIncineratorContainer> {
        public WasteIncineratorGui(WasteIncineratorContainer container, Inventory player_inventory, Component title) {
            super(container, player_inventory, title, "textures/gui/small_waste_incinerator_gui.png");
        }
    }

    public static class WasteIncineratorContainer
    extends AbstractContainerMenu {
        private static final int PLAYER_INV_START_SLOTNO = 16;
        protected final Player player_;
        protected final Container inventory_;
        protected final ContainerLevelAccess wpc_;
        private final ContainerData fields_;
        private int proc_time_needed_;

        public int field(int index) {
            return this.fields_.m_6413_(index);
        }

        public Player player() {
            return this.player_;
        }

        public Container inventory() {
            return this.inventory_;
        }

        public Level world() {
            return this.player_.f_19853_;
        }

        public WasteIncineratorContainer(int cid, Inventory player_inventory) {
            this(cid, player_inventory, (Container)new SimpleContainer(16), ContainerLevelAccess.f_39287_, (ContainerData)new SimpleContainerData(1));
        }

        private WasteIncineratorContainer(int cid, Inventory player_inventory, Container block_inventory, ContainerLevelAccess wpc, ContainerData fields) {
            super(ModContent.CT_WASTE_INCINERATOR, cid);
            this.player_ = player_inventory.f_35978_;
            this.inventory_ = block_inventory;
            this.wpc_ = wpc;
            this.fields_ = fields;
            int i = -1;
            this.m_38897_(new Slot(this.inventory_, ++i, 13, 9));
            this.m_38897_(new Slot(this.inventory_, ++i, 37, 12));
            this.m_38897_(new Slot(this.inventory_, ++i, 54, 13));
            this.m_38897_(new Slot(this.inventory_, ++i, 71, 14));
            this.m_38897_(new Slot(this.inventory_, ++i, 88, 15));
            this.m_38897_(new Slot(this.inventory_, ++i, 105, 16));
            this.m_38897_(new Slot(this.inventory_, ++i, 122, 17));
            this.m_38897_(new Slot(this.inventory_, ++i, 139, 18));
            this.m_38897_(new Slot(this.inventory_, ++i, 144, 38));
            this.m_38897_(new Slot(this.inventory_, ++i, 127, 39));
            this.m_38897_(new Slot(this.inventory_, ++i, 110, 40));
            this.m_38897_(new Slot(this.inventory_, ++i, 93, 41));
            this.m_38897_(new Slot(this.inventory_, ++i, 76, 42));
            this.m_38897_(new Slot(this.inventory_, ++i, 59, 43));
            this.m_38897_(new Slot(this.inventory_, ++i, 42, 44));
            this.m_38897_(new Slot(this.inventory_, ++i, 17, 58));
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)player_inventory, x, 8 + x * 18, 144));
            }
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.m_38897_(new Slot((Container)player_inventory, x + y * 9 + 9, 8 + x * 18, 86 + y * 18));
                }
            }
        }

        public boolean m_6875_(Player player) {
            return this.inventory_.m_6542_(player);
        }

        public ItemStack m_7648_(Player player, int index) {
            Slot slot = this.m_38853_(index);
            if (slot == null || !slot.m_6657_()) {
                return ItemStack.f_41583_;
            }
            ItemStack slot_stack = slot.m_7993_();
            ItemStack transferred = slot_stack.m_41777_();
            if (index >= 0 && index < 16) {
                if (!this.m_38903_(slot_stack, 16, 52, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (index >= 16 && index <= 52) {
                if (!this.m_38903_(slot_stack, 0, 15, true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                return ItemStack.f_41583_;
            }
            if (slot_stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slot_stack.m_41613_() == transferred.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slot_stack);
            return transferred;
        }
    }

    public static class WasteIncineratorTileEntity
    extends StandardEntityBlocks.StandardBlockEntity
    implements MenuProvider,
    Nameable {
        public static final int NUM_OF_FIELDS = 1;
        public static final int TICK_INTERVAL = 20;
        public static final int ENERGIZED_TICK_INTERVAL = 5;
        public static final int INCINERATION_STACK_DECREMENT = 4;
        public static final int NUM_OF_SLOTS = 16;
        public static final int INPUT_SLOT_NO = 0;
        public static final int BURN_SLOT_NO = 15;
        private int tick_timer_;
        private int check_timer_;
        private final Inventories.StorageInventory main_inventory_ = new Inventories.StorageInventory(this, 16, 1);
        private final LazyOptional<? extends IItemHandler> item_handler_ = Inventories.MappedItemHandler.createInsertionHandler((Container)this.main_inventory_, 0);
        private final RfEnergy.Battery battery_ = new RfEnergy.Battery(16000, 256, 0);
        private final LazyOptional<IEnergyStorage> energy_handler_ = this.battery_.createEnergyHandler();
        protected final ContainerData fields = new ContainerData(){

            public int m_6499_() {
                return 1;
            }

            public int m_6413_(int id) {
                switch (id) {
                    default: 
                }
                return 0;
            }

            public void m_8050_(int id, int value) {
                switch (id) {
                    default: 
                }
            }
        };

        public WasteIncineratorTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.TET_WASTE_INCINERATOR, pos, state);
            this.reset();
        }

        public CompoundTag getnbt() {
            return this.writenbt(new CompoundTag());
        }

        protected void reset() {
            this.main_inventory_.m_6211_();
            this.check_timer_ = 0;
            this.tick_timer_ = 0;
        }

        public void readnbt(CompoundTag nbt) {
            this.main_inventory_.load(nbt);
            this.battery_.load(nbt);
        }

        protected CompoundTag writenbt(CompoundTag nbt) {
            this.main_inventory_.save(nbt);
            this.battery_.save(nbt);
            return nbt;
        }

        public void m_142466_(CompoundTag nbt) {
            super.m_142466_(nbt);
            this.readnbt(nbt);
        }

        public CompoundTag m_6945_(CompoundTag nbt) {
            super.m_6945_(nbt);
            return this.writenbt(nbt);
        }

        public void m_7651_() {
            super.m_7651_();
            this.energy_handler_.invalidate();
            this.item_handler_.invalidate();
        }

        public Component m_7755_() {
            Block block = this.m_58900_().m_60734_();
            return new TextComponent(block != null ? block.m_7705_() : "Small Waste Incinerator");
        }

        public boolean m_8077_() {
            return false;
        }

        public Component m_7770_() {
            return this.m_7755_();
        }

        public Component m_5446_() {
            return super.m_5446_();
        }

        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
            return new WasteIncineratorContainer(id, inventory, this.main_inventory_, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.f_58858_), this.fields);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return this.item_handler_.cast();
            }
            if (capability == CapabilityEnergy.ENERGY) {
                return this.energy_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        @Override
        public void tick() {
            ItemStack first_stack;
            boolean shift;
            boolean was_processing;
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 20;
            if (this.f_58857_.f_46443_) {
                return;
            }
            boolean dirty = false;
            ItemStack processing_stack = this.main_inventory_.m_8020_(15);
            boolean is_processing = was_processing = !processing_stack.m_41619_();
            boolean new_stack_processing = false;
            if (!this.main_inventory_.m_8020_(0).m_41619_() && this.transferItems(0, 1, this.main_inventory_.m_6893_())) {
                dirty = true;
            }
            boolean bl = shift = !(first_stack = this.main_inventory_.m_8020_(0)).m_41619_();
            if (is_processing) {
                processing_stack.m_41774_(4);
                if (processing_stack.m_41613_() <= 0) {
                    processing_stack = ItemStack.f_41583_;
                    is_processing = false;
                }
                this.main_inventory_.m_6836_(15, processing_stack);
                if (this.battery_.draw(energy_consumption * 20)) {
                    this.tick_timer_ = 5;
                }
                dirty = true;
            }
            if (shift) {
                boolean transferred = false;
                for (int i = 14; i > 0; --i) {
                    transferred |= this.transferItems(i - 1, i, this.main_inventory_.m_6893_());
                }
                if (!is_processing && !transferred) {
                    this.shiftStacks(0, 15);
                    dirty = true;
                }
            }
            if (was_processing != is_processing || new_stack_processing) {
                BlockState state;
                if (new_stack_processing) {
                    this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12030_, SoundSource.BLOCKS, 0.05f, 2.4f);
                }
                if ((state = this.f_58857_.m_8055_(this.f_58858_)).m_60734_() instanceof WasteIncineratorBlock) {
                    this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)WasteIncineratorBlock.LIT, (Comparable)Boolean.valueOf(is_processing)), 18);
                }
            }
            if (dirty) {
                this.m_6596_();
            }
        }

        private ItemStack shiftStacks(int index_from, int index_to) {
            if (index_from >= index_to) {
                return ItemStack.f_41583_;
            }
            ItemStack out_stack = ItemStack.f_41583_;
            ItemStack stack = this.main_inventory_.m_8020_(index_from);
            for (int i = index_from + 1; i <= index_to; ++i) {
                out_stack = this.main_inventory_.m_8020_(i);
                this.main_inventory_.m_6836_(i, stack);
                stack = out_stack;
            }
            this.main_inventory_.m_6836_(index_from, ItemStack.f_41583_);
            return out_stack;
        }

        private boolean transferItems(int index_from, int index_to, int count) {
            ItemStack from = this.main_inventory_.m_8020_(index_from);
            if (from.m_41619_()) {
                return false;
            }
            ItemStack to = this.main_inventory_.m_8020_(index_to);
            if (from.m_41613_() < count) {
                count = from.m_41613_();
            }
            if (count <= 0) {
                return false;
            }
            boolean changed = true;
            if (to.m_41619_()) {
                this.main_inventory_.m_6836_(index_to, from.m_41620_(count));
            } else if (to.m_41613_() >= to.m_41741_()) {
                changed = false;
            } else if (Inventories.areItemStacksDifferent(from, to)) {
                changed = false;
            } else if (to.m_41613_() + count >= to.m_41741_()) {
                from.m_41774_(to.m_41741_() - to.m_41613_());
                to.m_41764_(to.m_41741_());
            } else {
                from.m_41774_(count);
                to.m_41769_(count);
            }
            if (from.m_41619_() && from != ItemStack.f_41583_) {
                this.main_inventory_.m_6836_(index_from, ItemStack.f_41583_);
                changed = true;
            }
            return changed;
        }
    }

    public static class WasteIncineratorBlock
    extends StandardBlocks.Cutout
    implements StandardEntityBlocks.IStandardEntityBlock<WasteIncineratorTileEntity> {
        public static final BooleanProperty LIT = EdFurnace.FurnaceBlock.LIT;

        public WasteIncineratorBlock(long config, BlockBehaviour.Properties builder, AABB unrotatedAABB) {
            super(config, builder, unrotatedAABB);
        }

        @Override
        @Nullable
        public BlockEntityType<WasteIncineratorTileEntity> getBlockEntityType() {
            return ModContent.TET_WASTE_INCINERATOR;
        }

        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{LIT});
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            return (BlockState)super.m_5573_(context).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
        }

        public boolean m_7278_(BlockState state) {
            return true;
        }

        public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
            int n;
            BlockEntity blockEntity = world.m_7702_(pos);
            if (!(blockEntity instanceof WasteIncineratorTileEntity)) {
                n = 0;
            } else {
                WasteIncineratorTileEntity te = (WasteIncineratorTileEntity)blockEntity;
                n = RsSignals.fromContainer(te.main_inventory_);
            }
            return n;
        }

        public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
            return false;
        }

        public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            if (world.f_46443_) {
                return;
            }
            if (!stack.m_41782_() || !stack.m_41783_().m_128441_("tedata")) {
                return;
            }
            CompoundTag te_nbt = stack.m_41783_().m_128469_("tedata");
            if (te_nbt.m_128456_()) {
                return;
            }
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof WasteIncineratorTileEntity)) {
                return;
            }
            ((WasteIncineratorTileEntity)te).readnbt(te_nbt);
            te.m_6596_();
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, Level world, BlockEntity te, boolean explosion) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (world.f_46443_) {
                return stacks;
            }
            if (!(te instanceof WasteIncineratorTileEntity)) {
                return stacks;
            }
            if (!explosion) {
                ItemStack stack = new ItemStack((ItemLike)this, 1);
                CompoundTag te_nbt = ((WasteIncineratorTileEntity)te).getnbt();
                if (!te_nbt.m_128456_()) {
                    CompoundTag nbt = new CompoundTag();
                    nbt.m_128365_("tedata", (Tag)te_nbt);
                    stack.m_41751_(nbt);
                }
                stacks.add(stack);
            } else {
                for (ItemStack stack : ((WasteIncineratorTileEntity)te).main_inventory_) {
                    stacks.add(stack);
                }
                ((WasteIncineratorTileEntity)te).getnbt();
            }
            return stacks;
        }

        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
            return this.useOpenGui(state, world, pos, player);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void m_7100_(BlockState state, Level world, BlockPos pos, Random rnd) {
            if (state.m_60734_() != this || !((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                return;
            }
            double rv = rnd.nextDouble();
            if (rv > 0.5) {
                return;
            }
            double x = 0.5 + (double)pos.m_123341_();
            double y = 0.5 + (double)pos.m_123342_();
            double z = 0.5 + (double)pos.m_123343_();
            double xr = rnd.nextDouble() * 0.4 - 0.2;
            double yr = rnd.nextDouble() * 0.5;
            double zr = rnd.nextDouble() * 0.4 - 0.2;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + xr, y + yr, z + zr, 0.0, 0.0, 0.0);
        }
    }
}

