/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.libmc.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.engineersdecor.libmc.detail.Auxiliaries;

public class StandardBlocks {
    public static final long CFG_DEFAULT = 0L;
    public static final long CFG_CUTOUT = 1L;
    public static final long CFG_MIPPED = 2L;
    public static final long CFG_TRANSLUCENT = 4L;
    public static final long CFG_WATERLOGGABLE = 8L;
    public static final long CFG_HORIZIONTAL = 16L;
    public static final long CFG_LOOK_PLACEMENT = 32L;
    public static final long CFG_FACING_PLACEMENT = 64L;
    public static final long CFG_OPPOSITE_PLACEMENT = 128L;
    public static final long CFG_FLIP_PLACEMENT_IF_SAME = 256L;
    public static final long CFG_FLIP_PLACEMENT_SHIFTCLICK = 512L;
    public static final long CFG_STRICT_CONNECTIONS = 1024L;
    public static final long CFG_AI_PASSABLE = 2048L;

    public static class HorizontalFourWayWaterLoggable
    extends WaterLoggable
    implements IStandardBlock {
        public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
        public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
        public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
        public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
        protected final Map<BlockState, VoxelShape> shapes;
        protected final Map<BlockState, VoxelShape> collision_shapes;

        public HorizontalFourWayWaterLoggable(long config, BlockBehaviour.Properties properties, AABB base_aabb, AABB[] side_aabb, int railing_height_extension) {
            super(config, properties, base_aabb);
            HashMap<BlockState, VoxelShape> build_shapes = new HashMap<BlockState, VoxelShape>();
            HashMap<BlockState, VoxelShape> build_collision_shapes = new HashMap<BlockState, VoxelShape>();
            for (BlockState state : this.m_49965_().m_61056_()) {
                VoxelShape shape;
                VoxelShape voxelShape = shape = base_aabb.m_82362_() == 0.0 || base_aabb.m_82376_() == 0.0 || base_aabb.m_82385_() == 0.0 ? Shapes.m_83040_() : Shapes.m_83064_((AABB)base_aabb);
                if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(side_aabb, Direction.NORTH, true)), (BooleanOp)BooleanOp.f_82695_);
                }
                if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(side_aabb, Direction.EAST, true)), (BooleanOp)BooleanOp.f_82695_);
                }
                if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(side_aabb, Direction.SOUTH, true)), (BooleanOp)BooleanOp.f_82695_);
                }
                if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(side_aabb, Direction.WEST, true)), (BooleanOp)BooleanOp.f_82695_);
                }
                if (shape.m_83281_()) {
                    shape = Shapes.m_83144_();
                }
                build_shapes.put((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), shape);
                build_shapes.put((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), shape);
                VoxelShape voxelShape2 = shape = base_aabb.m_82362_() == 0.0 || base_aabb.m_82376_() == 0.0 || base_aabb.m_82385_() == 0.0 ? Shapes.m_83040_() : Shapes.m_83064_((AABB)base_aabb);
                if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Auxiliaries.getUnionShape(Auxiliaries.getMappedAABB(Auxiliaries.getRotatedAABB(side_aabb, Direction.NORTH, true), bb -> bb.m_82363_(0.0, (double)railing_height_extension, 0.0))), (BooleanOp)BooleanOp.f_82695_);
                }
                if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Auxiliaries.getUnionShape(Auxiliaries.getMappedAABB(Auxiliaries.getRotatedAABB(side_aabb, Direction.EAST, true), bb -> bb.m_82363_(0.0, (double)railing_height_extension, 0.0))), (BooleanOp)BooleanOp.f_82695_);
                }
                if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Auxiliaries.getUnionShape(Auxiliaries.getMappedAABB(Auxiliaries.getRotatedAABB(side_aabb, Direction.SOUTH, true), bb -> bb.m_82363_(0.0, (double)railing_height_extension, 0.0))), (BooleanOp)BooleanOp.f_82695_);
                }
                if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Auxiliaries.getUnionShape(Auxiliaries.getMappedAABB(Auxiliaries.getRotatedAABB(side_aabb, Direction.WEST, true), bb -> bb.m_82363_(0.0, (double)railing_height_extension, 0.0))), (BooleanOp)BooleanOp.f_82695_);
                }
                if (shape.m_83281_()) {
                    shape = Shapes.m_83144_();
                }
                build_collision_shapes.put((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), shape);
                build_collision_shapes.put((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), shape);
            }
            this.shapes = build_shapes;
            this.collision_shapes = build_collision_shapes;
            this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }

        public HorizontalFourWayWaterLoggable(long config, BlockBehaviour.Properties properties, AABB base_aabb, AABB side_aabb, int railing_height_extension) {
            this(config, properties, base_aabb, new AABB[]{side_aabb}, railing_height_extension);
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST});
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            return (BlockState)((BlockState)((BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false));
        }

        @Override
        public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
            return this.shapes.getOrDefault(state, Shapes.m_83144_());
        }

        @Override
        public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
            return this.collision_shapes.getOrDefault(state, Shapes.m_83144_());
        }

        public static BooleanProperty getDirectionProperty(Direction face) {
            return switch (face) {
                case Direction.EAST -> EAST;
                case Direction.SOUTH -> SOUTH;
                case Direction.WEST -> WEST;
                default -> NORTH;
            };
        }
    }

    public static class HorizontalWaterLoggable
    extends Horizontal
    implements IStandardBlock {
        public HorizontalWaterLoggable(long config, BlockBehaviour.Properties properties, AABB aabb) {
            super(config | 8L | 0x10L, properties, aabb);
        }

        public HorizontalWaterLoggable(long config, BlockBehaviour.Properties properties, AABB[] aabbs) {
            super(config | 8L | 0x10L, properties, aabbs);
        }

        public HorizontalWaterLoggable(long config, BlockBehaviour.Properties properties, Supplier<ArrayList<VoxelShape>> shape_supplier) {
            super(config | 8L | 0x10L, properties, shape_supplier);
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{WATERLOGGED});
        }
    }

    public static class DirectedWaterLoggable
    extends Directed
    implements IStandardBlock {
        public DirectedWaterLoggable(long config, BlockBehaviour.Properties properties, AABB aabb) {
            super(config | 8L, properties, aabb);
        }

        public DirectedWaterLoggable(long config, BlockBehaviour.Properties properties, AABB[] aabbs) {
            super(config | 8L, properties, aabbs);
        }

        public DirectedWaterLoggable(long config, BlockBehaviour.Properties properties, Supplier<ArrayList<VoxelShape>> shape_supplier) {
            super(config | 8L, properties, shape_supplier);
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{WATERLOGGED});
        }
    }

    public static class Horizontal
    extends Cutout
    implements IStandardBlock {
        public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;
        protected final ArrayList<VoxelShape> vshapes;
        protected final ArrayList<VoxelShape> cshapes;

        public Horizontal(long config, BlockBehaviour.Properties properties, Supplier<ArrayList<VoxelShape>> shape_supplier) {
            super(config | 0x10L, properties);
            this.m_49959_((BlockState)super.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH));
            this.vshapes = shape_supplier.get();
            this.cshapes = new ArrayList<VoxelShape>(this.vshapes);
        }

        public Horizontal(long config, BlockBehaviour.Properties properties, AABB[] unrotatedAABBs) {
            this(config, properties, () -> Horizontal.makeHorizontalShapeLookup(unrotatedAABBs));
        }

        public Horizontal(long config, BlockBehaviour.Properties properties, AABB unrotatedAABB) {
            this(config, properties, new AABB[]{unrotatedAABB});
        }

        protected static ArrayList<VoxelShape> makeHorizontalShapeLookup(AABB[] unrotatedAABBs) {
            return new ArrayList<VoxelShape>(Arrays.asList(Shapes.m_83144_(), Shapes.m_83144_(), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.NORTH, true)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.SOUTH, true)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.WEST, true)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.EAST, true)), Shapes.m_83144_(), Shapes.m_83144_()));
        }

        protected void overrideCollisionShape(AABB unrotatedAABB) {
            for (int i = 0; i < this.cshapes.size(); ++i) {
                this.cshapes.set(i, Shapes.m_83064_((AABB)unrotatedAABB));
            }
        }

        @Override
        public VoxelShape m_5940_(BlockState state, BlockGetter source, BlockPos pos, CollisionContext selectionContext) {
            return this.vshapes.get(((Direction)state.m_61143_((Property)HORIZONTAL_FACING)).m_122411_() & 7);
        }

        @Override
        public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
            return this.cshapes.get(((Direction)state.m_61143_((Property)HORIZONTAL_FACING)).m_122411_() & 7);
        }

        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{HORIZONTAL_FACING});
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            Direction facing = context.m_43719_();
            if ((this.config & 0x20L) != 0L) {
                facing = context.m_8125_();
            } else {
                Direction direction = facing = facing == Direction.UP || facing == Direction.DOWN ? context.m_8125_() : facing;
            }
            if ((this.config & 0x80L) != 0L) {
                facing = facing.m_122424_();
            }
            if ((this.config & 0x200L) != 0L && context.m_43723_().m_6144_()) {
                facing = facing.m_122424_();
            }
            return (BlockState)super.m_5573_(context).m_61124_((Property)HORIZONTAL_FACING, (Comparable)facing);
        }

        public BlockState m_6843_(BlockState state, Rotation rot) {
            return (BlockState)state.m_61124_((Property)HORIZONTAL_FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
        }

        public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
            return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
        }
    }

    public static class Directed
    extends Cutout
    implements IStandardBlock {
        public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
        protected final ArrayList<VoxelShape> vshapes;
        protected final ArrayList<VoxelShape> cshapes;

        public Directed(long config, BlockBehaviour.Properties properties, Supplier<ArrayList<VoxelShape>> shape_supplier) {
            super(config, properties);
            this.m_49959_((BlockState)super.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.UP));
            this.vshapes = shape_supplier.get();
            this.cshapes = new ArrayList<VoxelShape>(this.vshapes);
        }

        public Directed(long config, BlockBehaviour.Properties properties, AABB[] unrotatedAABBs) {
            this(config, properties, () -> {
                boolean is_horizontal = (config & 0x10L) != 0L;
                return new ArrayList<VoxelShape>(Arrays.asList(Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.DOWN, is_horizontal)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.UP, is_horizontal)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.NORTH, is_horizontal)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.SOUTH, is_horizontal)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.WEST, is_horizontal)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.EAST, is_horizontal)), Shapes.m_83144_(), Shapes.m_83144_()));
            });
        }

        public Directed(long config, BlockBehaviour.Properties properties, AABB unrotatedAABB) {
            this(config, properties, new AABB[]{unrotatedAABB});
        }

        protected void overrideCollisionShape(AABB unrotatedAABB) {
            for (int i = 0; i < this.cshapes.size(); ++i) {
                this.cshapes.set(i, Shapes.m_83064_((AABB)unrotatedAABB));
            }
        }

        @Override
        public boolean m_5568_() {
            return false;
        }

        public boolean canCreatureSpawn(BlockState state, BlockGetter world, BlockPos pos, SpawnPlacements.Type type, @Nullable EntityType<?> entityType) {
            return false;
        }

        @Override
        public VoxelShape m_5940_(BlockState state, BlockGetter source, BlockPos pos, CollisionContext selectionContext) {
            return this.vshapes.get(((Direction)state.m_61143_((Property)FACING)).m_122411_() & 7);
        }

        @Override
        public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
            return this.cshapes.get(((Direction)state.m_61143_((Property)FACING)).m_122411_() & 7);
        }

        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{FACING});
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            Direction facing = context.m_43719_();
            if ((this.config & 0x30L) == 48L) {
                facing = context.m_8125_();
            } else if ((this.config & 0x30L) == 16L) {
                if (facing == Direction.UP || facing == Direction.DOWN) {
                    return null;
                }
            } else if ((this.config & 0x20L) != 0L) {
                facing = context.m_7820_();
            }
            if ((this.config & 0x80L) != 0L) {
                facing = facing.m_122424_();
            }
            if ((this.config & 0x200L) != 0L && context.m_43723_().m_6144_()) {
                facing = facing.m_122424_();
            }
            return (BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)facing);
        }
    }

    public static class WaterLoggable
    extends Cutout
    implements IStandardBlock {
        public WaterLoggable(long config, BlockBehaviour.Properties properties) {
            super(config | 8L, properties);
        }

        public WaterLoggable(long config, BlockBehaviour.Properties properties, AABB aabb) {
            super(config | 8L, properties, aabb);
        }

        public WaterLoggable(long config, BlockBehaviour.Properties properties, VoxelShape voxel_shape) {
            super(config | 8L, properties, voxel_shape);
        }

        public WaterLoggable(long config, BlockBehaviour.Properties properties, AABB[] aabbs) {
            super(config | 8L, properties, aabbs);
        }

        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{WATERLOGGED});
        }
    }

    public static class Cutout
    extends BaseBlock
    implements IStandardBlock {
        public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
        private final VoxelShape vshape;

        public Cutout(long conf, BlockBehaviour.Properties properties) {
            this(conf, properties, Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0));
        }

        public Cutout(long conf, BlockBehaviour.Properties properties, AABB aabb) {
            this(conf, properties, Shapes.m_83064_((AABB)aabb));
        }

        public Cutout(long conf, BlockBehaviour.Properties properties, AABB[] aabbs) {
            this(conf, properties, Arrays.stream(aabbs).map(Shapes::m_83064_).reduce(Shapes.m_83040_(), (shape, aabb) -> Shapes.m_83148_((VoxelShape)shape, (VoxelShape)aabb, (BooleanOp)BooleanOp.f_82695_)));
        }

        public Cutout(long conf, BlockBehaviour.Properties properties, VoxelShape voxel_shape) {
            super(conf, properties);
            this.vshape = voxel_shape;
            BlockState state = (BlockState)this.m_49965_().m_61090_();
            if ((conf & 8L) != 0L) {
                state = (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
            }
            this.m_49959_(state);
        }

        public VoxelShape m_5940_(BlockState state, BlockGetter source, BlockPos pos, CollisionContext selectionContext) {
            return this.vshape;
        }

        public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
            return this.vshape;
        }

        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            BlockState state = super.m_5573_(context);
            if ((this.config & 8L) != 0L) {
                FluidState fs = context.m_43725_().m_6425_(context.m_8083_());
                state = (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fs.m_76152_() == Fluids.f_76193_));
            }
            return state;
        }

        public boolean m_5568_() {
            return false;
        }

        public PushReaction m_5537_(BlockState state) {
            return PushReaction.NORMAL;
        }

        public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
            if ((this.config & 8L) != 0L && ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                return false;
            }
            return super.m_7420_(state, reader, pos);
        }

        public FluidState m_5888_(BlockState state) {
            if ((this.config & 8L) != 0L) {
                return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
            }
            return super.m_5888_(state);
        }

        public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
            if ((this.config & 8L) != 0L && ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                world.m_6217_().m_5945_(pos, (Object)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
            }
            return state;
        }
    }

    public static class BaseBlock
    extends Block
    implements IStandardBlock,
    LiquidBlockContainer {
        public final long config;

        public BaseBlock(long conf, BlockBehaviour.Properties properties) {
            super(properties);
            this.config = conf;
            BlockState state = (BlockState)this.m_49965_().m_61090_();
            this.m_49959_(state);
        }

        @Override
        public long config() {
            return this.config;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
            Auxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true);
        }

        @Override
        public IStandardBlock.RenderTypeHint getRenderTypeHint() {
            return this.getRenderTypeHint(this.config);
        }

        public boolean m_6044_(BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
            return false;
        }

        public boolean m_7361_(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidstate) {
            return false;
        }

        public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
            return (this.config & 0x800L) != 0L && super.m_7357_(state, world, pos, type);
        }

        public boolean hasSignalConnector(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
            return state.m_60803_();
        }

        public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
            boolean rsup = state.m_155947_() && state.m_60734_() != newState.m_60734_();
            super.m_6810_(state, world, pos, newState, isMoving);
            if (rsup) {
                world.m_46717_(pos, (Block)this);
            }
        }

        public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
            ServerLevel world = builder.m_78962_();
            Float explosion_radius = (Float)builder.m_78982_(LootContextParams.f_81464_);
            BlockEntity te = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
            if (!this.hasDynamicDropList() || world == null) {
                return super.m_7381_(state, builder);
            }
            boolean is_explosion = explosion_radius != null && explosion_radius.floatValue() > 0.0f;
            return this.dropList(state, (Level)world, te, is_explosion);
        }
    }

    public static interface IBlockItemFactory {
        public BlockItem getBlockItem(Block var1, Item.Properties var2);
    }

    public static interface IStandardBlock {
        default public long config() {
            return 0L;
        }

        default public boolean hasDynamicDropList() {
            return false;
        }

        default public List<ItemStack> dropList(BlockState state, Level world, @Nullable BlockEntity te, boolean explosion) {
            return Collections.singletonList(!world.m_5776_() ? new ItemStack((ItemLike)state.m_60734_().m_5456_()) : ItemStack.f_41583_);
        }

        default public RenderTypeHint getRenderTypeHint() {
            return this.getRenderTypeHint(this.config());
        }

        default public RenderTypeHint getRenderTypeHint(long config) {
            if ((config & 1L) != 0L) {
                return RenderTypeHint.CUTOUT;
            }
            if ((config & 2L) != 0L) {
                return RenderTypeHint.CUTOUT_MIPPED;
            }
            if ((config & 4L) != 0L) {
                return RenderTypeHint.TRANSLUCENT;
            }
            return RenderTypeHint.SOLID;
        }

        public static enum RenderTypeHint {
            SOLID,
            CUTOUT,
            CUTOUT_MIPPED,
            TRANSLUCENT,
            TRANSLUCENT_NO_CRUMBLING;

        }
    }
}

