/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.libmc.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.engineersdecor.libmc.detail.Auxiliaries;
import wile.engineersdecor.libmc.detail.TooltipDisplay;

public class Guis {

    @OnlyIn(value=Dist.CLIENT)
    public static class CheckBox
    extends UiWidget {
        private final Coord2d texture_position_off_;
        private final Coord2d texture_position_on_;
        private final ResourceLocation atlas_;
        private boolean checked_ = false;
        private Consumer<CheckBox> on_click_ = checkbox -> {};

        public CheckBox(ResourceLocation atlas, int width, int height, Coord2d atlas_texture_position_off, Coord2d atlas_texture_position_on) {
            super(0, 0, width, height, EMPTY_TEXT);
            this.texture_position_off_ = atlas_texture_position_off;
            this.texture_position_on_ = atlas_texture_position_on;
            this.atlas_ = atlas;
        }

        public boolean checked() {
            return this.checked_;
        }

        public CheckBox checked(boolean on) {
            this.checked_ = on;
            return this;
        }

        public CheckBox onclick(Consumer<CheckBox> action) {
            this.on_click_ = action;
            return this;
        }

        public void m_5716_(double mouseX, double mouseY) {
            this.checked_ = !this.checked_;
            this.on_click_.accept(this);
        }

        @Override
        public void m_6303_(PoseStack mx, int mouseX, int mouseY, float partialTicks) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.atlas_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69482_();
            Coord2d pos = this.checked_ ? this.texture_position_on_ : this.texture_position_off_;
            this.m_93228_(mx, this.f_93620_, this.f_93621_, pos.x, pos.y, this.f_93618_, this.f_93619_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class BackgroundImage
    extends UiWidget {
        private final ResourceLocation atlas_;
        private final Coord2d atlas_position_;
        public boolean f_93624_;

        public BackgroundImage(ResourceLocation atlas, int width, int height, Coord2d atlas_position) {
            super(0, 0, width, height, EMPTY_TEXT);
            this.atlas_ = atlas;
            this.atlas_position_ = atlas_position;
            this.f_93618_ = width;
            this.f_93619_ = height;
            this.f_93624_ = true;
        }

        public void draw(PoseStack mx, Screen parent) {
            if (!this.f_93624_) {
                return;
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.atlas_);
            parent.m_93228_(mx, this.f_93620_, this.f_93621_, this.atlas_position_.x, this.atlas_position_.y, this.f_93618_, this.f_93619_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class HorizontalProgressBar
    extends UiWidget {
        private final Coord2d texture_position_base_;
        private final Coord2d texture_position_filled_;
        private final ResourceLocation atlas_;
        private double progress_max_ = 100.0;
        private double progress_ = 0.0;

        public HorizontalProgressBar(ResourceLocation atlas, int width, int height, Coord2d base_texture_xy, Coord2d filled_texture_xy) {
            super(0, 0, width, height, EMPTY_TEXT);
            this.atlas_ = atlas;
            this.texture_position_base_ = base_texture_xy;
            this.texture_position_filled_ = filled_texture_xy;
        }

        public HorizontalProgressBar setProgress(double progress) {
            this.progress_ = Mth.m_14008_((double)progress, (double)0.0, (double)this.progress_max_);
            return this;
        }

        public double getProgress() {
            return this.progress_;
        }

        public HorizontalProgressBar setMaxProgress(double progress) {
            this.progress_max_ = Math.max(progress, 0.0);
            return this;
        }

        public double getMaxProgress() {
            return this.progress_max_;
        }

        @Override
        public HorizontalProgressBar show() {
            this.f_93624_ = true;
            return this;
        }

        @Override
        public HorizontalProgressBar hide() {
            this.f_93624_ = false;
            return this;
        }

        public void m_7435_(SoundManager handler) {
        }

        protected void m_7906_(PoseStack mx, Minecraft mc, int x, int y) {
        }

        @Override
        public void m_6303_(PoseStack mx, int mouseX, int mouseY, float partialTicks) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.atlas_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69482_();
            this.m_93228_(mx, this.f_93620_, this.f_93621_, this.texture_position_base_.x, this.texture_position_base_.y, this.f_93618_, this.f_93619_);
            if (this.progress_max_ > 0.0 && this.progress_ > 0.0) {
                int w = Mth.m_14045_((int)((int)Math.round(this.progress_ * (double)this.f_93618_ / this.progress_max_)), (int)0, (int)this.f_93618_);
                this.m_93228_(mx, this.f_93620_, this.f_93621_, this.texture_position_filled_.x, this.texture_position_filled_.y, w, this.f_93619_);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class UiWidget
    extends AbstractWidget {
        protected static final Component EMPTY_TEXT = new TextComponent("");
        protected static final Function<UiWidget, Component> NO_TOOLTIP = uiw -> EMPTY_TEXT;
        private Function<UiWidget, Component> tooltip_ = NO_TOOLTIP;

        public UiWidget(int x, int y, int width, int height, Component title) {
            super(x, y, width, height, title);
        }

        public UiWidget init(Screen parent) {
            this.f_93620_ += parent instanceof AbstractContainerScreen ? ((AbstractContainerScreen)parent).getGuiLeft() : 0;
            this.f_93621_ += parent instanceof AbstractContainerScreen ? ((AbstractContainerScreen)parent).getGuiTop() : 0;
            return this;
        }

        public UiWidget init(Screen parent, Coord2d position) {
            this.f_93620_ = position.x + (parent instanceof AbstractContainerScreen ? ((AbstractContainerScreen)parent).getGuiLeft() : 0);
            this.f_93621_ = position.y + (parent instanceof AbstractContainerScreen ? ((AbstractContainerScreen)parent).getGuiTop() : 0);
            return this;
        }

        public int m_5711_() {
            return this.f_93618_;
        }

        public int m_93694_() {
            return this.f_93619_;
        }

        public UiWidget show() {
            this.f_93624_ = true;
            return this;
        }

        public UiWidget hide() {
            this.f_93624_ = false;
            return this;
        }

        public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            super.m_6303_(matrixStack, mouseX, mouseY, partialTicks);
            if (this.m_5702_()) {
                this.m_7428_(matrixStack, mouseX, mouseY);
            }
        }

        public void m_7428_(PoseStack matrixStack, int mouseX, int mouseY) {
            if (this.tooltip_ == NO_TOOLTIP) {
                return;
            }
        }

        public void m_142291_(NarrationElementOutput element_output) {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Coord2d {
        public final int x;
        public final int y;

        public Coord2d(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class ContainerGui<T extends AbstractContainerMenu>
    extends AbstractContainerScreen<T> {
        protected final ResourceLocation background_image_;
        protected final Player player_;
        protected final BackgroundImage gui_background_;
        protected final TooltipDisplay tooltip_ = new TooltipDisplay();

        public ContainerGui(T menu, Inventory player_inv, Component title, String background_image, int width, int height) {
            super(menu, player_inv, title);
            this.background_image_ = new ResourceLocation(Auxiliaries.modid(), background_image);
            this.player_ = player_inv.f_35978_;
            this.f_97726_ = width;
            this.f_97727_ = height;
            this.gui_background_ = new BackgroundImage(this.background_image_, width, height, new Coord2d(0, 0));
        }

        public ContainerGui(T menu, Inventory player_inv, Component title, String background_image) {
            super(menu, player_inv, title);
            this.background_image_ = new ResourceLocation(Auxiliaries.modid(), background_image);
            this.player_ = player_inv.f_35978_;
            this.gui_background_ = new BackgroundImage(this.background_image_, this.f_97726_, this.f_97727_, new Coord2d(0, 0));
        }

        public void m_7856_() {
            super.m_7856_();
            this.gui_background_.init((Screen)this, new Coord2d(0, 0)).show();
        }

        public void m_6305_(PoseStack mx, int mouseX, int mouseY, float partialTicks) {
            this.m_7333_(mx);
            super.m_6305_(mx, mouseX, mouseY, partialTicks);
            if (!this.tooltip_.render(mx, this, mouseX, mouseY)) {
                this.m_7025_(mx, mouseX, mouseY);
            }
        }

        protected void m_7027_(PoseStack mx, int x, int y) {
        }

        protected final void m_7286_(PoseStack mx, float partialTicks, int mouseX, int mouseY) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69482_();
            this.gui_background_.draw(mx, (Screen)this);
            this.renderBgWidgets(mx, partialTicks, mouseX, mouseY);
            RenderSystem.m_69461_();
        }

        public final ResourceLocation getBackgroundImage() {
            return this.background_image_;
        }

        protected void renderBgWidgets(PoseStack mx, float partialTicks, int mouseX, int mouseY) {
        }

        protected void renderItemTemplate(PoseStack mx, ItemStack stack, int x, int y) {
            ItemRenderer ir = this.f_96542_;
            int main_zl = this.m_93252_();
            float zl = ir.f_115093_;
            int x0 = this.getGuiLeft();
            int y0 = this.getGuiTop();
            ir.f_115093_ = -80.0f;
            ir.m_115123_(stack, x0 + x, y0 + y);
            RenderSystem.m_69462_();
            RenderSystem.m_69482_();
            RenderSystem.m_69453_();
            RenderSystem.m_69478_();
            ir.f_115093_ = zl;
            this.m_93250_(100);
            RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.m_157429_((float)0.7f, (float)0.7f, (float)0.7f, (float)0.8f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.background_image_);
            this.m_93228_(mx, x0 + x, y0 + y, x, y, 16, 16);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.m_93250_(main_zl);
        }
    }
}

