/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.blocks.StandardEntityBlocks;
import wile.engineersdecor.libmc.detail.Auxiliaries;
import wile.engineersdecor.libmc.detail.Fluidics;
import wile.engineersdecor.libmc.detail.Overlay;

public class EdFluidBarrel {
    private static int capacity_ = 12000;
    private static int item_fluid_handler_transfer_rate_ = 1000;
    private static int tile_fluid_handler_transfer_rate_ = 1000;

    public static void on_config(int tank_capacity, int transfer_rate) {
        capacity_ = Mth.m_14045_((int)tank_capacity, (int)2000, (int)64000);
        item_fluid_handler_transfer_rate_ = tile_fluid_handler_transfer_rate_ = Mth.m_14045_((int)tank_capacity, (int)50, (int)4096);
        ModConfig.log("Config fluid barrel: capacity:" + capacity_ + "mb, transfer-rate:" + tile_fluid_handler_transfer_rate_ + "mb/t.");
    }

    public static class FluidBarrelItem
    extends BlockItem {
        public FluidBarrelItem(Block block, Item.Properties builder) {
            super(block, builder);
        }

        private static CompoundTag read_fluid_nbt(ItemStack stack) {
            if (!stack.m_41782_() || !stack.m_41783_().m_128441_("tedata")) {
                return new CompoundTag();
            }
            CompoundTag nbt = stack.m_41783_().m_128469_("tedata");
            if (!nbt.m_128425_("tank", 10)) {
                return new CompoundTag();
            }
            return nbt.m_128469_("tank");
        }

        private static void write_fluid_nbt(ItemStack stack, CompoundTag fluid_nbt) {
            if (fluid_nbt == null || fluid_nbt.m_128456_()) {
                if (!stack.m_41782_() || !stack.m_41783_().m_128425_("tedata", 10)) {
                    return;
                }
                CompoundTag tag = stack.m_41783_();
                CompoundTag tedata = tag.m_128469_("tedata");
                if (tedata.m_128441_("tank")) {
                    tedata.m_128473_("tank");
                }
                if (tedata.m_128456_()) {
                    tag.m_128473_("tedata");
                }
                stack.m_41751_(tag.m_128456_() ? null : tag);
            } else {
                CompoundTag tedata;
                CompoundTag tag = stack.m_41783_();
                if (tag == null) {
                    tag = new CompoundTag();
                }
                if ((tedata = tag.m_128469_("tedata")) == null) {
                    tedata = new CompoundTag();
                }
                tedata.m_128365_("tank", (Tag)fluid_nbt);
                tag.m_128365_("tedata", (Tag)tedata);
                stack.m_41751_(tag);
            }
        }

        public static FluidStack getFluid(ItemStack stack) {
            CompoundTag nbt = FluidBarrelItem.read_fluid_nbt(stack);
            return nbt.m_128456_() ? FluidStack.EMPTY : FluidStack.loadFluidStackFromNBT((CompoundTag)nbt);
        }

        public static ItemStack setFluid(ItemStack stack, FluidStack fs) {
            FluidBarrelItem.write_fluid_nbt(stack, fs.writeToNBT(new CompoundTag()));
            return stack;
        }

        public int getItemStackLimit(ItemStack stack) {
            return !FluidBarrelItem.getFluid(stack).isEmpty() ? 1 : super.getItemStackLimit(stack);
        }

        public boolean m_142522_(ItemStack stack) {
            return !FluidBarrelItem.getFluid(stack).isEmpty();
        }

        public int m_142158_(ItemStack stack) {
            return (int)Math.round(13.0 * Mth.m_14008_((double)((double)FluidBarrelItem.getFluid(stack).getAmount() / (double)capacity_), (double)0.0, (double)1.0));
        }

        public int m_142159_(ItemStack stack) {
            return 0x336633;
        }

        public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
            return new Fluidics.FluidContainerItemCapabilityWrapper(stack, capacity_, item_fluid_handler_transfer_rate_, FluidBarrelItem::read_fluid_nbt, FluidBarrelItem::write_fluid_nbt, e -> true);
        }

        public boolean hasContainerItem(ItemStack stack) {
            return stack.m_41613_() == 1 && !FluidBarrelItem.getFluid(stack).isEmpty();
        }

        public ItemStack getContainerItem(ItemStack stack) {
            if (stack.m_41613_() != 1) {
                return ItemStack.f_41583_;
            }
            FluidStack fs = FluidBarrelItem.getFluid(stack);
            if (fs.getAmount() > 1000) {
                fs.shrink(1000);
            } else {
                fs = FluidStack.EMPTY;
            }
            return FluidBarrelItem.setFluid(stack, fs);
        }
    }

    public static class FluidBarrelTileEntity
    extends StandardEntityBlocks.StandardBlockEntity
    implements ICapabilityProvider {
        private final int TICK_INTERVAL = 10;
        private int tick_timer_ = 0;
        private final Fluidics.Tank tank_ = new Fluidics.Tank(capacity_).setInteractionNotifier((t, d) -> this.on_tank_changed());
        private final LazyOptional<IFluidHandler> fluid_handler_ = this.tank_.createFluidHandler();

        public FluidBarrelTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.TET_FLUID_BARREL, pos, state);
        }

        public void readnbt(CompoundTag nbt) {
            this.tank_.load(nbt);
        }

        public CompoundTag writenbt(CompoundTag nbt) {
            this.tank_.save(nbt);
            return nbt;
        }

        public boolean handlePlayerInteraction(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand) {
            if (world.m_5776_()) {
                return false;
            }
            Tuple<Fluid, Integer> transferred = Fluidics.manualTrackedFluidHandlerInteraction(world, pos, null, player, hand);
            if (transferred == null) {
                world.m_5594_(null, pos, SoundEvents.f_12012_, SoundSource.BLOCKS, 0.2f, 0.02f);
            } else if ((Integer)transferred.m_14419_() > 0) {
                se = transferred.m_14418_() == Fluids.f_76195_ ? SoundEvents.f_11780_ : SoundEvents.f_11778_;
                world.m_5594_(null, pos, se, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                se = transferred.m_14418_() == Fluids.f_76195_ ? SoundEvents.f_11783_ : SoundEvents.f_11781_;
                world.m_5594_(null, pos, se, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            int vol = this.tank_.getFluidAmount();
            int cap = this.tank_.getCapacity();
            String name = new TranslatableComponent(this.tank_.getFluid().getTranslationKey()).getString();
            if (vol > 0 && cap > 0) {
                Overlay.show(player, (Component)Auxiliaries.localizable("block.engineersdecor.fluid_barrel.status", Integer.toString(vol), Integer.toString(cap), name));
            } else {
                Overlay.show(player, (Component)Auxiliaries.localizable("block.engineersdecor.fluid_barrel.status.empty", Integer.toString(vol), Integer.toString(cap)));
            }
            return true;
        }

        public double getNormalizedFillLevel() {
            return this.tank_.isEmpty() ? 0.0 : (double)this.tank_.getFluidAmount() / (double)this.tank_.getCapacity();
        }

        protected void on_tank_changed() {
            if (this.tick_timer_ > 2) {
                this.tick_timer_ = 2;
            }
        }

        public void m_142466_(CompoundTag nbt) {
            super.m_142466_(nbt);
            this.readnbt(nbt);
        }

        protected void m_183515_(CompoundTag nbt) {
            super.m_183515_(nbt);
            this.writenbt(nbt);
        }

        public void m_7651_() {
            super.m_7651_();
            this.fluid_handler_.invalidate();
        }

        public CompoundTag clear_getnbt() {
            return this.tank_.save(new CompoundTag());
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return this.fluid_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        private boolean transfer_down() {
            int nfilled;
            if (this.tank_.isEmpty()) {
                return false;
            }
            IFluidHandler fh = Fluidics.handler(this.f_58857_, this.f_58858_.m_7495_(), Direction.UP);
            if (fh == null) {
                return false;
            }
            FluidStack fs = this.tank_.getFluid().copy();
            if (fs.getAmount() > tile_fluid_handler_transfer_rate_) {
                fs.setAmount(tile_fluid_handler_transfer_rate_);
            }
            if ((nfilled = fh.fill(fs, IFluidHandler.FluidAction.EXECUTE)) <= 0) {
                return false;
            }
            this.tank_.drain(nfilled, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }

        @Override
        public void tick() {
            double norm_level;
            int fill_level;
            if (this.f_58857_.m_5776_() || --this.tick_timer_ >= 0) {
                return;
            }
            this.tick_timer_ = 10;
            BlockState state = this.m_58900_();
            Block block = state.m_60734_();
            if (!(block instanceof FluidBarrelBlock)) {
                return;
            }
            if (((Direction)state.m_61143_((Property)FluidBarrelBlock.FACING)).m_122434_().m_122478_()) {
                this.transfer_down();
            }
            int n = fill_level = (norm_level = this.getNormalizedFillLevel()) <= 0.0 ? 0 : (int)Mth.m_14008_((double)(norm_level * 4.0 + 0.5), (double)1.0, (double)4.0);
            if (fill_level != (Integer)state.m_61143_((Property)FluidBarrelBlock.FILL_LEVEL)) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)FluidBarrelBlock.FILL_LEVEL, (Comparable)Integer.valueOf(fill_level)), 2);
                this.f_58857_.m_46672_(this.f_58858_, block);
            }
        }
    }

    public static class FluidBarrelBlock
    extends StandardBlocks.DirectedWaterLoggable
    implements StandardEntityBlocks.IStandardEntityBlock<FluidBarrelTileEntity>,
    StandardBlocks.IBlockItemFactory {
        public static final int FILL_LEVEL_MAX = 4;
        public static final IntegerProperty FILL_LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)4);

        public FluidBarrelBlock(long config, BlockBehaviour.Properties builder, AABB[] unrotatedAABB) {
            super(config, builder, unrotatedAABB);
            this.m_49959_((BlockState)((BlockState)super.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)FILL_LEVEL, (Comparable)Integer.valueOf(0)));
        }

        @Override
        @Nullable
        public BlockEntityType<FluidBarrelTileEntity> getBlockEntityType() {
            return ModContent.TET_FLUID_BARREL;
        }

        @Override
        public boolean isBlockEntityTicking(Level world, BlockState state) {
            return true;
        }

        @Override
        public BlockItem getBlockItem(Block block, Item.Properties builder) {
            return new FluidBarrelItem(block, builder);
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, Level world, BlockEntity te, boolean explosion) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (world.f_46443_) {
                return stacks;
            }
            if (!(te instanceof FluidBarrelTileEntity)) {
                return stacks;
            }
            ItemStack stack = new ItemStack((ItemLike)this, 1);
            CompoundTag te_nbt = ((FluidBarrelTileEntity)te).clear_getnbt();
            if (!te_nbt.m_128456_()) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128365_("tedata", (Tag)te_nbt);
                stack.m_41751_(nbt);
            }
            stacks.add(stack);
            return stacks;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
            if (!(stack.m_41720_() instanceof FluidBarrelItem) || Auxiliaries.Tooltip.helpCondition()) {
                super.m_5871_(stack, world, tooltip, flag);
                return;
            }
            FluidStack fs = FluidBarrelItem.getFluid(stack);
            if (!fs.isEmpty()) {
                tooltip.add((Component)Auxiliaries.localizable(this.m_7705_() + ".status.tip", Integer.toString(fs.getAmount()), Integer.toString(capacity_), new TranslatableComponent(fs.getTranslationKey())));
            } else {
                tooltip.add((Component)Auxiliaries.localizable(this.m_7705_() + ".status.tip.empty", "0", Integer.toString(capacity_)));
            }
            if (!Auxiliaries.Tooltip.extendedTipCondition()) {
                super.m_5871_(stack, world, tooltip, flag);
            }
        }

        @Override
        public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
            return Shapes.m_83144_();
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{FILL_LEVEL});
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            BlockState state = super.m_5573_(context);
            if (!context.m_43723_().m_6144_()) {
                state = (BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.UP);
            }
            return state;
        }

        public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            if (world.f_46443_) {
                return;
            }
            if (!stack.m_41782_() || !stack.m_41783_().m_128441_("tedata")) {
                return;
            }
            CompoundTag te_nbt = stack.m_41783_().m_128469_("tedata");
            if (te_nbt.m_128456_()) {
                return;
            }
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof FluidBarrelTileEntity)) {
                return;
            }
            ((FluidBarrelTileEntity)te).readnbt(te_nbt);
            te.m_6596_();
            world.m_186460_(pos, (Block)this, 4);
        }

        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
            if (player.m_21120_(hand).m_41720_() == this.m_5456_()) {
                return InteractionResult.PASS;
            }
            if (world.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            BlockEntity blockEntity = world.m_7702_(pos);
            if (!(blockEntity instanceof FluidBarrelTileEntity)) {
                return InteractionResult.FAIL;
            }
            FluidBarrelTileEntity te = (FluidBarrelTileEntity)blockEntity;
            if (!te.handlePlayerInteraction(state, world, pos, player, hand)) {
                return InteractionResult.PASS;
            }
            world.m_186460_(pos, (Block)this, 4);
            return InteractionResult.CONSUME;
        }

        public boolean m_7278_(BlockState state) {
            return true;
        }

        public int m_6782_(BlockState state, Level world, BlockPos pos) {
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof FluidBarrelTileEntity)) {
                return 0;
            }
            return (int)Mth.m_14008_((double)(((FluidBarrelTileEntity)te).getNormalizedFillLevel() * 15.0), (double)0.0, (double)15.0);
        }

        public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
            return false;
        }
    }
}

