/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor;

import com.mojang.logging.LogUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.EdLadderBlock;
import wile.engineersdecor.libmc.detail.Auxiliaries;
import wile.engineersdecor.libmc.detail.Networking;
import wile.engineersdecor.libmc.detail.OptionalRecipeCondition;
import wile.engineersdecor.libmc.detail.Overlay;
import wile.engineersdecor.libmc.detail.Registries;

@Mod(value="engineersdecor")
public class ModEngineersDecor {
    public static final String MODID = "engineersdecor";
    public static final String MODNAME = "Engineer's Decor";
    public static final int VERSION_DATAFIXER = 0;
    private static final Logger LOGGER = LogUtils.getLogger();

    public ModEngineersDecor() {
        Auxiliaries.init(MODID, LOGGER, ModConfig::getServerConfig);
        Auxiliaries.logGitVersion(MODNAME);
        Registries.init(MODID, "sign_decor", reg -> reg.register(FMLJavaModLoadingContext.get().getModEventBus()));
        ModContent.init(MODID);
        OptionalRecipeCondition.init(MODID, LOGGER);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ModConfig.SERVER_CONFIG_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfig.COMMON_CONFIG_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void onSetup(FMLCommonSetupEvent event) {
        CraftingHelper.register((IConditionSerializer)OptionalRecipeCondition.Serializer.INSTANCE);
        Networking.init(MODID);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        ModContent.registerMenuGuis(event);
        ModContent.registerBlockEntityRenderers(event);
        ModContent.processContentClientSide(event);
        Overlay.register();
    }

    @SubscribeEvent
    public void onPlayerEvent(LivingEvent.LivingUpdateEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_6147_()) {
            EdLadderBlock.onPlayerUpdateEvent(player);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ForgeEvents {
        @SubscribeEvent
        public static void onConfigLoad(ModConfigEvent.Loading event) {
            ModConfig.apply();
        }

        @SubscribeEvent
        public static void onConfigReload(ModConfigEvent.Reloading event) {
            try {
                Auxiliaries.logger().info("Config file changed {}", (Object)event.getConfig().getFileName());
                ModConfig.apply();
            }
            catch (Throwable e) {
                Auxiliaries.logger().error("Failed to load changed config: " + e.getMessage());
            }
        }
    }
}

