/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.EdCatwalkBlock;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.detail.Auxiliaries;

public class EdCatwalkStairsBlock
extends StandardBlocks.HorizontalWaterLoggable {
    public static final BooleanProperty RIGHT_RAILING = BooleanProperty.m_61465_((String)"right_railing");
    public static final BooleanProperty LEFT_RAILING = BooleanProperty.m_61465_((String)"left_railing");
    protected final Map<BlockState, VoxelShape> shapes;
    protected final Map<BlockState, VoxelShape> collision_shapes;
    protected final Map<Direction, Integer> y_rotations;

    public EdCatwalkStairsBlock(long config, BlockBehaviour.Properties properties, AABB[] base_aabb, AABB[] railing_aabbs) {
        super(config, properties, base_aabb);
        HashMap<BlockState, VoxelShape> sh = new HashMap<BlockState, VoxelShape>();
        HashMap<BlockState, VoxelShape> csh = new HashMap<BlockState, VoxelShape>();
        this.m_49965_().m_61056_().forEach(state -> {
            Direction facing = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
            VoxelShape base_shape = Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(base_aabb, facing, true));
            if (((Boolean)state.m_61143_((Property)RIGHT_RAILING)).booleanValue()) {
                VoxelShape right_shape = Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getMirroredAABB(railing_aabbs, Direction.Axis.X), facing, true));
                base_shape = Shapes.m_83148_((VoxelShape)base_shape, (VoxelShape)right_shape, (BooleanOp)BooleanOp.f_82695_);
            }
            if (((Boolean)state.m_61143_((Property)LEFT_RAILING)).booleanValue()) {
                VoxelShape left_shape = Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(railing_aabbs, facing, true));
                base_shape = Shapes.m_83148_((VoxelShape)base_shape, (VoxelShape)left_shape, (BooleanOp)BooleanOp.f_82695_);
            }
            sh.put((BlockState)state, base_shape);
            csh.put((BlockState)state, base_shape);
        });
        this.shapes = sh;
        this.collision_shapes = csh;
        this.y_rotations = new HashMap<Direction, Integer>();
        this.y_rotations.put(Direction.NORTH, 0);
        this.y_rotations.put(Direction.EAST, 1);
        this.y_rotations.put(Direction.SOUTH, 2);
        this.y_rotations.put(Direction.WEST, 3);
        this.y_rotations.put(Direction.UP, 0);
        this.y_rotations.put(Direction.DOWN, 0);
        this.m_49959_((BlockState)((BlockState)super.m_49966_().m_61124_((Property)LEFT_RAILING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_RAILING, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.shapes.getOrDefault(state, Shapes.m_83144_());
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.collision_shapes.getOrDefault(state, Shapes.m_83144_());
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{RIGHT_RAILING, LEFT_RAILING});
    }

    @Override
    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return super.m_5573_(context);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item = player.m_21120_(hand).m_41720_();
        if (!(item instanceof BlockItem)) {
            return InteractionResult.PASS;
        }
        Block block = ((BlockItem)item).m_40614_();
        Direction facing = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
        if (block == this) {
            BlockPos adjacent_pos;
            Direction hlv = Arrays.stream(Direction.m_122382_((Entity)player)).filter(d -> d.m_122434_().m_122479_()).findFirst().orElse(Direction.NORTH);
            if (hlv == facing) {
                adjacent_pos = pos.m_7494_().m_121945_(hlv);
            } else if (hlv == facing.m_122424_()) {
                adjacent_pos = pos.m_7495_().m_121945_(hlv);
            } else {
                return world.m_5776_() ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
            }
            BlockState adjacent_state = world.m_8055_(adjacent_pos);
            if (adjacent_state == null) {
                return world.m_5776_() ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
            }
            if (!adjacent_state.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(world, adjacent_pos, hit.m_82434_().m_122424_(), player.m_21120_(hand), hit.m_82434_()))) {
                return InteractionResult.CONSUME;
            }
            BlockState place_state = (BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)facing);
            place_state = (BlockState)place_state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(adjacent_state.m_60819_().m_76152_() == Fluids.f_76193_));
            EdCatwalkBlock.place_consume(place_state, world, adjacent_pos, player, hand, 1);
            return world.m_5776_() ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
        }
        if (block == ModContent.getBlock("steel_catwalk") || block == ModContent.getBlock("steel_catwalk_ta")) {
            BlockPos adjacent_pos = pos.m_121945_(facing);
            BlockState adjacent_state = world.m_8055_(adjacent_pos);
            if (adjacent_state == null) {
                return InteractionResult.CONSUME;
            }
            if (!adjacent_state.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(world, adjacent_pos, hit.m_82434_().m_122424_(), player.m_21120_(hand), hit.m_82434_()))) {
                return InteractionResult.CONSUME;
            }
            BlockState place_state = ModContent.getBlock("steel_catwalk_ta").m_49966_();
            place_state = (BlockState)place_state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(adjacent_state.m_60819_().m_76152_() == Fluids.f_76193_));
            EdCatwalkBlock.place_consume(place_state, world, adjacent_pos, player, hand, 1);
            return world.m_5776_() ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
        }
        if (block == ModContent.getBlock("steel_railing")) {
            Direction face = hit.m_82434_();
            int shrink = 0;
            BlockState place_state = state;
            if (face == Direction.UP) {
                Vec3 rhv = hit.m_82450_().m_82546_(Vec3.m_82512_((Vec3i)hit.m_82425_())).m_82559_(new Vec3(1.0, 0.0, 1.0)).m_82537_(Vec3.m_82528_((Vec3i)facing.m_122436_()));
                Direction direction = face = rhv.f_82480_ > 0.0 ? facing.m_122427_() : facing.m_122428_();
            }
            if (face == facing.m_122427_()) {
                if (((Boolean)state.m_61143_((Property)RIGHT_RAILING)).booleanValue()) {
                    place_state = (BlockState)state.m_61124_((Property)RIGHT_RAILING, (Comparable)Boolean.valueOf(false));
                    shrink = -1;
                } else {
                    place_state = (BlockState)state.m_61124_((Property)RIGHT_RAILING, (Comparable)Boolean.valueOf(true));
                    shrink = 1;
                }
            } else if (face == facing.m_122428_()) {
                if (((Boolean)state.m_61143_((Property)LEFT_RAILING)).booleanValue()) {
                    place_state = (BlockState)state.m_61124_((Property)LEFT_RAILING, (Comparable)Boolean.valueOf(false));
                    shrink = -1;
                } else {
                    place_state = (BlockState)state.m_61124_((Property)LEFT_RAILING, (Comparable)Boolean.valueOf(true));
                    shrink = 1;
                }
            }
            if (shrink != 0) {
                EdCatwalkBlock.place_consume(place_state, world, pos, player, hand, shrink);
            }
            return world.m_5776_() ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean hasDynamicDropList() {
        return true;
    }

    @Override
    public List<ItemStack> dropList(BlockState state, Level world, @Nullable BlockEntity te, boolean explosion) {
        if (world.m_5776_()) {
            return Collections.singletonList(ItemStack.f_41583_);
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((ItemLike)state.m_60734_().m_5456_()));
        int n = ((Boolean)state.m_61143_((Property)LEFT_RAILING) != false ? 1 : 0) + ((Boolean)state.m_61143_((Property)RIGHT_RAILING) != false ? 1 : 0);
        if (n > 0) {
            drops.add(new ItemStack((ItemLike)ModContent.getBlock("steel_railing"), n));
        }
        return drops;
    }
}

